/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uiframe.client.HelpBasicData;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLTemplateRptProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.client.SimpleNotePad;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.rpt.RptCheckExpTank;
import com.kingdee.eas.fi.rpt.RptCheckExpression;
import com.kingdee.eas.fi.rpt.RptResourceHelper;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.client.AbstractRptCheckUI;
import com.kingdee.eas.fi.rpt.client.IControlledDialogListener;
import com.kingdee.eas.fi.rpt.client.ISimpleDialog;
import com.kingdee.eas.fi.rpt.client.ISimpleDialogListener;
import com.kingdee.eas.fi.rpt.client.RptCheckExpressionEditUI;
import com.kingdee.eas.fi.rpt.client.RptHelper;
import com.kingdee.eas.fi.rpt.client.RptReportProcessUI;
import com.kingdee.eas.fi.rpt.client.RptTablePane;
import com.kingdee.eas.fi.rpt.client.SheetSelectUI;
import com.kingdee.eas.fi.rpt.client.TempReportProcessUI;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.help.CSH;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class RptCheckUI
extends AbstractRptCheckUI
implements ISimpleDialog {
    private ArrayList listeners;
    public ExpressionBank expBank;
    public RptCheckExpTank expTank;
    public RptCheckExpressionEditUI editor;
    public RptCheckExpression curExpression;
    private String currentOrgNum;
    private String creatorOrgNum;
    public boolean isCreator = true;
    private boolean isCslReportAudit = false;
    private int foreland;
    private boolean openReportCanSaveCheckSolution = true;
    public static boolean isK3 = false;
    private static final String defaultExpression = "A1=B1+C1";
    private List allSheetsName;

    public static RptCheckUI getInstance(UIContext ctx) throws Exception {
        Object ui = ctx.get((Object)"Owner");
        isK3 = ui instanceof RptReportProcessUI ? ((RptReportProcessUI)ui).isK3() : (ui instanceof TempReportProcessUI ? ((TempReportProcessUI)((Object)ui)).isK3() : ui instanceof CSLTemplateRptProcessUI);
        IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow wnd = fy.create(RptCheckUI.class.getName(), (Map)ctx);
        RptCheckUI res = (RptCheckUI)wnd.getUIObject();
        res.onShow();
        return res;
    }

    public RptCheckUI() throws Exception {
        this.toolBar = null;
        this.menuBar = null;
        this.statusBar = null;
        this.expTank = null;
        this.editor = null;
        this.foreland = 1;
        this.listeners = new ArrayList(1);
        this.initializeUI();
    }

    public void initializeUI() {
        this.expBank = new ExpressionBank();
        this.lstExpression.setModel((ListModel)this.expBank);
        this.lstExpression.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                RptCheckExpression ep;
                String cnt = "";
                int index = RptCheckUI.this.lstExpression.getSelectedIndex();
                if (index != -1 && (ep = (RptCheckExpression)RptCheckUI.this.expBank.getElementAt(index)) != null) {
                    cnt = ep.getContent();
                }
                RptCheckUI.this.txtContent.setText(cnt);
            }
        });
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    RptCheckUI.this.editExpression();
                }
            }
        };
        this.lstExpression.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                int index = RptCheckUI.this.lstExpression.getSelectedIndex();
                if (index == -1) {
                    return;
                }
                RptCheckExpression exp = (RptCheckExpression)RptCheckUI.this.expBank.getElementAt(index);
                RptCheckUI.this.btnEdit.setEnabled(RptCheckUI.this.openReportCanSaveCheckSolution && exp.isEditable());
                RptCheckUI.this.btnDelete.setEnabled(RptCheckUI.this.openReportCanSaveCheckSolution && exp.isDeleteable());
            }
        });
        this.lstExpression.addMouseListener((MouseListener)ml);
        this.txtContent.addMouseListener((MouseListener)ml);
        this.btnAdd.setText(null);
        this.btnAdd.setIcon(RptResourceHelper.getIcon("imgTbtn_new"));
        this.btnDelete.setText(null);
        this.btnDelete.setIcon(RptResourceHelper.getIcon("imgTbtn_delete"));
        this.btnEdit.setText(null);
        this.btnEdit.setIcon(RptResourceHelper.getIcon("imgTbtn_edit"));
        this.txtContent.setEnabled(false);
        this.btnImport.setEnabled(true);
        this.btnOutput.setEnabled(true);
        this.btnOutput.setIcon(RptResourceHelper.getIcon("imgTbtn_output"));
        this.btnImport.setIcon(RptResourceHelper.getIcon("imgTbtn_input"));
    }

    @Override
    public void actionBtnAdd_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnAdd_actionPerformed(e);
        String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"137_RptCheckUI");
        RptCheckExpression expr = new RptCheckExpression(MessageFormat.format(msg, this.getForeland()), defaultExpression);
        expr.setSheetName(this.getCurSheetName());
        this.editExpression(expr, true);
    }

    public RptCheckExpression[] createDefaultRptCheckExpression(int size) {
        RptCheckExpression[] eps = new RptCheckExpression[size];
        int i = 0;
        int base = this.getForeland();
        while (i < size) {
            eps[i] = new RptCheckExpression(RptResourceHelper.getString("rptcheck-expression-new") + base, defaultExpression);
            eps[i].setSheetName(this.getCurSheetName());
            ++i;
            ++base;
        }
        return eps;
    }

    protected String getCurSheetName() {
        DefaultKingdeeTreeNode nd;
        TreePath path = this.treSheets.getSelectionPath();
        if (path != null && (nd = (DefaultKingdeeTreeNode)path.getLastPathComponent()) != null && nd.isLeaf()) {
            return nd.getText();
        }
        return null;
    }

    public int getForeland() {
        this.foreland = 0;
        for (int i = this.expBank.entrys.size() - 1; i >= 0; --i) {
            RptCheckExpression expr = (RptCheckExpression)this.expBank.entrys.get(i);
            int num = TableToolkit.parsePostfixNumber(expr.getName());
            if (this.foreland >= num) continue;
            this.foreland = num;
        }
        return ++this.foreland;
    }

    @Override
    public void actionBtnEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnEdit_actionPerformed(e);
        this.editExpression();
    }

    @Override
    public void actionBtnDelete_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnDelete_actionPerformed(e);
        int[] count = this.lstExpression.getSelectedIndices();
        int length = count.length;
        if (length > 1) {
            int[] select = this.lstExpression.getSelectedIndices();
            for (int i = length - 1; i >= 0; --i) {
                this.expBank.remove(select[i]);
            }
        } else {
            int index = this.lstExpression.getSelectedIndex();
            if (this.expBank.remove(index)) {
                if (index > 0) {
                    --index;
                }
                if (index >= 0 && index < this.expBank.getSize()) {
                    this.lstExpression.setSelectedIndex(index);
                }
            }
        }
    }

    @Override
    public void actionBtnOk_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnOk_actionPerformed(e);
        this.endWizard(true);
    }

    @Override
    public void actionBtnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnCancel_actionPerformed(e);
        this.endWizard(false);
    }

    @Override
    public void open(Object cookie, String title) {
        this.open(cookie, title, null, null);
    }

    public void open(Object cookie, String title, IBookProvider iBookProvider, Object uiContext) {
        this.open(cookie, title, null, null, true);
    }

    public void open(Object cookie, String title, IBookProvider iBookProvider, Object uiContext, boolean openReportCanSaveCheckSolution) {
        IUIWindow w;
        this.fireListenersSetout();
        this.openReportCanSaveCheckSolution = openReportCanSaveCheckSolution;
        if (!this.loadExpressions((RptCheckExpTank)cookie)) {
            this.fireListenersReturnee(null, false);
        }
        if ((w = this.getUIWindow()) instanceof KDDialog) {
            KDDialog d = (KDDialog)w;
            if (title != null) {
                d.setTitle(title);
            }
            d.addWindowListener((WindowListener)new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    RptCheckUI.this.endWizard(false);
                }
            });
        }
        w.show();
    }

    public boolean loadExpressions(RptCheckExpTank tank) {
        this.expTank = tank != null ? (RptCheckExpTank)tank.clone() : new RptCheckExpTank();
        if (this.allSheetsName == null) {
            String sheetList = this.getSheetList();
            if (sheetList == null) {
                return false;
            }
            this.loadSheetTree(sheetList.split(","));
        } else {
            this.loadSheetTree(this.allSheetsName.toArray(new String[0]));
        }
        this.treSheets.setSelectionPath(this.treSheets.getPathForRow(1));
        return true;
    }

    private void loadSheetTree(String[] shtList) {
        KingdeeTreeModel md = (KingdeeTreeModel)this.treSheets.getModel();
        md.setRoot(null);
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        if (shtList.length > 0) {
            root.setText(shtList[0]);
        }
        DefaultKingdeeTreeNode entry = null;
        for (int i = 1; i < shtList.length; ++i) {
            entry = new DefaultKingdeeTreeNode();
            entry.setText(shtList[i]);
            root.add((MutableTreeNode)entry);
        }
        md.setRoot((TreeNode)root);
        this.treSheets.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultKingdeeTreeNode nd = (DefaultKingdeeTreeNode)e.getPath().getLastPathComponent();
                RptCheckUI.this.loadSheetExpressions(nd.isLeaf() ? nd.getText() : null);
            }
        });
    }

    void loadSheetExpressions(String sheetName) {
        this.expBank.clear();
        boolean isEditable = sheetName != null;
        this.btnAdd.setEnabled(this.openReportCanSaveCheckSolution && isEditable);
        this.btnDelete.setEnabled(this.openReportCanSaveCheckSolution && isEditable);
        this.btnEdit.setEnabled(this.openReportCanSaveCheckSolution && isEditable);
        if (!isEditable) {
            return;
        }
        this.expTank.getSheetExpression(sheetName, "", this.expBank.entrys);
        this.expBank.update();
        if (this.expBank.getSize() > 0) {
            this.lstExpression.setSelectedIndex(0);
        }
    }

    protected void editExpression() {
        int index = this.lstExpression.getSelectedIndex();
        if (index == -1) {
            return;
        }
        this.editExpression((RptCheckExpression)this.expBank.getElementAt(index), false);
    }

    protected void editExpression(RptCheckExpression expr, boolean isAddNew) {
        if (expr == null) {
            return;
        }
        if (!expr.isEditable()) {
            return;
        }
        if (this.editor == null) {
            try {
                this.getUIContext().put("Owner", this);
                this.getUIContext().put("isK3", isK3);
                this.editor = RptCheckExpressionEditUI.getUIInstance(this.getUIContext());
                this.editor.addSimpleDialogListener(new EditorListener());
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if (!isAddNew) {
            this.curExpression = expr;
        }
        this.editor.open(expr, Boolean.valueOf(isAddNew).toString());
    }

    public boolean checkExprName(String name) {
        boolean res = false;
        if (name == null || name.length() == 0) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("NeedSchemaName"));
        } else if (this.expBank.contains(name)) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("SchemaNameExists"));
        } else {
            res = true;
        }
        return res;
    }

    public boolean containsCheckItemName(String name) {
        return this.expBank.contains(name);
    }

    void endWizard(boolean isOk) {
        this.disposeUIWindow();
        this.fireListenersReturnee(this.expTank, isOk);
    }

    @Override
    public synchronized void addSimpleDialogListener(ISimpleDialogListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    private String getSheetList() {
        IControlledDialogListener l;
        String res = null;
        RptTablePane pna = null;
        Iterator ls = this.listeners.iterator();
        while (ls.hasNext() && ((l = (IControlledDialogListener)ls.next()) == null || (pna = (RptTablePane)((Object)l.getTrueController())) == null)) {
        }
        if (pna != null) {
            res = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.lable11");
            res = res + ',';
            int num = pna.getTabCount();
            for (int i = 0; i < num; ++i) {
                res = res + pna.getTitleAt(i) + ',';
            }
        }
        return res;
    }

    private void fireListenersReturnee(RptCheckExpTank tank, boolean isOk) {
        for (ISimpleDialogListener l : this.listeners) {
            if (l == null) continue;
            l.pilotReturnee(this, tank, isOk);
        }
    }

    private void fireListenersSetout() {
        for (ISimpleDialogListener l : this.listeners) {
            if (l == null) continue;
            l.pilotSetout(this);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        RptHelper.setDefaultButton(this, (JButton)this.btnOk);
        RptHelper.setEscAction(this, (Action)((Object)this.actionBtnCancel));
        RptHelper.registF1Action(this, (Action)((Object)this.actionHelp));
    }

    @Override
    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
        CSH.setHelpIDString((Component)((Component)e.getSource()), (String)"fatempClassAttribute");
        CSH.DisplayHelpFromSource help = new CSH.DisplayHelpFromSource(HelpBasicData.getInstance().getHelpBroker());
        help.actionPerformed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionOutput_actionPerformed(ActionEvent e) throws Exception {
        String path = this.getPathName(false);
        if (path != null) {
            File file = new File(path + ".txt");
            if (file.exists()) {
                int rt = 0;
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"89_RptCheckUI");
                rt = MsgBox.showConfirm2((Component)((Object)this), (String)MessageFormat.format(msg, path));
                if (2 == rt || rt == 1) {
                    return;
                }
                file.delete();
                file = new File(path + ".txt");
            }
            KingdeeTreeModel md = (KingdeeTreeModel)this.treSheets.getModel();
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)md.getRoot();
            OutputStreamWriter writer = null;
            FileOutputStream fillOut = null;
            try {
                fillOut = new FileOutputStream(file);
                writer = new OutputStreamWriter(fillOut);
                int count = root.getChildCount();
                for (int i = 0; i < count; ++i) {
                    DefaultKingdeeTreeNode entry = (DefaultKingdeeTreeNode)root.getChildAt(i);
                    String sheetName = entry.getText();
                    writer.write("[" + sheetName + "]\r\n");
                    ArrayList formulas = new ArrayList();
                    this.expTank.getSheetExpression(sheetName, this.currentOrgNum, formulas);
                    for (RptCheckExpression exp : formulas) {
                        String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"138_RptCheckUI");
                        writer.write(MessageFormat.format(msg, exp.getName(), exp.getContent(), exp.getDescription(), exp.getCheckResultState()) + "\r\n");
                    }
                }
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.lable8"));
            }
            catch (Throwable throwable) {
                CslRptUtil.close(writer);
                CslRptUtil.close((Object)fillOut);
                throw throwable;
            }
            CslRptUtil.close((Object)writer);
            CslRptUtil.close((Object)fillOut);
        }
    }

    @Override
    public void actioonImport_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        HashMap returnObject = new HashMap();
        uiContext.put((Object)"RETURN_OBJECT", returnObject);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SheetSelectUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        if (returnObject.get("BTN").equals("CANCEL")) {
            return;
        }
        String path = (String)returnObject.get("FILE_NAME");
        if (path == null) {
            return;
        }
        HashMap sheets = this.getSheets(path, (ArrayList)returnObject.get("SHEET_NAMES"));
        if (sheets == null) {
            return;
        }
        KingdeeTreeModel md = (KingdeeTreeModel)this.treSheets.getModel();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)md.getRoot();
        StringBuffer sheetInfoBuf = new StringBuffer();
        HashMap<String, Sheet> sheetOlds = new HashMap<String, Sheet>();
        int count = root.getChildCount();
        for (int i = 0; i < count; ++i) {
            DefaultKingdeeTreeNode entry = (DefaultKingdeeTreeNode)root.getChildAt(i);
            Sheet sheet = new Sheet();
            sheet.sheetName = entry.getText();
            sheetOlds.put(sheet.sheetName, sheet);
            ArrayList formulas = new ArrayList();
            this.expTank.getSheetExpression(sheet.sheetName, this.currentOrgNum, formulas);
            for (RptCheckExpression exp : formulas) {
                sheet.checkItems.put(exp.getName(), exp.getContent());
            }
        }
        Iterator it1 = sheets.keySet().iterator();
        ArrayList filter = new ArrayList();
        while (it1.hasNext()) {
            Object obj = it1.next();
            if (sheetOlds.get(obj) != null) continue;
            sheetInfoBuf.append("[" + obj + "]");
            filter.add(obj);
        }
        if (sheetInfoBuf.length() > 0) {
            int rt = 0;
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"91_RptCheckUI");
            rt = MsgBox.showConfirm2((Component)((Object)this), (String)MessageFormat.format(msg, sheetInfoBuf.toString()));
            if (rt == 2 || rt == 1) {
                return;
            }
            for (int i = 0; i < filter.size(); ++i) {
                sheets.remove(filter.get(i));
            }
        }
        StringBuffer formulaBuffer = new StringBuffer();
        HashMap filterMap = new HashMap();
        Iterator it7 = sheets.keySet().iterator();
        while (it7.hasNext()) {
            StringBuffer buf = new StringBuffer();
            Object sheetName = it7.next();
            Sheet oldSheet = (Sheet)sheetOlds.get(sheetName);
            if (oldSheet != null) {
                Sheet newSheet = (Sheet)sheets.get(sheetName);
                for (String itemName : newSheet.checkItems.keySet()) {
                    ArrayList<String> list;
                    if (oldSheet.checkItems.get(itemName) != null) {
                        buf.append("[" + itemName + "]");
                    }
                    if ((list = (ArrayList<String>)filterMap.get(sheetName)) == null) {
                        list = new ArrayList<String>();
                        filterMap.put(sheetName, list);
                    }
                    list.add(itemName);
                }
            }
            if (buf.length() <= 0) continue;
            formulaBuffer.append("{ " + sheetName + " " + buf + " }\n");
        }
        if (formulaBuffer.length() > 0) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.lable3");
            int rt2 = MsgBox.showConfirm3((Component)((Object)this), (String)(msg + formulaBuffer.toString() + "\uff1f"));
            if (rt2 == 2) {
                return;
            }
            if (rt2 == 1) {
                for (Object sheetName : filterMap.keySet()) {
                    ArrayList filterItemList = (ArrayList)filterMap.get(sheetName);
                    Sheet sheet = (Sheet)sheets.get(sheetName);
                    for (int i = 0; i < filterItemList.size(); ++i) {
                        sheet.checkItems.remove(filterItemList.get(i));
                    }
                }
            }
        }
        StringBuffer error = new StringBuffer();
        for (String sheetName : sheets.keySet()) {
            if (sheetOlds.get(sheetName) == null) {
                root.add((MutableTreeNode)new DefaultKingdeeTreeNode((Object)sheetName));
            }
            ExpressionBank tempBlank = new ExpressionBank();
            this.expTank.getSheetExpression(sheetName, this.currentOrgNum, tempBlank.entrys);
            Sheet sheet = (Sheet)sheets.get(sheetName);
            Iterator itt34 = sheet.iterator();
            while (itt34.hasNext()) {
                Checkitem itm = (Checkitem)itt34.next();
                RptCheckExpression exp = new RptCheckExpression();
                exp.setSheetName(sheetName);
                exp.setContent(itm.content);
                exp.setName(itm.name);
                exp.setDescription(itm.desc);
                exp.setCheckResultState(itm.checkResultState);
                if (tempBlank.contains(exp.getName())) {
                    if (tempBlank.canCover(exp.getName())) {
                        tempBlank.remove(exp.getName());
                        tempBlank.add(exp);
                        continue;
                    }
                    error.append(sheetName + "  " + exp.getName() + "\r\n");
                    continue;
                }
                tempBlank.add(exp);
            }
        }
        this.loadExpressions(this.expTank);
        if (error.length() > 0) {
            error.append(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.label4"));
            UIContext uiCtx = new UIContext((Object)this);
            uiCtx.put((Object)"Title", (Object)RptUtil.getResourceSince51("RESULT"));
            uiCtx.put((Object)"ShowOpen", (Object)Boolean.FALSE);
            SimpleNotePad.showMessageByModel((UIContext)uiCtx, (String)error.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public HashMap getSheets(String path, ArrayList list) {
        Sheet sheet = null;
        HashMap<String, Sheet> map = new HashMap<String, Sheet>();
        BufferedReader in = null;
        FileInputStream fileIn = null;
        InputStreamReader inStr = null;
        try {
            fileIn = new FileInputStream(path);
            inStr = new InputStreamReader(fileIn);
            in = new BufferedReader(inStr);
            String line = in.readLine();
            String lineNext = "";
            while (line != null) {
                try {
                    line = line.trim();
                    if (lineNext.length() > 0) {
                        line = lineNext + "\n" + line.trim();
                    }
                    if (line.startsWith("[") && line.endsWith("]")) {
                        String sheetName = line.substring(1, line.length() - 1).trim();
                        sheet = new Sheet();
                        sheet.sheetName = sheetName.trim();
                        if (list.contains(sheetName)) {
                            map.put(sheetName, sheet);
                        }
                    } else if (line.indexOf(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"209_RptCheckUI")) >= 0 && line.indexOf(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"210_RptCheckUI")) >= 0 && line.indexOf(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"211_RptCheckUI")) >= 0 && line.indexOf(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"212_RptCheckUI")) >= 0) {
                        lineNext = "";
                        String name = line.substring(0, line.indexOf(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"210_RptCheckUI")));
                        String content = line.substring(line.indexOf(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"210_RptCheckUI")), line.indexOf(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"211_RptCheckUI")));
                        String desc = line.substring(line.indexOf(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"211_RptCheckUI")), line.indexOf(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"213_RptCheckUI")));
                        int checkResultState = new Integer(line.substring(line.indexOf(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"213_RptCheckUI")) + EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"213_RptCheckUI").length()));
                        name = name.replaceAll(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"209_RptCheckUI"), "").trim();
                        content = content.replaceAll(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"210_RptCheckUI"), "").trim();
                        desc = desc.replaceAll(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"211_RptCheckUI"), "").trim();
                        Checkitem itm = new Checkitem();
                        itm.name = name;
                        itm.content = content;
                        itm.desc = desc;
                        itm.checkResultState = checkResultState;
                        if (sheet != null) {
                            sheet.add(itm);
                        }
                    } else if (line.trim().length() > 0) {
                        lineNext = line.trim();
                    }
                    line = in.readLine();
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
        }
        catch (FileNotFoundException e) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.lable5");
            MsgBox.showError((Component)((Object)this), (String)msg);
            HashMap hashMap = null;
            CslRptUtil.close(in);
            CslRptUtil.close((Object)inStr);
            CslRptUtil.close((Object)fileIn);
            return hashMap;
        }
        catch (IOException iOException) {
            CslRptUtil.close(in);
            CslRptUtil.close(inStr);
            CslRptUtil.close((Object)fileIn);
            {
                catch (Throwable throwable) {
                    CslRptUtil.close(in);
                    CslRptUtil.close(inStr);
                    CslRptUtil.close((Object)fileIn);
                    throw throwable;
                }
            }
        }
        CslRptUtil.close((Object)in);
        CslRptUtil.close((Object)inStr);
        CslRptUtil.close((Object)fileIn);
        return map;
    }

    private String getPathName(boolean isInMode) {
        String msg;
        String pathName = null;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new PathFilter(isInMode));
        if (isInMode) {
            msg = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.lable6");
            chooser.setDialogTitle(msg);
        } else {
            msg = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.lable7");
            chooser.setDialogTitle(msg);
        }
        int returnVal = chooser.showSaveDialog((Component)((Object)this));
        if (returnVal == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return pathName;
    }

    public void setSheetNames(List allSheetsName) {
        this.allSheetsName = allSheetsName;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        KeyStroke ks = KeyStroke.getKeyStroke("ctrl shift H");
        String strKey = "CTRL_SHIFT_D";
        this.getActionMap().put(strKey, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RptCheckUI.this.actionBtnDelete_actionPerformed(e);
                }
                catch (Exception e1) {
                    RptCheckUI.this.handUIException(e1);
                }
            }
        });
        this.getInputMap(2).put(ks, strKey);
    }

    public String getCurrentOrgNum() {
        return this.currentOrgNum;
    }

    public void setCurrentOrgNum(String currentOrgNum) {
        this.currentOrgNum = currentOrgNum;
    }

    public String getCreatorOrgNum() {
        return this.creatorOrgNum;
    }

    public void setCreatorOrgNum(String creatorOrgNum) {
        this.creatorOrgNum = creatorOrgNum;
    }

    public boolean isCreator() {
        return this.isCreator;
    }

    public void setCreator(boolean isCreator) {
        this.isCreator = isCreator;
    }

    public boolean isCslReportAudit() {
        return this.isCslReportAudit;
    }

    public void setCslReportAudit(boolean isCslReportAudit) {
        this.isCslReportAudit = isCslReportAudit;
    }

    public class Checkitem {
        public String name;
        public String content;
        public String desc;
        public int checkResultState;
    }

    public class Sheet {
        public String sheetName;
        public HashMap checkItems = new HashMap();
        public ArrayList sortList = new ArrayList();

        void add(Checkitem itm) {
            this.checkItems.put(itm.name, itm);
            this.sortList.add(itm.name);
        }

        public Iterator iterator() {
            return new MIterator();
        }

        class MIterator
        implements Iterator {
            Iterator it1;
            Object value;

            MIterator() {
                this.it1 = Sheet.this.sortList.iterator();
                this.value = null;
            }

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.value != null) {
                    return true;
                }
                Object curKey = null;
                while (this.it1.hasNext()) {
                    curKey = this.it1.next();
                    if (Sheet.this.checkItems.get(curKey) == null) continue;
                    this.value = Sheet.this.checkItems.get(curKey);
                    break;
                }
                return this.value != null;
            }

            public Object next() {
                Object value1 = this.value;
                this.value = null;
                return value1;
            }
        }
    }

    private class PathFilter
    extends FileFilter {
        private boolean modeIn;

        public PathFilter(boolean inMode) {
            this.modeIn = inMode;
        }

        @Override
        public boolean accept(File arg0) {
            return arg0.getName().endsWith(".txt") || arg0.getName().endsWith(".txt");
        }

        @Override
        public String getDescription() {
            return ".txt/.TXT";
        }
    }

    public class ExpressionBank
    extends AbstractListModel {
        public ArrayList entrys = new ArrayList(1);

        public boolean contains(String name) {
            if (name == null) {
                return false;
            }
            for (int i = this.entrys.size() - 1; i >= 0; --i) {
                RptCheckExpression expr = (RptCheckExpression)this.entrys.get(i);
                if (!name.equalsIgnoreCase(expr.getName())) continue;
                return true;
            }
            return false;
        }

        public boolean canCover(String name) {
            if (name == null) {
                return true;
            }
            for (int i = this.entrys.size() - 1; i >= 0; --i) {
                RptCheckExpression expr = (RptCheckExpression)this.entrys.get(i);
                if (!name.equalsIgnoreCase(expr.getName())) continue;
                return expr.isDeleteable() && expr.isEditable();
            }
            return true;
        }

        public void remove(String name) {
            if (name == null) {
                return;
            }
            for (int i = this.entrys.size() - 1; i >= 0; --i) {
                RptCheckExpression expr = (RptCheckExpression)this.entrys.get(i);
                if (!name.equalsIgnoreCase(expr.getName())) continue;
                this.remove(i);
                return;
            }
        }

        public void update() {
            this.fireContentsChanged(this, 0, this.entrys.size());
        }

        public void update(int index) {
            this.fireContentsChanged(this, index, index);
        }

        public void clear() {
            this.fireIntervalRemoved(this, 0, this.entrys.size());
            this.entrys.clear();
        }

        public boolean add(RptCheckExpression exp) {
            if (exp == null) {
                return false;
            }
            RptCheckUI.this.expTank.add(exp);
            this.entrys.add(exp);
            int index = this.entrys.size() - 1;
            this.fireIntervalAdded(this, index, index);
            return true;
        }

        public boolean remove(int index) {
            if (index < 0 || index >= this.entrys.size()) {
                return false;
            }
            RptCheckUI.this.expTank.remove((RptCheckExpression)this.entrys.get(index));
            this.entrys.remove(index);
            this.fireIntervalRemoved(this, index, index);
            return true;
        }

        @Override
        public int getSize() {
            return this.entrys.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.entrys.get(index);
        }
    }

    public class EditorListener
    implements IControlledDialogListener {
        @Override
        public Object getTrueController() {
            return RptCheckUI.this;
        }

        @Override
        public void pilotSetout(ISimpleDialog source) {
        }

        @Override
        public void pilotReturnee(ISimpleDialog source, Object result, boolean isOk) {
            if (isOk) {
                if (((RptCheckExpressionEditUI)source).isAddNew() && result != null) {
                    if (result instanceof RptCheckExpression) {
                        RptCheckUI.this.curExpression = (RptCheckExpression)result;
                        if (RptCheckUI.this.expBank.add(RptCheckUI.this.curExpression)) {
                            RptCheckUI.this.lstExpression.setSelectedIndex(RptCheckUI.this.expBank.getSize() - 1);
                        }
                    } else {
                        RptCheckExpression[] eps = (RptCheckExpression[])result;
                        for (int i = 0; i < eps.length; ++i) {
                            RptCheckUI.this.expBank.add(eps[i]);
                            RptCheckUI.this.curExpression = eps[i];
                        }
                        RptCheckUI.this.lstExpression.setSelectedIndex(RptCheckUI.this.expBank.getSize() - 1);
                    }
                } else {
                    RptCheckUI.this.curExpression.copyFrom((RptCheckExpression)result);
                    int index = RptCheckUI.this.expBank.entrys.indexOf(RptCheckUI.this.curExpression);
                    if (index != -1) {
                        RptCheckUI.this.expBank.update(index);
                        RptCheckUI.this.lstExpression.setSelectedIndex(index);
                        RptCheckUI.this.txtContent.setText(RptCheckUI.this.curExpression.getContent());
                    }
                }
            }
        }
    }
}

