/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.rpt.ColorSchemeCollection;
import com.kingdee.eas.fi.rpt.ColorSchemeFactory;
import com.kingdee.eas.fi.rpt.ColorSchemeInfo;
import com.kingdee.eas.fi.rpt.IColorScheme;
import com.kingdee.eas.fi.rpt.client.AbstractRptColorSchemesUI;
import com.kingdee.eas.fi.rpt.client.ColorChangeListener;
import com.kingdee.eas.fi.rpt.util.ColorCellEditor;
import com.kingdee.eas.fi.rpt.util.ColorUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.IIDList;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;

public class RptColorSchemesUI
extends AbstractRptColorSchemesUI {
    private static final Logger logger = CoreUIObject.getLogger(RptColorSchemesUI.class);
    private EventListenerList listenerList = new EventListenerList();
    private IColorScheme colorScheme;

    public RptColorSchemesUI() throws Exception {
        this.tblMain.getActionMap().remove("Delete");
        this.tblMain.getActionMap().remove("Paste");
        this.tblMain.getActionMap().remove("Cut");
    }

    public void onLoad() throws Exception {
        this.setDataObject(this.createNewData());
        super.onLoad();
        this.tblMain.getColumn("itemValue").setEditor((ICellEditor)new ColorCellEditor());
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                if (e.getColIndex() == RptColorSchemesUI.this.tblMain.getColumnIndex("itemValue") && e.getValue() != null) {
                    Color color = ColorUtil.parseColor(e.getValue());
                    RptColorSchemesUI.this.tblMain.getCell(e.getRowIndex(), e.getColIndex()).getStyleAttributes().setBackground(color);
                }
            }
        });
        this.tblMain.getColumn("itemValue").getStyleAttributes().setLocked(false);
    }

    @Override
    public void loadCollectionFields() {
        super.loadCollectionFields();
        ICell cell = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            cell = this.tblMain.getRow(i).getCell("itemValue");
            cell.getStyleAttributes().setBackground(ColorUtil.parseColor(cell.getValue()));
        }
    }

    protected void loadDataCollection() throws Exception {
        if (this.getUIContext().get("InitDataObject") != null && this.getUIContext().get("InitDataObject") instanceof IObjectCollection) {
            this.setDataCollection((IObjectCollection)this.getUIContext().get("InitDataObject"));
        } else if (this.getUIContext().get("IDList") != null) {
            this.setDataCollection(this.getCollection((IIDList)this.getUIContext().get("IDList")));
        } else {
            Object ownerUI = this.getUIContext().get("Owner");
            String uiClassName = ownerUI.getClass().getName();
            if (ownerUI instanceof CoreUI) {
                CoreUI ownerCoreUI = (CoreUI)ownerUI;
                uiClassName = ownerCoreUI.getMetaDataPK().getFullName();
            }
            this.setDataCollection((IObjectCollection)((IColorScheme)this.getBizInterface()).getColorSchemes(uiClassName));
        }
        this.loadCollectionFields();
    }

    public void initWorkButton() {
        super.initWorkButton();
        boolean enableAndVisible = false;
        this.actionSave.setEnabled(enableAndVisible);
        this.actionSave.setVisible(enableAndVisible);
        this.actionAddLine.setEnabled(enableAndVisible);
        this.actionAddLine.setVisible(enableAndVisible);
        this.actionInsertLine.setEnabled(enableAndVisible);
        this.actionInsertLine.setVisible(enableAndVisible);
        this.actionRemoveLine.setEnabled(enableAndVisible);
        this.actionRemoveLine.setVisible(enableAndVisible);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.fireColorSchemeChange();
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
    }

    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsertLine_actionPerformed(e);
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
    }

    protected IObjectCollection createNewCollection() {
        return new ColorSchemeCollection();
    }

    protected IObjectValue createNewData() {
        ColorSchemeInfo colorScheme = new ColorSchemeInfo();
        Object ownerUI = this.getUIContext().get("Owner");
        String uiClassName = ownerUI.getClass().getName();
        if (ownerUI instanceof CoreUI) {
            CoreUI ownerCoreUI = (CoreUI)ownerUI;
            uiClassName = ownerCoreUI.getMetaDataPK().getFullName();
        }
        colorScheme.setUiClassName(uiClassName);
        return colorScheme;
    }

    protected ICoreBase getBizInterface() throws Exception {
        if (this.colorScheme == null) {
            this.colorScheme = ColorSchemeFactory.getRemoteInstance();
        }
        return this.colorScheme;
    }

    public void addColorChangeListener(ColorChangeListener l) {
        this.listenerList.add(ColorChangeListener.class, l);
    }

    private Map getColorSchemes() {
        HashMap<String, Color> colorSchemes = new HashMap<String, Color>();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            String key = (String)this.tblMain.getRow(i).getCell("itemKey").getValue();
            String value = (String)this.tblMain.getRow(i).getCell("itemValue").getValue();
            colorSchemes.put(key, ColorUtil.parseColor(value));
        }
        return colorSchemes;
    }

    protected void fireColorSchemeChange() {
        Map colorSchemes = this.getColorSchemes();
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ColorChangeListener.class) continue;
            ((ColorChangeListener)listeners[i + 1]).colorChanged(colorSchemes);
        }
    }
}

