/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportGroupEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseCollection;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseFactory;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptParaMgrStartergy;
import com.kingdee.eas.fi.gr.cslrpt.client.GroupRptMenuStrategy;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.IRptSheetParam;
import com.kingdee.eas.fi.rpt.PublicStatusEnum;
import com.kingdee.eas.fi.rpt.PublishedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.client.AbstractRptCommitEditUI;
import com.kingdee.eas.fi.rpt.client.ReportMaintainUI;
import com.kingdee.eas.fi.rpt.client.RptMenuStrategy;
import com.kingdee.eas.fi.rpt.client.RptParaMgrStartergy;
import com.kingdee.eas.fi.rpt.client.RptReportProcessUI;
import com.kingdee.eas.fi.rpt.client.RptStrategyManager;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.workflow.IMultiAssignmentUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Map;
import javax.swing.JButton;

public class RptCommitEditUI
extends AbstractRptCommitEditUI {
    String currCompanyID = null;
    TempletDispenseInfo templetDispenseInfo = null;

    public RptCommitEditUI() throws Exception {
        this.prmtSavePlace.setEnabled(false);
        this.cbxPeriodType.setEnabled(false);
        this.rbnGroupTemplate.setSelected(true);
        this.rbnCommonTemplate.setEnabled(false);
        this.rbnNoTemplate.setEnabled(false);
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.remove((Component)this.btnAdd);
        this.remove((Component)this.btnDel);
        this.ctnOrg.addButton((JButton)this.btnAdd);
        this.ctnOrg.addButton((JButton)this.btnDel);
    }

    @Override
    public void audit() throws Exception {
        ObjectStringPK pk = new ObjectStringPK();
        pk.setKeyValue(this.editData.getPKField(), (Object)this.editData.getId().toString());
        if (this.getIsAudited()) {
            ((ICslReport)this.getBizInterface()).unAudit((IObjectPK)pk);
            this.editData.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        } else {
            this.checkAudit();
            ((ICslReport)this.getBizInterface()).audit((IObjectPK)pk);
            this.editData.setAuditedStatus(AuditedStatusEnum.AUDITED);
        }
    }

    public void checkAudit() throws Exception {
        boolean bIsExists;
        ICslReport cslReport = CslReportFactory.getRemoteInstance();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgTree", (Object)this.editData.getOrgTree().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)this.editData.getCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("currency", (Object)this.editData.getCurrency().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("template", (Object)this.editData.getTemplate().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)new Integer(this.editData.getPeriodType().getValue())));
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)new Integer(this.editData.getYear())));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)new Short(this.editData.getPeriod())));
        filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)new Integer(this.editData.getSourceType().getValue())));
        filter.getFilterItems().add(new FilterItemInfo("auditedStatus", (Object)new Integer(2)));
        if (super.getOprtState().equals(OprtState.EDIT)) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId().toString(), CompareType.NOTEQUALS));
        }
        if (bIsExists = cslReport.exists(filter)) {
            MsgBox.showWarning((String)RptUtil.getResourceSince51("SameConditionReportAudited"));
            SysUtil.abort();
        }
    }

    @Override
    public IObjectValue createNewData() {
        CslReportInfo reportInfo = new CslReportInfo();
        reportInfo.setPeriodType(RptPeriodTypeEnum.MONTHLY);
        if (this.currentYear != null) {
            reportInfo.setYear(this.currentYear.intValue());
        }
        if (this.currentPeriod != null) {
            reportInfo.setPeriod(this.currentPeriod.shortValue());
        }
        reportInfo.setPublicStatus(PublicStatusEnum.UNPUBLIC);
        reportInfo.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
        reportInfo.setId(BOSUuid.create((BOSObjectType)reportInfo.getBOSType()));
        try {
            reportInfo.setCompany(RptUtilForClient.getCurrentCompany());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return reportInfo;
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.selfLoadField();
        this.rbnGroupTemplate.setSelected(true);
        this.prmtTemplate.setEnabled(true);
        if (this.getOprtState().equals("ADDNEW")) {
            this.templateTypeChange();
        } else {
            this.construstDispenseTemplate();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.selfstoreFields();
        this.editData.setReportDate(RPTDateUtil.getPeriodLastDate((int)this.editData.getYear(), (int)this.editData.getPeriod(), (RptPeriodTypeEnum)this.editData.getPeriodType()));
    }

    @Override
    public VirtualSheetParamInfo save() throws Exception {
        this.selfVerifyInput();
        if (this.editData.getAuditedStatus() != null && this.editData.getAuditedStatus().getValue() == 2) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("ReportAlreadyAudited"));
            this.editData.setChgStatus(0);
            return this.editData;
        }
        this.checkAssignment((ItemAction)this.actionSubmit);
        this.storeFields();
        this.verifyInput(null);
        ((ICslReport)this.getBizInterface()).submit((CoreBaseInfo)this.editData);
        this.setDataObject((IObjectValue)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(this.editData.getId()), this.getSelectors()));
        this.setOprtState("EDIT");
        this.save = true;
        if (this.getUIContext().get("isFromWorkflow") == null || !((Boolean)this.getUIContext().get("isFromWorkflow")).booleanValue()) {
            ((ReportMaintainUI)this.getUIContext().get("Owner")).selfRefresh();
        }
        return this.editData;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return CslReportFactory.getRemoteInstance();
    }

    @Override
    public RptStrategyManager getRptStrategyManager() {
        RptStrategyManager rptStrategyManager = new RptStrategyManager();
        GroupRptMenuStrategy cslMenu = new GroupRptMenuStrategy();
        cslMenu.setReportBaseInfo((ReportBaseInfo)this.editData);
        cslMenu.setOpenType(1);
        rptStrategyManager.setCslParamStartegy(false);
        rptStrategyManager.setRptMenuStartegy((RptMenuStrategy)cslMenu);
        CslRptParaMgrStartergy para = new CslRptParaMgrStartergy();
        rptStrategyManager.setRptParaMgrStartergy((RptParaMgrStartergy)para);
        return rptStrategyManager;
    }

    @Override
    public void prmtTemplateChange() {
        super.prmtTemplateChange();
        this.construstDispenseTemplate();
    }

    protected void construstDispenseTemplate() {
        if (this.editData.getTemplate() == null) {
            return;
        }
        if (this.currCompanyID == null) {
            this.currCompanyID = (String)SysContext.getSysContext().getProperty((Object)"CurCompanyId");
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("orgBound.id"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("dispenseSrcID"));
        sic.add(new SelectorItemInfo("isAllowChgTemplet"));
        sic.add(new SelectorItemInfo("isCoverTmpFormula"));
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("company.id", (Object)this.currCompanyID);
        FilterItemInfo filterItem2 = new FilterItemInfo("sourceType", (Object)Integer.valueOf("1"));
        FilterItemInfo filterItem3 = new FilterItemInfo("dispenseSrcID", (Object)this.editData.getTemplate().getId().toString());
        filter.getFilterItems().add(filterItem);
        filter.getFilterItems().add(filterItem2);
        filter.getFilterItems().add(filterItem3);
        view.setFilter(filter);
        try {
            TempletDispenseCollection templetDispenseCollection = TempletDispenseFactory.getRemoteInstance().getTempletDispenseCollection(view);
            if (templetDispenseCollection.size() > 0) {
                this.templetDispenseInfo = templetDispenseCollection.get(0);
                this.editData.setOrgUnit(this.templetDispenseInfo.getCompany());
                this.editData.setOrgTree(this.templetDispenseInfo.getOrgBound());
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public String getProcessUI() {
        return RptReportProcessUI.class.getName();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return this.getSelfSelections();
    }

    @Override
    public RptSheetParamInfo processCreat(String sheetId) {
        RptSheetParamInfo newSheetParam = new RptSheetParamInfo();
        newSheetParam.setSheetID(sheetId);
        newSheetParam.setRelaType(ReportTypeEnum.REPORT);
        newSheetParam.setStartYear(0);
        newSheetParam.setEndYear(0);
        newSheetParam.setStartPeriod(0);
        newSheetParam.setEndPeriod(0);
        newSheetParam.setStatus(1);
        newSheetParam.setReportClass(CSLReportGroupEnum.COMMON);
        return newSheetParam;
    }

    @Override
    protected void openReport(boolean isStore, boolean isShowReport) throws Exception {
        this.isDestroy = false;
        if (isStore) {
            this.storeFields();
        }
        if (this.getOprtState().equals("ADDNEW") && this.prmtTemplate.getData() != null) {
            TemplateInfo temp = (TemplateInfo)this.prmtTemplate.getData();
            String tempId = temp.getId().toString();
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("sheetName"));
            sic.add(new SelectorItemInfo("startYear"));
            sic.add(new SelectorItemInfo("endYear"));
            sic.add(new SelectorItemInfo("startPeriod"));
            sic.add(new SelectorItemInfo("endPeriod"));
            sic.add(new SelectorItemInfo("startDate"));
            sic.add(new SelectorItemInfo("endDate"));
            sic.add(new SelectorItemInfo("reportClass"));
            sic.add(new SelectorItemInfo("isIncludingUnposted"));
            sic.add(new SelectorItemInfo("currency.id"));
            sic.add(new SelectorItemInfo("currency.name"));
            sic.add(new SelectorItemInfo("currency.number"));
            sic.add(new SelectorItemInfo("relaType"));
            sic.add(new SelectorItemInfo("sheetID"));
            sic.add(new SelectorItemInfo("report.id"));
            FilterInfo filter = new FilterInfo();
            FilterItemInfo filterItem = new FilterItemInfo("report", (Object)tempId);
            filter.getFilterItems().add(filterItem);
            view.setFilter(filter);
            RptSheetParamCollection rptSheetParamCollection = ((IRptSheetParam)this.getRptSheetParamBizInterface()).getRptSheetParamCollection(view);
            if (rptSheetParamCollection != null && rptSheetParamCollection.size() > 0) {
                for (int j = 0; j < rptSheetParamCollection.size(); ++j) {
                    RptSheetParamInfo info = rptSheetParamCollection.get(j);
                    info.setRelaType(ReportTypeEnum.GROUPCOMMITREPORT);
                    info.setId(null);
                    info.setStatus(1);
                }
            }
            this.editData.getSheetParam().addCollection(rptSheetParamCollection);
        }
        if (this.prmtTemplate.getData() != null && this.getOprtState().equals("ADDNEW")) {
            this.editData.setZipData(((TemplateInfo)this.prmtTemplate.getData()).getZipData());
        }
        if (this.uiWindow == null) {
            UIContext uiContext = new UIContext(this.getUIContext().get("Owner"));
            uiContext.put((Object)"self", (Object)this);
            uiContext.put((Object)"saveUI", (Object)this.getMetaDataPK().getFullName());
            uiContext.put((Object)"superParent", this.getUIContext().get("superParent"));
            String id = this.editData.getId().toString();
            uiContext.put((Object)"ID", (Object)id);
            if (this.getUIContext().get("isMultiApprove") != null) {
                uiContext.put((Object)"isMultiApprove", this.getUIContext().get("isMultiApprove"));
                uiContext.put((Object)"isNewWindow", this.getUIContext().get("isNewWindow"));
                IMultiAssignmentUI multiApproveUI = (IMultiAssignmentUI)this.getUIContext().get("Owner");
                this.uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getProcessUI(), (Map)uiContext, null, this.getOprtState());
                multiApproveUI.billUIChanged((CoreUIObject)this.uiWindow.getUIObject());
                if (isShowReport) {
                    multiApproveUI.setNewWindowShow(false);
                    this.uiWindow.show();
                }
            } else {
                this.uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getProcessUI(), (Map)uiContext, null, this.getOprtState());
                this.uiWindow.show();
            }
        }
    }
}

