/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslParamFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.IInvestDataProvider;
import com.kingdee.eas.fi.gr.cslrpt.InvestDataProviderFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.GroupNormalProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.client.GroupRptProcessUI;
import com.kingdee.eas.fi.gr.dynamic.fill.ClearUpBook;
import com.kingdee.eas.fi.rpt.CompanyF7Helper;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.fi.rpt.client.RptReportProcessUI;
import com.kingdee.eas.fi.rpt.client.TempReportProcessUI;
import com.kingdee.eas.fi.rpt.util.FillSheetAssistant;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.IKDPromptSelector2;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class RptCompanyFillWizard {
    private IKDPromptSelector2 f7;
    private static final Logger logger = Logger.getLogger(RptCompanyFillWizard.class);

    public RptCompanyFillWizard(IUIObject owner, OrgTreeInfo orgTreeInfo) {
        this(owner, orgTreeInfo, null);
    }

    public RptCompanyFillWizard(IUIObject owner, OrgTreeInfo orgTreeInfo, Set selectedOrgIds) {
        boolean isUnion = false;
        if (owner instanceof TempReportProcessUI || owner instanceof RptReportProcessUI || owner instanceof GroupNormalProcessUI) {
            isUnion = true;
        }
        String useUion = null;
        try {
            useUion = CslParamFactory.getRemoteInstance().getParam("KEY_CSLPARAM_Company_Fill_Use_UnionTree");
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
        isUnion = useUion == null ? false : isUnion && RptUtil.isTrue(useUion);
        try {
            if (isUnion && owner instanceof GroupRptProcessUI) {
                orgTreeInfo = CSLContextHelper.getCSLContext().getCurOrgBound();
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        if (isUnion && orgTreeInfo == null) {
            Date date = (Date)owner.getUIContext().get("Report_Date");
            try {
                orgTreeInfo = CslRptUtil.getBasicOrgTreeInfo((Date)date);
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (isUnion && orgTreeInfo != null) {
            this.f7 = new SubMoveUnionF7(owner);
            ((UnionF7Helper.UnionF7)this.f7).setMultiSelect(true);
            ((UnionF7Helper.UnionF7)this.f7).setTreeID(orgTreeInfo.getId().toString());
            ((UnionF7Helper.UnionF7)this.f7).setCtrlUnitPK(orgTreeInfo.getCU());
            ((UnionF7Helper.UnionF7)this.f7).setContainSealUp(false);
            ((UnionF7Helper.UnionF7)this.f7).setNeedAddOrgRange(false);
            ((UnionF7Helper.UnionF7)this.f7).setSelectedOrgIds(selectedOrgIds);
        } else {
            this.f7 = CompanyF7Helper.getCommonCompanyF7ByOrgType(owner);
            ((NewCompanyF7)this.f7).setShowAssistantOrg(true);
            ((NewCompanyF7)this.f7).setCheckedAssistantOrgChkBox(true);
            ((NewCompanyF7)this.f7).setRootUnitID("00000000-0000-0000-0000-000000000000CCE7AED4");
            ((NewCompanyF7)this.f7).setNeedAddOrgRange(false);
            ((NewCompanyF7)this.f7).setMultiSelect(true);
            ((NewCompanyF7)this.f7).setContainSealUp(false);
            ((NewCompanyF7)this.f7).setSelectedOrgIds(selectedOrgIds);
        }
    }

    public Object[] showSelector() {
        this.f7.show();
        if (this.f7.isCanceled()) {
            return null;
        }
        return (Object[])this.f7.getData();
    }

    public static void autoFillInvestCompany(ReportBaseInfo report, Book book) throws BOSException, EASBizException {
        if (report.getSourceType() != RptSrcTypeEnum.NORMAL && report.getSourceType() != RptSrcTypeEnum.COMMITREPORT) {
            return;
        }
        String companyId = report.getCompany().getId().toString();
        ReportVariables vs = ReportVariables.loadFromBook((Book)book);
        IInvestDataProvider iInvProvider = InvestDataProviderFactory.getRemoteInstance();
        ArrayList companyList = iInvProvider.getInvCompanyByShareHolder(companyId);
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            int reportClass = vs.getIntValue("SheetClass", sheet.getSheetName(), 1);
            if (companyList == null || companyList.size() == 0) {
                return;
            }
            if (reportClass != 30 && reportClass != 40) continue;
            RptCompanyFillWizard.fillSheet(sheet, 0, 0, true, companyList);
            break;
        }
    }

    public static boolean fillSheet(Sheet sheet, int x, int y, boolean isVertical, List data) {
        try {
            boolean isInterOrExch = false;
            ReportVariables v = ReportVariables.loadFromBook((Book)sheet.getBook());
            if (v != null) {
                int reportClass = v.getIntValue("SheetClass", sheet.getSheetName(), 1);
                isInterOrExch = reportClass == 10 || reportClass == 20;
            }
            ClearUpBook clearUpBook = null;
            if (isInterOrExch) {
                clearUpBook = new ClearUpBook(sheet.getBook(), false);
                clearUpBook.insertDigitCol(sheet);
            }
            FillSheetAssistant fillsheet = new FillSheetAssistant();
            boolean result = fillsheet.fillSheet(sheet, x, y, isVertical, data);
            if (isInterOrExch) {
                clearUpBook.fillDigitCol(sheet);
            }
            return result;
        }
        catch (Exception e) {
            logger.error((Object)"fillSheet error.", (Throwable)e);
            ExceptionHandler.handle((Throwable)e);
            return false;
        }
    }

    private class SubMoveUnionF7
    extends UnionF7Helper.UnionF7 {
        public SubMoveUnionF7(IUIObject _uiObject) {
            super(_uiObject, 1);
        }

        @Override
        public TreeModel buildTreeModel(OrgViewType orgViewType, OrgTreeInfo orgTreeInfo, DefaultKingdeeTreeNode selectedNode) throws Exception {
            TreeModel model = super.buildTreeModel(orgViewType, orgTreeInfo, selectedNode);
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)model.getRoot();
            root.setCheckBoxEnabled(false);
            root.setCheckBoxVisible(false);
            return model;
        }
    }
}

