/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDScrollBar;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.kscript.runtime.Pair;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uiframe.client.HelpBasicData;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.rpt.BalanceHint;
import com.kingdee.eas.fi.rpt.CellReference;
import com.kingdee.eas.fi.rpt.ConvertHint;
import com.kingdee.eas.fi.rpt.IReportCacl;
import com.kingdee.eas.fi.rpt.ReportCaclFactory;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptConvertFullHint;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptResourceHelper;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.client.AbstractRptConvertWizardUI;
import com.kingdee.eas.fi.rpt.client.IControlledDialogListener;
import com.kingdee.eas.fi.rpt.client.ISimpleDialog;
import com.kingdee.eas.fi.rpt.client.ISimpleDialogListener;
import com.kingdee.eas.fi.rpt.client.RptHelper;
import com.kingdee.eas.fi.rpt.client.RptSheetChooseDialog;
import com.kingdee.eas.fi.rpt.client.RptTablePane;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.help.CSH;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class RptConvertWizardUI
extends AbstractRptConvertWizardUI
implements ISimpleDialog {
    private static final Logger log = Logger.getLogger((String)RptConvertWizardUI.class.getName());
    private ArrayList listeners;
    private List sheetNames;
    private IReportCacl calculater = ReportCaclFactory.getRemoteInstance();
    private Date reportEndDate = null;
    private static final String[] entrys = new String[]{"rptconvertwizardui-tblhint-head-sheetname", "rptconvertwizardui-tblhint-head-region", "rptconvertwizardui-tblhint-head-operation", "rptconvertwizardui-tblhint-head-rate", "rptconvertwizardui-tblhint-head-decimal"};
    private String[] operations = new String[]{"rptconvertwizardui-tblhint-operation-division", "rptconvertwizardui-tblhint-operation-multiply"};
    private String defaultRate = "1.0";
    private int defaultPrecision = 1;
    private static final String DEFAULTRANGE = "ALL";
    private CurrencyInfo abbr = null;

    public static RptConvertWizardUI getInstance(CoreUIObject parentUI) throws Exception {
        IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow wnd = fy.create(RptConvertWizardUI.class.getName(), (Map)new UIContext((Object)parentUI));
        RptConvertWizardUI res = (RptConvertWizardUI)wnd.getUIObject();
        if (parentUI.getUIContext().containsKey("Convert.SrcCurrency") && parentUI.getUIContext().get("Convert.SrcCurrency") instanceof CurrencyInfo) {
            res.setAbbr((CurrencyInfo)parentUI.getUIContext().get("Convert.SrcCurrency"));
        }
        res.onShow();
        return res;
    }

    private Date getReportEndDate(VirtualSheetParamInfo report) {
        if (report instanceof CslReportInfo) {
            CslReportInfo cslr = (CslReportInfo)report;
            return RPTDateUtil.getPeriodLastDate((int)cslr.getYear(), (int)cslr.getPeriod(), (RptPeriodTypeEnum)cslr.getPeriodType());
        }
        if (report instanceof ReportInfo) {
            return ((ReportInfo)report).getEndDate();
        }
        return Calendar.getInstance().getTime();
    }

    public RptConvertWizardUI() throws Exception {
        this.listeners = new ArrayList(1);
        this.initialize();
    }

    private void initialize() throws Exception {
        this.btnAddConvertHint.setIcon(RptResourceHelper.getIcon("imgTbtn_new"));
        this.btnDeletConvertHint.setIcon(RptResourceHelper.getIcon("imgTbtn_delete"));
        this.btnAddExpression.setIcon(RptResourceHelper.getIcon("imgTbtn_new"));
        this.btnDeletExpression.setIcon(RptResourceHelper.getIcon("imgTbtn_delete"));
        String resource = "com.kingdee.eas.fi.rpt.ReportResource";
        for (int i = 0; i < this.operations.length; ++i) {
            this.operations[i] = EASResource.getString((String)resource, (String)this.operations[i]);
        }
        Object[] decimals = new Integer[10];
        for (int i = 0; i < decimals.length; ++i) {
            decimals[i] = new Integer(i);
        }
        IRow hr = this.tblConvertHints.addHeadRow();
        int j = entrys.length;
        for (int i = 0; i < j; ++i) {
            IColumn col = this.tblConvertHints.addColumn(i);
            if (i == 2) {
                col.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox((Object[])this.operations)));
                col.setWidth(40);
            } else if (i == 4) {
                col.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox(decimals)));
            }
            hr.getCell(i).setValue((Object)EASResource.getString((String)resource, (String)entrys[i]));
        }
        this.cbxAbbrDes.setCommitFormat("$number$");
        this.cbxAbbrDes.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                RptConvertWizardUI.this.setDefaultRate("1.0");
                Object _new = e.getNewValue();
                Object _src = RptConvertWizardUI.this.cbxAbbrSrc.getData();
                if (_new != null) {
                    try {
                        String number = null;
                        if (_src != null) {
                            number = _src instanceof CurrencyInfo ? ((CurrencyInfo)_src).getNumber() : _src.toString();
                            String to = null;
                            to = _new instanceof CurrencyInfo ? ((CurrencyInfo)_new).getNumber() : _new.toString();
                            BigDecimal result = null;
                            if (number != null || to != null) {
                                ExchangeTableInfo xtbl = SysContext.getSysContext().getCurrentFIUnit().getBaseExchangeTable();
                                if (xtbl == null) {
                                    throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"NoExchangeTableInThisCompany")});
                                }
                                String xtblid = xtbl.getId().toString();
                                result = RptConvertWizardUI.this.calculater.exchangeRate(number, to, RptConvertWizardUI.this.reportEndDate, xtblid);
                            }
                            if (result != null) {
                                RptConvertWizardUI.this.setDefaultRate(result.toString());
                                RptConvertWizardUI.this.defaultPrecision = result.scale();
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        TableActionListener tal = new TableActionListener();
        this.tblConvertHints.addKDTEditListener((KDTEditListener)tal);
        this.tblConvertHints.addKDTMouseListener((KDTMouseListener)tal);
        this.tblConvertHints.getSelectManager().setSelectMode(2);
        this.tblConvertHints.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                KDTable tbl;
                KDTable kDTable = tbl = e == null ? null : (KDTable)e.getSource();
                if (tbl == null) {
                    return;
                }
                RptConvertWizardUI.this.setCellColor(tbl.getCell(e.getPrevRowIndex(), e.getPrevColumnIndex()), Color.BLACK, LineStyle.NULL_LINE);
                RptConvertWizardUI.this.setCellColor(tbl.getCell(e.getRowIndex(), e.getColumnIndex()), Color.BLACK, LineStyle.SINGLE_LINE);
            }
        });
        this.tblConvertHints.getActionMap().put("CancelEdit", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RptConvertWizardUI.this.tblConvertHints.getEditManager().isEditing()) {
                    RptConvertWizardUI.this.tblConvertHints.getEditManager().cancelEditing();
                } else {
                    RptConvertWizardUI.this.endWizard(false);
                }
            }
        });
        this.lstBalance.setModel(new DefaultListModel());
        this.lstBalance.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    RptConvertWizardUI.this.menuBalance.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    RptConvertWizardUI.this.editBalanceExpression();
                }
            }
        });
        this.getUIMenuBar().setVisible(true);
    }

    void setCellColor(ICell cell, Color cl, LineStyle style) {
        if (cell == null) {
            return;
        }
        StyleAttributes sa = cell.getStyleAttributes();
        Styles.Position[] bds = new Styles.Position[]{Styles.Position.LEFT, Styles.Position.TOP, Styles.Position.RIGHT, Styles.Position.BOTTOM};
        for (int i = bds.length - 1; i >= 0; --i) {
            sa.setBorderColor(bds[i], cl);
            sa.setBorderLineStyle(bds[i], style);
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.btnAddConvertHint.setIcon(RptResourceHelper.getIcon("imgTbtn_new"));
        this.btnDeletConvertHint.setIcon(RptResourceHelper.getIcon("imgTbtn_delete"));
        this.conConvertHint.addButton((JButton)this.btnAddConvertHint);
        this.conConvertHint.addButton((JButton)this.btnDeletConvertHint);
        this.btnAddExpression.setIcon(RptResourceHelper.getIcon("imgTbtn_new"));
        this.btnDeletExpression.setIcon(RptResourceHelper.getIcon("imgTbtn_delete"));
        this.conBalance.addButton((JButton)this.btnAddExpression);
        this.conBalance.addButton((JButton)this.btnDeletExpression);
        this.lstBalance.removeAllElements();
    }

    public void onShow() throws Exception {
        super.onShow();
        RptHelper.setDefaultButton(this, (JButton)this.btnOk);
        RptHelper.setEscAction(this, (Action)((Object)this.actionBtnCancel));
        RptHelper.registF1Action(this, (Action)((Object)this.actionHelp));
    }

    void editBalanceExpression() {
        if (this.lstBalance.isSelectionEmpty()) {
            return;
        }
        int s = this.lstBalance.getSelectedIndex();
        DefaultListModel md = (DefaultListModel)this.lstBalance.getModel();
        Object o = md.get(s);
        Pair res = RptUtilForClient.inquireInfo(this.resHelper.getString("conBalance.title"), o.toString().trim(), this);
        String out = (String)res.second;
        if (res == null || !RptUtil.isTrue(res.first)) {
            if (o == null || o.toString().trim().length() == 0) {
                md.remove(s);
            }
            return;
        }
        while (out != null) {
            if (!BalanceHint.testBalanceExp(out = out.trim())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"rptconvertwizardui-tblhint-error-exp"));
                res = RptUtilForClient.inquireInfo(this.resHelper.getString("conBalance.title"), out, this);
                if (res == null || !RptUtil.isTrue(res.first)) break;
                out = (String)res.second;
                continue;
            }
            if (out.length() == 0) {
                md.remove(s);
                break;
            }
            md.setElementAt(out, s);
            break;
        }
    }

    @Override
    public void actionBtnOk_actionPerformed(ActionEvent e) throws Exception {
        this.endWizard(true);
    }

    @Override
    public void actionBtnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.endWizard(false);
    }

    public void open(Object cookie, String title, List sheets) {
        this.fireListenersSetout();
        this.loadHints((RptConvertFullHint)cookie);
        this.sheetNames = sheets;
        IColumn col = this.tblConvertHints.getColumn(0);
        KDBizPromptBox sheetChooser = new KDBizPromptBox();
        sheetChooser.setSelector((KDPromptSelector)new RptSheetChooseDialog((IUIObject)this, sheets));
        sheetChooser.setEditable(true);
        col.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)sheetChooser));
        this.tblConvertHints.addKDTEditListener((KDTEditListener)new EditingListener());
        IUIWindow w = this.getUIWindow();
        if (w instanceof KDDialog) {
            KDDialog d = (KDDialog)w;
            if (title != null) {
                d.setTitle(title);
            }
            d.addWindowListener((WindowListener)new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    RptConvertWizardUI.this.endWizard(false);
                }
            });
        }
        w.show();
    }

    private List sheetNames2List(String sheets) {
        if (sheets == null || sheets.trim().length() < 1) {
            return null;
        }
        if (sheets.charAt(0) == '[' && sheets.charAt(sheets.length() - 1) == ']') {
            sheets = sheets.substring(1, sheets.length() - 1);
        }
        List<String> editingList = Arrays.asList(sheets.split(","));
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < editingList.size(); ++i) {
            String obj = editingList.get(i);
            if (!this.sheetNames.contains(obj) || result.contains(obj)) continue;
            result.add(obj);
        }
        return result;
    }

    private void loadHints(RptConvertFullHint hint) {
        this.cbxAbbrSrc.setValue((Object)this.abbr);
        this.cbxAbbrSrc.setEnabled(false);
        if (hint == null) {
            return;
        }
        hint.srcAbbr = this.abbr == null ? null : this.abbr.getName();
        this.cbxAbbrDes.setValue((Object)hint.desAbbr);
        try {
            ICurrency curr;
            CurrencyCollection col;
            if (hint.desAbbr != null && (col = (curr = CurrencyFactory.getRemoteInstance()).getCurrencyCollection("select name, number where name='" + hint.desAbbr + "'")) != null && col.size() > 0) {
                this.cbxAbbrDes.setValue((Object)col.get(0));
            }
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        this.loadConvertHints(hint.cvHint);
        this.loadBalanceRegionHints(hint.baHint);
        this.cbxOutput.setSelectedIndex(hint.cvMode);
    }

    private void loadBalanceRegionHints(Collection expHints) {
        if (expHints == null) {
            return;
        }
        DefaultListModel md = (DefaultListModel)this.lstBalance.getModel();
        for (BalanceHint h : expHints) {
            String exp = h.getExpression();
            if (exp == null) continue;
            md.addElement(exp);
        }
    }

    private void loadConvertHints(Collection covHints) {
        if (covHints == null) {
            return;
        }
        int i = 0;
        for (ConvertHint h : covHints) {
            IRow row;
            if ((row = this.tblConvertHints.getRow(i++)) == null) {
                row = this.tblConvertHints.addRow();
            }
            if (row == null) continue;
            if (h.sheetName == null || h.sheetName.size() < 1) {
                row.getCell(0).setValue((Object)"");
            } else {
                row.getCell(0).setValue((Object)h.sheetName);
            }
            row.getCell(1).setValue((Object)(h.isAllTable ? DEFAULTRANGE : TableToolkit.xy2range(h.region)));
            row.getCell(2).setValue((Object)this.operations[h.operation]);
            row.getCell(3).setValue((Object)String.valueOf(h.rate));
            row.getCell(4).setValue((Object)String.valueOf(h.decimal));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void endWizard(boolean isOk) {
        RptConvertFullHint res = null;
        if (isOk) {
            Collection conv = this.getConvertHints();
            if (conv == null) {
                if (this.tblConvertHints.getRowCount() != 0) return;
                isOk = false;
            } else {
                Collection baln = this.getBalanceHints();
                if (baln == null) {
                    if (this.lstBalance.getModel().getSize() > 0) {
                        return;
                    }
                } else {
                    res = new RptConvertFullHint();
                    res.cvHint = conv;
                    res.baHint = baln;
                    res.cvMode = this.cbxOutput.getSelectedIndex();
                    res.srcAbbr = ((JTextField)this.cbxAbbrSrc.getEditor()).getText();
                    res.desAbbr = ((JTextField)this.cbxAbbrDes.getEditor()).getText();
                    if (this.cbxAbbrDes.getData() instanceof CurrencyInfo) {
                        res.desAbbrNumber = ((CurrencyInfo)this.cbxAbbrDes.getData()).getNumber();
                    }
                }
            }
        }
        this.disposeUIWindow();
        this.fireListenersReturnee(res, isOk);
    }

    @Override
    public synchronized void addSimpleDialogListener(ISimpleDialogListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    private RptTablePane getRptTablePane() {
        ISimpleDialogListener l;
        RptTablePane res = null;
        Iterator ls = this.listeners.iterator();
        while (ls.hasNext() && ((l = (ISimpleDialogListener)ls.next()) == null || !(l instanceof IControlledDialogListener) || (res = (RptTablePane)((Object)((IControlledDialogListener)l).getTrueController())) == null)) {
        }
        return res;
    }

    private void fireListenersSetout() {
        for (ISimpleDialogListener l : this.listeners) {
            if (l == null) continue;
            l.pilotSetout(this);
        }
    }

    private void fireListenersReturnee(RptConvertFullHint result, boolean isOk) {
        for (ISimpleDialogListener l : this.listeners) {
            if (l == null) continue;
            l.pilotReturnee(this, result, isOk);
        }
    }

    boolean testCellReference(CellReference cellRefer) {
        boolean noRegion;
        if (cellRefer == null) {
            return false;
        }
        boolean bl = noRegion = cellRefer.region == null || cellRefer.region.x1 == -1 && cellRefer.region.x2 == -1 && cellRefer.region.y1 == -1 && cellRefer.region.y2 == -1;
        if (noRegion) {
            return false;
        }
        if (cellRefer.sheetName == null) {
            return true;
        }
        RptTablePane pan = this.getRptTablePane();
        return pan != null && pan.getPage(cellRefer.sheetName) != null;
    }

    @Override
    public void actionAddExpression_actionPerformed(ActionEvent e) throws Exception {
        Object val;
        super.actionAddExpression_actionPerformed(e);
        DefaultListModel md = (DefaultListModel)this.lstBalance.getModel();
        int rct = md.getSize() - 1;
        if (rct >= 0 && ((val = md.get(rct)) == null || val.toString().trim().length() == 0)) {
            this.lstBalance.setSelectedIndex(rct);
            rct = -2;
        }
        if (rct != -2) {
            md.addElement(" ");
            this.lstBalance.setSelectedIndex(rct + 1);
        }
        this.editBalanceExpression();
    }

    @Override
    public void actionAddHint_actionPerformed(ActionEvent e) throws Exception {
        this.addNewHintEntry(-1);
    }

    void addNewHintEntry(int currentRow) {
        int rct = this.tblConvertHints.getRowCount();
        if (currentRow >= 0) {
            Object val;
            if (rct > 0 && currentRow != rct - 1) {
                return;
            }
            if (rct > 1 && ((val = this.tblConvertHints.getRow(currentRow - 1).getCell(1).getValue()) == null || val.toString().trim().length() == 0)) {
                this.tblConvertHints.getSelectManager().select(currentRow, 0);
                return;
            }
        }
        IRow r = this.tblConvertHints.addRow();
        r.getCell(3).setValue((Object)this.defaultRate);
        r.getCell(1).setValue((Object)DEFAULTRANGE);
        KDComboBox b = (KDComboBox)this.tblConvertHints.getColumn(2).getEditor().getComponent();
        r.getCell(2).setValue((Object)b.getItemAt(0).toString());
        b = (KDComboBox)this.tblConvertHints.getColumn(4).getEditor().getComponent();
        r.getCell(4).setValue((Object)b.getItemAt(this.defaultPrecision).toString());
        this.tblConvertHints.getSelectManager().select(r.getRowIndex(), 0);
    }

    @Override
    public void actionDeletExpression_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeletExpression_actionPerformed(e);
        if (!this.lstBalance.isSelectionEmpty()) {
            ((DefaultListModel)this.lstBalance.getModel()).remove(this.lstBalance.getSelectedIndex());
        }
        this.lstBalance.setSelectedIndex(this.lstBalance.getFirstVisibleIndex());
    }

    @Override
    public void actionDeletHint_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeletHint_actionPerformed(e);
        this.deletHintEntry(this.tblConvertHints.getSelectManager().getActiveRowIndex());
    }

    private void deletHintEntry(int index) {
        this.tblConvertHints.removeRow(index);
    }

    public Collection getConvertHints() {
        ArrayList<ConvertHint> res = new ArrayList<ConvertHint>(2);
        ConvertHint ht = null;
        IRow row = null;
        int size = this.tblConvertHints.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblConvertHints.getRow(i);
            Object val = row.getCell(1).getValue();
            CellReference cr = TableToolkit.parsePosition(val == null ? null : val.toString());
            if (cr == null) continue;
            ht = new ConvertHint();
            ht.sheetName.clear();
            if (cr.sheetName != null) {
                ht.sheetName.add(cr.sheetName);
            } else {
                Object obj = row.getCell(0).getValue();
                if (obj instanceof List) {
                    ht.sheetName.addAll((List)obj);
                }
            }
            ht.region = cr.region;
            ht.isAllTable = TableToolkit.isAllTable(cr.region);
            val = row.getCell(3).getValue();
            if (val != null) {
                ht.rate = Double.parseDouble(val.toString());
            }
            if ((val = row.getCell(2).getValue()) != null) {
                int n = ht.operation = this.operations[0].equals(val.toString()) ? 0 : 1;
            }
            if ((val = row.getCell(4).getValue()) != null) {
                ht.decimal = Integer.parseInt(val.toString());
            }
            res.add(ht);
        }
        return res;
    }

    public Collection getBalanceHints() {
        ArrayList<BalanceHint> res = new ArrayList<BalanceHint>(2);
        BalanceHint ht = null;
        DefaultListModel md = (DefaultListModel)this.lstBalance.getModel();
        int size = md.size();
        for (int i = 0; i < size; ++i) {
            Object val = md.elementAt(i);
            if (val == null || !(ht = new BalanceHint()).setCondition(val.toString().trim())) continue;
            res.add(ht);
        }
        return res;
    }

    public void setAbbr(CurrencyInfo ab) {
        this.abbr = ab;
        if (ab == null) {
            return;
        }
        try {
            FilterInfo filter;
            EntityViewInfo v = this.cbxAbbrDes.getQueryAgent().getEntityViewInfo();
            if (v == null) {
                v = new EntityViewInfo();
                this.cbxAbbrDes.getQueryAgent().setEntityViewInfo(v);
            }
            if ((filter = v.getFilter()) == null) {
                filter = new FilterInfo();
                v.setFilter(filter);
            }
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)this.abbr.getNumber(), CompareType.NOTEQUALS));
        }
        catch (Exception e1) {
            log.debug((Object)e1.getMessage());
        }
    }

    @Override
    public void open(Object cookie, String title) {
        this.open(cookie, title, null);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.cbxAbbrSrc.setDisplayFormat("$name$");
        this.cbxAbbrDes.setDisplayFormat("$name$");
        this.tblConvertHints.getLayoutManager().setHorizonScrollBar((JScrollBar)new KDScrollBar(0));
        this.tblConvertHints.getLayoutManager().setVerticalScrollBar((JScrollBar)new KDScrollBar(1));
    }

    public String getDefaultRate() {
        return this.defaultRate;
    }

    public void setDefaultRate(String defaultRate) {
        this.defaultRate = defaultRate;
    }

    public Date getReportEndDate() {
        return this.reportEndDate;
    }

    public void setReportEndDate(Date reportEnd) {
        this.reportEndDate = reportEnd;
    }

    @Override
    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
        CSH.setHelpIDString((Component)((Component)e.getSource()), (String)"fatempClassAttribute");
        CSH.DisplayHelpFromSource help = new CSH.DisplayHelpFromSource(HelpBasicData.getInstance().getHelpBroker());
        help.actionPerformed(e);
    }

    private class TableActionListener
    extends KDTEditAdapter
    implements KDTMouseListener {
        private TableActionListener() {
        }

        public void editStarting(KDTEditEvent e) {
        }

        public void tableClicked(KDTMouseEvent e) {
            if (e.getButton() != 1) {
                RptConvertWizardUI.this.menuHint.show(e.getComponent(), e.getX() + 22, e.getY() + 22);
            }
        }

        public void editStopping(KDTEditEvent e) {
            if (e.getColIndex() == 1) {
                String value = (String)RptConvertWizardUI.this.tblConvertHints.getEditManager().getEditor().getValue();
                CellReference cr = TableToolkit.parsePosition(value);
                if (!RptConvertWizardUI.this.testCellReference(cr)) {
                    MsgBox.showInfo((Component)((Object)RptConvertWizardUI.this), (String)RptResourceHelper.getString("rptconvertwizardui-tblhint-error-region"));
                    e.setCancel(true);
                    RptConvertWizardUI.this.tblConvertHints.getEditManager().getEditor().setValue((Object)RptConvertWizardUI.DEFAULTRANGE);
                }
            } else if (e.getColIndex() == 3) {
                try {
                    String value = (String)RptConvertWizardUI.this.tblConvertHints.getEditManager().getEditor().getValue();
                    double val = Double.parseDouble(value);
                    if (val <= 0.0) {
                        throw new Exception();
                    }
                }
                catch (Exception ex) {
                    MsgBox.showInfo((Component)((Object)RptConvertWizardUI.this), (String)RptResourceHelper.getString("rptconvertwizardui-tblhint-error-rate"));
                    e.setCancel(true);
                    RptConvertWizardUI.this.tblConvertHints.getEditManager().getEditor().setValue((Object)RptConvertWizardUI.this.defaultRate);
                }
            }
        }
    }

    private final class EditingListener
    extends KDTEditAdapter {
        private EditingListener() {
        }

        public void editStarting(KDTEditEvent e) {
            KDPromptSelector obj2;
            KDTable tbl;
            Component obj;
            super.editStarting(e);
            if (e.getColIndex() == 0 && (obj = (tbl = (KDTable)e.getSource()).getEditManager().getEditorComponent()) instanceof KDBizPromptBox && (obj2 = ((KDBizPromptBox)obj).getSelector()) instanceof RptSheetChooseDialog) {
                Object obj3 = e.getValue();
                if (obj3 != null && obj3 instanceof List) {
                    ((RptSheetChooseDialog)obj2).setSelectedSheet((List)obj3);
                } else {
                    ((RptSheetChooseDialog)obj2).setSelectedSheet(null);
                }
            }
        }

        public void editStopped(KDTEditEvent e) {
            Object sheetName;
            KDTable tbl;
            ICell cell;
            super.editStopped(e);
            if (e.getColIndex() == 0 && (cell = (tbl = (KDTable)e.getSource()).getCell(e.getRowIndex(), e.getColIndex())) != null && (sheetName = e.getValue()) != null && sheetName instanceof String) {
                cell.setValue((Object)RptConvertWizardUI.this.sheetNames2List((String)sheetName));
            }
        }
    }
}

