/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.fi.rpt.RptDataInfo;
import com.kingdee.eas.fi.rpt.client.AbstractRptDataReportDetailListUI;
import com.kingdee.eas.fi.rpt.client.TimeCellTextFormator;
import com.kingdee.eas.fi.rpt.rptdata.RptDataFormulaDetailInfo;
import com.kingdee.eas.fi.rpt.rptdata.RptDataUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class RptDataReportDetailListUI
extends AbstractRptDataReportDetailListUI {
    private static final Logger log = CoreUIObject.getLogger(RptDataReportDetailListUI.class);

    public RptDataReportDetailListUI() throws Exception {
        this.getUIContext().put("RequestModel", 0);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.setColumnMoveable(true);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    int selectRow = e.getSelectBlock().getBeginRow();
                    RptDataReportDetailListUI.this.showFormulaAfterSelectRows(new int[]{selectRow});
                }
                catch (Exception e1) {
                    log.error((Object)"", (Throwable)e1);
                }
            }
        });
        this.mainQueryPK = MetaDataPK.create((String)"com.kingdee.eas.fi.rpt.RptDataReportDetailQuery");
        if (!this.getUIContext().containsKey(RptDataFormulaDetailInfo.class)) {
            return;
        }
        RptDataFormulaDetailInfo detail = (RptDataFormulaDetailInfo)this.getUIContext().get(RptDataFormulaDetailInfo.class);
        this.resetFormulaDetailCtrl(detail.getFormulaDetail());
        this.tblMain.removeRows();
        boolean i = false;
        AverageTime totalCalcFinishTime = new AverageTime();
        AverageTime totalServerCalcFinishTime = new AverageTime();
        AverageTime totalNetFinishTime = new AverageTime();
        AverageTime totalUpNetFinishTime = new AverageTime();
        AverageTime totalDownNetFinishTime = new AverageTime();
        TimeCellTextFormator timeCellTextFormator = new TimeCellTextFormator();
        for (RptDataInfo record : detail.getRecords()) {
            IRow row = this.tblMain.addRow();
            row.setUserObject((Object)record);
            row.getCell("id").setValue((Object)record.getId());
            row.getCell("rptId").setValue((Object)record.getRptId());
            row.getCell("userId").setValue((Object)record.getUserId());
            row.getCell("userName").setValue((Object)record.getUserName());
            row.getCell("userNum").setValue((Object)record.getUserNumber());
            row.getCell("userIp").setValue((Object)record.getUserIp());
            row.getCell("calcStartTime").setValue((Object)record.getCalcStartTime());
            row.getCell("calcFinishTime").setValue((Object)timeCellTextFormator.convert(record.getCalcFinishTime()));
            row.getCell("serverCalcFinishTime").setValue((Object)timeCellTextFormator.convert(record.getServerCalcFinishTime()));
            row.getCell("netFinishTime").setValue((Object)timeCellTextFormator.convert(record.getNetFinishTime()));
            row.getCell("upNetFinishTime").setValue((Object)timeCellTextFormator.convert(record.getUpNetFinishTime()));
            row.getCell("downNetFinishTime").setValue((Object)timeCellTextFormator.convert(record.getDownNetFinishTime()));
            totalCalcFinishTime.add(record.getCalcFinishTime());
            totalServerCalcFinishTime.add(record.getServerCalcFinishTime());
            totalNetFinishTime.add(record.getNetFinishTime());
            totalUpNetFinishTime.add(record.getUpNetFinishTime());
            totalDownNetFinishTime.add(record.getDownNetFinishTime());
        }
        KDTFootManager footRowManager = this.tblMain.getFootManager();
        IRow footRow = null;
        if (footRowManager == null) {
            String total = EASResource.getString((String)"com.kingdee.eas.base.myeas.MyEasResource.KpiIndAvlValue");
            footRowManager = new KDTFootManager(this.tblMain);
            footRowManager.addFootView();
            this.tblMain.setFootManager(footRowManager);
            footRow = footRowManager.addFootRow(0);
            footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
            this.tblMain.getIndexColumn().setWidthAdjustMode((short)1);
            this.tblMain.getIndexColumn().setWidth(50);
            footRowManager.addIndexText(0, total);
        } else {
            footRow = footRowManager.getFootRow(0);
        }
        ICell cellCalcFinishTime = footRow.getCell("calcFinishTime");
        ICell cellServerCalcFinishTime = footRow.getCell("serverCalcFinishTime");
        ICell cellNetFinishTime = footRow.getCell("netFinishTime");
        ICell cellUpNetFinishTime = footRow.getCell("upNetFinishTime");
        ICell cellDownNetFinishTime = footRow.getCell("downNetFinishTime");
        cellCalcFinishTime.getStyleAttributes().setFontColor(Color.BLACK);
        cellCalcFinishTime.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"left"));
        cellServerCalcFinishTime.getStyleAttributes().setFontColor(Color.BLACK);
        cellServerCalcFinishTime.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"left"));
        cellNetFinishTime.getStyleAttributes().setFontColor(Color.BLACK);
        cellNetFinishTime.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"left"));
        cellUpNetFinishTime.getStyleAttributes().setFontColor(Color.BLACK);
        cellUpNetFinishTime.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"left"));
        cellDownNetFinishTime.getStyleAttributes().setFontColor(Color.BLACK);
        cellDownNetFinishTime.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"left"));
        cellCalcFinishTime.setValue((Object)timeCellTextFormator.convert(totalCalcFinishTime.getAverageValue()));
        cellServerCalcFinishTime.setValue((Object)timeCellTextFormator.convert(totalServerCalcFinishTime.getAverageValue()));
        cellNetFinishTime.setValue((Object)timeCellTextFormator.convert(totalNetFinishTime.getAverageValue()));
        cellUpNetFinishTime.setValue((Object)timeCellTextFormator.convert(totalUpNetFinishTime.getAverageValue()));
        cellDownNetFinishTime.setValue((Object)timeCellTextFormator.convert(totalDownNetFinishTime.getAverageValue()));
        this.txtTotalCalcNum.setText("" + detail.getRecords().size());
        if (this.getUIContext().containsKey(RptDataInfo.class)) {
            RptDataInfo currRptInfo = (RptDataInfo)this.getUIContext().get(RptDataInfo.class);
            this.setUITitle(this.getUITitle() + "-" + currRptInfo.getRptName());
        }
        this.menuBar.setVisible(false);
        this.menuBar.setEnabled(false);
        this.defineOrderColumn();
    }

    private void defineOrderColumn() {
    }

    private void resetFormulaDetailCtrl(Properties formulaDetail) {
        StringBuffer sb = new StringBuffer();
        TreeSet<Map.Entry<Object, Object>> treeSet = new TreeSet<Map.Entry<Object, Object>>(new Comparator<Map.Entry<Object, Object>>(){

            @Override
            public int compare(Map.Entry<Object, Object> o1, Map.Entry<Object, Object> o2) {
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                int o1Cmp = 0;
                int o2Cmp = 0;
                try {
                    o1Cmp = Integer.parseInt((String)o1.getValue());
                }
                catch (NumberFormatException e) {
                    return 1;
                }
                try {
                    o2Cmp = Integer.parseInt((String)o2.getValue());
                }
                catch (NumberFormatException e) {
                    return -1;
                }
                return o1Cmp > o2Cmp ? -1 : 1;
            }
        });
        treeSet.addAll(formulaDetail.entrySet());
        for (Map.Entry<Object, Object> entry : treeSet) {
            sb.append(entry.getKey() + ":" + entry.getValue() + "\r\n");
        }
        this.txtFormulaDetail.setText(sb.toString());
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    private void showFormulaAfterSelectRows(int[] selectRows) {
        IRow row = this.tblMain.getRow(selectRows[0]);
        if (!(row.getUserObject() instanceof RptDataInfo)) {
            log.error((Object)"no set userObject property for row");
            return;
        }
        RptDataInfo currRecord = (RptDataInfo)row.getUserObject();
        Properties formulaDetail = RptDataUtil.convertProperties(currRecord.getFormulaDetail());
        this.resetFormulaDetailCtrl(formulaDetail);
    }

    protected boolean isOrderForClickTableHead() {
        return true;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        return new CommonQueryDialog();
    }

    private static class AverageTime {
        private List<Long> values = new LinkedList<Long>();

        private AverageTime() {
        }

        public void add(Long value) {
            this.values.add(value);
        }

        public Long getAverageValue() {
            long totalValue = 0L;
            int size = 0;
            for (Long value : this.values) {
                if (value == Long.MAX_VALUE) continue;
                ++size;
                totalValue += value.longValue();
            }
            if (!this.values.isEmpty() && size == 0) {
                return Long.MAX_VALUE;
            }
            return totalValue / (long)size;
        }
    }
}

