/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.fi.rpt.RptResourceHelper;
import com.kingdee.eas.fi.rpt.client.RptContentFinderUI;
import com.kingdee.eas.fi.rpt.client.RptTablePane;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RptFinderMode
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 20040725105755L;
    public static final int MOD_RANGE_SHEET = 0;
    public static final int MOD_RANGE_REPORT = 1;
    public static final int MOD_SORT_COLUMN = 1;
    public static final int MOD_SORT_ROW = 0;
    public static final int MOD_TYPE_DATA = 0;
    public static final int MOD_TYPE_FORMULA = 1;
    public static final int MOD_TYPE_ITEM = 2;
    public static final int MOD_FIND = 0;
    public static final int MOD_REPLACE = 1;
    public static final boolean MOD_MATCH_CASE = false;
    public static final boolean MOD_MATCH_CONTENT = false;
    private int modRange;
    private int modSort;
    private int modType;
    private int modAction;
    private boolean isMatchCase;
    private boolean isMatchContent;
    private boolean isMatchRegular;
    private ArrayList findWhat;
    private ArrayList replaceWhat;
    private String findLine;
    private String replaceLine;
    private String findLineLower;
    private Pattern findLineRegex;
    private Pattern findLineLowerRegex;
    private Pattern findLineNoCaseRegex;
    private RptContentFinderUI finder;
    private RptTablePane rptPane;
    private transient FootPrint startPosition;
    private transient FootPrint curPosition;
    private boolean hasFound;
    private int warningCount = 0;
    public static final String[][] regexKeys = new String[][]{{".", "\\."}, {"(", "\\("}, {")", "\\)"}, {"[", "\\["}, {"]", "\\]"}, {"|", "\\|"}, {"+", "\\+"}, {"\\", "\\\\"}, {"^", "\\^"}, {"$", "\\$"}};

    public RptFinderMode() {
        this.reset();
    }

    public void reset() {
        this.setRptPane(null);
        this.setFindWhat(null);
        this.setFindLine(null);
        this.setReplaceWhat(null);
        this.setReplaceLine(null);
        this.setModRange(0);
        this.setModSort(1);
        this.setModType(0);
        this.setMatchCase(false);
        this.setMatchContent(false);
        this.setModAction(0);
        this.resetPosition(null);
        this.warningCount = 0;
    }

    protected Object clone() throws CloneNotSupportedException {
        RptFinderMode res = (RptFinderMode)super.clone();
        res.resetPosition(null);
        return res;
    }

    private void resetPosition(FootPrint pos) {
        this.setStartPosition(pos);
        this.setCurPosition(pos);
        this.setHasFound(false);
    }

    public ArrayList getFindWhat() {
        return this.findWhat;
    }

    public void setFindWhat(ArrayList what) {
        this.findWhat = what;
    }

    public String getFindLine() {
        return this.findLine;
    }

    public void setFindLine(String line) {
        if (RptUtil.isEquals(this.getFindLine(), line)) {
            return;
        }
        this.resetPosition(null);
        this.findLine = line;
        this.findLineLower = line == null ? null : line.toLowerCase();
        try {
            this.findLineRegex = line == null ? null : Pattern.compile(this.makeRegex(line));
            this.findLineLowerRegex = this.findLineLower == null ? null : Pattern.compile(this.makeRegex(this.findLineLower));
            this.findLineNoCaseRegex = line == null ? null : Pattern.compile(this.makeRegex(line), 2);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
    }

    private String makeRegex(String line) {
        int len = regexKeys.length;
        for (int i = 0; i < len; ++i) {
            line = RptUtil.replace(line, regexKeys[i][0], regexKeys[i][1]);
        }
        line = RptUtil.replace(line, "*", ".*");
        line = RptUtil.replace(line, "?", ".?");
        return line;
    }

    public String getReplaceLine() {
        return this.replaceLine;
    }

    public void setReplaceLine(String line) {
        this.replaceLine = line;
    }

    public boolean isHasFound() {
        return this.hasFound;
    }

    public void setHasFound(boolean isFound) {
        this.hasFound = isFound;
    }

    public boolean isMatchCase() {
        return this.isMatchCase;
    }

    public void setMatchCase(boolean isMatch) {
        if (this.isMatchCase == isMatch) {
            return;
        }
        this.resetPosition(null);
        this.isMatchCase = isMatch;
    }

    public boolean isMatchContent() {
        return this.isMatchContent;
    }

    public void setMatchContent(boolean isMatch) {
        if (this.isMatchContent == isMatch) {
            return;
        }
        this.resetPosition(null);
        this.isMatchContent = isMatch;
    }

    public boolean isMatchRegular() {
        return this.isMatchRegular;
    }

    public void setMatchRegular(boolean isMatch) {
        if (this.isMatchRegular == isMatch) {
            return;
        }
        this.resetPosition(null);
        this.isMatchRegular = isMatch;
    }

    public int getModRange() {
        return this.modRange;
    }

    public void setModRange(int mRange) {
        if (this.modRange == mRange) {
            return;
        }
        this.resetPosition(null);
        this.modRange = mRange;
    }

    public int getModSort() {
        return this.modSort;
    }

    public void setModSort(int mSort) {
        if (this.modSort == mSort) {
            return;
        }
        this.resetPosition(null);
        this.modSort = mSort;
    }

    public int getModType() {
        return this.modType;
    }

    public void setModType(int mType) {
        this.modType = mType;
    }

    public ArrayList getReplaceWhat() {
        return this.replaceWhat;
    }

    public void setReplaceWhat(ArrayList what) {
        this.replaceWhat = what;
    }

    public int getModAction() {
        return this.modAction;
    }

    public void setModAction(int action) {
        if (this.modAction == action) {
            return;
        }
        this.resetPosition(null);
        this.modAction = action;
    }

    public RptTablePane getRptPane() {
        return this.rptPane;
    }

    public void setRptPane(RptTablePane pane) {
        this.rptPane = pane;
    }

    public FootPrint getCurPosition() {
        return this.curPosition;
    }

    public void setCurPosition(FootPrint pos) {
        this.curPosition = pos;
    }

    public FootPrint getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(FootPrint pos) {
        this.startPosition = pos;
    }

    public RptContentFinderUI getUI() {
        return this.finder;
    }

    public void setUI(RptContentFinderUI ui) {
        this.finder = ui;
    }

    private boolean verifyFindLine() {
        return this.findLine != null && this.findLine.length() > 0;
    }

    private boolean verifyReplaceLine() {
        return !RptUtil.isEquals(this.findLine, this.replaceLine);
    }

    public void findPre() {
        this.find(false);
    }

    public void findNext() {
        this.find(true);
    }

    private void find(boolean isForward) {
        if (!this.verifyConditions(isForward)) {
            return;
        }
        boolean isFind = false;
        int nPages = this.rptPane.getTabCount();
        while (this.curPosition != null) {
            if (this.match(this.curPosition.cell)) {
                KDTable table = this.curPosition.table;
                ICell cell = this.curPosition.cell;
                table.getSelectManager().select(cell.getRowIndex(), cell.getColumnIndex());
                this.hasFound = true;
                isFind = true;
            }
            if (this.curPosition.atEnd() && this.modRange == 1) {
                this.curPosition = this.curPosition.jump(this.getNextTable(isForward, this.curPosition.table), nPages);
                continue;
            }
            this.curPosition = this.curPosition.walk();
            if (!isFind && !this.startPosition.equals(this.curPosition)) continue;
        }
        if (!this.hasFound) {
            MsgBox.showInfo((String)RptResourceHelper.getString("rptfindermode-not-find"));
        }
    }

    private boolean verifyConditions(boolean isForward) {
        if (!this.verifyFindLine()) {
            return false;
        }
        if (this.startPosition == null || this.startPosition.isForwards != isForward) {
            this.curPosition = new FootPrint();
            this.curPosition.setTable(this.getNextTable(isForward, null));
            this.curPosition.start(isForward, this.modSort);
            this.startPosition = new FootPrint(this.curPosition);
        }
        if (this.curPosition != null) {
            this.curPosition.jumpTimes = 0;
        }
        return this.startPosition != null && this.startPosition.table != null;
    }

    private boolean match(ICell cell) {
        Object value = null;
        switch (this.getModType()) {
            case 0: {
                value = cell.getValue();
                break;
            }
            case 1: {
                value = cell.getExpressions();
                break;
            }
            case 2: {
                RptCell rc = RptCell.getRptCell(cell);
                if (rc == null) break;
                value = rc.getItemFormulaLine();
            }
        }
        if (value == null) {
            return false;
        }
        String line = value.toString();
        String target = this.findLine;
        Pattern pn = this.findLineRegex;
        if (!this.isMatchCase) {
            line = line.toLowerCase(Locale.ENGLISH);
            target = this.findLineLower;
            pn = this.findLineLowerRegex;
        }
        if (this.isMatchRegular) {
            return pn == null ? false : (this.isMatchContent ? pn.matcher(line).matches() : pn.matcher(line).find());
        }
        return this.isMatchContent ? line.equals(target) : line.indexOf(target) != -1;
    }

    public void replace() {
        if (this.rptPane == null || !this.verifyReplaceLine()) {
            return;
        }
        this.warningCount = 0;
        List list = this.rptPane.getAllFocusCells();
        for (ICell cell : list) {
            if (cell == null || !this.match(cell)) continue;
            this.replace(cell);
        }
        this.rptPane.resetFormulaBarContent();
    }

    private boolean replace(ICell cell) {
        if (cell.getStyleAttributes().isLocked()) {
            if (this.rptPane != null && this.warningCount < 1) {
                ++this.warningCount;
                this.rptPane.warnForbidden(0x30000000);
            }
            return false;
        }
        switch (this.getModType()) {
            case 0: {
                String nv = this.replace(cell.getValue());
                if (nv != null && nv.length() > 0 && nv.charAt(0) == '=') {
                    cell.setValue(null);
                    cell.setExpressions(nv);
                    break;
                }
                cell.setValue((Object)nv);
                break;
            }
            case 1: {
                String ne = this.replace(cell.getExpressions());
                if (ne != null && ne.length() > 0 && ne.charAt(0) == '=') {
                    cell.setExpressions(ne);
                    break;
                }
                cell.setExpressions(null);
                cell.setValue((Object)ne);
                break;
            }
            case 2: {
                RptCell rc = RptCell.getRptCell(cell);
                if (rc == null) break;
                rc.setItemFormula(this.replace(rc.getItemFormulaLine()));
            }
        }
        return true;
    }

    private String replace(Object oldValue) {
        if (oldValue == null || this.findLine == null) {
            return this.replaceLine;
        }
        if (this.isMatchRegular) {
            if (this.replaceLine == null) {
                this.replaceLine = "";
            }
            Pattern pn = this.isMatchCase ? this.findLineRegex : this.findLineNoCaseRegex;
            return pn == null ? oldValue.toString() : pn.matcher(oldValue.toString()).replaceAll(this.replaceLine);
        }
        return RptUtil.replace(oldValue.toString(), this.findLine, this.replaceLine, !this.isMatchCase);
    }

    public void replaceAll() {
        this.resetPosition(null);
        if (!this.verifyReplaceLine() || !this.verifyConditions(true)) {
            return;
        }
        int count = 0;
        int nPages = this.rptPane.getTabCount();
        this.rptPane.setBatchEdit(true);
        this.warningCount = 0;
        while (this.curPosition != null) {
            if (this.match(this.curPosition.cell) && this.replace(this.curPosition.cell)) {
                ++count;
            }
            if (this.curPosition.atEnd() && this.modRange == 1) {
                this.curPosition = this.curPosition.jump(this.getNextTable(true, this.curPosition.table), nPages);
                continue;
            }
            this.curPosition = this.curPosition.walk();
            if (!this.startPosition.equals(this.curPosition)) continue;
        }
        this.rptPane.setBatchEdit(false);
        this.rptPane.resetFormulaBarContent();
        MsgBox.showInfo((String)(String.valueOf(count) + RptResourceHelper.getString("rptfindermode-replace")));
        this.resetPosition(null);
    }

    protected KDTable getNextTable(boolean isForward, KDTable curTable) {
        if (this.rptPane == null) {
            return null;
        }
        KDTable res = null;
        if (curTable == null) {
            res = this.rptPane.getCurrentPage();
        } else {
            int maxPos = this.rptPane.getTabCount() - 1;
            if (maxPos >= 0) {
                int curPos = this.rptPane.indexOfComponent((Component)curTable);
                if (isForward) {
                    if (++curPos > maxPos) {
                        curPos = 0;
                    }
                } else if (--curPos < 0) {
                    curPos = maxPos;
                }
                res = (KDTable)this.rptPane.getComponentAt(curPos);
                this.rptPane.setSelectedComponent((Component)res);
            }
        }
        return res;
    }

    private class FootPrint {
        public boolean isForwards;
        public int mode;
        private int maxRow;
        private int maxCol;
        private int curRow;
        private int curCol;
        public KDTable table;
        public ICell cell;
        public int jumpTimes;

        public FootPrint() {
            this(null);
        }

        public FootPrint(FootPrint mirror) {
            if (mirror == null) {
                this.table = null;
                this.cell = null;
            } else {
                this.table = mirror.table;
                this.cell = mirror.cell;
                this.curRow = mirror.curRow;
                this.curCol = mirror.curCol;
                this.isForwards = mirror.isForwards;
            }
        }

        public void setTable(KDTable tbl) {
            this.table = tbl;
            this.cell = null;
        }

        public FootPrint start(boolean isForward, int mod) {
            IRow r;
            this.maxRow = this.table.getExpandedRowCount();
            this.maxCol = this.table.getExpandedColumnCount();
            this.curRow = this.table.getSelectManager().getActiveRowIndex();
            this.curCol = this.table.getSelectManager().getActiveColumnIndex();
            if (this.curRow < 0 || this.curRow >= this.maxRow) {
                this.curRow = 0;
            }
            if (this.curCol < 0 || this.curCol >= this.maxCol) {
                this.curCol = 0;
            }
            if ((r = this.table.getRow(this.curRow)) != null) {
                this.cell = r.getCell(this.curCol);
            }
            this.isForwards = isForward;
            this.mode = mod;
            this.jumpTimes = 0;
            return this.cell == null ? null : this;
        }

        public FootPrint jump(KDTable newTable, int maxTimes) {
            this.setTable(newTable);
            if (this.table == null) {
                return null;
            }
            this.maxRow = this.table.getExpandedRowCount();
            this.maxCol = this.table.getExpandedColumnCount();
            this.curRow = this.isForwards ? 0 : this.maxRow;
            this.curCol = this.isForwards ? 0 : this.maxCol;
            IRow r = this.table.getRow(this.curRow);
            if (r != null) {
                this.cell = r.getCell(this.curCol);
            }
            return this.cell == null || this.jumpTimes++ > maxTimes ? null : this;
        }

        public FootPrint walk() {
            IRow r;
            if (this.mode == 1) {
                if (this.isForwards) {
                    if (this.curCol >= this.maxCol) {
                        this.curCol = 0;
                        if (++this.curRow > this.maxRow) {
                            this.curRow = 0;
                        }
                    } else {
                        ++this.curCol;
                    }
                } else if (this.curCol <= 0) {
                    this.curCol = this.maxCol;
                    if (--this.curRow < 0) {
                        this.curRow = this.maxRow;
                    }
                } else {
                    --this.curCol;
                }
            } else if (this.isForwards) {
                if (this.curRow >= this.maxRow) {
                    this.curRow = 0;
                    if (++this.curCol > this.maxCol) {
                        this.curCol = 0;
                    }
                } else {
                    ++this.curRow;
                }
            } else if (this.curRow <= 0) {
                this.curRow = this.maxRow;
                if (--this.curCol < 0) {
                    this.curCol = this.maxCol;
                }
            } else {
                --this.curRow;
            }
            if ((r = this.table.getRow(this.curRow)) != null) {
                this.cell = r.getCell(this.curCol);
            }
            return this.cell == null ? null : this;
        }

        public boolean atEnd() {
            return this.isForwards ? this.curRow == this.maxRow && this.curCol == this.maxCol : this.curRow == 0 && this.curCol == 0;
        }

        public boolean equals(FootPrint another) {
            return another != null && this.table == another.table && this.curRow == another.curRow && this.curCol == another.curCol;
        }
    }
}

