/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.print.PrintBookTrans;
import com.kingdee.bos.ctrl.excel.print.PrintManager;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTPrintManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.print.IVariantParser;
import com.kingdee.bos.ctrl.print.config.extendui.TablePrintSetupModel;
import com.kingdee.bos.ctrl.print.extend.MultiPrintJobManager;
import com.kingdee.bos.ctrl.print.preview.ButtonItemGroup;
import com.kingdee.bos.ctrl.print.preview.PreviewToolBar;
import com.kingdee.bos.ctrl.print.ui.component.PainterInfo;
import com.kingdee.bos.kscript.runtime.Pair;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.newrpt.client.designer.ReportHeaderFooterSetupUI;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.client.RptContainerClient;
import com.kingdee.eas.fi.rpt.client.SheetContainerClient;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class RptHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.rpt.client.RptHelper");

    public static void printMultiReports(ListUI listUI, String keyFieldName) {
        if (listUI == null || keyFieldName == null) {
            return;
        }
        KDTable tbl = listUI.getMainTable();
        if (tbl == null) {
            return;
        }
        ArrayList sbs = tbl.getSelectManager().getBlocks();
        if (sbs == null) {
            return;
        }
        ArrayList<String> ids = new ArrayList<String>(5);
        for (int b = 0; b < sbs.size(); ++b) {
            KDTSelectBlock sb = (KDTSelectBlock)sbs.get(b);
            if (sb == null) continue;
            for (int r = sb.getTop(); r <= sb.getBottom(); ++r) {
                ICell cell = tbl.getRow(r).getCell(keyFieldName);
                if (cell == null || cell.getValue() == null) continue;
                String id = cell.getValue().toString();
                ICell cellDate = tbl.getRow(r).getCell("lastUpdateTime");
                if (cellDate != null && cellDate.getValue() != null) {
                    id = id + "@" + cellDate.getValue().toString();
                }
                if (ids.contains(id)) continue;
                ids.add(id);
            }
        }
        RptHelper.printMultiReports(ids, listUI);
    }

    public static SelectorItemCollection getSelectors(boolean isCslRpt) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("periodType"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("startDate"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("isSupportAdjust"));
        sic.add(new SelectorItemInfo("convertStatus"));
        sic.add(new SelectorItemInfo("k3Template.id"));
        sic.add(new SelectorItemInfo("orgType"));
        sic.add(new SelectorItemInfo("orgUnit.Name"));
        sic.add(new SelectorItemInfo("orgUnit.Number"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.Name"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("sourceCurrency.id"));
        sic.add(new SelectorItemInfo("sourceCurrency.number"));
        sic.add(new SelectorItemInfo("orgTree.id"));
        sic.add(new SelectorItemInfo("orgTree.number"));
        sic.add(new SelectorItemInfo("orgTree.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        return sic;
    }

    private static void initPrintSetting(RptHelper rptHelper, SpreadContext spread, String id, ICoreBase bizInterface) throws Exception {
        IVariantParser varintParser = spread.getPrintManager().getPrinter().getVariantParser();
        if (varintParser == null || !(varintParser instanceof MyVariantParser)) {
            varintParser = rptHelper.new MyVariantParser();
        }
        ((MyVariantParser)varintParser).init(spread, id, bizInterface);
        spread.getPrintManager().getPrinter().setVariantParser(varintParser);
        spread.getPrintManager().setHeadFootUI(ReportHeaderFooterSetupUI.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printBooks(List reportIds, ICoreBase biz, JComponent owner) throws Exception {
        if (reportIds == null || reportIds.size() < 1) {
            return;
        }
        HashSet ids = new HashSet(reportIds.size());
        for (int i = 0; i < reportIds.size(); ++i) {
            ids.add(reportIds.get(i));
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("data"));
        view.setSelector(sic);
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        CoreBaseCollection coll = biz.getCollection(view);
        SpreadContext spread = null;
        HashMap<String, CoreBaseInfo> id_rptInfo = new HashMap<String, CoreBaseInfo>();
        CoreBaseInfo coreBaseInfo = null;
        for (int i = 0; i < coll.size(); ++i) {
            coreBaseInfo = coll.get(i);
            id_rptInfo.put(coreBaseInfo.getId().toString(), coreBaseInfo);
        }
        ids.clear();
        coll.clear();
        RptHelper rptHelper = new RptHelper();
        PrintManager printManager = null;
        try {
            for (int i = 0; i < reportIds.size(); ++i) {
                Object id = reportIds.get(i);
                if (id == null || !id_rptInfo.containsKey(id.toString())) continue;
                coreBaseInfo = (CoreBaseInfo)id_rptInfo.get(id.toString());
                Book book = IOHelper.unpackBook(coreBaseInfo.getBytes("data"), "rpt_trans");
                book.setCalculate(false);
                if (spread == null) {
                    spread = new SpreadContext(book);
                    RptHelper.initPrintSetting(rptHelper, spread, id.toString(), biz);
                    printManager = spread.getPrintManager();
                    printManager.getPrinter().setParentWindow((Component)owner);
                    ((TablePrintSetupModel)printManager.getPrinter().getPrintConfig().getModel()).setPrintContentType(1);
                    PreviewToolBar previewBar = printManager.getPrinter().getPrintPreview().getPreviewBar();
                    ButtonItemGroup buttonItemGroup = previewBar.getButtonItemGroup(0);
                    buttonItemGroup.getButtonItems().remove(0);
                    printManager.getPrinter().setPrintComplete(false);
                    int status = printManager.print(false);
                    while (3 == status) {
                        status = printManager.print(false);
                    }
                    if (2 != status) continue;
                    return;
                }
                printManager = spread.getPrintManager();
                spread.setBook(book);
                RptHelper.initPrintSetting(rptHelper, spread, id.toString(), biz);
                printManager.getPrinter().setParentWindow((Component)owner);
                ((TablePrintSetupModel)printManager.getPrinter().getPrintConfig().getModel()).setPrintContentType(1);
                printManager.getMultiPrintManager().clear();
                PrintBookTrans.loadFromBook((MultiPrintJobManager)printManager.getMultiPrintManager(), (Book)book);
                printManager.printDirect();
            }
        }
        finally {
            if (printManager != null) {
                if (printManager.getPrinter() != null) {
                    printManager.getPrinter().setPrintComplete(true);
                    if (printManager.getPrinter().getPrintConfig() != null && printManager.getPrinter().getPrintConfig().getModel() != null) {
                        printManager.getPrinter().getPrintConfig().getModel().reset();
                    }
                }
                printManager.clear();
            }
        }
        id_rptInfo.clear();
        spread = null;
    }

    public static void printMultiReports(Collection rptIDs, ListUI listUI) {
        if (rptIDs == null || rptIDs.size() < 1) {
            return;
        }
        RptContainerClient comp = RptContainerClient.getInstance();
        KDTPrintManager pd = null;
        Iterator it = rptIDs.iterator();
        while (it.hasNext()) {
            try {
                Pair res = RptHelper.printReport(pd, comp.getReport((String)it.next()), listUI);
                if (res == null || res.first == Boolean.FALSE) {
                    return;
                }
                pd = (KDTPrintManager)res.second;
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    private static Pair printReport(KDTPrintManager pd, SheetContainerClient report, ListUI listUI) {
        if (report == null) {
            return new Pair((Object)Boolean.TRUE, null);
        }
        Collection tbls = report.getTables();
        if (tbls == null) {
            return new Pair((Object)Boolean.TRUE, null);
        }
        Pair res = new Pair();
        for (KDTable tbl : tbls) {
            if (tbl == null) continue;
            if (pd == null) {
                pd = tbl.getPrintManager();
                pd.setParent((Component)listUI);
                boolean isOK = tbl.getPrintManager().pageSetup();
                if (!isOK) {
                    return new Pair((Object)Boolean.FALSE, null);
                }
                res.second = pd;
            } else {
                tbl.getPrintManager().copy(pd);
            }
            tbl.getPrintManager().printDirect();
        }
        res.first = Boolean.TRUE;
        res.second = pd;
        return res;
    }

    public static void printTable(KDTable table, KDTPrintManager kpm) {
        if (table == null || kpm == null) {
            return;
        }
        KDTPrintManager newpm = table.getPrintManager();
        if (newpm != kpm) {
            newpm.copy(kpm);
        }
        newpm.printDirect();
    }

    public static void preViewMultiReports(ListUI listUI, String keyFieldName) {
        if (listUI == null || keyFieldName == null) {
            return;
        }
        KDTable tbl = listUI.getMainTable();
        if (tbl == null) {
            return;
        }
        KDTSelectBlock sb = tbl.getSelectManager().get();
        if (sb == null) {
            return;
        }
        ICell cell = tbl.getRow(sb.getTop()).getCell(keyFieldName);
        if (cell == null || cell.getValue() == null) {
            return;
        }
        String id = cell.getValue().toString();
        ICell cellDate = tbl.getRow(sb.getTop()).getCell("lastUpdateTime");
        if (cellDate != null && cellDate.getValue() != null) {
            id = id + "@" + cellDate.getValue().toString();
        }
        RptHelper.preViewReport(id);
    }

    private static void preViewReport(String rptID) {
        RptContainerClient comp = RptContainerClient.getInstance();
        SheetContainerClient report = null;
        try {
            report = comp.getReport(rptID);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (report == null) {
            return;
        }
        Collection tbls = report.getTables();
        if (tbls == null) {
            return;
        }
        for (KDTable tbl : tbls) {
            if (tbl == null) continue;
            tbl.getPrintManager().printPreview();
            break;
        }
    }

    public static void setDefaultButton(CoreUIObject ui, JButton button) {
        if (ui == null || button == null) {
            return;
        }
        JRootPane rp = ui.getRootPane();
        if (rp == null) {
            return;
        }
        rp.setDefaultButton(button);
    }

    public static void registF1Action(CoreUIObject ui, Action action) {
        if (ui == null || action == null) {
            return;
        }
        KeyStroke ks = KeyStroke.getKeyStroke(112, 0);
        IUIWindow wnd = ui.getUIWindow();
        JRootPane jp = null;
        JLayeredPane lp = null;
        if (wnd instanceof JDialog) {
            jp = ((JDialog)wnd).getRootPane();
            lp = ((JDialog)wnd).getLayeredPane();
        } else if (wnd instanceof JFrame) {
            jp = ((JFrame)wnd).getRootPane();
            lp = ((JFrame)wnd).getLayeredPane();
        }
        String strKey = "F1";
        if (jp != null) {
            jp.getActionMap().put(strKey, action);
            jp.getInputMap(2).put(ks, strKey);
        }
        if (lp != null) {
            lp.getActionMap().put(strKey, action);
            lp.getInputMap(2).put(ks, strKey);
        }
    }

    public static void setEscAction(CoreUIObject ui, Action action) {
        if (ui == null || action == null) {
            return;
        }
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        IUIWindow wnd = ui.getUIWindow();
        JRootPane jp = null;
        JLayeredPane lp = null;
        if (wnd instanceof JDialog) {
            jp = ((JDialog)wnd).getRootPane();
            lp = ((JDialog)wnd).getLayeredPane();
        } else if (wnd instanceof JFrame) {
            jp = ((JFrame)wnd).getRootPane();
            lp = ((JFrame)wnd).getLayeredPane();
        }
        if (jp != null) {
            jp.getActionMap().put("ESCAPE", action);
            jp.getInputMap(2).put(ks, "ESCAPE");
        }
        if (lp != null) {
            lp.getActionMap().put("ESCAPE", action);
            lp.getInputMap(2).put(ks, "ESCAPE");
        }
    }

    public static void setFocusTo(Component target) {
        if (target != null) {
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new FocusEvent(target, 1004));
        }
    }

    public class MyVariantParser
    implements IVariantParser {
        private SpreadContext spread = null;
        ICoreBase bizInterface = null;
        String id = null;
        private boolean isInited = false;

        public void init(SpreadContext spread, String id, ICoreBase bizInterface) {
            this.spread = spread;
            this.id = id;
            this.bizInterface = bizInterface;
            this.isInited = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String parse(String varName, PainterInfo info) {
            if (varName == null) {
                return null;
            }
            if ((varName = varName.trim()).length() <= 1) {
                return varName;
            }
            if (varName.charAt(0) != '=') {
                return varName;
            }
            if (!this.isInited) {
                try {
                    boolean isCslRpt = this.bizInterface instanceof ICslReport;
                    EntityViewInfo view = new EntityViewInfo();
                    view.setSelector(RptHelper.getSelectors(isCslRpt));
                    view.setFilter(new FilterInfo());
                    view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)this.id, CompareType.EQUALS));
                    CoreBaseCollection coll = this.bizInterface.getCollection(view);
                    if (coll != null) {
                        CslRptUtil.prepareCalculate(null, (ReportBaseInfo)((ReportBaseInfo)coll.getObject(0)), (Book)this.spread.getBook(), (boolean)isCslRpt);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"parse error.", (Throwable)e);
                }
                finally {
                    this.isInited = true;
                }
            }
            Variant calcFormula = this.spread.getBook().getActiveSheet().calcFormula(varName);
            logger.error((Object)("-------------" + varName + "  :" + calcFormula));
            return calcFormula.toString();
        }
    }
}

