/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionEvent;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionListener;
import com.kingdee.bos.ctrl.kdf.util.style.Pattern;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.rpt.CSLCommentsCollection;
import com.kingdee.eas.fi.rpt.PostilCollection;
import com.kingdee.eas.fi.rpt.PostilInfo;
import com.kingdee.eas.fi.rpt.ReportCaclProxy;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.fi.rpt.RptCellComment;
import com.kingdee.eas.fi.rpt.RptComment;
import com.kingdee.eas.fi.rpt.RptCommentTank;
import com.kingdee.eas.fi.rpt.RptContextManager;
import com.kingdee.eas.fi.rpt.RptResourceHelper;
import com.kingdee.eas.fi.rpt.RptSheetComment;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.TablePorperts;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.client.IControlledDialogListener;
import com.kingdee.eas.fi.rpt.client.ISimpleDialog;
import com.kingdee.eas.fi.rpt.client.RptCellCmtEditUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Color;
import java.awt.Container;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RptSheet
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 20040911094750L;
    private transient RptCommentTank comment = null;
    private transient boolean hasCmtLinked = false;
    private transient boolean hasItemLinked = false;
    private transient List sheetBeforeActionListeners;
    protected RptContextManager context = null;
    transient ArrayList cellComments;
    private String name;
    private transient KDTable table;
    transient RptSheetParamInfo params = null;
    protected HashMap keys;
    protected String id;
    protected HashMap basePosition = new HashMap();
    boolean isLock = false;
    private String sumCalcZone = null;
    private EditorListener edListener = null;

    public static RptSheet getRptSheet(KDTable table) {
        TablePorperts tp = TablePorperts.getInstance(table);
        if (tp == null) {
            return null;
        }
        RptSheet st = null;
        Object obj = tp.get("rptsheet");
        if (!(obj instanceof RptSheet)) {
            st = new RptSheet();
            tp.put("rptsheet", st);
            st.setBasePosition((HashMap)tp.get("baseposition"));
            st.setKeys((HashMap)tp.get("keys"));
            st.setSumCalcZone((String)tp.get(TablePorperts.SUMCALCZONE));
        } else {
            st = (RptSheet)obj;
        }
        st.name = table.getName();
        st.id = table.getID();
        st.table = table;
        st.getContext().setTable(table);
        st.setBasePosition((HashMap)tp.get("baseposition"));
        st.setKeys((HashMap)tp.get("keys"));
        st.setSumCalcZone((String)tp.get(TablePorperts.SUMCALCZONE));
        return st;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.id);
        out.writeObject(this.name);
        out.writeBoolean(this.isLock);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object o = in.readObject();
        if (o == null) {
            this.id = null;
        } else if (o instanceof String) {
            this.id = (String)o;
        } else {
            throw new ClassNotFoundException();
        }
        o = in.readObject();
        if (o == null) {
            this.name = null;
        } else if (o instanceof String) {
            this.name = (String)o;
        } else {
            throw new ClassNotFoundException();
        }
        this.isLock = in.readBoolean();
    }

    public RptSheet() {
        this.keys = new HashMap(5);
        this.cellComments = new ArrayList();
        this.context = RptContextManager.getInstance();
    }

    public String toString() {
        return this.name;
    }

    public Object clone() {
        RptSheet result = new RptSheet();
        result.params = this.params == null ? null : (RptSheetParamInfo)this.params.clone();
        result.table = this.table;
        result.hasCmtLinked = false;
        result.hasItemLinked = false;
        result.isLock = this.isLock;
        result.id = this.id;
        result.name = this.name;
        result.context = this.context == null ? RptContextManager.getInstance() : this.context;
        result.comment = this.duplicateSheetComments();
        result.cellComments = this.duplicateCellComments();
        result.keys = (HashMap)this.keys.clone();
        result.setSumCalcZone(this.getSumCalcZone());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RptSheet)) {
            return false;
        }
        RptSheet s = (RptSheet)obj;
        if (this.table == s.table) {
            return true;
        }
        return this.table != null && s.table != null && this.table.getID() != null && this.table.getID().equals(s.table.getID());
    }

    public int hashCode() {
        int hashCode = 19;
        if (this.table == null) {
            hashCode = hashCode * 11 + 1;
        } else {
            hashCode = hashCode * 13 + this.table.hashCode();
            hashCode = this.table.getID() == null ? hashCode * 11 + 1 : hashCode * 13 + this.table.getID().hashCode();
        }
        return hashCode;
    }

    public RptCommentTank duplicateSheetComments() {
        if (this.comment == null) {
            return null;
        }
        RptCommentTank res = new RptCommentTank();
        for (int i = 0; i < this.comment.getSize(); ++i) {
            RptComment cmt = (RptComment)this.comment.getElementAt(i);
            if (cmt == null || !cmt.isValid()) continue;
            RptComment newbird = cmt.getCommentCopy();
            if (newbird.getSource() != null) {
                newbird.getSource().setId(null);
            }
            if (!cmt.isFresh()) {
                newbird.setNewly();
            }
            res.addInitEntry(newbird);
        }
        return res;
    }

    public ArrayList duplicateCellComments() {
        int lstX = this.table.getExpandedColumnCount();
        int lstY = this.table.getExpandedRowCount();
        ArrayList<RptCellComment> res = new ArrayList<RptCellComment>();
        for (int y = 0; y < lstY; ++y) {
            IRow r = this.table.getRow(y);
            if (r == null) continue;
            for (int x = 0; x < lstX; ++x) {
                RptCommentTank ct;
                RptCell rc = RptCell.getRptCell(r.getCell(x));
                if (rc == null || (ct = (RptCommentTank)rc.getComment()) == null) continue;
                for (int i = 0; i < ct.getSize(); ++i) {
                    RptCellComment cmt = (RptCellComment)ct.getElementAt(i);
                    if (cmt == null || !cmt.isValid()) continue;
                    RptCellComment newbird = (RptCellComment)cmt.getCommentCopy();
                    if (newbird.getSource() != null) {
                        newbird.getSource().setId(null);
                    }
                    if (!cmt.isFresh()) {
                        newbird.setNewly();
                    }
                    res.add(newbird);
                }
            }
        }
        return res;
    }

    public void swapWith(RptSheet another) {
        if (another == null) {
            return;
        }
        Object temp = null;
        temp = this.name;
        this.name = another.name;
        another.name = temp;
        temp = this.table;
        this.table = another.table;
        another.table = (KDTable)temp;
        temp = this.params;
        this.params = another.params;
    }

    public void setLock(String range, boolean dolock) {
        KDTSelectBlock sb = TableToolkit.rangeToBlock(range);
        if (sb == null) {
            return;
        }
        switch (sb.getMode()) {
            case 1: {
                for (int r = sb.getTop(); r <= sb.getBottom(); ++r) {
                    IRow ro = this.table.getRow(r);
                    if (ro == null) continue;
                    for (int c = sb.getLeft(); c < sb.getRight(); ++c) {
                        ICell ce = ro.getCell(c);
                        if (ce == null) continue;
                        ce.getStyleAttributes().setLocked(dolock);
                    }
                }
                break;
            }
            case 2: {
                for (int r = sb.getTop(); r <= sb.getBottom(); ++r) {
                    IRow ro = this.table.getRow(r);
                    if (ro == null) continue;
                    ro.getStyleAttributes().setLocked(dolock);
                }
                break;
            }
            case 4: {
                IRow ro = this.table.getRow(sb.getTop());
                if (ro == null) break;
                for (int c = sb.getLeft(); c < sb.getRight(); ++c) {
                    ICell ce = ro.getCell(c);
                    if (ce == null) continue;
                    ce.getStyleAttributes().setLocked(dolock);
                }
                break;
            }
        }
    }

    public String getId() {
        if (this.id == null && this.table != null) {
            this.id = this.table.getID();
        }
        return this.id;
    }

    public HashMap getKeys() {
        return this.keys;
    }

    public HashMap getSyncKeys() {
        HashMap bug = (HashMap)this.getExtendProperty("keys");
        if (bug != null) {
            this.keys = bug;
            return bug;
        }
        if (this.keys == null) {
            this.keys = new HashMap(5);
        }
        this.setKeys(this.keys);
        return this.keys;
    }

    public String getName() {
        return this.name;
    }

    public RptSheetParamInfo getParams() {
        return this.params;
    }

    public KDTable getTable() {
        return this.table;
    }

    public RptContextManager getContext() {
        if (this.context == null) {
            this.context = RptContextManager.getInstance();
        }
        return this.context;
    }

    public void setId(String string) {
        if (this.table != null) {
            this.table.setID(string);
        }
        this.id = string;
    }

    public synchronized void setKeys(HashMap map) {
        this.keys = map;
        this.setExtendProperty("keys", this.keys);
    }

    public void setName(String string) {
        if (this.table != null) {
            this.table.setName(string);
        }
        this.name = string;
    }

    public void setParams(RptSheetParamInfo info) {
        this.params = info;
        if (this.context.getData() != null) {
            this.context.getData().SetSheetParam((IObjectValue)this.params);
        }
    }

    public void setTable(KDTable aTable) {
        this.table = aTable;
        TablePorperts tp = TablePorperts.getInstance(this.table);
        if (tp != null) {
            tp.put("rptsheet", this);
        }
        if (this.comment != null) {
            this.comment.setTable(this.table);
        }
        this.getContext().setTable(this.table);
    }

    public void refreshContext(ReportCaclProxy data) {
        if (this.context == null) {
            this.context = RptContextManager.getInstance(data);
        } else {
            this.context.setData(data);
            if (data != null) {
                data.SetSheetParam((IObjectValue)this.getParams());
            }
        }
    }

    public ReportCaclProxy getReportCaclProxy() {
        if (this.context == null) {
            return null;
        }
        return (ReportCaclProxy)this.context.getData();
    }

    public boolean isLock() {
        this.isLock = this.table == null ? false : this.table.getStyleAttributes().isLocked();
        return this.isLock;
    }

    public void setLock(boolean b) {
        if (this.table != null) {
            this.isLock = b;
            StyleAttributes sa = this.table.getStyleAttributes();
            if (sa.isLocked() != this.isLock) {
                Color cl = this.isLock ? new Color(228, 228, 228) : Color.WHITE;
                sa.setLocked(this.isLock);
                if (sa.getPattern() == Pattern.None) {
                    sa.setPattern(Pattern.Solid);
                }
                sa.setBackground(cl);
            }
        }
    }

    public ArrayList getComments() {
        if (this.cellComments == null) {
            this.cellComments = new ArrayList();
        }
        return this.cellComments;
    }

    public void addCellComment(PostilInfo pinfo) {
        this.addCellComment(pinfo, false);
    }

    public void addCellComment(PostilInfo pinfo, boolean isSetToNew) {
        try {
            RptCellComment acmt = new RptCellComment(pinfo);
            if (isSetToNew) {
                acmt.setNewly();
            }
            this.getComments().add(acmt);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addComment(PostilInfo pinfo) {
        this.addComment(pinfo, false);
    }

    public void addComment(PostilInfo pinfo, boolean isSetToNew) {
        try {
            if (this.comment == null) {
                this.comment = new RptCommentTank();
            }
            RptSheetComment acmt = new RptSheetComment(pinfo);
            if (isSetToNew) {
                acmt.setNewly();
            }
            this.comment.addEntry(acmt);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeComments() {
        this.comment = null;
    }

    public void getComments(PostilCollection comments) {
        if (this.comment == null) {
            return;
        }
        this.comment.dump(comments);
    }

    public void getComments(CSLCommentsCollection comments) {
    }

    public void getCellsComment(PostilCollection comments) {
        if (comments == null || this.table == null) {
            return;
        }
        this.table.setRefresh(false);
        int lstX = this.table.getExpandedColumnCount();
        int lstY = this.table.getExpandedRowCount();
        IRow r = null;
        RptCell rc = null;
        for (int y = 0; y < lstY; ++y) {
            r = this.table.getRow(y);
            if (r == null) continue;
            for (int x = 0; x < lstX; ++x) {
                rc = RptCell.getRptCell(r.getCell(x));
                if (rc == null) continue;
                rc.getComments(comments);
            }
        }
        this.table.setRefresh(true);
    }

    public void removeAllComments() {
        this.removeComments();
        this.getComments().clear();
        this.table.setRefresh(false);
        int lstX = this.table.getExpandedColumnCount();
        int lstY = this.table.getExpandedRowCount();
        IRow r = null;
        ICell c = null;
        RptCell rc = null;
        for (int y = 0; y < lstY; ++y) {
            r = this.table.getRow(y);
            if (r == null) continue;
            for (int x = 0; x < lstX; ++x) {
                c = r.getCell(x);
                if (c == null || (rc = RptCell.getRptCell(c.getUserObject())) == null) continue;
                rc.setCell(c);
                rc.removeComments();
            }
        }
        this.table.setRefresh(true);
        this.hasCmtLinked = false;
    }

    public void getCellsComment(CSLCommentsCollection comments) {
        if (comments == null || this.table == null) {
            return;
        }
        this.table.setRefresh(false);
        int lstX = this.table.getExpandedColumnCount();
        int lstY = this.table.getExpandedRowCount();
        int reportClass = 1;
        if (this.params != null && this.params.getReportClass() != null) {
            reportClass = this.params.getReportClass().getValue();
        }
        IRow r = null;
        RptCell rc = null;
        for (int y = 0; y < lstY; ++y) {
            r = this.table.getRow(y);
            if (r == null) continue;
            for (int x = 0; x < lstX; ++x) {
                rc = RptCell.getRptCell(r.getCell(x));
                if (rc == null) continue;
                comments.add(rc, reportClass);
            }
        }
        this.table.setRefresh(true);
    }

    public void dispatchComments() {
        int c;
        int r;
        int size;
        if (this.table == null) {
            return;
        }
        int ERRNUM = -2;
        int cacheRow = -2;
        int cacheCol = -2;
        IRow row = null;
        ICell cell = null;
        RptCell rc = null;
        RptCellComment cmt = null;
        this.table.setRefresh(false);
        int n = size = this.cellComments == null ? 0 : this.cellComments.size();
        if (!this.hasCmtLinked) {
            for (int i = 0; i < size; ++i) {
                cmt = (RptCellComment)this.cellComments.get(i);
                r = cmt.getPosition().y;
                if (r != cacheRow) {
                    cacheRow = r;
                    cacheCol = -2;
                    row = this.table.getRow(r);
                }
                if (row == null) {
                    cacheRow = -2;
                    continue;
                }
                c = cmt.getPosition().x;
                if (c != cacheCol) {
                    cacheCol = c;
                    cell = row.getCell(c);
                }
                if (cell == null) {
                    cacheCol = -2;
                    continue;
                }
                rc = RptCell.getRptCell(cell);
                if (rc == null) continue;
                rc.setSheet(this);
                rc.addComment(cmt);
            }
            boolean bl = this.hasCmtLinked = size > 0;
        }
        if (!this.hasItemLinked) {
            cacheRow = this.table.getExpandedRowCount();
            cacheCol = this.table.getExpandedColumnCount();
            for (r = 0; r < cacheRow; ++r) {
                row = this.table.getRow(r);
                if (row == null) continue;
                for (c = 0; c < cacheCol; ++c) {
                    cell = row.getCell(c);
                    if (cell == null || (rc = RptCell.getRptCell(cell)) == null) continue;
                    rc.setSheet(this);
                }
            }
            this.hasItemLinked = true;
        }
        this.table.setRefresh(true);
        this.table.repaint();
    }

    public CoreUIObject getParentUI() {
        if (this.table == null) {
            return null;
        }
        Container pane = this.table.getParent();
        if (pane == null) {
            return null;
        }
        Container prcui = pane.getParent();
        if (prcui == null || !(prcui instanceof CoreUIObject)) {
            return null;
        }
        return (CoreUIObject)prcui;
    }

    public RptCell getRptCell(ICell cell) {
        RptCell res = RptCell.getRptCell(cell);
        if (res == null) {
            res = new RptCell(cell);
            cell.setUserObject((Object)res);
            res.setCell(cell);
        }
        res.setSheet(this);
        return res;
    }

    public void editComment(boolean isEditable) {
        if (this.comment == null) {
            this.comment = new RptCommentTank();
        }
        if (this.edListener == null) {
            this.edListener = new EditorListener();
        }
        try {
            String title = RptResourceHelper.getString("sheetcmt") + RptResourceHelper.getString(isEditable ? "edit" : "view");
            RptCellCmtEditUI ed = RptCellCmtEditUI.getInstance(this.getParentUI());
            ed.addSimpleDialogListener(this.edListener);
            ed.open(this.comment, title, isEditable);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public void beforSave() {
        if (this.params != null) {
            this.params.getPostils().clear();
            this.getComments(this.params.getPostils());
            this.getCellsComment(this.params.getPostils());
            this.params.setString("sheet.id", this.table != null ? this.table.getID() : this.id);
        }
    }

    public BOSUuid getPID() {
        return this.getParams() == null ? null : this.getParams().getId();
    }

    public HashMap getBasePosition() {
        this.basePosition = (HashMap)this.getExtendProperty("baseposition");
        if (this.basePosition == null) {
            this.basePosition = new HashMap(5);
            this.setBasePosition(this.basePosition);
        }
        return this.basePosition;
    }

    public void setBasePosition(HashMap map) {
        this.basePosition = map;
        this.setExtendProperty("baseposition", this.basePosition);
    }

    public Object getExtendProperty(Object key) {
        TablePorperts tp = this.getExtendProperts();
        return tp == null ? null : tp.get(key);
    }

    public void setExtendProperty(Object key, Object value) {
        TablePorperts tp = this.getExtendProperts();
        if (tp != null) {
            tp.put(key, value);
        }
    }

    public TablePorperts getExtendProperts() {
        TablePorperts tp = TablePorperts.getInstance(this.table);
        if (tp != null) {
            tp.put("rptsheet", this);
        }
        return tp;
    }

    public void setExtendProperts(HashMap properts) {
        TablePorperts tp = TablePorperts.setInstance(this.table, properts);
        if (tp != null) {
            tp.put("rptsheet", this);
        }
    }

    public void update() {
        TablePorperts tp = TablePorperts.getInstance(this.table);
        if (tp != null) {
            tp.put("rptsheet", this);
            tp.put("keys", this.keys);
        }
    }

    public HashMap getTransientProperts() {
        TablePorperts tp = TablePorperts.getInstance(this.table);
        return tp != null ? tp.getTransientProperts() : null;
    }

    public void setTransientProperts(HashMap tps) {
        TablePorperts tp = TablePorperts.getInstance(this.table);
        if (tp != null) {
            tp.setTransientProperts(tps);
        }
    }

    public void insertCols(int count) {
        if (this.table == null) {
            return;
        }
        int basePos = this.table.getSelectManager().getActiveColumnIndex();
        if (basePos < 0) {
            basePos = 0;
        }
        while (count-- > 0) {
            if (!this.executeBeforeAction(2, new Integer(basePos))) continue;
            this.table.addColumn(basePos);
        }
    }

    public void insertRows(int count) {
        if (this.table == null) {
            return;
        }
        int basePos = this.table.getSelectManager().getActiveRowIndex();
        if (basePos < 0) {
            basePos = 0;
        }
        while (count-- > 0) {
            if (!this.executeBeforeAction(0, new Integer(basePos))) continue;
            this.table.addRow(basePos);
        }
    }

    private boolean executeBeforeAction(int type, Object param) {
        if (this.sheetBeforeActionListeners != null) {
            BeforeActionEvent e = new BeforeActionEvent((Object)this.table, type, param);
            for (int i = 0; i < this.sheetBeforeActionListeners.size(); ++i) {
                ((BeforeActionListener)this.sheetBeforeActionListeners.get(i)).beforeAction(e);
                if (!e.isCancel()) continue;
                return false;
            }
        }
        return true;
    }

    public void addSheetBeforeAction(BeforeActionListener action) {
        if (this.sheetBeforeActionListeners == null) {
            this.sheetBeforeActionListeners = new ArrayList(1);
        }
        this.sheetBeforeActionListeners.add(action);
    }

    public void removeSheetBeforeAction(BeforeActionListener action) {
        if (this.sheetBeforeActionListeners == null) {
            return;
        }
        this.sheetBeforeActionListeners.remove(action);
    }

    public void removeSheetBeforeActions() {
        if (this.sheetBeforeActionListeners == null) {
            return;
        }
        this.sheetBeforeActionListeners.clear();
    }

    public String getSumCalcZone() {
        this.sumCalcZone = (String)this.getExtendProperty(TablePorperts.SUMCALCZONE);
        return this.sumCalcZone;
    }

    public void setSumCalcZone(String sumCalcZone) {
        this.setExtendProperty(TablePorperts.SUMCALCZONE, sumCalcZone);
        this.sumCalcZone = sumCalcZone;
    }

    private class EditorListener
    implements IControlledDialogListener {
        private EditorListener() {
        }

        @Override
        public Object getTrueController() {
            return new RptSheetComment();
        }

        @Override
        public void pilotSetout(ISimpleDialog source) {
        }

        @Override
        public void pilotReturnee(ISimpleDialog source, Object result, boolean isOk) {
            if (isOk) {
                RptSheet.this.comment.updateFrom((RptCommentTank)result);
                if (RptSheet.this.params != null && RptSheet.this.params.getStatus() == 0) {
                    RptSheet.this.params.setStatus(2);
                }
            }
        }
    }
}

