/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.kdf.table.KDTPrintManager;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.kscript.runtime.Pair;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.client.AbstractRptSheetPrintUI;
import com.kingdee.eas.fi.rpt.client.HeaderFooterSetupUI;
import com.kingdee.eas.fi.rpt.client.ReportProcessUI;
import com.kingdee.eas.fi.rpt.client.RptHelper;
import com.kingdee.eas.fi.rpt.client.RptSheet;
import com.kingdee.eas.fi.rpt.client.RptSheetChooseDialog;
import com.kingdee.eas.fi.rpt.client.RptTablePane;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;

public class RptSheetPrintUI
extends AbstractRptSheetPrintUI {
    PrintConfigListener applyPrintConfigObserver = null;
    private RptTablePane report = null;
    private boolean isOKey = false;
    private KDTPrintManager config = null;

    public void onShow() throws Exception {
        super.onShow();
        RptHelper.setDefaultButton(this, (JButton)this.btnPrint);
        RptHelper.setEscAction(this, (Action)((Object)this.actionBtnCancel));
    }

    public static RptSheetPrintUI getInstance(CoreUIObject parentUI) throws Exception {
        IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow wnd = fy.create(RptSheetPrintUI.class.getName(), (Map)new UIContext((Object)parentUI));
        RptSheetPrintUI res = (RptSheetPrintUI)wnd.getUIObject();
        res.onShow();
        return res;
    }

    public RptSheetPrintUI() throws Exception {
        this.initialize();
        this.cbxUseFirstPrintSetting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RptSheetPrintUI.this.cbxUseFirstPrintSetting.isSelected()) {
                    RptSheetPrintUI.this.btnConfig.setEnabled(true);
                } else {
                    RptSheetPrintUI.this.btnConfig.setEnabled(false);
                }
            }
        });
    }

    private void initialize() throws Exception {
        this.boxRegion.setEnabled(false);
        this.boxRegion.setEditable(true);
        this.grpPageSelection.setValue(0);
        class GroupListener
        implements ActionListener {
            GroupListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                RptSheetPrintUI.this.boxRegion.setEnabled(e.getSource() == RptSheetPrintUI.this.btnPageSelect);
            }
        }
        GroupListener gl = new GroupListener();
        this.btnPageAll.addActionListener((ActionListener)gl);
        this.btnPageSelect.addActionListener((ActionListener)gl);
    }

    @Override
    public void actionConfig_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfig_actionPerformed(e);
        Collection coll = this.getSelectedSheets();
        if (coll == null || coll.size() < 1) {
            MsgBox.showWarning((String)RptUtil.getReportResource("choose_sheet_to_print"));
            return;
        }
        int op = MsgBox.showConfirm2((String)RptUtil.getReportResource("PrintSetting_will_apply_AllSheets"));
        if (op == 2) {
            return;
        }
        if (this.getPrintAttrData() && this.applyPrintConfigObserver != null) {
            this.applyPrintConfigObserver.applyPrintConfig(coll, this.config);
        }
    }

    public void setPrintConfigObserver(PrintConfigListener o) {
        this.applyPrintConfigObserver = o;
    }

    @Override
    public void actionBtnOk_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnOk_actionPerformed(e);
        Collection coll = this.getSelectedSheets();
        if (coll == null || coll.size() < 1) {
            MsgBox.showWarning((String)RptUtil.getReportResource("choose_sheet_to_print"));
            return;
        }
        this.endWizard(true);
    }

    @Override
    public void actionBtnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnCancel_actionPerformed(e);
        this.endWizard(false);
    }

    public void open(RptTablePane rpt, String title) {
        this.report = rpt;
        this.cbxUseFirstPrintSetting.setSelected(true);
        try {
            ArrayList sheets = this.report.getSheets();
            ArrayList<String> sheetNames = new ArrayList<String>();
            for (int i = 0; i < sheets.size(); ++i) {
                sheetNames.add(((RptSheet)sheets.get(i)).getTable().getName());
            }
            this.boxRegion.setSelector((KDPromptSelector)new RptSheetChooseDialog((IUIObject)this, sheetNames));
            this.boxRegion.setEditable(false);
        }
        catch (Exception e12) {
            Object e12 = null;
        }
        IUIWindow w = this.getUIWindow();
        if (w instanceof KDDialog) {
            KDDialog d = (KDDialog)w;
            if (title != null) {
                d.setTitle(title);
            }
            d.addWindowListener((WindowListener)new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    e.setSource(null);
                    RptSheetPrintUI.this.endWizard(false);
                }
            });
        }
        w.show();
    }

    public Pair getPrintConfigure() {
        Collection sheets = null;
        if (this.report != null) {
            if (this.btnPageAll.isSelected()) {
                sheets = this.report.getVisibleIndices();
            } else {
                List line = (List)this.boxRegion.getData();
                if (line != null) {
                    sheets = this.getIndicesBySheetName(line);
                }
            }
        }
        return new Pair(sheets, (Object)this.config);
    }

    private Collection getIndicesBySheetName(List nameList) {
        ArrayList<Integer> rs = new ArrayList<Integer>(nameList.size());
        for (int i = 0; i < this.report.getSheetCount(); ++i) {
            if (!nameList.contains(this.report.getSheet(i).getName())) continue;
            rs.add(new Integer(i));
        }
        return rs;
    }

    private Collection getSelectedSheets() {
        Collection sheets = null;
        if (this.report != null) {
            if (this.btnPageAll.isSelected()) {
                sheets = this.report.getVisibleIndices();
            } else {
                List line = (List)this.boxRegion.getData();
                if (line != null) {
                    sheets = this.getIndicesBySheetName(line);
                }
            }
        }
        return sheets;
    }

    public boolean isOk() {
        return this.isOKey;
    }

    void endWizard(boolean isOk) {
        this.isOKey = isOk;
        boolean checked = this.cbxUseFirstPrintSetting.isSelected();
        try {
            if (this.isOKey && this.config == null) {
                this.isOKey = checked ? this.getPrintAttrData() : true;
            }
            this.disposeUIWindow();
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    private boolean getPrintAttrData() throws Exception {
        KDTPrintManager pm = this.getPrintManager();
        ReportProcessUI reportProcessUI = new ReportProcessUI();
        pm.setHeadFootUI(HeaderFooterSetupUI.class);
        HeaderFooterSetupUI.extendButtonAction = reportProcessUI.new ReportProcessUI.HFDesignerAction();
        if (pm.pageSetup()) {
            this.config = pm;
            return true;
        }
        return false;
    }

    private KDTPrintManager getPrintManager() {
        return this.report.getPageAt(0).getPrintManager();
    }

    public boolean isUsingFirstPageSetting() {
        return this.cbxUseFirstPrintSetting.isSelected();
    }

    protected static interface PrintConfigListener {
        public void applyPrintConfig(Collection var1, KDTPrintManager var2);
    }
}

