/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.RptResourceHelper;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.client.AbstractRptSheetSelectorUI;
import com.kingdee.eas.fi.rpt.client.ISimpleDialog;
import com.kingdee.eas.fi.rpt.client.ISimpleDialogListener;
import com.kingdee.eas.fi.rpt.client.RptHelper;
import com.kingdee.eas.fi.rpt.client.RptTablePane;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class RptSheetSelectorUI
extends AbstractRptSheetSelectorUI
implements ISimpleDialog,
KDPromptSelector {
    private ArrayList listeners = new ArrayList(1);
    private RptTablePane pane = null;
    private KDPromptBox ctrl = null;
    private boolean isCancel = true;
    String selection = null;

    public static RptSheetSelectorUI getInstance(CoreUIObject parentUI) throws Exception {
        IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow wnd = fy.create(RptSheetSelectorUI.class.getName(), (Map)new UIContext((Object)parentUI));
        RptSheetSelectorUI res = (RptSheetSelectorUI)wnd.getUIObject();
        res.onShow();
        return res;
    }

    public void setTablePane(RptTablePane tablePane) {
        this.pane = tablePane;
    }

    public void setControl(KDPromptBox f7) {
        this.ctrl = f7;
    }

    public RptSheetSelectorUI() throws Exception {
        this.btnSelectAll.setIcon(RptResourceHelper.getIcon("imgTbtn_addmapping"));
        this.btnSelectNone.setIcon(RptResourceHelper.getIcon("imgTbtn_deletemapping"));
    }

    @Override
    public void actionBtnOk_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnOk_actionPerformed(e);
        this.endWizard(true);
    }

    @Override
    public void actionBtnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnCancel_actionPerformed(e);
        this.endWizard(false);
    }

    @Override
    public void actionBtnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnSelectAll_actionPerformed(e);
        this.selectAll(true);
    }

    @Override
    public void actionBtnSelectNone_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnSelectNone_actionPerformed(e);
        this.selectAll(false);
    }

    private void selectAll(boolean isChecked) {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treSheets.getModel().getRoot();
        if (root != null) {
            int num = root.getChildCount();
            for (int i = 0; i < num; ++i) {
                DefaultKingdeeTreeNode nd = (DefaultKingdeeTreeNode)root.getChildAt(i);
                nd.setChecked(isChecked);
            }
        }
        this.treSheets.updateUI();
    }

    private int[] getSelectedIndices() {
        int[] res = null;
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treSheets.getModel().getRoot();
        if (root != null) {
            int num = root.getChildCount();
            int[] aim = new int[num];
            int i = 0;
            int j = 0;
            for (i = 0; i < num; ++i) {
                DefaultKingdeeTreeNode nd = (DefaultKingdeeTreeNode)root.getChildAt(i);
                if (!nd.isChecked()) continue;
                aim[j] = i;
                ++j;
            }
            if (j > 0) {
                res = new int[j];
                for (i = 0; i < j; ++i) {
                    res[i] = aim[i];
                }
            }
        }
        return res;
    }

    public void show() {
        this.open(null, null);
    }

    private String getSheetList() {
        String res = null;
        if (this.pane != null) {
            res = RptResourceHelper.getString("rptcheckui-report-root");
            res = res + ',';
            int num = this.pane.getTabCount();
            for (int i = 0; i < num; ++i) {
                res = res + this.pane.getTitleAt(i) + ',';
            }
        }
        return res;
    }

    private void loadSheetTree(String sheets) {
        KingdeeTreeModel md = (KingdeeTreeModel)this.treSheets.getModel();
        md.setRoot(null);
        if (sheets == null) {
            return;
        }
        this.treSheets.setShowCheckBox(true);
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        root.setCheckBoxVisible(false);
        root.setCheckBoxEnabled(false);
        String[] shtList = sheets.split(",");
        if (shtList.length > 0) {
            root.setText(shtList[0]);
        }
        String line = this.ctrl == null ? null : this.ctrl.getText();
        Collection hint = TableToolkit.parseIndices(line, 0, shtList.length - 1);
        DefaultKingdeeTreeNode entry = null;
        for (int i = 1; i < shtList.length; ++i) {
            entry = new DefaultKingdeeTreeNode();
            entry.setText(shtList[i]);
            if (hint != null && hint.contains(new Integer(i - 1))) {
                entry.setChecked(true);
            }
            root.add((MutableTreeNode)entry);
        }
        md.setRoot((TreeNode)root);
    }

    @Override
    public void open(Object cookie, String title) {
        this.fireListenersSetout();
        if (this.pane == null) {
            this.endWizard(false);
        }
        this.loadSheetTree(this.getSheetList());
        IUIWindow w = this.getUIWindow();
        if (w instanceof KDDialog) {
            KDDialog d = (KDDialog)w;
            if (title != null) {
                d.setTitle(title);
            }
            d.addWindowListener((WindowListener)new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    RptSheetSelectorUI.this.endWizard(false);
                }
            });
        }
        w.show();
    }

    private void endWizard(boolean isOk) {
        this.isCancel = !isOk;
        this.selection = isOk ? TableToolkit.formatIndices(this.getSelectedIndices()) : null;
        this.disposeUIWindow();
        this.fireListenersReturnee(this.selection, isOk);
    }

    @Override
    public void addSimpleDialogListener(ISimpleDialogListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public boolean isCanceled() {
        return this.isCancel;
    }

    public Object getData() {
        return this.selection;
    }

    private void fireListenersSetout() {
        for (ISimpleDialogListener l : this.listeners) {
            if (l == null) continue;
            l.pilotSetout(this);
        }
    }

    private void fireListenersReturnee(String result, boolean isOk) {
        this.selection = result;
        for (ISimpleDialogListener l : this.listeners) {
            if (l == null) continue;
            l.pilotReturnee(this, result, isOk);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        RptHelper.setDefaultButton(this, (JButton)this.btnOk);
        RptHelper.setEscAction(this, (Action)((Object)this.actionBtnCancel));
    }
}

