/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDScrollBar;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.biz.BizClient;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptCalculatorFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectCollection;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICslRptCalculator;
import com.kingdee.eas.fi.gr.cslrpt.ISumRptRela;
import com.kingdee.eas.fi.gr.cslrpt.SumRptRelaFactory;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLPermissionUtil;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.IReportProcess;
import com.kingdee.eas.fi.rpt.IRptSheetParam;
import com.kingdee.eas.fi.rpt.ISumReportProcess;
import com.kingdee.eas.fi.rpt.PublishedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportBaseCollection;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptOperationSchemaComp;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.client.AbstractRptSumEditUI;
import com.kingdee.eas.fi.rpt.client.ReportEditUI;
import com.kingdee.eas.fi.rpt.client.ReportMaintainUI;
import com.kingdee.eas.fi.rpt.client.RptBaseMenuStrategy;
import com.kingdee.eas.fi.rpt.client.RptComboBoxModel;
import com.kingdee.eas.fi.rpt.client.RptReportMenuStrategy;
import com.kingdee.eas.fi.rpt.client.RptReportPromptBox;
import com.kingdee.eas.fi.rpt.client.RptSumReportMenuStrategy;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.SumcalcRange;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.workflow.IMultiAssignmentUI;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JScrollBar;

public class RptSumEditUI
extends AbstractRptSumEditUI
implements ISumReportProcess {
    private boolean isAddnew = false;
    int currentsubReportNumber = 0;
    private boolean hasBudgetedPermission;
    private boolean hasACPermission;
    private HashMap dataCollectMap = new HashMap();

    public RptSumEditUI() throws Exception {
        this.btnSubmitUnAudit.putClientProperty((Object)"IsInArrowScope", (Object)Boolean.FALSE);
        this.btnUnSubmit.putClientProperty((Object)"IsInArrowScope", (Object)Boolean.FALSE);
        this.btnAdd.setEnabled(true);
        this.btnDel.setEnabled(true);
        this.btnAdd.setVisible(true);
        this.btnDel.setVisible(true);
        this.rbnNoTemplate.setEnabled(false);
    }

    @Override
    public IReportProcess duplicate(Object ojbect) throws Exception {
        UIContext uiContext = new UIContext(this.getUIContext().get("Owner"));
        this.userObjectSelf = ojbect;
        uiContext.put((Object)"ID", null);
        uiContext.put((Object)"type", (Object)"duplicate");
        uiContext.put((Object)"Owner", this.getUIContext().get("Owner"));
        uiContext.put((Object)"OwnerWindow", this.getUIContext().get("OwnerWindow"));
        IUIWindow uw = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ReportEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        return (IReportProcess)uw.getUIObject();
    }

    @Override
    public void prmtTemplateChange() {
        super.prmtTemplateChange();
        this.cbxPeriodType.setEnabled(true);
        try {
            TemplateInfo templateInfo;
            int templateType = this.btngTemplate.getValue();
            if (templateType == 2 && this.hasBudgetedPermission && (templateInfo = (TemplateInfo)this.prmtTemplate.getData()) != null) {
                BOSUuid id = templateInfo.getId();
                boolean isIncludeOtherDC = ((TemplateInfo)TemplateFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(id))).isIncludeOtherDC();
                if (!isIncludeOtherDC) {
                    if (!this.hasACPermission) {
                        this.prmtTemplate.setData(null);
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.onlyHaveBgPermis"));
                        SysUtil.abort();
                    } else {
                        this.cbxDataCollect.setSelectedItem(this.dataCollectMap.get("ACTUALDATA"));
                        this.cbxDataCollect.setEnabled(false);
                    }
                } else if (!this.hasACPermission) {
                    this.cbxDataCollect.setEnabled(false);
                } else {
                    this.cbxDataCollect.setEnabled(true);
                }
            }
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.selfLoadField();
        if (this.editData.isIsOpenAutoCalc()) {
            this.chkCalculate.setSelected(true);
        } else {
            this.chkCalculate.setSelected(false);
        }
        this.initSubReport();
    }

    public void initSubReport() {
        this.tblSubReport.removeRows();
        if (this.editData != null && this.editData.getSubReport() != null) {
            ReportBaseCollection subReport = this.editData.getSubReport();
            int size = subReport.size();
            for (int i = 0; i < size; ++i) {
                this.addTable(subReport.get(i));
            }
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return this.getSelfSelections();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.remove((Component)this.btnAdd);
        this.remove((Component)this.btnDel);
        this.ctnSubReport.addButton((JButton)this.btnAdd);
        this.ctnSubReport.addButton((JButton)this.btnDel);
    }

    @Override
    protected void initSelfUI() throws Exception {
        super.initSelfUI();
        this.tblSubReport.checkParsed();
        this.tblSubReport.getColumn(0).getStyleAttributes().setHided(true);
        this.tblSubReport.getSelectManager().setSelectMode(2);
        this.cbxStartYear.setModel((ComboBoxModel)new RptComboBoxModel(this.yearMap.keySet().toArray(), false));
        this.cbxStartYear.setSelectedItem((Object)this.currentYear);
        this.cbxStartPeriod.setModel((ComboBoxModel)new RptComboBoxModel((List)this.yearMap.get(this.currentYear)));
        this.cbxStartPeriod.setSelectedItem((Object)this.currentPeriod);
        Object isSupportOtherDS = CslRptUtil.getParamValue(null, null, (String)"GR_CSL_SupportOtherDS");
        DataCollectCollection datacollect = DataCollectFactory.getRemoteInstance().getDataCollectCollection("select * where number in ('ACTUALDATA','BUDGETDATA')");
        this.dataCollectMap.clear();
        for (int i = 0; i < datacollect.size(); ++i) {
            DataCollectInfo dataCollect = datacollect.get(i);
            this.cbxDataCollect.addItem((Object)dataCollect);
            this.dataCollectMap.put(dataCollect.getNumber(), dataCollect);
        }
        this.cbxDataCollect.setSelectedItem(this.dataCollectMap.get("ACTUALDATA"));
        this.cbxDataCollect.setEnabled(false);
        if ("true".equals(isSupportOtherDS)) {
            this.labdataCollect.setVisible(true);
        } else {
            this.labdataCollect.setVisible(false);
        }
        this.hasBudgetedPermission = CSLPermissionUtil.hasDataCollectPermission(null, (String)SysContext.getSysContext().getCurrentUserInfo().getId().toString(), (DataCollectInfo)((DataCollectInfo)this.dataCollectMap.get("BUDGETDATA")));
        this.hasACPermission = CSLPermissionUtil.hasDataCollectPermission(null, (String)SysContext.getSysContext().getCurrentUserInfo().getId().toString(), (DataCollectInfo)((DataCollectInfo)this.dataCollectMap.get("ACTUALDATA")));
    }

    private ISumRptRela getSumRptInterFace() throws BOSException {
        return SumRptRelaFactory.getRemoteInstance();
    }

    @Override
    protected void selfLoadField() {
        super.selfLoadField();
        if (this.editData.getStartDate() != null) {
            this.dpkStarDate.setValue((Object)this.editData.getStartDate());
        }
        if (this.editData.getYear() != 0) {
            this.cbxStartYear.setSelectedItem((Object)new Integer(this.editData.getYear()));
        }
        if (this.editData.getPeriod() != 0) {
            this.cbxStartPeriod.setSelectedItem((Object)new Integer(this.editData.getPeriod()));
        }
    }

    @Override
    public void actionUnSubmit_actionPerformed(ActionEvent e) throws Exception {
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        if ("EDIT".equals(this.getOprtState()) || "VIEW".equals(this.getOprtState())) {
            BizClient bizClient = BizClient.newInstance((String)UIConfig.getUrl());
            AssignmentInfo[] assignments = bizClient.checkAssignmentInfos(this.editData.getId().toString(), ((UserInfo)SysContext.getSysContext().getCurrentUser()).getId().toString());
            int length = assignments.length;
            for (int i = 0; i < length; ++i) {
                String actionName = assignments[i].getBizOperation();
                if (actionName.equalsIgnoreCase("ActionUnSubmit")) {
                    this.wfContext.addToDataMap((Object)this.editData.getId().toString(), this.getValue((IObjectPK)pk));
                    ReportFactory.getRemoteInstance().unSubmit(this.editData.getId());
                    break;
                }
                if (i != length - 1) continue;
                MsgBox.showInfo((String)RptUtil.getResourceSince51("ReportHasbeenAudited"));
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionSubmitUnAudit_actionPerformed(ActionEvent e) throws Exception {
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        this.wfContext.addToDataMap((Object)this.editData.getId().toString(), this.getValue((IObjectPK)pk));
        ReportFactory.getRemoteInstance().submitUnAudite(this.editData.getId());
    }

    @Override
    public void actionbtnAdd_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, String> ultraFilter;
        if (this.prmtTemplate.getData() == null) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("PleaseChooseTemplate"));
            SysUtil.abort();
        }
        RptReportPromptBox rptReportPromptBox = new RptReportPromptBox((IUIObject)this, true);
        rptReportPromptBox.setTemplateGroup(((TemplateInfo)this.prmtTemplate.getData()).getGroup());
        rptReportPromptBox.setPeriodType(((TemplateInfo)this.prmtTemplate.getData()).getPeriodType().getValue());
        rptReportPromptBox.setOrgType(RptNewUIUtil.getOrgTypeUsedReflect(this.getClass(), (Object)this));
        rptReportPromptBox.setOrgUnitInfo(this.getCurrCompanyOrgInfo());
        if (this.cbxCurrency.getSelectedItem() != null) {
            ultraFilter = new HashMap<String, String>(1);
            ultraFilter.put("currency.id", ((CurrencyInfo)this.cbxCurrency.getSelectedItem()).getId().toString());
            rptReportPromptBox.appendFilter(ultraFilter);
        }
        if (this.cbxDataCollect.getSelectedItem() != null) {
            ultraFilter = new HashMap(1);
            ultraFilter.put("dataCollectNumber", ((DataCollectInfo)this.cbxDataCollect.getSelectedItem()).getNumber().toString());
            rptReportPromptBox.appendFilter(ultraFilter);
        }
        rptReportPromptBox.show();
        if (rptReportPromptBox.isCanceled()) {
            return;
        }
        ArrayList oldReportIDs = this.getSubReportIds();
        Object[] ArrayreportDatas = (Object[])rptReportPromptBox.getData();
        ArrayList reportDatas = this.filterData(ArrayreportDatas, oldReportIDs);
        if (reportDatas != null && reportDatas.size() > 0) {
            for (int j = 0; j < reportDatas.size(); ++j) {
                this.addTable((ReportInfo)reportDatas.get(j));
            }
        }
        this.tempalteChange();
    }

    private void tempalteChange() {
        if (this.currentsubReportNumber > 0) {
            this.prmtTemplate.setEnabled(false);
            this.rbnCommonTemplate.setEnabled(false);
            this.rbnGroupTemplate.setEnabled(false);
        } else {
            this.prmtTemplate.setEnabled(true);
            this.rbnCommonTemplate.setEnabled(true);
            this.rbnGroupTemplate.setEnabled(true);
        }
    }

    @Override
    public ArrayList getSubReportIds() {
        ArrayList<String> reportIDs = new ArrayList<String>();
        for (int i = 0; i < this.tblSubReport.getRowCount(); ++i) {
            String reportId = ((ReportBaseInfo)this.tblSubReport.getRow(i).getCell(0).getValue()).getId().toString();
            if (reportId == null || reportId.length() <= 0) continue;
            reportIDs.add(reportId);
        }
        return reportIDs;
    }

    protected ReportBaseCollection getSubReport() {
        ReportBaseCollection subReport = new ReportBaseCollection();
        for (int i = 0; i < this.tblSubReport.getRowCount(); ++i) {
            ReportBaseInfo report = (ReportBaseInfo)this.tblSubReport.getRow(i).getCell(0).getValue();
            if (report == null) continue;
            subReport.add(report);
        }
        return subReport;
    }

    private ArrayList filterData(Object[] newReports, ArrayList oldReports) {
        if (newReports == null || newReports.length == 0) {
            return null;
        }
        ArrayList<Object> returnDatas = new ArrayList<Object>();
        int oldReportDatasSize = newReports.length;
        for (int i = 0; i < oldReportDatasSize; ++i) {
            String id = ((ReportInfo)newReports[i]).getId().toString();
            if (oldReports.contains(id)) continue;
            returnDatas.add(newReports[i]);
        }
        return returnDatas;
    }

    private void addTable(ReportBaseInfo reportInfo) {
        IRow row = this.tblSubReport.addRow();
        row.getStyleAttributes().setLocked(true);
        row.getCell("object").setValue((Object)reportInfo);
        row.getCell("number").setValue((Object)reportInfo.getNumber());
        row.getCell("name").setValue((Object)reportInfo.getName());
        row.getCell("sourceType").setValue((Object)reportInfo.getSourceType());
        row.getCell("period").setValue((Object)ReportMaintainUI.scrambReportPeriod(reportInfo.getPeriodType(), new Integer(reportInfo.getYear()), new Integer(reportInfo.getPeriod()), reportInfo.getStartDate()));
        row.getCell("auditedStatus").setValue((Object)reportInfo.getAuditedStatus());
        ++this.currentsubReportNumber;
    }

    @Override
    public void actionbtnDel_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblSubReport.getSelectManager().get() == null) {
            return;
        }
        int ibeginRow = this.tblSubReport.getSelectManager().get().getBeginRow();
        int iEndrow = this.tblSubReport.getSelectManager().get().getEndRow();
        int ilastRow = this.tblSubReport.getRowCount();
        if (ibeginRow != -1 && iEndrow != -1) {
            for (int i = ibeginRow; i < iEndrow + 1; ++i) {
                IRow row = this.tblSubReport.getRow(i);
                if (row == null) continue;
                row = this.tblSubReport.removeRow(i);
                --iEndrow;
                --i;
            }
        } else if (ilastRow > 0) {
            IRow row = this.tblSubReport.getRow(ilastRow);
            this.tblSubReport.removeRow(ilastRow - 1);
        }
        --this.currentsubReportNumber;
        this.tempalteChange();
    }

    @Override
    public void openVertify() {
        ArrayList reportIDs = this.getSubReportIds();
        if (reportIDs.size() == 0) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("SubReportNull"));
            SysUtil.abort();
        }
    }

    public void workFlowBeforeOpen() throws Exception {
        if ("EDIT".equals(this.getOprtState()) || "VIEW".equals(this.getOprtState())) {
            BizClient bizClient = BizClient.newInstance((String)UIConfig.getUrl());
            AssignmentInfo[] assignments = bizClient.checkAssignmentInfos(this.editData.getId().toString(), ((UserInfo)SysContext.getSysContext().getCurrentUser()).getId().toString());
            int length = assignments.length;
            for (int i = 0; i < length; ++i) {
                String actionName = assignments[i].getBizOperation();
                if (!actionName.equalsIgnoreCase("ActionUnSubmit")) continue;
                this.getRptStrategyManager();
                ((RptReportMenuStrategy)this.rptStrategyManager.getRptMenuStartegy()).setWorkflowStatus(1);
                break;
            }
        }
    }

    public void checkRptSumIsWorkFlow() throws Exception {
        BizClient bizClient;
        AssignmentInfo[] assignments;
        boolean isWorkFlow = false;
        if (("EDIT".equals(this.getOprtState()) || "VIEW".equals(this.getOprtState())) && (assignments = (bizClient = BizClient.newInstance((String)UIConfig.getUrl())).checkAssignmentInfos(this.editData.getId().toString(), ((UserInfo)SysContext.getSysContext().getCurrentUser()).getId().toString())) != null && assignments.length > 0) {
            isWorkFlow = true;
        }
        if (isWorkFlow) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("ObjectInWorkFlow"));
            SysUtil.abort();
        }
    }

    @Override
    protected void openReport(boolean isStore, boolean isShowReport) throws Exception {
        this.workFlowBeforeOpen();
        this.isDestroy = false;
        if (isStore) {
            this.storeFields();
        }
        if (this.getOprtState().equals("ADDNEW") && this.prmtTemplate.getData() != null) {
            TemplateInfo temp = (TemplateInfo)this.prmtTemplate.getData();
            String tempId = temp.getId().toString();
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("sheetName"));
            sic.add(new SelectorItemInfo("startYear"));
            sic.add(new SelectorItemInfo("endYear"));
            sic.add(new SelectorItemInfo("startPeriod"));
            sic.add(new SelectorItemInfo("endPeriod"));
            sic.add(new SelectorItemInfo("startDate"));
            sic.add(new SelectorItemInfo("endDate"));
            sic.add(new SelectorItemInfo("isIncludingUnposted"));
            sic.add(new SelectorItemInfo("currency.id"));
            sic.add(new SelectorItemInfo("currency.name"));
            sic.add(new SelectorItemInfo("currency.number"));
            sic.add(new SelectorItemInfo("relaType"));
            sic.add(new SelectorItemInfo("sheetID"));
            sic.add(new SelectorItemInfo("report.id"));
            FilterInfo filter = new FilterInfo();
            FilterItemInfo filterItem = new FilterItemInfo("report", (Object)tempId);
            filter.getFilterItems().add(filterItem);
            view.setFilter(filter);
            RptSheetParamCollection rptSheetParamCollection = ((IRptSheetParam)this.getRptSheetParamBizInterface()).getRptSheetParamCollection(view);
            if (rptSheetParamCollection != null) {
                for (int j = 0; j < rptSheetParamCollection.size(); ++j) {
                    RptSheetParamInfo info = rptSheetParamCollection.get(j);
                    info.setRelaType(ReportTypeEnum.REPORT);
                    info.setId(null);
                    info.setStatus(1);
                }
            }
            this.editData.getSheetParam().addCollection(rptSheetParamCollection);
            this.calculateSumReport(temp);
        }
        if (this.uiWindow == null) {
            UIContext uiContext = new UIContext(this.getUIContext().get("Owner"));
            uiContext.put((Object)"self", (Object)this);
            uiContext.put((Object)"saveUI", (Object)this.getMetaDataPK().getFullName());
            uiContext.put((Object)"superParent", this.getUIContext().get("superParent"));
            uiContext.put((Object)"InitDataObject", (Object)this.editData);
            uiContext.put((Object)"isCommonSum", (Object)Boolean.TRUE);
            if (this.getUIContext().get("isMultiApprove") != null) {
                uiContext.put((Object)"isMultiApprove", this.getUIContext().get("isMultiApprove"));
                uiContext.put((Object)"isNewWindow", this.getUIContext().get("isNewWindow"));
                IMultiAssignmentUI multiApproveUI = (IMultiAssignmentUI)this.getUIContext().get("Owner");
                this.uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getProcessUI(), (Map)uiContext, null, this.getOprtState());
                multiApproveUI.billUIChanged((CoreUIObject)this.uiWindow.getUIObject());
                if (isShowReport) {
                    multiApproveUI.setNewWindowShow(false);
                    this.destroyWindow();
                    this.uiWindow.show();
                }
            } else {
                this.destroyWindow();
                this.openProcessUI(uiContext, this.getOprtState());
            }
        }
    }

    protected void initData(Book book, RptOperationSchemaComp schema) throws IOException {
        this.editData.setBook(book);
    }

    private ArrayList getSheetsID(Book book) throws Exception {
        ArrayList<String> res = new ArrayList<String>(book.getSheetCount());
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet table = book.getSheet(i);
            String id = table.getID();
            if (StringUtils.isEmpty((String)id)) continue;
            res.add(id);
        }
        return res;
    }

    private void calculateSumReport(TemplateInfo temp) throws Exception {
        Book book = temp.getBook();
        boolean autoCalculate = book.isAutoCalculate();
        book.setCalculate(false);
        BookProperties pp = BookProperties.loadFromBook(book);
        RptOperationSchemaComp schema = pp.getOperationSchema();
        ArrayList reportIDs = this.getSubReportIds();
        if (reportIDs.size() == 0) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("SubReportNull"));
            SysUtil.abort();
        }
        HashMap<String, SumcalcRange> sheetIDs = new HashMap<String, SumcalcRange>();
        boolean isExistsSumZone = false;
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            if (sheet == null) continue;
            String sheetName = sheet.getSheetName();
            SumcalcRange sumZone = (SumcalcRange)sheet.getUserObjectValue("SUMCALCZONE");
            if (sumZone == null || sumZone.isEmpty()) continue;
            sheetIDs.put(sheetName, sumZone);
            isExistsSumZone = true;
            int colcount = sheet.getMaxColIndex();
            for (int j = 0; j <= colcount; ++j) {
                int rowcount = sheet.getMaxRowIndex();
                for (int k = 0; k <= rowcount; ++k) {
                    CellBlock cb;
                    Cell cell = sheet.getCell(k, j, false);
                    if (cell == null || !sumZone.contains(cb = CellBlock.getNewCellBlock((int)cell.getRow(), (int)cell.getCol())) || cell.getFormula() == null || !cell.getFormula().startsWith("=")) continue;
                    cell.setFormula(null);
                }
            }
        }
        ICslRptCalculator calculator = CslRptCalculatorFactory.getRemoteInstance();
        HashMap cellMap = null;
        cellMap = !isExistsSumZone ? calculator.calculateSumRptBySheets(reportIDs, this.getSheetsID(book)) : calculator.calculateSumRptBySheets(reportIDs, sheetIDs);
        this.loadTables(isExistsSumZone, book, cellMap);
        this.initData(book, schema);
        book.setCalculate(autoCalculate);
    }

    private void loadTables(boolean isExistsSumZone, Book book, HashMap cellMap) {
        if (cellMap == null) {
            return;
        }
        if (cellMap != null && isExistsSumZone) {
            cellMap = (HashMap)cellMap.get("sumBySheet");
        }
        if (cellMap == null) {
            return;
        }
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet table = book.getSheet(i);
            String sheetTag = isExistsSumZone ? table.getSheetName() : table.getID();
            HashMap map = (HashMap)cellMap.get(sheetTag);
            if (map == null) continue;
            for (Point pos : map.keySet()) {
                Cell cell = table.getCell(pos.y, pos.x, true);
                if (cell == null) continue;
                HashMap cellInfo = (HashMap)map.get(pos);
                if (!isExistsSumZone) {
                    cell.setFormula("=" + cellInfo.get("expression"));
                }
                cell.setValue(new Variant(cellInfo.get("value")));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public VirtualSheetParamInfo save() throws Exception {
        try {
            this.isSaving = true;
            this.selfVerifyInput();
        }
        catch (AbortException e) {
            this.getUIWindow().show();
            if (this.getButtonAction() == 1) {
                this.save();
            }
            this.abort();
        }
        if (this.editData.getAuditedStatus() != null && this.editData.getAuditedStatus().getValue() == 2) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("ReportAlreadyAudited"));
            this.editData.setChgStatus(0);
            return this.editData;
        }
        this.checkRptSumIsWorkFlow();
        this.storeFields();
        this.verifyInput(null);
        if (this.isVersion() && this.getOprtState().equals("EDIT")) {
            int isok = MsgBox.showConfirm3((String)RptUtil.getResourceSince51("PerformHistoryVersion"));
            if (isok == 0) {
                ((IReport)this.getBizInterface()).reportVersion(this.editData);
            } else {
                if (isok != 1) {
                    this.editData.setChgStatus(0);
                    return this.editData;
                }
                ((IReport)this.getBizInterface()).submit((CoreBaseInfo)this.editData);
            }
        } else {
            ((IReport)this.getBizInterface()).submit((CoreBaseInfo)this.editData);
        }
        this.setDataObject((IObjectValue)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(this.editData.getId()), this.getSelectors()));
        this.setOprtState("EDIT");
        this.save = true;
        if (this.getUIContext().get("isFromWorkflow") == null || !((Boolean)this.getUIContext().get("isFromWorkflow")).booleanValue()) {
            ((ReportMaintainUI)this.getUIContext().get("Owner")).selfRefresh();
        }
        this.editData.setSubReport(((IReport)this.getBizInterface()).getSubReport(this.editData.getId()));
        return this.editData;
    }

    @Override
    public void actionEditReport_actionPerformed(ActionEvent e) throws Exception {
        String dataCollectNumber = ((DataCollectInfo)this.cbxDataCollect.getSelectedItem()).getNumber();
        if ("ACTUALDATA".equals(dataCollectNumber)) {
            if (!this.hasACPermission) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"No_AMDC_Permission"));
                SysUtil.abort();
            }
        } else if (!this.hasBudgetedPermission) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"No_BGDC_Permission"));
            SysUtil.abort();
        }
        if (this.isAddnew) {
            int templateType = this.btngTemplate.getValue();
            if (templateType == 1 && this.prmtTemplate.getData() == null) {
                MsgBox.showInfo((String)RptUtil.getResourceSince51("NormalTemplateCannotBeNull"));
                SysUtil.abort();
            }
            if (templateType == 2 && this.prmtTemplate.getData() == null) {
                MsgBox.showInfo((String)RptUtil.getResourceSince51("GroupTemplateCannotBeNull"));
                SysUtil.abort();
            }
            if (this.editData.getSourceType() == null) {
                if (templateType == 1 || templateType == 0) {
                    this.editData.setSourceType(RptSrcTypeEnum.NORMAL);
                } else {
                    RptTmpTypeEnum choosedTemplateType = ((TemplateInfo)this.prmtTemplate.getData()).getTemplateType();
                    if (choosedTemplateType == RptTmpTypeEnum.DYNAMICNORMALREPORT || choosedTemplateType == RptTmpTypeEnum.RPTDYNAMICREPORT) {
                        this.editData.setSourceType(RptSrcTypeEnum.DYNAMICNORMALREPORT);
                    } else {
                        this.editData.setSourceType(RptSrcTypeEnum.COMMITREPORT);
                    }
                }
            }
            this.openReport(true, false);
        }
        this.destroyWindow();
    }

    @Override
    public VirtualSheetParamInfo saveAs() throws Exception {
        this.selfVerifyInput();
        this.storeFields();
        this.verifyInput(null);
        String oldId = this.editData.getId().toString();
        this.editData.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        this.editData.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
        this.editData.setAuditor(null);
        this.editData.setAuditTime(null);
        this.editData.setId(null);
        IObjectPK pk = ((IReport)this.getBizInterface()).submit((CoreBaseInfo)this.editData);
        this.releaseObjectLock(oldId);
        this.requestObjectLock(pk.toString());
        this.setDataObject((IObjectValue)this.getBizInterface().getValue(pk, this.getSelectors()));
        this.setOprtState("EDIT");
        this.save = true;
        if (this.getUIContext().get("isFromWorkflow") == null || !((Boolean)this.getUIContext().get("isFromWorkflow")).booleanValue()) {
            ((ReportMaintainUI)this.getUIContext().get("Owner")).selfRefresh();
        }
        this.editData.setSubReport(((IReport)this.getBizInterface()).getSubReport(this.editData.getId()));
        this.txtNumber.setText(this.editData.getNumber());
        return this.editData;
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.selfstoreFields();
        this.editData.setExchangeRate(new BigDecimal("1"));
        this.editData.setSourceType(RptSrcTypeEnum.COMMOMSUM);
        this.editData.setSubReport(this.getSubReport());
        if (this.chkCalculate.getSelected() == 32) {
            this.editData.setIsOpenAutoCalc(true);
        } else {
            this.editData.setIsOpenAutoCalc(false);
        }
        DataCollectInfo dataCollectSelected = (DataCollectInfo)this.cbxDataCollect.getSelectedItem();
        this.editData.setDataCollect(dataCollectSelected);
        this.editData.setDataCollectNumber(dataCollectSelected.getNumber());
    }

    protected void initListener() {
        super.initListener();
        this.cbxDataCollect.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    RptSumEditUI.this.tblSubReport.removeRows();
                }
            }
        });
    }

    @Override
    public void onLoad() throws Exception {
        this.isViewingReportPropertis = false;
        super.onLoad();
        if (this.getUIContext().get("ID") != null) {
            this.editData.setSubReport(((IReport)this.getBizInterface()).getSubReport(BOSUuid.read((String)this.getUIContext().get("ID").toString())));
        }
        this.initSubReport();
        this.tblSubReport.getLayoutManager().setHorizonScrollBar((JScrollBar)new KDScrollBar(0));
        this.tblSubReport.getLayoutManager().setVerticalScrollBar((JScrollBar)new KDScrollBar(1));
        this.btngTemplate.setSelected(this.rbnCommonTemplate.getModel(), true);
        this.templateTypeChange();
        if (!this.getOprtState().equals("ADDNEW")) {
            this.actionbtnAdd.setEnabled(false);
            this.actionbtnDel.setEnabled(false);
        } else {
            this.actionbtnAdd.setEnabled(true);
            this.actionbtnDel.setEnabled(true);
        }
    }

    @Override
    protected void templateTypeChange() {
        super.templateTypeChange();
        this.cbxPeriodType.setEnabled(true);
    }

    @Override
    public RptBaseMenuStrategy getReportMenuStrategy() {
        return new RptSumReportMenuStrategy();
    }

    @Override
    public void unSubmit() {
        try {
            this.actionUnSubmit_actionPerformed(null);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void submitWorkFlow() throws Exception {
        if (this.editData.getAuditedStatus().getValue() == 2) {
            this.btnSubmitUnAudit.doClick();
        } else {
            this.actionSubmit.setEnabled(true);
            this.btnSubmit.doClick();
        }
    }

    public boolean isAddnew() {
        return this.isAddnew;
    }

    public void setAddnew(boolean isAddnew) {
        this.isAddnew = isAddnew;
    }

    @Override
    public IObjectValue createNewData() {
        ReportInfo info = (ReportInfo)super.createNewData();
        info.setSourceType(RptSrcTypeEnum.COMMOMSUM);
        return info;
    }

    @Override
    public void actionTemplateType_actionPerformed(ActionEvent e) throws Exception {
        super.actionTemplateType_actionPerformed(e);
        int templateType = this.btngTemplate.getValue();
        if (templateType == 0 || templateType == 1) {
            this.cbxDataCollect.setSelectedItem(this.dataCollectMap.get("ACTUALDATA"));
            this.cbxDataCollect.setEnabled(false);
        } else if (templateType == 2) {
            this.controlDataCollect();
        }
    }

    protected void controlDataCollect() {
        if (this.hasBudgetedPermission && !this.hasACPermission) {
            this.cbxDataCollect.setSelectedItem(this.dataCollectMap.get("BUDGETDATA"));
            this.cbxDataCollect.setEnabled(false);
            this.rbnNoTemplate.setEnabled(false);
            this.rbnCommonTemplate.setEnabled(false);
            this.rbnGroupTemplate.setSelected(true);
            this.btngTemplate.setValue(2);
            this.templateTypeChange();
        } else if (!this.hasBudgetedPermission && this.hasACPermission) {
            this.cbxDataCollect.setSelectedItem(this.dataCollectMap.get("ACTUALDATA"));
            this.cbxDataCollect.setEnabled(false);
        } else {
            int templateType = this.btngTemplate.getValue();
            if (templateType == 0 || templateType == 1) {
                this.cbxDataCollect.setSelectedItem(this.dataCollectMap.get("ACTUALDATA"));
                this.cbxDataCollect.setEnabled(false);
            } else {
                this.cbxDataCollect.setEnabled(true);
            }
            this.rbnNoTemplate.setEnabled(false);
            this.rbnCommonTemplate.setEnabled(true);
        }
    }
}

