/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.OrgUnitTreePromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptCalculatorFactory;
import com.kingdee.eas.fi.gr.cslrpt.ICslRptCalculator;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptResourceHelper;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.client.AbstractRptSummaryFiltersUI;
import com.kingdee.eas.fi.rpt.client.ISimpleDialog;
import com.kingdee.eas.fi.rpt.client.ISimpleDialogListener;
import com.kingdee.eas.fi.rpt.client.RptHelper;
import com.kingdee.eas.fi.rpt.client.RptSummaryListUI;
import com.kingdee.eas.fi.rpt.client.RptTemplateTreePromptBox;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RptSummaryFiltersUI
extends AbstractRptSummaryFiltersUI
implements ISimpleDialog {
    private ArrayList listeners = new ArrayList(1);

    public static RptSummaryFiltersUI getInstance(CoreUIObject parentUI) throws Exception {
        IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow wnd = fy.create(RptSummaryFiltersUI.class.getName(), (Map)new UIContext((Object)parentUI));
        RptSummaryFiltersUI res = (RptSummaryFiltersUI)wnd.getUIObject();
        res.onShow();
        return res;
    }

    public RptSummaryFiltersUI() throws Exception {
        this.initialize();
    }

    private void initialize() throws Exception {
        this.prmCompany.setSelector((KDPromptSelector)new OrgUnitTreePromptBox((IUIObject)this, new OrgType[]{OrgType.Company}, null, null, true, false, false, true));
        this.prmCompany.setEnabledMultiSelection(true);
        this.prmCompany.setDisplayFormat("$number$--$name$");
        this.prmCompany.setEditFormat("$number$--$name$");
        this.prmCompany.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RptSummaryFiltersUI.this.setDateFilterStatus(RptSummaryFiltersUI.this.getTemplateInfo(), RptSummaryFiltersUI.this.getOrgUnitInfo());
            }
        });
        RptTemplateTreePromptBox box = new RptTemplateTreePromptBox((IUIObject)this);
        ArrayList<RptTmpTypeEnum> tempTypelist = new ArrayList<RptTmpTypeEnum>();
        tempTypelist.add(RptTmpTypeEnum.COMMONREPORT);
        tempTypelist.add(RptTmpTypeEnum.GROUPREPORT);
        tempTypelist.add(RptTmpTypeEnum.RPTDYNAMICREPORT);
        box.setTempTypeList(tempTypelist);
        this.prmTemplet.setSelector((KDPromptSelector)box);
        this.prmTemplet.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RptSummaryFiltersUI.this.setDateFilterStatus(RptSummaryFiltersUI.this.getTemplateInfo(), RptSummaryFiltersUI.this.getOrgUnitInfo());
            }
        });
        Timestamp d = new Timestamp(System.currentTimeMillis());
        Integer year = new Integer(DateTimeUtils.getYear((Date)d));
        Integer month = new Integer(DateTimeUtils.getMonth((Date)d));
        this.spnSYear.setValue((Object)year);
        this.spnTYear.setValue((Object)year);
        this.spnSMonth.setValue((Object)month);
        this.spnTMonth.setValue((Object)month);
        ((SpinnerNumberModel)this.spnSYear.getModel()).setMinimum(new Integer(0));
        ((SpinnerNumberModel)this.spnTYear.getModel()).setMinimum(new Integer(0));
        this.cbxSDate.getDatePickerDownList().setNullValueEnabled(true);
        this.cbxTDate.getDatePickerDownList().setNullValueEnabled(true);
        this.setDateFilterStatus(null, null);
        CompanyOrgUnitInfo cc = RptUtilForClient.getCurrentCompany();
        if (cc != null) {
            this.prmRptCompany.setSelector((KDPromptSelector)new OrgUnitTreePromptBox((IUIObject)this, new OrgType[]{OrgType.Company}, true));
            this.prmRptCompany.setEnabledMultiSelection(true);
            this.prmRptCompany.setDisplayFormat("$name$");
            this.prmRptCompany.setEditFormat("$name$");
            this.prmRptCompany.setData((Object)cc);
            this.prmCompany.setData((Object)new Object[]{cc});
        }
    }

    private void setDateFilterStatus(TemplateInfo tinfo, Object[] oinfo) {
        RptPeriodTypeEnum type;
        boolean enableYear = false;
        boolean enablePeriod = false;
        boolean enableDate = false;
        int minMonth = -1;
        int maxMonth = -1;
        if (tinfo != null && (type = tinfo.getPeriodType()) != null) {
            switch (type.getValue()) {
                case 1: {
                    enableDate = true;
                    break;
                }
                case 3: {
                    enableYear = true;
                    enablePeriod = true;
                    break;
                }
                case 6: {
                    enableYear = true;
                    break;
                }
                case 2: {
                    maxMonth = 52;
                    minMonth = 1;
                    enableYear = true;
                    enablePeriod = true;
                    break;
                }
                case 5: {
                    maxMonth = 2;
                    minMonth = 1;
                    enableYear = true;
                    enablePeriod = true;
                    break;
                }
                case 4: {
                    maxMonth = 4;
                    minMonth = 1;
                    enableYear = true;
                    enablePeriod = true;
                }
            }
        }
        Integer min = new Integer(minMonth > 0 ? minMonth : 1);
        Integer max = new Integer(maxMonth > 0 ? maxMonth : 12);
        this.setDatePickEnabled(enableDate);
        this.setYearPickEnabled(enableYear);
        this.setPeriodPickEnabled(enablePeriod, min, max);
        this.setEndTimePickEnabled(oinfo == null || oinfo.length < 2);
    }

    public boolean isDatesInOrder() {
        int sy = this.getYear(true);
        int ty = this.getYear(false);
        int sm = this.getMonth(true);
        int tm = this.getMonth(false);
        return sy < ty || sy == ty && sm <= tm;
    }

    private void setEndTimePickEnabled(boolean isEnableEnd) {
        boolean newStatus = isEnableEnd;
        boolean oldStatus = false;
        oldStatus = this.spnTYear.isEnabled();
        this.spnTYear.setEnabled(newStatus && oldStatus);
        oldStatus = this.spnTMonth.isEnabled();
        this.spnTMonth.setEnabled(newStatus && oldStatus);
        oldStatus = this.cbxTDate.isEnabled();
        this.cbxTDate.setEnabled(newStatus && oldStatus);
    }

    private void setDatePickEnabled(boolean isEnable) {
        this.cbxSDate.setEnabled(isEnable);
        this.cbxTDate.setEnabled(isEnable);
    }

    private void setYearPickEnabled(boolean isEnable) {
        this.spnSYear.setEnabled(isEnable);
        this.spnTYear.setEnabled(isEnable);
    }

    private void setPeriodPickEnabled(boolean isEnable, Integer min, Integer max) {
        if (isEnable && min != null && max != null) {
            ((SpinnerNumberModel)this.spnSMonth.getModel()).setMinimum(min);
            ((SpinnerNumberModel)this.spnSMonth.getModel()).setMaximum(max);
            ((SpinnerNumberModel)this.spnTMonth.getModel()).setMinimum(min);
            ((SpinnerNumberModel)this.spnTMonth.getModel()).setMaximum(max);
            Object sv = this.spnSMonth.getValue();
            if (sv == null) {
                sv = min;
            } else if (max.compareTo((Integer)sv) < 0) {
                sv = max;
            } else if (min.compareTo((Integer)sv) > 0) {
                sv = min;
            }
            this.spnSMonth.setValue(sv);
            Object tv = this.spnTMonth.getValue();
            if (tv == null) {
                tv = min;
            } else if (max.compareTo((Integer)tv) < 0) {
                tv = max;
            } else if (min.compareTo((Integer)tv) > 0) {
                tv = min;
            }
            this.spnTMonth.setValue(tv);
        }
        this.spnSMonth.setEnabled(isEnable);
        this.spnTMonth.setEnabled(isEnable);
    }

    private boolean isDatePickEnabled() {
        return this.cbxSDate.isEnabled() && this.cbxTDate.isEnabled();
    }

    private boolean isYearPickEnabled() {
        return this.spnSYear.isEnabled() && this.spnTYear.isEnabled();
    }

    private boolean isPeriodPickEnabled() {
        return this.spnSMonth.isEnabled() && this.spnTMonth.isEnabled();
    }

    @Override
    public void actionBtnOk_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnOk_actionPerformed(e);
        if (this.checkFilter()) {
            this.callListUI((CoreUIObject)this.getUIContext().get("Owner"));
        }
    }

    private boolean checkFilter() {
        String strTmp;
        StringBuffer missed = new StringBuffer();
        Object objTmp = this.prmRptCompany.getData();
        if (objTmp == null) {
            missed.append(RptResourceHelper.getString("rptsummaryfiltersui-rptcompany"));
            missed.append(',');
        }
        if (StringUtils.isEmpty((String)(strTmp = this.txtRptCode.getText()))) {
            missed.append(RptResourceHelper.getString("rptsummaryfiltersui-code"));
            missed.append(',');
        }
        if (StringUtils.isEmpty((String)(strTmp = this.txtRptName.getText()))) {
            missed.append(RptResourceHelper.getString("rptsummaryfiltersui-name"));
            missed.append(',');
        }
        if (!((objTmp = this.prmTemplet.getData()) instanceof TemplateInfo)) {
            missed.append(RptResourceHelper.getString("rptsummaryfiltersui-template"));
            missed.append(',');
        }
        if ((objTmp = this.prmCompany.getData()) == null || ((Object[])objTmp).length < 1 || ((Object[])objTmp)[0] == null) {
            missed.append(RptResourceHelper.getString("rptsummaryfiltersui-organise"));
            missed.append(',');
        }
        if (!((objTmp = this.prmAbbr.getData()) instanceof CurrencyInfo)) {
            missed.append(RptResourceHelper.getString("rptsummaryfiltersui-currency"));
            missed.append(',');
        }
        if (missed.length() > 0) {
            String tip = RptResourceHelper.getString("rptsummaryfiltersui-missedhead") + missed.toString() + RptResourceHelper.getString("rptsummaryfiltersui-missedtail");
            MsgBox.showInfo((String)tip);
            return false;
        }
        return true;
    }

    @Override
    public void actionBtnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnCancel_actionPerformed(e);
        this.endWizard(false);
    }

    @Override
    public void open(Object cookie, String title) {
        this.fireListenersSetout();
        IUIWindow w = this.getUIWindow();
        if (w instanceof KDDialog) {
            KDDialog d = (KDDialog)w;
            if (title != null) {
                d.setTitle(title);
            }
            d.addWindowListener((WindowListener)new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    RptSummaryFiltersUI.this.endWizard(false);
                }
            });
        }
        w.show();
    }

    private void endWizard(boolean isOk) {
        this.endWizard(null, isOk);
    }

    private void endWizard(Collection summaryInfo, boolean isOk) {
        HashMap result = null;
        if (isOk) {
            result = this.summaryReport(summaryInfo);
        }
        this.disposeUIWindow();
        this.fireListenersReturnee(result, isOk);
    }

    private HashMap summaryReport(Collection summaryInfo) {
        try {
            TemplateInfo ti = this.getTemplateInfo();
            if (ti == null) {
                return null;
            }
            KDF kdf = ti.getKDF();
            Collection tables = kdf == null ? null : kdf.getAllTable();
            HashMap cellMap = this.triggerRptSummary(summaryInfo, this.getSheetsID(tables));
            if (cellMap == null) {
                return null;
            }
            if (!this.loadTables(tables, cellMap)) {
                return null;
            }
            HashMap<String, Collection> res = new HashMap<String, Collection>();
            this.initSumReportInfo(res, ti, tables);
            res.put("subReports", summaryInfo);
            return res;
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    private boolean loadTables(Collection tables, HashMap cellMap) {
        if (tables == null || cellMap == null) {
            return false;
        }
        for (KDTable table : tables) {
            table.getScriptManager().setAutoRun(false);
            table.setRefresh(false);
            String id = table.getID();
            HashMap map = (HashMap)cellMap.get(id);
            if (map == null) continue;
            for (Point pos : map.keySet()) {
                ICell c;
                IRow r = table.getRow(pos.y);
                if (r == null || (c = r.getCell(pos.x)) == null) continue;
                c.setExpressions(null);
                c.setValue(map.get(pos));
            }
            table.setRefresh(true);
        }
        return true;
    }

    private void initSumReportInfo(HashMap ri, TemplateInfo ti, Collection tables) {
        Object rc;
        Object[] org;
        Timestamp et;
        Timestamp st;
        int em;
        int sm;
        int ey;
        boolean ido;
        int sy;
        if (ri == null || ti == null || tables == null) {
            return;
        }
        ri.put("tables", tables);
        ri.put("template", ti);
        CurrencyInfo ci = this.getCurrencyInfo();
        if (ci != null) {
            ri.put("currency", ci);
        }
        if ((sy = this.getYear(ido = this.isDatesInOrder())) > 0) {
            ri.put("year.start", new Integer(sy));
        }
        if ((ey = this.getYear(!ido)) > 0) {
            ri.put("year.end", new Integer(ey));
        }
        if ((sm = this.getMonth(ido)) > 0) {
            ri.put("period.start", new Integer(sm));
        }
        if ((em = this.getMonth(!ido)) > 0) {
            ri.put("period.end", new Integer(em));
        }
        if ((st = this.getDate(true)) != null) {
            ri.put("date.start", st);
        }
        if ((et = this.getDate(false)) != null) {
            ri.put("date.end", et);
        }
        if ((org = this.getOrgUnitInfo()) != null) {
            ri.put("organise", org);
        }
        if ((rc = this.prmRptCompany.getData()) != null) {
            ri.put("rptCompany", rc);
        }
        ri.put("rptCode", this.txtRptCode.getText());
        ri.put("rptName", this.txtRptName.getText());
    }

    private HashMap triggerRptSummary(Collection summaryInfo, ArrayList sheetIds) throws BOSException, EASBizException {
        if (summaryInfo == null || summaryInfo.size() < 1) {
            return null;
        }
        if (sheetIds == null || sheetIds.size() < 1) {
            return null;
        }
        ICslRptCalculator calculator = CslRptCalculatorFactory.getRemoteInstance();
        return calculator.calculateSumRptBySheets(new ArrayList(summaryInfo), sheetIds);
    }

    private ArrayList getSheetsID(Collection tables) throws Exception {
        if (tables == null) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>(tables.size());
        for (KDTable table : tables) {
            String id;
            if (table == null || StringUtils.isEmpty((String)(id = table.getID()))) continue;
            res.add(id);
        }
        return res;
    }

    @Override
    public synchronized void addSimpleDialogListener(ISimpleDialogListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    private void fireListenersSetout() {
        for (ISimpleDialogListener l : this.listeners) {
            if (l == null) continue;
            l.pilotSetout(this);
        }
    }

    private void fireListenersReturnee(Object result, boolean isOk) {
        for (ISimpleDialogListener l : this.listeners) {
            if (l == null) continue;
            l.pilotReturnee(this, result, isOk);
        }
    }

    private void callListUI(CoreUIObject parentUI) throws Exception {
        RptSummaryListUI list = RptSummaryListUI.getInstance(parentUI);
        list.addSimpleDialogListener(new RptSummaryListListener());
        list.open(this, null);
    }

    public TemplateInfo getTemplateInfo() {
        return (TemplateInfo)this.prmTemplet.getData();
    }

    public Object[] getOrgUnitInfo() {
        return (Object[])this.prmCompany.getData();
    }

    public CurrencyInfo getCurrencyInfo() {
        return (CurrencyInfo)this.prmAbbr.getData();
    }

    public int getYear(boolean isStartYear) {
        if (!this.isYearPickEnabled()) {
            return -1;
        }
        KDSpinner sp = isStartYear ? this.spnSYear : this.spnTYear;
        Object o = sp.getValue();
        return o == null ? -1 : Integer.parseInt(o.toString());
    }

    public int getMonth(boolean isStartMonth) {
        if (!this.isPeriodPickEnabled()) {
            return -1;
        }
        KDSpinner sp = isStartMonth ? this.spnSMonth : this.spnTMonth;
        Object o = sp.getValue();
        return o == null ? -1 : Integer.parseInt(o.toString());
    }

    public Timestamp getDate(boolean isStartDate) {
        if (!this.isDatePickEnabled()) {
            return null;
        }
        KDDatePicker dp = isStartDate ? this.cbxSDate : this.cbxTDate;
        return dp.getTimestamp();
    }

    public void onShow() throws Exception {
        super.onShow();
        RptHelper.setDefaultButton(this, (JButton)this.btnOk);
        RptHelper.setEscAction(this, (Action)((Object)this.actionBtnCancel));
    }

    private class RptSummaryListListener
    implements ISimpleDialogListener {
        private RptSummaryListListener() {
        }

        @Override
        public void pilotSetout(ISimpleDialog source) {
        }

        @Override
        public void pilotReturnee(ISimpleDialog source, Object result, boolean isOk) {
            Collection info;
            Collection collection = info = result instanceof Collection ? (Collection)result : null;
            if (isOk) {
                RptSummaryFiltersUI.this.endWizard(info, isOk);
            }
        }
    }
}

