/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.expr.TableRelations;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.ExtendButtonAction;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootSetupPane;
import com.kingdee.bos.ctrl.kdf.printprovider.IExSetup;
import com.kingdee.bos.ctrl.kdf.printprovider.dialogs.IExSetupConfigurator;
import com.kingdee.bos.ctrl.kdf.printprovider.headerfooter.ExtVarProvider;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.ITableAliasParser;
import com.kingdee.bos.ctrl.kdf.table.KDTDataRequestManager;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTPrintManager;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTScriptManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.style.Pattern;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.swing.KDFontChooser;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.runtime.Pair;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.rpt.BalanceHint;
import com.kingdee.eas.fi.rpt.CSLCommentsCollection;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.PostilCollection;
import com.kingdee.eas.fi.rpt.PostilInfo;
import com.kingdee.eas.fi.rpt.Rect;
import com.kingdee.eas.fi.rpt.ReportCaclProxy;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.fi.rpt.RptComment;
import com.kingdee.eas.fi.rpt.RptCommentTank;
import com.kingdee.eas.fi.rpt.RptResourceHelper;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.TablePorperts;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.client.HeaderFooterSetupUI;
import com.kingdee.eas.fi.rpt.client.ICellChangeListener;
import com.kingdee.eas.fi.rpt.client.IControlledDialogListener;
import com.kingdee.eas.fi.rpt.client.IModifyingManager;
import com.kingdee.eas.fi.rpt.client.ISheetCopyProcesser;
import com.kingdee.eas.fi.rpt.client.ISimpleDialog;
import com.kingdee.eas.fi.rpt.client.KDTActionAgent;
import com.kingdee.eas.fi.rpt.client.ProgressManager;
import com.kingdee.eas.fi.rpt.client.ReportProcessUI;
import com.kingdee.eas.fi.rpt.client.RptCellCmtEditUI;
import com.kingdee.eas.fi.rpt.client.RptFormula;
import com.kingdee.eas.fi.rpt.client.RptFormulaBar;
import com.kingdee.eas.fi.rpt.client.RptFormulaComp;
import com.kingdee.eas.fi.rpt.client.RptFormulaParameter;
import com.kingdee.eas.fi.rpt.client.RptSheet;
import com.kingdee.eas.fi.rpt.client.RptTableHelper;
import com.kingdee.eas.fi.rpt.util.FormulaConvertUtil;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class RptTablePane
extends KDTabbedPane {
    public static final int INIT_ROW_COUNT = 64;
    public static final int INIT_COL_COUNT = 40;
    public static final int INIT_COL_COUNT_MAX = 400;
    HashMap tabNames;
    private ArrayList tabs;
    boolean isEditingByFmbar;
    private KDTable tblTmp;
    private IObjectValue editData;
    private ResourceBundleHelper resHelper;
    RptFormulaBar fmBar;
    KDPopupMenu tabContextMenu;
    KDPopupMenu cellContextMenu;
    KDPopupMenu rangeContextMenu;
    private TableRelations tableRelations;
    RptCommentTank comment;
    private int foreland;
    private String namePrefix;
    private int editMode;
    private int formulaMode = 1;
    private List cellChangeListeners;
    private ActionListener sheetInsertListener;
    private ISheetCopyProcesser copyProcesser = null;
    private ProgressManager procManager = null;
    protected IModifyingManager imm = null;
    private TableActionListener al = new TableActionListener();
    private TableAliasParser pl = new TableAliasParser();
    private TableInputListener tl = new TableInputListener();
    KeyListener kl = new KeyListener(){

        @Override
        public void keyPressed(KeyEvent arg0) {
        }

        @Override
        public void keyReleased(KeyEvent arg0) {
        }

        @Override
        public void keyTyped(KeyEvent arg0) {
            if (RptTablePane.this.imm != null) {
                RptTablePane.this.imm.incModifiedCount();
            }
        }
    };
    boolean isUpdatingFont = false;
    public static final int AL_NULL = 0;
    public static final int AL_MASK = 65535;
    public static final int AL_CELL = 4096;
    public static final int AL_BLOCK = 8192;
    public static final int AL_TABLE = 8192;
    public static final int AC_NULL = 0;
    public static final int AC_MASK = -65536;
    public static final int AC_MERGE = 0x10000000;
    public static final int AC_SPLIT = 0x20000000;
    public static final int AC_LOCK = 0x30000000;
    public static final int AC_ULOCK = 0x40000000;
    public static final int AC_STVAL = 0x50000000;
    public static final int AC_STFUN = 0x60000000;
    public static final int AC_CLFUN = 0x70000000;
    public static final int AC_CLVAL = Integer.MIN_VALUE;
    public static final int AC_DELCL = -1879048192;
    public static final int AC_TBLOK = 0x10000000;
    public static final int AC_TBULK = 0x11000000;
    public static final int AC_ATEST = 0x12000000;
    public static final Color LOCKCOLOR = new Color(228, 228, 228);
    private EditorListener edListener = null;
    private KDFontChooser fontChooser = null;

    public void setEditData(IObjectValue data) {
        this.editData = data;
    }

    public int getEditMode() {
        return this.editMode;
    }

    public ProgressManager getProgressBar() {
        return this.procManager;
    }

    public void setProgressBar(ProgressManager manager) {
        this.procManager = manager;
    }

    public void setModifyingManager(IModifyingManager amm) {
        this.imm = amm;
    }

    public void setEditMode(int mode) {
        this.setEditModeInternal(mode);
        this.resetSheetsEditMode();
        this.resetFormulaBarContent();
    }

    private void setEditModeInternal(int mode) {
        this.editMode = mode;
    }

    private void resetSheetsEditMode() {
        for (int i = 0; i < this.getSheetCount(); ++i) {
            KDTable tbl = this.getPageAt(i);
            if (tbl == null) continue;
            tbl.setCellDisplayMode(this.getEditMode());
        }
    }

    public void resetFormulaBarContent() {
        if (this.fmBar != null) {
            this.fmBar.beginEdit();
            this.endEditInternal();
            this.setHotCellValue();
            this.fmBar.endEdit();
        }
    }

    public ArrayList getSheets() {
        ArrayList chain = this.getAllTabs();
        int size = chain.size();
        ArrayList<RptSheet> res = new ArrayList<RptSheet>(size);
        for (int i = 0; i < size; ++i) {
            Pair p = (Pair)chain.get(i);
            RptSheet s = RptSheet.getRptSheet((KDTable)p.first);
            s.setExtendProperty("visiablilty", p.second);
            res.add(s);
        }
        return res;
    }

    public int getSheetCount() {
        return this.getAllTabs().size();
    }

    public RptSheet getSheet(int i) {
        return RptSheet.getRptSheet(this.getPageAt(i));
    }

    public RptSheet getSheet(String name) {
        return RptSheet.getRptSheet(this.getPage(name));
    }

    public void setSheets(ArrayList sheets) {
        if (sheets == null) {
            return;
        }
        int newSize = sheets.size();
        for (int i = 0; i < newSize; ++i) {
            RptSheet s = (RptSheet)sheets.get(i);
            KDTable t = s.getTable();
            ReportCaclProxy bug = null;
            boolean isNewly = false;
            boolean chg = true;
            if (t == null) {
                t = this.createNewTable();
                bug = this.initPage(t, "_");
                s.setTable(t);
                isNewly = true;
            } else {
                int op = this.indexOfPage((Component)t);
                if (op == i) {
                    String title = this.getSheetTitleAt(op);
                    if (!title.equals(s.getName())) {
                        this.tabNames.remove(title.toLowerCase());
                        s.setName(this.getSuitableName(s.getName()));
                        this.tabNames.put(s.getName().toLowerCase(), t);
                    }
                    bug = s.getReportCaclProxy();
                    chg = false;
                } else if (op != -1) {
                    this.tabNames.remove(this.getSheetTitleAt(op).toLowerCase());
                    this.removePageAt(op, false);
                }
            }
            if (chg) {
                String name = this.getSuitableName(s.getName());
                s.setName(name);
                if (RptUtil.isTrue(s.getExtendProperty("visiablilty"), true)) {
                    this.insertPage(name, null, (Component)t, null, i);
                } else {
                    this.inChain(i, (Component)t, Boolean.FALSE);
                }
                this.tabNames.put(name.toLowerCase(), t);
            }
            if (bug == null) {
                bug = (ReportCaclProxy)s.getContext().getData();
            }
            s.update();
            if (isNewly || s.getTable().getStyleAttributes().isLocked() != s.isLock()) {
                this.setLock2(s.getTable(), s.isLock());
            }
            s.refreshContext(bug);
            t.setName(s.getName());
            t.setID(s.getId());
            this.setSheetTitleAt(i, s.getName());
        }
        int oldSize = this.getSheetCount();
        while (oldSize > newSize) {
            this.removePageAt(--oldSize);
        }
        this.setHotCellValue();
    }

    public int indexOfPage(Component page) {
        ArrayList chain = this.getAllTabs();
        for (int i = chain.size() - 1; i >= 0; --i) {
            Pair p = (Pair)chain.get(i);
            if (p.first != page) continue;
            return i;
        }
        return -1;
    }

    public void setFunctionProvider(ReportCaclProxy provider) {
        int num = this.getSheetCount();
        for (int i = 0; i < num; ++i) {
            KDTable t = this.getPageAt(i);
            try {
                t.getScriptManager().addFunctionProvider((Object)new ReportCaclProxy(t, this.editData));
            }
            catch (Exception exc) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)exc);
            }
            t.getScriptManager().setAutoRun(false);
        }
    }

    public RptTablePane() {
        super(3, 1);
        this.initialize();
        this.getActionMap().remove("Alt_T");
    }

    void initialize() {
        this.foreland = 0;
        this.isEditingByFmbar = false;
        this.editMode = 0;
        this.comment = null;
        this.tabNames = new HashMap(3, 0.75f);
        this.resHelper = new ResourceBundleHelper(RptTablePane.class.getName());
        this.namePrefix = this.resHelper.getString("sheet.Name");
        this.tableRelations = new TableRelations();
        this.addMouseListener(new TabMouseListener());
        this.addChangeListener(new TabMouseListener());
        this.addHeadMouseListener(new TabMouseListener());
    }

    public TableRelations getTableRelations() {
        return this.tableRelations;
    }

    private String getSuitableName(String name) {
        if (name == null) {
            name = this.getNextName();
        } else {
            name = name.trim();
            if (this.tabNames.keySet().contains(name.toLowerCase())) {
                MsgBox.showInfo((Component)((Object)this), (String)this.resHelper.getString("sheet.overlapName"));
                name = this.getNextName();
            }
        }
        return name;
    }

    private String getNextName() {
        String res = null;
        do {
            res = this.namePrefix + ++this.foreland;
        } while (this.tabNames.keySet().contains(res.toLowerCase()) && this.foreland < 1000);
        return res;
    }

    public RptSheet addPage(String name) {
        return this.addPage(-1, name);
    }

    public RptSheet addPage(int index, String name) {
        KDTable at = this.createNewTable();
        return this.addPage(at, index, name);
    }

    public RptSheet addPage(KDTable table, String name) {
        return this.addPage(table, this.getSheetCount() - 1, name);
    }

    public RptSheet addPage(KDTable table, int index, String name) {
        if (table == null) {
            return null;
        }
        table.addKDTEditListener(new KDTEditListener(){

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editValueChanged(KDTEditEvent e) {
                if (RptTablePane.this.imm != null) {
                    RptTablePane.this.imm.incModifiedCount();
                }
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
        if (index < 0) {
            index = this.getSheetCount();
        }
        if (name == null) {
            name = table.getName();
        }
        name = this.getSuitableName(name);
        ReportCaclProxy bug = this.initPage(table, name);
        boolean isVisiable = true;
        RptSheet bigBug = RptSheet.getRptSheet(table);
        if (bigBug != null) {
            bigBug.refreshContext(bug);
            Object v = bigBug.getExtendProperty("visiablilty");
            isVisiable = RptUtil.isTrue(v, true);
        }
        if (isVisiable) {
            this.insertPage(name, null, (Component)table, null, index);
        } else {
            this.inChain(index, (Component)table, Boolean.FALSE);
        }
        this.tabNames.put(name.toLowerCase(), table);
        return bigBug;
    }

    protected ReportCaclProxy initPage(KDTable table, String name) {
        ReportCaclProxy bug = null;
        table.setRefresh(false);
        table.setName(name);
        table.setHeadDisplayMode(1);
        table.getIOManager().setExpandedOnly(true);
        table.getPrintManager().setExpandedOnly(true);
        table.getPrintManager().setDataMode(0);
        table.setFormulaMode(this.formulaMode);
        table.getSelectManager().setSelectPaintMode(1);
        table.putDefaultRenderers(Boolean.class, table.getDefaultRenderer(Object.class));
        table.putDefaultRenderers(Date.class, table.getDefaultRenderer(Object.class));
        table.putDefaultEditor(Boolean.class, table.getDefaultEditor(Object.class));
        table.putDefaultEditor(Date.class, table.getDefaultEditor(Object.class));
        table.getMergeManager().setDataMode(1);
        table.getActionMap().remove("F7Edit");
        table.getDataRequestManager().setPageRowCount(64);
        int count = table.getColumnCount();
        int delta = 40 - count;
        if (delta > 0) {
            boolean isAutoRun = table.getScriptManager().isAutoRun();
            boolean isAdjustFormula = table.getScriptManager().isAutoAdjustFormula();
            table.getScriptManager().setAutoRun(false);
            table.getScriptManager().setAutoAdjustFormula(false);
            for (int i = 0; i < delta; ++i) {
                table.addColumn(i + count);
            }
            table.getScriptManager().setAutoRun(isAutoRun);
            table.getScriptManager().setAutoAdjustFormula(isAdjustFormula);
        }
        if (table.getHeadRowCount() < 1) {
            table.addHeadRow();
        }
        KDTDataRequestManager dm = table.getDataRequestManager();
        dm.setDataRequestMode(1);
        dm.addDataRequestListener((KDTDataRequestListener)this.al);
        KDTScriptManager sm = table.getScriptManager();
        sm.setRelationsObject(this.tableRelations);
        sm.setAliasParser((ITableAliasParser)this.pl);
        table.addKDTEditListener((KDTEditListener)this.al);
        table.addKDTActiveCellListener((KDTActiveCellListener)this.al);
        table.addKDTSelectListener((KDTSelectListener)this.al);
        table.setCellDisplayMode(this.editMode);
        this.initTableKeyboardListener(table);
        table.addKDTMouseListener((KDTMouseListener)this.tl);
        if (this.sheetInsertListener != null) {
            this.sheetInsertListener.actionPerformed(new ActionEvent(RptSheet.getRptSheet(table), 0, name));
        }
        try {
            if (!(this.editData instanceof TemplateInfo)) {
                bug = new ReportCaclProxy(table, this.editData);
                table.getScriptManager().addFunctionProvider((Object)bug);
            }
        }
        catch (BOSException exc) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)exc);
        }
        table.getPrintManager().addHeaderFooterVarProvider((ExtVarProvider)new XExtVarProvider(table));
        table.setRefresh(true);
        return bug;
    }

    void appendCells(KDTable table, Rectangle range) {
        table.getScriptManager().setAutoAdjustFormula(false);
        boolean refresh = table.isRefresh();
        boolean autorun = table.getScriptManager().isAutoRun();
        table.setRefresh(false);
        table.getScriptManager().setAutoRun(false);
        while (range.height-- > 0) {
            table.addRow();
        }
        table.setRefresh(refresh);
        table.getScriptManager().setAutoRun(autorun);
        table.getScriptManager().setAutoAdjustFormula(true);
    }

    public String renamePage(int index, String newName) {
        return this.renamePage(index, newName, null);
    }

    public void renamePage(Component table, String newName, Object owner) {
        this.renamePage(this.indexOfPage(table), newName, owner);
    }

    public String renamePage(int index, String newName, Object owner) {
        if (newName == null) {
            Pair res = RptUtilForClient.inquireInfo(this.resHelper.getString("sheet.promptName"), this.getSheetTitleAt(index), owner, true);
            if (res == null || !RptUtil.isTrue(res.first)) {
                return null;
            }
            newName = (String)res.second;
        }
        if (index < 0 || index >= this.getSheetCount()) {
            return null;
        }
        if ((newName = newName.trim()).equalsIgnoreCase(this.getSheetTitleAt(index))) {
            return null;
        }
        if (newName.length() == 0 || this.tabNames.keySet().contains(newName.toLowerCase())) {
            MsgBox.showInfo((Component)((Object)this), (String)this.resHelper.getString("sheet.overlapName"));
            return null;
        }
        KDTable tbl = this.getPageAt(index);
        this.tabNames.remove(this.getSheetTitleAt(index).toLowerCase());
        this.tabNames.put(newName.toLowerCase(), tbl);
        tbl.setName(newName);
        this.setSheetTitleAt(index, newName);
        return newName;
    }

    public void removePage(Component table) {
        this.removePageAt(this.indexOfPage(table), true);
    }

    public void removePage(Component table, boolean isLimited) {
        this.removePageAt(this.indexOfPage(table), isLimited);
    }

    private boolean tryRemove() {
        if (this.getSheetCount() == 1) {
            MsgBox.showInfo((Component)((Object)this), (String)this.resHelper.getString("sheet.onlyOne"));
            return false;
        }
        return true;
    }

    public void unLoadPages() {
        while (this.getTabCount() > 0) {
            this.removeTabAt(0);
        }
        this.getAllTabs().clear();
        this.tabNames.clear();
        this.foreland = 0;
        this.tableRelations = new TableRelations();
    }

    public void setCellContextMenu(KDPopupMenu menu) {
        this.cellContextMenu = menu;
        if (this.rangeContextMenu == null) {
            this.rangeContextMenu = this.cellContextMenu;
        }
    }

    public void setRangeContextMenu(KDPopupMenu menu) {
        this.rangeContextMenu = menu;
        if (this.cellContextMenu == null) {
            this.cellContextMenu = this.rangeContextMenu;
        }
    }

    public void setTabContextMenu(KDPopupMenu menu) {
        this.tabContextMenu = menu;
    }

    public KDTable getCurrentPage() {
        return (KDTable)this.getSelectedComponent();
    }

    public KDTable getPage(String name) {
        return name == null ? null : (KDTable)this.tabNames.get(name.toLowerCase());
    }

    public String getSheetTitleAt(int i) {
        KDTable tbl = this.getPageAt(i);
        return tbl != null ? tbl.getName() : null;
    }

    public String setSheetTitleAt(int i, String name) {
        int index;
        KDTable tbl = this.getPageAt(i);
        if (tbl != null) {
            tbl.setName(name);
        }
        if ((index = this.getVisiableIndex(i)) != -1) {
            this.setTitleAt(index, name);
        }
        return name;
    }

    public int getSelectedIndex() {
        return super.getSelectedIndex();
    }

    public KDTable getPageAt(int i) {
        if (i < 0 || i >= this.getSheetCount()) {
            return null;
        }
        return (KDTable)((Pair)this.getAllTabs().get((int)i)).first;
    }

    private void initTableKeyboardListener(KDTable table) {
        if (table == null) {
            return;
        }
        ActionMap am = table.getActionMap();
        am.put("Paste", (Action)((Object)new KDTActionAgent(table, 1, this)));
        am.put("Cut", (Action)((Object)new KDTActionAgent(table, 3, this)));
        am.put("Delete", (Action)((Object)new KDTActionAgent(table, 2, this)));
        am.put("CancelEdit", (Action)((Object)new KDTActionAgent(table, 4, this)));
    }

    void setHotCellValue() {
        this.setHotCellValue(this.getFoucusCell());
    }

    void setHotCellValue(KDTable table, int rowIndex, int colIndex) {
        if (table == null) {
            return;
        }
        IRow r = table.getRow(rowIndex);
        if (r == null) {
            return;
        }
        this.setHotCellValue(r.getCell(colIndex));
    }

    private void setHotCellValue(ICell cell) {
        if (!this.isEditingByFmbar) {
            if (cell != null && this.fmBar != null) {
                Object value = null;
                if (this.getEditMode() == 0) {
                    value = cell.getValue();
                } else {
                    value = cell.getExpressions();
                    if (value == null) {
                        value = cell.getValue();
                    }
                }
                this.fmBar.setFormulaLine(value == null ? null : value.toString());
                RptCell rc = RptCell.getRptCell(cell.getUserObject());
                String line = rc != null ? rc.getItemFormulaLine() : null;
                this.fmBar.setItemLine(line);
                this.fmBar.setLocked(cell.getStyleAttributes().isLocked());
            } else {
                this.fmBar.setFormulaLine((String)null);
                this.fmBar.setItemLine(null);
                this.fmBar.setLocked(false);
            }
        }
    }

    public void setSelectRange(String range) {
        KDTable tbl = this.getCurrentPage();
        if (tbl == null) {
            return;
        }
        KDTSelectBlock sb = TableToolkit.rangeToBlock(range);
        if (sb != null) {
            tbl.getSelectManager().select(sb);
        } else {
            tbl.getSelectManager().removeAll();
        }
    }

    public void setFmBar(RptFormulaBar bar) {
        this.fmBar = bar;
        this.tblTmp = this.getCurrentPage();
    }

    public void beginEdit() {
        this.isEditingByFmbar = true;
    }

    public boolean setFormulaLine(String line) {
        this.isEditingByFmbar = true;
        ICell cell = this.getFormulaCell();
        if (cell != null) {
            if (line != null) {
                if (line.length() > 0 && line.charAt(0) == '=') {
                    cell.setExpressions(line);
                } else {
                    cell.setValue((Object)line);
                }
            } else {
                cell.setValue((Object)line);
            }
            cell.setChange(true);
        }
        return true;
    }

    public void setItemLine(String line) {
        RptCell cell = this.getCurrentCell();
        if (cell != null) {
            cell.setItemFormula(line);
            this.imm.incModifiedCount();
            this.getCurrentPage().repaint();
        }
    }

    public ICell getFormulaCell() {
        IRow row;
        KDTable tbl = this.getCurrentPage();
        if (tbl != null) {
            this.tblTmp = tbl;
        }
        if (this.tblTmp == null) {
            return null;
        }
        ArrayList bks = this.tblTmp.getSelectManager().getBlocks();
        if (bks == null || bks.size() < 1) {
            return null;
        }
        KDTSelectBlock bk = (KDTSelectBlock)bks.get(0);
        if (bk == null) {
            return null;
        }
        KDTSelectManager sm = this.tblTmp.getSelectManager();
        int r = sm.getActiveRowIndex();
        int c = sm.getActiveColumnIndex();
        switch (bk.getMode()) {
            case 1: {
                r = bk.getBeginRow();
                c = bk.getBeginCol();
                break;
            }
            case 4: {
                c = bk.getBeginCol();
                break;
            }
            case 2: {
                r = bk.getBeginRow();
            }
        }
        IRow iRow = row = r < 0 ? null : this.tblTmp.getRow(r);
        if (row == null) {
            return null;
        }
        return c < 0 ? null : row.getCell(c);
    }

    public ICell getFoucusCell() {
        IRow row;
        KDTable tbl = this.getCurrentPage();
        if (tbl != null) {
            this.tblTmp = tbl;
        }
        if (this.tblTmp == null) {
            return null;
        }
        KDTSelectManager sm = this.tblTmp.getSelectManager();
        int r = sm.getActiveRowIndex();
        int c = sm.getActiveColumnIndex();
        IRow iRow = row = r < 0 ? null : this.tblTmp.getRow(r);
        if (row == null) {
            return null;
        }
        return c < 0 ? null : row.getCell(c);
    }

    public List getAllFocusCells() {
        ArrayList<ICell> list = new ArrayList<ICell>();
        KDTable tbl = this.getCurrentPage();
        KDTSelectManager selectManager = tbl.getSelectManager();
        int length = selectManager.size();
        for (int i = 0; i < length; ++i) {
            KDTSelectBlock block = selectManager.get(i);
            int left = block.getLeft();
            int right = block.getRight();
            int top = block.getTop();
            int bottom = block.getBottom();
            for (int x = left; x <= right; ++x) {
                for (int y = top; y <= bottom; ++y) {
                    list.add(tbl.getCell(y, x));
                }
            }
        }
        return list;
    }

    public void endEdit() {
        this.endEditInternal();
        this.onSelectedChange();
    }

    private void endEditInternal() {
        this.isEditingByFmbar = false;
        this.tblTmp = null;
    }

    void onSelectedChange() {
        ICell cell = this.getFoucusCell();
        if (cell == null) {
            return;
        }
        this.updateFont(cell.getStyleAttributes());
        this.verifyFormula(cell);
        this.verifyItemFormula(cell);
        this.fireCellChanged(cell);
    }

    private void verifyItemFormula(ICell cell) {
    }

    public boolean isUpdatingFont() {
        return this.isUpdatingFont;
    }

    private void updateFont(StyleAttributes sa) {
        this.isUpdatingFont = true;
        int st = 0;
        if (sa.isBold()) {
            st |= 1;
        }
        if (sa.isItalic()) {
            st |= 2;
        }
        this.fontChooser.setFontFamily(sa.getFontName());
        this.fontChooser.setFontSize(sa.getFontSize());
        this.fontChooser.setFontStyle(st);
        this.isUpdatingFont = false;
    }

    private void verifyFormula(ICell cell) {
        String tip = null;
        if (cell != null) {
            FormulaHint fh = null;
            try {
                List l = TableToolkit.parseExcelFormula(cell.getExpressions(), true);
                if (l != null && l.size() > 0) {
                    fh = (FormulaHint)l.get(l.size() - 1);
                }
            }
            catch (ParserException e) {
                fh = TableToolkit.parseFormula(cell.getExpressions());
            }
            if (fh != null) {
                RptFormula fm = null;
                try {
                    fm = RptFormulaComp.getInstance().getFormula(fh.name);
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                if (fm != null) {
                    RptFormulaParameter p;
                    int num = fm.getParameters().size();
                    if (!(fh.params != null && fh.params.length == num || num < 1 || (p = (RptFormulaParameter)fm.getParameters().iterator().next()) != null && p.getRepeatNum() > 1)) {
                        tip = RptResourceHelper.getString("rpttablepane-formula-verify");
                    }
                }
            }
        }
        this.getProgressBar().popMessage(tip);
    }

    public void setMerge(boolean isMerge) {
        this.actionsRollover((isMerge ? 0x10000000 : 0x20000000) | 0x2000);
    }

    public void setLock(boolean isLock) {
        this.actionsRollover(isLock ? 0x30000000 : 0x40000000);
        boolean lk = false;
        ICell ic = this.getFoucusCell();
        if (ic != null) {
            lk = ic.getStyleAttributes().isLocked();
        }
        this.fmBar.setLocked(lk);
    }

    public void setLock2(KDTable table, boolean isLock) {
        this.actionsRollover(table, TableToolkit.rangeToBlock("ALL"), isLock ? 0x30000000 : 0x40000000);
        boolean lk = false;
        ICell ic = this.getFoucusCell();
        if (ic != null) {
            lk = ic.getStyleAttributes().isLocked();
        }
        this.fmBar.setLocked(lk);
    }

    private boolean actionsRollover(int actionCode) {
        KDTable tbl = this.getCurrentPage();
        if (tbl == null) {
            return false;
        }
        KDTSelectManager sm = tbl.getSelectManager();
        int s = sm.size();
        for (int i = 0; i < s; ++i) {
            if (this.actionsRollover(tbl, sm.get(i), actionCode)) continue;
            return false;
        }
        return true;
    }

    private boolean actionsRollover(KDTable tbl, KDTSelectBlock sb, int actionCode) {
        if (tbl == null || sb == null) {
            return true;
        }
        int act = actionCode & 0xFFFF0000;
        int level = actionCode & 0xFFFF;
        boolean isOK = true;
        switch (sb.getMode()) {
            case 1: {
                if (level == 8192) {
                    isOK = this.doBlockAction(tbl, act, sb.getLeft(), sb.getTop(), sb.getRight(), sb.getBottom());
                    break;
                }
                isOK = this.doCellAction(tbl, act, sb.getLeft(), sb.getTop(), sb.getRight(), sb.getBottom());
                break;
            }
            case 2: {
                if (level == 4096) {
                    isOK = this.doCellAction(tbl, act, sb.getLeft(), sb.getTop(), tbl.getColumnCount() - 1, sb.getBottom());
                    break;
                }
                isOK = this.doRowAction(tbl, act, 0, sb.getTop(), tbl.getColumnCount() - 1, sb.getBottom());
                break;
            }
            case 4: {
                if (level == 4096) {
                    isOK = this.doCellAction(tbl, act, sb.getLeft(), sb.getTop(), sb.getRight(), tbl.getRowCount() - 1);
                    break;
                }
                isOK = this.doColumnAction(tbl, act, sb.getLeft(), 0, sb.getRight(), tbl.getRowCount() - 1);
                break;
            }
            case 8: {
                isOK = level == 4096 ? this.doCellAction(tbl, act, 0, 0, tbl.getColumnCount(), tbl.getRowCount()) : this.doTableAction(tbl, act);
            }
        }
        this.imm.incModifiedCount();
        return isOK;
    }

    private boolean isActionForbidden(int actCode, Object target, int disMode) {
        if (target == null) {
            return false;
        }
        boolean res = false;
        switch (actCode) {
            case 0x30000000: 
            case 0x40000000: {
                res = false;
                break;
            }
            case -2147483648: 
            case 0x10000000: 
            case 0x12000000: 
            case 0x20000000: 
            case 0x60000000: {
                if (target instanceof ICell) {
                    String f = ((ICell)target).getExpressions();
                    res = ((ICell)target).getStyleAttributes().isLocked();
                    break;
                }
                res = target instanceof IRow ? ((IRow)target).getStyleAttributes().isLocked() : (target instanceof IColumn ? ((IColumn)target).getStyleAttributes().isLocked() : (target instanceof KDTable ? ((KDTable)target).getStyleAttributes().isLocked() : false));
            }
        }
        if (res) {
            this.warnForbidden(0x30000000);
            return res;
        }
        return res;
    }

    public void warnForbidden(int warnCode) {
        String resKey = null;
        switch (warnCode) {
            case 0x30000000: {
                resKey = this.resHelper.getString("forbid.Locked");
                break;
            }
            case 0x60000000: {
                resKey = this.resHelper.getString("forbid.FunAtVar");
                break;
            }
            default: {
                resKey = RptResourceHelper.getString("rpttablepane-formula-not-modified");
            }
        }
        if (resKey != null) {
            MsgBox.showInfo((Component)((Object)this), (String)resKey);
        }
    }

    private boolean doColumnAction(KDTable table, int actCode, int left, int top, int right, int bottom) {
        int disMode = table.getCellDisplayMode();
        block6: for (int x = left; x <= right; ++x) {
            IColumn col = table.getColumn(x);
            for (int y = top; y <= bottom; ++y) {
                if (!this.isActionForbidden(actCode, table.getRow(y).getCell(x), disMode)) continue;
                return false;
            }
            switch (actCode) {
                case 0x10000000: {
                    table.getMergeManager().mergeBlock(top, left, bottom, right, 2);
                    continue block6;
                }
                case 0x20000000: {
                    table.getMergeManager().splitBlock(top, left, bottom, right);
                    continue block6;
                }
                case 0x30000000: {
                    this.setLock(col, true);
                    KDTableHelper.setColumnLocked((KDTable)table, (int)x, (boolean)true);
                    continue block6;
                }
                case 0x40000000: {
                    this.setLock(col, false);
                    KDTableHelper.setColumnLocked((KDTable)table, (int)x, (boolean)false);
                }
            }
        }
        return true;
    }

    private boolean doRowAction(KDTable table, int actCode, int left, int top, int right, int bottom) {
        int disMode = table.getCellDisplayMode();
        block6: for (int y = top; y <= bottom; ++y) {
            IRow row = table.getRow(y);
            for (int x = left; x <= right; ++x) {
                if (!this.isActionForbidden(actCode, row.getCell(x), disMode)) continue;
                return false;
            }
            switch (actCode) {
                case 0x10000000: {
                    table.getMergeManager().mergeBlock(top, left, bottom, right, 1);
                    continue block6;
                }
                case 0x20000000: {
                    table.getMergeManager().splitBlock(top, left, bottom, right);
                    continue block6;
                }
                case 0x30000000: {
                    this.setLock(row, true);
                    KDTableHelper.setRowLocked((KDTable)table, (int)y, (boolean)true);
                    continue block6;
                }
                case 0x40000000: {
                    this.setLock(row, false);
                    KDTableHelper.setRowLocked((KDTable)table, (int)y, (boolean)false);
                }
            }
        }
        return true;
    }

    private boolean doBlockAction(KDTable table, int actCode, int left, int top, int right, int bottom) {
        int disMode = table.getCellDisplayMode();
        for (int y = top; y <= bottom; ++y) {
            IRow row = table.getRow(y);
            for (int x = left; x <= right; ++x) {
                if (!this.isActionForbidden(actCode, row.getCell(x), disMode)) continue;
                return false;
            }
        }
        switch (actCode) {
            case 0x10000000: {
                table.getMergeManager().mergeBlock(top, left, bottom, right, 4);
                break;
            }
            case 0x20000000: {
                table.getMergeManager().splitBlock(top, left, bottom, right);
            }
        }
        return true;
    }

    private boolean doTableAction(KDTable table, int actCode) {
        switch (actCode) {
            case 0x30000000: {
                this.setLock(table, true);
                break;
            }
            case 0x40000000: {
                this.setLock(table, false);
            }
        }
        return true;
    }

    private boolean doCellAction(KDTable table, int actCode, int left, int top, int right, int bottom) {
        int disMode = table.getCellDisplayMode();
        for (int y = top; y <= bottom; ++y) {
            IRow row = table.getRow(y);
            block7: for (int x = left; x <= right; ++x) {
                ICell cell = row.getCell(x);
                if (this.isActionForbidden(actCode, cell, disMode)) {
                    return false;
                }
                switch (actCode) {
                    case 0x10000000: {
                        table.getMergeManager().mergeBlock(top, left, bottom, right, 4);
                        continue block7;
                    }
                    case 0x20000000: {
                        table.getMergeManager().splitBlock(top, left, bottom, right);
                        continue block7;
                    }
                    case 0x30000000: {
                        this.setLock(cell, true);
                        continue block7;
                    }
                    case 0x40000000: {
                        this.setLock(cell, false);
                    }
                }
            }
        }
        return true;
    }

    public void setLock(Object target, boolean isLock) {
        StyleAttributes sa = null;
        if (target instanceof ICell) {
            sa = ((ICell)target).getStyleAttributes();
        } else if (target instanceof IColumn) {
            sa = ((IColumn)target).getStyleAttributes();
        } else if (target instanceof IRow) {
            sa = ((IRow)target).getStyleAttributes();
        } else if (target instanceof KDTable) {
            sa = ((KDTable)target).getStyleAttributes();
        }
        if (sa != null) {
            sa.setLocked(isLock);
            if (sa.getPattern() == Pattern.None) {
                sa.setPattern(Pattern.Solid);
            }
            sa.setBackground(isLock ? LOCKCOLOR : Color.WHITE);
        }
    }

    public void addComment(PostilInfo pinfo) {
        this.addComment(pinfo, false);
    }

    public void addComment(PostilInfo pinfo, boolean isSetToNew) {
        try {
            if (this.comment == null) {
                this.comment = new RptCommentTank();
            }
            RptComment acmt = new RptComment(pinfo);
            if (isSetToNew) {
                acmt.setNewly();
            }
            this.comment.addEntry(acmt);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void removeComments() {
        this.comment = null;
    }

    public void getComments(PostilCollection comments) {
        if (this.comment == null) {
            return;
        }
        this.comment.dump(comments);
    }

    public void getComments(CSLCommentsCollection comments) {
    }

    public RptSheet getCurrentSheet() {
        RptSheet res = null;
        int id = this.getSelectedSheetIndex();
        if (id == -1) {
            id = 0;
        }
        try {
            this.setSelectedIndex(this.getVisiableIndex(id));
            res = this.getSheet(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    public void editComment(boolean isEditable) {
        if (this.comment == null) {
            this.comment = new RptCommentTank();
        }
        if (this.edListener == null) {
            this.edListener = new EditorListener();
        }
        try {
            String title = RptResourceHelper.getString("rptcmt") + RptResourceHelper.getString(isEditable ? "edit" : "view");
            RptCellCmtEditUI ed = RptCellCmtEditUI.getInstance((CoreUIObject)this.getParent());
            ed.addSimpleDialogListener(this.edListener);
            ed.open(this.comment, title, isEditable);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public RptCell getCurrentCell() {
        ICell ic = this.getFoucusCell();
        return ic == null ? null : this.getCurrentSheet().getRptCell(ic);
    }

    public RptSheet duplicate(RptSheet target) {
        if (target == null) {
            return null;
        }
        String name = this.getDuplicateName(target.getName());
        if (name == null) {
            return null;
        }
        KDTable orgTable = target.getTable();
        int index = this.indexOfPage((Component)orgTable);
        int ROW = orgTable.getExpandedRowCount();
        int COL = orgTable.getExpandedColumnCount();
        KDTable table = this.createNewTable();
        table.setRefresh(false);
        boolean refresh = table.isRefresh();
        boolean autorun = table.getScriptManager().isAutoRun();
        table.setRefresh(false);
        table.getScriptManager().setAutoRun(false);
        for (int row = 0; row < ROW; ++row) {
            table.addRow();
            for (int col = 0; col < COL; ++col) {
                table.addColumn();
            }
        }
        table.setRefresh(refresh);
        table.getScriptManager().setAutoRun(autorun);
        ReportCaclProxy cp = this.initPage(table, name);
        this.insertPage(name, null, (Component)table, null, index + 1);
        this.tabNames.put(name.toLowerCase(), table);
        HashMap<KDTMergeBlock, KDTMergeBlock> mergedBlocks = new HashMap<KDTMergeBlock, KDTMergeBlock>();
        for (int row = 0; row < ROW; ++row) {
            IRow rn;
            IRow ro = orgTable.getRow(row);
            if (ro == null || (rn = table.getRow(row)) == null) continue;
            rn.setHeight(ro.getHeight());
            for (int col = 0; col < COL; ++col) {
                ICell co;
                if (row == 0) {
                    IColumn coln;
                    IColumn colo = orgTable.getColumn(col);
                    if (colo == null || (coln = table.getColumn(col)) == null) continue;
                    coln.setWidth(colo.getWidth());
                }
                if ((co = ro.getCell(col)) == null) continue;
                ICell cn = rn.setCell(col, (ICell)co.clone());
                KDTMergeBlock merger = co.getMergeBlock();
                if (merger != null) {
                    if (mergedBlocks.containsKey(merger)) {
                        cn.getKDTCell().setMergeBlock((KDTMergeBlock)mergedBlocks.get(merger));
                    } else {
                        mergedBlocks.put(merger, cn.getMergeBlock());
                        table.getMergeManager().getMergeBlockList().add(cn.getMergeBlock());
                    }
                }
                if (cn == null) continue;
                cn.setValue(co.getValue());
                cn.setExpressions(co.getExpressions());
                RptCell rptcell = RptCell.getRptCell(co);
                cn.setUserObject(null);
                if (rptcell == null) continue;
                RptCell ncell = RptCell.getRptCellWithoutUserObject(cn);
                if (rptcell.getItemFormula() != null) {
                    ncell.setItemFormula((ItemFormula)rptcell.getItemFormula().clone());
                    cn.setUserObject((Object)ncell);
                }
                if (this.copyProcesser == null) continue;
                this.copyProcesser.copyCell(rptcell, ncell);
            }
        }
        this.tabNames.put(name.toLowerCase(), table);
        table.setName(name);
        RptSheet res = RptSheet.getRptSheet(table);
        try {
            if (target.keys != null) {
                res.keys = (HashMap)target.keys.clone();
            }
            if (target.basePosition != null) {
                res.basePosition = (HashMap)target.basePosition.clone();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        res.setTable(table);
        res.setName(name);
        res.setParams((RptSheetParamInfo)target.getParams().clone());
        res.setId(BOSUuid.create((String)"RPTSHEET").toString());
        if (res.getParams() != null) {
            res.getParams().setId(null);
            res.getParams().setStatus(1);
            res.getParams().setSheetID(res.getId());
            res.getParams().setSheetName(name);
        }
        res.refreshContext(cp);
        res.dispatchComments();
        if (this.copyProcesser != null) {
            this.copyProcesser.copySheet(target, res);
        }
        res.update();
        table.setRefresh(true);
        return res;
    }

    private String getDuplicateName(String target) {
        if (target == null) {
            target = this.resHelper.getString("sheet.Name");
        }
        String test = target.toLowerCase();
        for (int i = 2; i < 50; ++i) {
            String res = test + "(" + i + ")";
            if (this.tabNames.get(res) != null) continue;
            return test + "(" + i + ")";
        }
        return null;
    }

    public void convertTable(KDTable table, Rect region, int operation, double rate, int decimal) {
        if (table == null || region == null || rate == 0.0) {
            return;
        }
        int max_x = table.getExpandedColumnCount();
        int max_y = table.getExpandedRowCount();
        if (max_x > 0) {
            --max_x;
        }
        if (max_y > 0) {
            --max_y;
        }
        region.format(0, 0, max_x, max_y);
        BigDecimal rt = new BigDecimal(Double.toString(rate));
        int rateScale = rt.scale();
        rt = rt.setScale(rateScale > decimal ? rateScale : decimal, 4);
        table.setRefresh(false);
        IRow row = null;
        ICell cell = null;
        Object value = null;
        for (int y = region.y1; y <= region.y2; ++y) {
            row = table.getRow(y);
            if (row == null) continue;
            for (int x = region.x1; x <= region.x2; ++x) {
                cell = row.getCell(x);
                StyleAttributes sa = cell.getStyleAttributes();
                if (cell == null || sa.isLocked()) continue;
                value = cell.getValue();
                String fm = cell.getExpressions();
                try {
                    char OPER = '*';
                    if (operation == 0) {
                        OPER = '/';
                    }
                    if (value != null) {
                        BigDecimal val = null;
                        val = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(value.toString());
                        int sc = val.scale();
                        if (sc < decimal) {
                            sc = decimal + 2;
                            val = val.setScale(sc);
                        }
                        val = operation == 0 ? val.divide(rt, 4) : val.multiply(rt);
                        val = val.setScale(decimal, 4);
                        cell.setValue((Object)val);
                        StringBuffer decimaString = new StringBuffer("0.");
                        for (int i = 0; i < decimal; ++i) {
                            decimaString.append("0");
                        }
                        sa.setNumberFormat(decimaString.toString() + ";-" + decimaString.toString());
                    }
                    if (fm == null || fm.length() <= 1 || fm.charAt(0) != '=') continue;
                    fm = FormulaConvertUtil.convert(fm, OPER, rt.toString());
                    cell.setExpressions(fm);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        table.setRefresh(true);
    }

    public void summaryTables(KDTable target, KDTable[] tables) {
        if (target == null || tables == null || tables.length < 1) {
            return;
        }
        target.setRefresh(false);
        int size = tables.length;
        IRow[] rows = new IRow[size];
        IRow outRow = null;
        ICell cell = null;
        int max_x = tables[0].getExpandedColumnCount();
        int max_y = tables[0].getExpandedRowCount();
        BigDecimal sum = null;
        BigDecimal value = null;
        Object rawValue = null;
        String strValue = null;
        block2: for (int y = 0; y < max_y; ++y) {
            outRow = target.getRow(y);
            if (outRow == null) continue;
            for (int i = 0; i < size; ++i) {
                rows[i] = tables[i].getRow(y);
                if (rows[i] == null) continue block2;
            }
            for (int x = 0; x < max_x; ++x) {
                sum = new BigDecimal("0");
                value = null;
                for (int i = 0; i < size; ++i) {
                    cell = rows[i].getCell(x);
                    if (cell == null || cell.getStyleAttributes().isLocked()) {
                        value = null;
                        break;
                    }
                    rawValue = cell.getValue();
                    if (rawValue == null || (strValue = rawValue.toString().trim()).length() == 0) continue;
                    try {
                        value = sum = sum.add(new BigDecimal(strValue));
                        continue;
                    }
                    catch (Exception e) {
                        value = null;
                        break;
                    }
                }
                if ((cell = outRow.getCell(x)) == null) continue;
                cell.setValue(value == null ? rows[0].getCell(x).getValue() : sum);
            }
        }
        target.setRefresh(true);
        target.repaint();
    }

    public void processBalanceExp(BalanceHint hint) {
        int y;
        KDTable tbl;
        if (hint == null || hint.base == null || hint.base.region == null || hint.expression == null) {
            return;
        }
        KDTable kDTable = tbl = hint.base.sheetName == null ? this.getCurrentPage() : this.getPage(hint.base.sheetName);
        if (tbl == null) {
            return;
        }
        Rect rt = hint.base.region.normalize();
        int x = rt.x1 >= 0 ? rt.x1 : rt.x2;
        int n = y = rt.y1 >= 0 ? rt.y1 : rt.y2;
        if (x < 0 && y < 0) {
            return;
        }
        IRow r = tbl.getRow(y);
        if (r == null) {
            return;
        }
        ICell c = r.getCell(x);
        if (c == null) {
            return;
        }
        KDTScriptManager sm = tbl.getScriptManager();
        boolean ar = sm.isAutoRun();
        sm.setAutoRun(false);
        for (int i = 0; i < this.getSheetCount(); ++i) {
            tbl = this.getPageAt(i);
            if (tbl == null) continue;
            TablePorperts.getInstance(tbl).put("SheetParam", RptSheet.getRptSheet(tbl).getParams());
            RptSheet.getRptSheet(tbl).getContext().getData().setEditData(this.editData);
            tbl.getScriptManager().setAutoRun(false);
        }
        Variant res = sm.run("=" + hint.expression);
        if (res != null) {
            BigDecimal bs = null;
            try {
                bs = res.toBigDecimal();
            }
            catch (Exception exception) {
                // empty catch block
            }
            c.setValue((Object)(bs == null ? null : bs));
        } else {
            c.setValue(null);
        }
        c.setExpressions(null);
        c.setChange(false);
        sm.setAutoRun(ar);
    }

    public ICell getTemporaryCell(KDTable table) {
        if (table == null) {
            return null;
        }
        int Y = table.getExpandedRowCount() - 1;
        int X = table.getExpandedColumnCount() - 1;
        int y = Y < 0 ? 0 : Y;
        int x = X < 0 ? 0 : X;
        ICell cell = null;
        boolean hasFound = false;
        for (int i = 0; i < 10; ++i) {
            Object val;
            IRow r;
            if ((r = table.getRow(y++)) == null) {
                r = table.addRow();
            }
            if (r == null) break;
            cell = r.getCell(x);
            if (cell == null || (val = cell.getValue()) != null && val.toString().trim().length() != 0) continue;
            hasFound = true;
            break;
        }
        return hasFound ? cell : null;
    }

    public void removeAllComments() {
        this.removeComments();
        RptSheet sht = null;
        int count = this.getSheetCount();
        for (int i = 0; i < count; ++i) {
            sht = this.getSheet(i);
            if (sht == null) continue;
            sht.removeAllComments();
        }
    }

    public boolean canPickFormula(boolean isFormula) {
        return true;
    }

    public void onPaste(KDTable table) {
        table = this.verify(table);
        table.getEditHelper().paste();
        this.resetFormulaBarContent();
    }

    public void onCut(KDTable table) {
        if (!this.actionsRollover(-2147479552)) {
            return;
        }
        table = this.verify(table);
        table.getEditHelper().copy();
        int MARK = 15;
        KDTRange range = table.getSelectManager().toRange();
        table.getEditHelper().delete(range.getSequenceRange(), 15);
        this.resetFormulaBarContent();
    }

    public void onDelet(KDTable table, String actionName) {
        if (!this.actionsRollover(-2147479552)) {
            return;
        }
        table = this.verify(table);
        int mod = RptTableHelper.getKDTDeleteMode(actionName);
        RptTableHelper helper = RptTableHelper.getInstance(table);
        if (mod == 8) {
            helper.delete(actionName);
        } else {
            helper.delete(mod);
        }
        this.resetFormulaBarContent();
    }

    public void onCopy(KDTable table) {
        if ((table = this.verify(table)) == null) {
            return;
        }
        table.getEditHelper().copy();
    }

    public void onDeletFormat(KDTable table) {
        if ((table = this.verify(table)) == null) {
            return;
        }
        RptTableHelper.getInstance(table).delete(RptTableHelper.getKDTDeleteMode("format"));
        this.resetFormulaBarContent();
    }

    public void removeSelectedColumns() {
        int res = RptTableHelper.getInstance(this.getCurrentPage()).removeSelectedColumns();
        if (res != 0) {
            this.warnForbidden(res);
        }
        this.resetFormulaBarContent();
    }

    public void removeSelectedRows() {
        int res = RptTableHelper.getInstance(this.getCurrentPage()).removeSelectedRows();
        if (res != 0) {
            this.warnForbidden(res);
        }
        this.resetFormulaBarContent();
        this.imm.incModifiedCount();
    }

    private boolean testWrite(KDTable table, KDTRange range) {
        return this.testWrite(table, range, null);
    }

    private boolean testWrite(KDTable table, KDTRange range, String actionName) {
        boolean canNot;
        if (table == null) {
            return false;
        }
        boolean bl = canNot = !"value".equals(actionName) && table.getCellDisplayMode() == 0;
        if (canNot) {
            canNot = RptTableHelper.getInstance(table).isFormulaInRange(range);
        }
        if (canNot) {
            MsgBox.showInfo((String)RptResourceHelper.getString("rpttablepane-formula-not-modified"));
        }
        return !canNot;
    }

    private boolean testWrite(KDTable table, String actionName) {
        return this.testWrite(table, table.getSelectManager().toRange(), actionName);
    }

    private boolean testWrite(KDTable table) {
        return this.testWrite(table, table.getSelectManager().toRange(), null);
    }

    private KDTable verify(KDTable table) {
        return table == null ? this.getCurrentPage() : table;
    }

    public void setBatchEdit(boolean isBatchEdit) {
        int ct = this.getSheetCount();
        for (int i = 0; i < ct; ++i) {
            if (isBatchEdit) {
                this.getPageAt(i).setRefresh(false);
                continue;
            }
            this.getPageAt(i).setRefresh(true);
            this.getPageAt(i).repaint();
        }
    }

    private ArrayList getAllTabs() {
        if (this.tabs == null) {
            this.tabs = new ArrayList(3);
        }
        return this.tabs;
    }

    private Component inChain(int position, Component table, Boolean isVisiabe) {
        ArrayList list = this.getAllTabs();
        list.add(position, new Pair((Object)table, (Object)isVisiabe));
        return table;
    }

    private Component inChain(int position, Component table) {
        return this.inChain(position, table, Boolean.TRUE);
    }

    private Component offChain(Component table) {
        ArrayList chain = this.getAllTabs();
        for (int i = 0; i < chain.size(); ++i) {
            if (table != ((Pair)chain.get((int)i)).first) continue;
            chain.remove(i);
            break;
        }
        return table;
    }

    public void insertPage(String title, Icon icon, Component component, String tip, int index) {
        this.inChain(index, component);
        index = this.getVisiableIndex(index);
        if (index < 0) {
            index = 0;
        }
        this.insertTab(title, icon, component, tip, index);
        this.tabNames.put(title.toLowerCase(), component);
        this.imm.incModifiedCount();
    }

    public void removePageAt(int index) {
        this.removePageAt(index, true);
    }

    public void removePageAt(int index, boolean isLimited) {
        if (isLimited && !this.tryRemove()) {
            return;
        }
        if (index < 0 || index >= this.getSheetCount()) {
            return;
        }
        int i = this.getVisiableIndex(index);
        if (i != -1) {
            super.removeTabAt(i);
        }
        KDTable tbl = this.getPageAt(index);
        this.offChain((Component)tbl);
        this.tabNames.remove(tbl.getName().toLowerCase());
        this.imm.incModifiedCount();
    }

    public int getVisiableIndex(int index) {
        ArrayList chain = this.getAllTabs();
        int res = 0;
        for (int i = 0; i < chain.size(); ++i) {
            if (Boolean.TRUE != ((Pair)chain.get((int)i)).second) continue;
            if (i == index) {
                return res;
            }
            ++res;
        }
        return -1;
    }

    public Collection getVisibleIndices() {
        ArrayList chain = this.getAllTabs();
        int size = chain.size();
        ArrayList<Integer> res = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            if (Boolean.TRUE != ((Pair)chain.get((int)i)).second) continue;
            res.add(new Integer(i));
        }
        return res;
    }

    public Collection getVisibleSheets() {
        ArrayList chain = this.getAllTabs();
        int size = chain.size();
        ArrayList<RptSheet> res = new ArrayList<RptSheet>(size);
        for (int i = 0; i < size; ++i) {
            Pair p = (Pair)chain.get(i);
            if (Boolean.TRUE != p.second) continue;
            res.add(RptSheet.getRptSheet((KDTable)p.first));
        }
        return res;
    }

    public Collection getTrueIndices(Collection visibleIndices) {
        int size = visibleIndices == null ? 0 : visibleIndices.size();
        ArrayList<Integer> res = new ArrayList<Integer>(size);
        if (size < 1) {
            return res;
        }
        ArrayList chain = this.getAllTabs();
        int csize = chain.size();
        Iterator it = visibleIndices.iterator();
        while (it.hasNext()) {
            int i = (Integer)it.next();
            Component tbl = this.getComponentAt(i);
            for (i = 0; i < csize; ++i) {
                if (((Pair)chain.get((int)i)).first != tbl) continue;
                res.add(new Integer(i));
            }
        }
        return res;
    }

    public int getTrueIndex(int index) {
        return this.indexOfPage(this.getComponentAt(index));
    }

    public void hideTabAt(int index) {
        Pair p = this.getTabPair(this.getComponentAt(index));
        if (p != null) {
            p.second = Boolean.FALSE;
            RptSheet.getRptSheet((KDTable)p.first).setExtendProperty("visiablilty", Boolean.FALSE);
        }
        super.removeTabAt(index);
        this.imm.incModifiedCount();
    }

    public void hideTab(Component table) {
        if (table != null) {
            Pair p = this.getTabPair(table);
            if (p != null) {
                p.second = Boolean.FALSE;
                RptSheet.getRptSheet((KDTable)table).setExtendProperty("visiablilty", Boolean.FALSE);
            }
            super.removeTabAt(this.indexOfComponent(table));
            this.imm.incModifiedCount();
        }
    }

    public Component unHideTab(Component table) {
        ArrayList chain = this.getAllTabs();
        Pair p = null;
        int i = 0;
        for (i = 0; i < chain.size(); ++i) {
            p = (Pair)chain.get(i);
            if (table == p.first) break;
            p = null;
        }
        if (p == null || p.second != Boolean.FALSE) {
            return table;
        }
        int pos = 0;
        for (pos = i - 1; pos >= 0; --pos) {
            Pair pr = (Pair)chain.get(pos);
            if (pr.second != Boolean.TRUE) continue;
            pos = this.indexOfComponent((Component)pr.first);
            if (pos >= 0) break;
            pos = 0;
            break;
        }
        if (this.getTabCount() > 0 || pos < 0) {
            ++pos;
        }
        RptSheet.getRptSheet((KDTable)table).setExtendProperty("visiablilty", Boolean.TRUE);
        super.insertTab(table.getName(), null, table, table.getName(), pos);
        p.second = Boolean.TRUE;
        this.imm.incModifiedCount();
        return table;
    }

    private Pair getTabPair(Component table) {
        ArrayList chain = this.getAllTabs();
        for (int i = 0; i < chain.size(); ++i) {
            Pair p = (Pair)chain.get(i);
            if (table != p.first) continue;
            return p;
        }
        return null;
    }

    public ArrayList getHidedTabs() {
        ArrayList<Object> res = new ArrayList<Object>(3);
        ArrayList chain = this.getAllTabs();
        for (int i = chain.size() - 1; i >= 0; --i) {
            Pair p = (Pair)chain.get(i);
            if (p.second != Boolean.FALSE) continue;
            res.add(p.first);
        }
        return res;
    }

    public void unHideTabs(ArrayList chain) {
        int size = chain.size();
        for (int i = 0; i < size; ++i) {
            this.unHideTab((Component)chain.get(i));
        }
    }

    public int getSelectedSheetIndex() {
        int pos = this.getSelectedIndex();
        if (pos == -1) {
            return -1;
        }
        return this.getTrueIndex(pos);
    }

    public ArrayList getMoverTabs() {
        ArrayList<RptSheet> res = new ArrayList<RptSheet>(3);
        int size = this.getTabCount();
        for (int i = 0; i < size; ++i) {
            res.add(RptSheet.getRptSheet((KDTable)this.getComponentAt(i)));
        }
        return res;
    }

    public void MoveTab(RptSheet from, RptSheet toBefore) {
        if (from == null) {
            return;
        }
        ArrayList c = this.getAllTabs();
        if (toBefore == null) {
            this.remove((Component)from.getTable());
            this.add((Component)from.getTable());
            c.remove(this.indexOfPage((Component)from.getTable()));
            c.add(new Pair((Object)from.getTable(), (Object)Boolean.TRUE));
        } else if (from != toBefore) {
            int f = this.indexOfPage((Component)from.getTable());
            int t = this.indexOfPage((Component)toBefore.getTable());
            if (f > 0 && f == t - 1) {
                return;
            }
            if (f < t && t > 0) {
                --t;
            }
            this.removePageAt(f);
            this.insertPage(from.getTable().getName(), null, (Component)from.getTable(), from.getTable().getName(), t);
        }
    }

    public RptSheet getSheetByID(String id) {
        ArrayList c = this.getAllTabs();
        for (int i = c.size() - 1; i >= 0; --i) {
            KDTable t = (KDTable)((Pair)c.get((int)i)).first;
            if (!t.getID().equalsIgnoreCase(id)) continue;
            return RptSheet.getRptSheet(t);
        }
        return null;
    }

    public int getCurrentColWidth() {
        RptCell cell = this.getCurrentCell();
        if (cell == null) {
            return -1;
        }
        return this.getCurrentPage().getColumn(cell.getCell().getColumnIndex()).getWidth();
    }

    public void setCurrentColWidth(int value) {
        KDTable tbl = this.getCurrentPage();
        if (tbl == null) {
            return;
        }
        ArrayList bks = tbl.getSelectManager().getBlocks();
        if (bks == null || bks.size() < 1) {
            return;
        }
        for (int i = 0; i < bks.size(); ++i) {
            int to;
            KDTSelectBlock sb = (KDTSelectBlock)bks.get(i);
            if (sb == null) continue;
            switch (sb.getMode()) {
                case 1: 
                case 4: {
                    int from = sb.getLeft();
                    to = sb.getRight();
                    break;
                }
                default: {
                    int from = 0;
                    to = tbl.getExpandedColumnCount();
                }
            }
            for (int n = from; n <= to; ++n) {
                tbl.getColumn(n).setWidth(value);
            }
        }
        this.imm.incModifiedCount();
    }

    public int getCurrentRowHeight() {
        RptCell cell = this.getCurrentCell();
        if (cell == null) {
            return -1;
        }
        return this.getCurrentPage().getRow(cell.getCell().getRowIndex()).getHeight();
    }

    public void setCurrentRowHeight(int value) {
        KDTable tbl = this.getCurrentPage();
        if (tbl == null) {
            return;
        }
        ArrayList bks = tbl.getSelectManager().getBlocks();
        if (bks == null || bks.size() < 1) {
            return;
        }
        for (int i = 0; i < bks.size(); ++i) {
            int to;
            KDTSelectBlock sb = (KDTSelectBlock)bks.get(i);
            if (sb == null) continue;
            switch (sb.getMode()) {
                case 1: 
                case 2: {
                    int from = sb.getTop();
                    to = sb.getBottom();
                    break;
                }
                default: {
                    int from = 0;
                    to = tbl.getExpandedRowCount();
                }
            }
            for (int n = from; n <= to; ++n) {
                tbl.getRow(n).setHeight(value);
            }
        }
        this.imm.incModifiedCount();
    }

    public void setFontChooser(KDFontChooser kfc) {
        this.fontChooser = kfc;
    }

    public void onEscape() {
        try {
            ((ReportProcessUI)((Object)this.getParent())).actionFileExit_actionPerformed(null);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public boolean onFileProview(ExtendButtonAction extBtn) throws Exception {
        RptSheet sheet = this.getCurrentSheet();
        if (sheet == null) {
            return false;
        }
        KDTPrintManager prm = sheet.getTable().getPrintManager();
        if (sheet.getExtendProperty("PrintProviewSetup") != Boolean.TRUE) {
            HeaderFooterSetupUI.extendButtonAction = extBtn;
            prm.setHeadFootUI(HeaderFooterSetupUI.class);
            sheet.setExtendProperty("PrintProviewSetup", Boolean.TRUE);
            prm.addHeaderFooterVarProvider((ExtVarProvider)new XExtVarProvider(sheet.getTable()));
        }
        prm.printPreview();
        return prm.getNewPrintManager().getPrinter().getPrintConfig().isChange();
    }

    public int getFormulaMode() {
        return this.formulaMode;
    }

    public void setFormulaMode(int formulaMode) {
        this.formulaMode = formulaMode;
    }

    public void addCellChangeListener(ICellChangeListener l) {
        if (this.cellChangeListeners == null) {
            this.cellChangeListeners = new ArrayList(1);
        }
        this.cellChangeListeners.add(l);
    }

    public void removeCellChangeListener(ICellChangeListener l) {
        if (this.cellChangeListeners == null) {
            return;
        }
        this.cellChangeListeners.remove(l);
    }

    private void fireCellChanged(ICell cell) {
        if (this.cellChangeListeners == null) {
            return;
        }
        for (int i = 0; i < this.cellChangeListeners.size(); ++i) {
            ICellChangeListener c = (ICellChangeListener)this.cellChangeListeners.get(i);
            c.onCellChanged(cell);
        }
    }

    public void setSheetInsertListener(ActionListener l) {
        this.sheetInsertListener = l;
    }

    private KDTable createNewTable() {
        KDTable table = new KDTable();
        table.getScriptManager().setAutoRun(false);
        table.setPrintConfigDefault(false, true, false, false, false);
        table.setHeadDisplayMode(1);
        table.getIOManager().setExpandedOnly(true);
        table.getPrintManager().setExpandedOnly(true);
        table.getPrintManager().setDataMode(0);
        table.setFormulaMode(this.formulaMode);
        table.getSelectManager().setSelectPaintMode(1);
        return table;
    }

    public void registerSheetCopyProesser(ISheetCopyProcesser p) {
        this.copyProcesser = p;
    }

    public class FormulaSetupConfigurator
    implements IExSetupConfigurator {
        ExtendButtonAction action = null;
        private boolean isSetuped = false;

        public FormulaSetupConfigurator(ExtendButtonAction act) {
            this.action = act;
        }

        public String getTargetName() {
            return RptUtil.getResourceSince51("HeaderFooterSetting");
        }

        public void config(IExSetup es) {
            if (es == null || this.isSetuped) {
                return;
            }
            ((HeadFootSetupPane)es).addExtendButton(this.action);
            this.isSetuped = true;
        }

        public void unconfig() {
        }
    }

    private class EditorListener
    implements IControlledDialogListener {
        private EditorListener() {
        }

        @Override
        public Object getTrueController() {
            return new RptComment();
        }

        @Override
        public void pilotSetout(ISimpleDialog source) {
        }

        @Override
        public void pilotReturnee(ISimpleDialog source, Object result, boolean isOk) {
            if (isOk) {
                RptTablePane.this.comment.updateFrom((RptCommentTank)result);
                RptTablePane.this.imm.incModifiedCount();
            }
        }
    }

    private class TableActionListener
    extends KDTEditAdapter
    implements KDTActiveCellListener,
    KDTDataRequestListener,
    KDTSelectListener {
        private boolean isInit = false;

        private TableActionListener() {
        }

        public void editStarting(KDTEditEvent e) {
            this.isInit = false;
        }

        public void editStarted(KDTEditEvent e) {
            if (!RptTablePane.this.isEditingByFmbar && RptTablePane.this.fmBar != null) {
                RptTablePane.this.fmBar.beginEdit();
            }
            this.isInit = true;
            this.setChangedValue(e, this.isInit);
        }

        public void editValueChanged(KDTEditEvent e) {
            this.setChangedValue(e, this.isInit);
        }

        public void editCanceled(KDTEditEvent e) {
            this.isInit = false;
        }

        private void setChangedValue(KDTEditEvent e, boolean isInit) {
            if (RptTablePane.this.isEditingByFmbar || RptTablePane.this.fmBar == null || !isInit) {
                return;
            }
            RptTablePane.this.fmBar.setFormulaLine(e.getValue() == null ? null : e.getValue().toString());
        }

        public void editStopping(KDTEditEvent e) {
            if (!RptTablePane.this.isEditingByFmbar && RptTablePane.this.fmBar != null) {
                RptTablePane.this.fmBar.endEdit();
                RptTablePane.this.setHotCellValue((KDTable)e.getSource(), e.getRowIndex(), e.getColIndex());
            }
            this.isInit = false;
        }

        public void editStopped(KDTEditEvent e) {
            RptTablePane.this.onSelectedChange();
            this.isInit = false;
        }

        public void activeCellChanged(KDTActiveCellEvent e) {
            this.isInit = false;
            RptTablePane.this.onSelectedChange();
        }

        private void activeCellChanged(KDTable table, Point pt) {
            if (pt != null) {
                RptTablePane.this.setHotCellValue(table, pt.y, pt.x);
            }
            this.isInit = false;
        }

        public void tableDataRequest(KDTDataRequestEvent e) {
            Rectangle ra = new Rect(e.getFirstCol(), e.getFirstRow(), e.getLastCol(), e.getLastRow()).toRectangle();
            KDTable tbl = (KDTable)e.getSource();
            int delta = 400 - tbl.getColumnCount();
            for (int i = tbl.getColumnCount(); i < 40; ++i) {
                tbl.addColumn();
            }
            if (delta < 0) {
                delta = 0;
            }
            if (ra.width > delta) {
                ra.width = delta;
            }
            RptTablePane.this.appendCells(tbl, ra);
        }

        public void tableSelectChanged(KDTSelectEvent e) {
            if (!RptTablePane.this.isEditingByFmbar && RptTablePane.this.fmBar != null) {
                RptTablePane.this.fmBar.setCurrentRange(TableToolkit.blockToRange(e.getSelectBlock()));
                this.activeCellChanged((KDTable)e.getSource(), TableToolkit.getHotPoint(e.getSelectBlock()));
            }
        }
    }

    private class TableInputListener
    implements KDTMouseListener {
        private TableInputListener() {
        }

        public void tableClicked(KDTMouseEvent e) {
            if (e.getButton() != 1) {
                this.triggerTableContextMenu((MouseEvent)e);
            }
        }

        private void triggerTableContextMenu(MouseEvent e) {
            KDPopupMenu menu;
            KDPopupMenu kDPopupMenu = menu = RptTablePane.this.cellContextMenu != null ? RptTablePane.this.cellContextMenu : RptTablePane.this.rangeContextMenu;
            if (menu != null) {
                menu.show(e.getComponent(), e.getX() + 22, e.getY() + 22);
            }
        }
    }

    private class TableAliasParser
    implements ITableAliasParser {
        private TableAliasParser() {
        }

        public KDTable parseAlias(String alias) {
            return alias == null ? null : (KDTable)RptTablePane.this.tabNames.get(alias.toLowerCase());
        }
    }

    private class TabMouseListener
    extends MouseAdapter
    implements ChangeListener {
        private TabMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.triggerTabContextMenu(e);
            }
        }

        private void triggerTabContextMenu(MouseEvent e) {
            if (RptTablePane.this.tabContextMenu != null) {
                RptTablePane.this.tabContextMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            KDTable tbl = (KDTable)RptTablePane.this.getSelectedComponent();
            if (tbl == null) {
                return;
            }
            RptSheet sht = RptSheet.getRptSheet(tbl);
            if (sht != null) {
                sht.dispatchComments();
            }
            if (tbl.getScriptManager().isAutoRun()) {
                tbl.getScriptManager().run();
                RptTablePane.this.imm.incModifiedCount();
            }
            RptTablePane.this.setHotCellValue();
        }
    }

    private class XExtVarProvider
    implements ExtVarProvider {
        private KDTable table;

        public XExtVarProvider(KDTable tbl) {
            this.table = tbl;
            if (this.table == null) {
                throw new IllegalArgumentException("table==null@XExtVarProvider's constructor");
            }
        }

        public Variant requestVarData(String varName) {
            if (varName == null) {
                return null;
            }
            if ((varName = varName.trim()).length() <= 1) {
                return new Variant((Object)varName);
            }
            if (varName.charAt(0) != '=') {
                varName = "=" + varName;
            }
            return this.table.getScriptManager().run(varName);
        }
    }
}

