/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.analysis.util.editor.EditorStyleModel;
import com.kingdee.bos.ctrl.analysis.util.editor.StyledEditor;
import com.kingdee.bos.ctrl.excel.impl.facade.editor.ICellEditor;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.sql.util.Base64;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.SqlResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.client.designer.ReportDesignerUI;
import com.kingdee.eas.fi.newrpt.dbcenter.DBCenterFactory;
import com.kingdee.eas.fi.newrpt.dbcenter.DBCenterInfo;
import com.kingdee.eas.fi.rpt.DataTypeEnum;
import com.kingdee.eas.fi.rpt.Parster;
import com.kingdee.eas.fi.rpt.SQLFormulaUtil;
import com.kingdee.eas.fi.rpt.SqlUtilFacadeFactory;
import com.kingdee.eas.fi.rpt.client.AbstractScriptEditUI;
import com.kingdee.eas.fi.rpt.client.DetailItemF7;
import com.kingdee.eas.fi.rpt.client.SQLEditorStyleModel;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.fm.common.IFMIsqlFacade;
import com.kingdee.eas.fm.common.client.FMISQLEditorStyleModel;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ScriptEditUI
extends AbstractScriptEditUI {
    private static final long serialVersionUID = 1773162274193048151L;
    private static final Logger logger = CoreUIObject.getLogger(ScriptEditUI.class);
    StyledEditor formulaDoc;
    StyledEditor formulaCheckDoc;

    public void onLoad() throws Exception {
        super.onLoad();
        this.addBtn_actionPerformed(null);
        this.paramBox.setText(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"391_ScriptEditUI"));
        this.formulaDoc = new StyledEditor();
        this.formulaCheckDoc = new StyledEditor();
        this.formulaCheckDoc.setEditable(false);
        this.scriptScrollPane.getViewport().add((Component)this.formulaDoc, null);
        this.scriptCheckScrollPane.getViewport().add((Component)this.formulaCheckDoc, null);
        FMISQLEditorStyleModel model = SQLEditorStyleModel.model.getStyle();
        this.formulaDoc.setStyleModel((EditorStyleModel)model);
        this.formulaCheckDoc.setStyleModel((EditorStyleModel)model);
        this.clearColumnBtn.setSelected(0);
        this.paramBox.setSelected(false);
        this.clearColumnBtn.setSelected(false);
        this.paramBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ScriptEditUI.this.paramBox.isSelected()) {
                    ScriptEditUI.this.clearColumnBtn.setSelected(false);
                }
            }
        });
        this.clearColumnBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ScriptEditUI.this.clearColumnBtn.isSelected()) {
                    ScriptEditUI.this.paramBox.setSelected(false);
                }
            }
        });
        this.kDTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Component bo = ScriptEditUI.this.kDTabbedPane1.getSelectedComponent();
                if (ScriptEditUI.this.kDTabbedPane1.getSelectedComponent() != ScriptEditUI.this.editPanel && ScriptEditUI.this.kDTabbedPane1.getSelectedComponent() == ScriptEditUI.this.checkPanel) {
                    ScriptEditUI.this.formulaCheckDoc.setText("");
                    ScriptEditUI.this.formulaCheckDoc.setText(ScriptEditUI.this.getSQL());
                }
            }
        });
        this.initScript();
    }

    protected void addBtn_actionPerformed(ActionEvent e) throws Exception {
    }

    public void initScript() {
        String txt;
        Range range = (Range)this.getUIContext().get("activeRange");
        if (range != null && (txt = range.getFormula()) != null) {
            int start = txt.indexOf("=executeSQL");
            if (txt != null && start >= 0) {
                txt = StringUtils.replace((String)txt, (String)"=executeSQL", (String)"");
                String formula = (txt = txt.substring(start, txt.length())).substring(1, txt.length() - 1);
                if (this.countMatches(formula, "#") >= 2) {
                    String[] ss = formula.split("#");
                    ss[1] = StringUtils.replace((String)ss[1], (String)"\"", (String)"");
                    ss[1] = StringUtils.replace((String)ss[1], (String)",", (String)"");
                    ss[2] = StringUtils.replace((String)ss[2], (String)"\"", (String)"");
                    ss[2] = StringUtils.replace((String)ss[2], (String)",", (String)"");
                    ss[3] = StringUtils.replace((String)ss[3], (String)"\"", (String)"");
                    ss[3] = StringUtils.replace((String)ss[3], (String)",", (String)"");
                    String dbCenterNumber = null;
                    if (ss.length > 4 && !StringUtils.isEmpty((String)ss[4])) {
                        ss[4] = StringUtils.replace((String)ss[4], (String)"\"", (String)"");
                        ss[4] = StringUtils.replace((String)ss[4], (String)",", (String)"");
                        dbCenterNumber = ss[4].trim();
                    }
                    String isShowField = ss[1].trim();
                    String isclearColumn = ss[2].trim();
                    String sqlheader = ss[0].substring(1);
                    this.formulaDoc.setText(sqlheader);
                    this.titleText.setText(ss[3]);
                    if (isShowField.equals("1")) {
                        this.showFieldBox.setSelected(true);
                    }
                    if (isclearColumn.startsWith("1")) {
                        this.clearColumnBtn.setSelected(true);
                    } else {
                        this.clearColumnBtn.setSelected(false);
                    }
                    if (isclearColumn.length() == 2 && isclearColumn.endsWith("1")) {
                        this.paramBox.setSelected(true);
                    } else {
                        this.paramBox.setSelected(false);
                    }
                    if (!StringUtils.isEmpty((String)dbCenterNumber) && !StringUtils.isEmpty((String)dbCenterNumber)) {
                        try {
                            DBCenterInfo dbCenter = DBCenterFactory.getRemoteInstance().getDBCenterInfo("where number = '" + dbCenterNumber + "'");
                            this.pmtDbCenter.setData((Object)dbCenter);
                        }
                        catch (EASBizException e) {
                            this.handleException((Exception)((Object)e));
                        }
                        catch (BOSException e) {
                            this.handleException((Exception)((Object)e));
                        }
                    }
                }
            }
        }
    }

    public String getSQLHeader() {
        return this.formulaDoc.getText();
    }

    public String getSQL() {
        Parster parster = new Parster(this.getSQLHeader(), this.getBook());
        return parster.getSql();
    }

    private Book getBook() {
        ReportDesignerUI ui = (ReportDesignerUI)this.getUIContext().get("Owner");
        return ui.getBook();
    }

    public int isClearColumns() {
        if (this.clearColumnBtn.isSelected()) {
            return 1;
        }
        return 0;
    }

    public int isParamModel() {
        if (this.paramBox.isSelected()) {
            return 1;
        }
        return 0;
    }

    public int isShowField() {
        if (this.showFieldBox.isSelected()) {
            return 1;
        }
        return 0;
    }

    protected void f7listener() {
    }

    @Override
    protected void testBtn_actionPerformed(ActionEvent e) throws Exception {
        this.checkSQL(true);
    }

    void table_tableClicked(KDTMouseEvent e) {
    }

    private int countMatches(String str, String subStr) {
        if (str == null || str.length() == 0 || subStr == null || subStr.length() == 0) {
            return 0;
        }
        int count = 0;
        int index = 0;
        while ((index = str.indexOf(subStr, index)) != -1) {
            ++count;
            index += subStr.length();
        }
        return count;
    }

    private void checkContent(String value) {
        if (this.countMatches(value, ";") > 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.client.QuerySchemeResource", (String)"filter_content_Error"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)value)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.client.QuerySchemeResource", (String)"filter_notNull"));
            SysUtil.abort();
        }
    }

    private String getWithoutFieldContent(String value) {
        StringBuffer bf = new StringBuffer();
        bf.append("{");
        bf.append(value);
        bf.append("}");
        return bf.toString();
    }

    private String getWithFieldContent(String filter, DataTypeEnum dataType, String value) {
        StringBuffer bf = new StringBuffer();
        bf.append("{");
        bf.append(filter).append("|").append(dataType.getValue());
        bf.append("[");
        bf.append(value);
        bf.append("]");
        bf.append("}");
        return bf.toString();
    }

    public String getRowContent(IRow row) {
        if (row != null) {
            String value = (String)row.getCell("value").getValue();
            this.checkContent(value);
            DataTypeEnum dataType = (DataTypeEnum)((Object)row.getCell("dataType").getValue());
            String filter = (String)row.getCell("filter").getValue();
            if (StringUtils.isEmpty((String)filter)) {
                return this.getWithoutFieldContent(value);
            }
            return this.getWithFieldContent(filter, dataType, value);
        }
        return "";
    }

    private void checkSQL(boolean isBtnTest) {
        SqlResult obj = null;
        try {
            String sql = this.getSQL();
            if (sql != null) {
                SQLFormulaUtil.isSelectSql(sql);
                if (this.pmtDbCenter.getData() != null) {
                    DBCenterInfo dbCenter = this.getDBCenterInfo();
                    obj = SqlUtilFacadeFactory.getRemoteInstance().excuteQueryByDbCenter(dbCenter, sql, null);
                } else {
                    IFMIsqlFacade facade = FMIsqlFacadeFactory.getRemoteInstance();
                    obj = facade.executeSql(sql);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.client.QuerySchemeResource", (String)"sqlError"));
            SysUtil.abort();
        }
        catch (EASBizException e) {
            e.printStackTrace();
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.client.QuerySchemeResource", (String)"sqlError"));
            SysUtil.abort();
        }
        if (isBtnTest && obj != null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.client.QuerySchemeResource", (String)"testSuccess"));
        }
    }

    private DBCenterInfo getDBCenterInfo() {
        DBCenterInfo dbCenter = (DBCenterInfo)this.pmtDbCenter.getData();
        if (!StringUtils.isEmpty((String)dbCenter.getDbPassWord())) {
            String secret = new String(Base64.decode((String)dbCenter.getDbPassWord()));
            dbCenter.setDbPassWord(secret);
        }
        return dbCenter;
    }

    @Override
    public void cancelBtn_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    @Override
    protected void confirmBtn_actionPerformed(ActionEvent e) throws Exception {
        String sql = this.getSQL();
        if (sql != null && sql.trim().length() > 0) {
            SQLFormulaUtil.isSelectSql(sql);
            ReportDesignerUI ui = (ReportDesignerUI)this.getUIContext().get("Owner");
            Book b = ui.getBook();
            Sheet sheet = b.getActiveSheet();
            ICellEditor editor = this.stopSuperUIEditting(ui);
            Range range = sheet.getActiveCellRange();
            range.setFormula(this.createFormula());
            this.setSuperUIEditting(ui, editor);
            this.disposeUIWindow();
            logger.info((Object)"insert sql script to cell suceessfully");
            return;
        }
    }

    public String createFormula() {
        String formual = null;
        String dbCenterNumber = null;
        if (this.pmtDbCenter.getValue() != null) {
            dbCenterNumber = ((DBCenterInfo)this.pmtDbCenter.getValue()).getNumber();
            formual = "=executeSQL(\"" + this.getSQLHeader() + "#\",\"" + this.isShowField() + "#\",\"" + this.isClearColumns() + this.isParamModel() + "#\",\"" + this.titleText.getText() + "#\",\"" + dbCenterNumber + "\")";
        } else {
            formual = "=executeSQL(\"" + this.getSQLHeader() + "#\",\"" + this.isShowField() + "#\",\"" + this.isClearColumns() + this.isParamModel() + "#\",\"" + this.titleText.getText() + "\")";
        }
        return formual;
    }

    private ICellEditor stopSuperUIEditting(ReportDesignerUI ui) {
        ICellEditor edit = ui.getSpreadManager().getSpreadContainer().getEditManager().getCurrentEditor();
        if (edit != null) {
            edit.stopEditing();
        }
        return edit;
    }

    private void setSuperUIEditting(ReportDesignerUI ui, ICellEditor edit) {
        if (edit != null) {
            ui.getSpreadManager().getSpreadContainer().getEditManager().startEditing();
        }
    }

    private void rowInit(IRow row) {
        ICell boxCell = row.getCell("select");
        ICell dataType = row.getCell("dataType");
        KDComboBox comBox = new KDComboBox();
        comBox.addItems(DataTypeEnum.getEnumList().toArray());
        KDTDefaultCellEditor editorComBox = new KDTDefaultCellEditor((JComboBox)comBox);
        dataType.setEditor((com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor)editorComBox);
        dataType.setValue((Object)DataTypeEnum.string);
        KDCheckBox box = new KDCheckBox();
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JCheckBox)box);
        boxCell.setEditor((com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor)editor);
        boxCell.setValue((Object)Boolean.FALSE);
        KDBizPromptBox detailItemPromptBox = new KDBizPromptBox();
        DetailItemF7 selector = null;
        selector = new DetailItemF7((Object)this, detailItemPromptBox);
        detailItemPromptBox.setSelector((KDPromptSelector)selector);
        KDTDefaultCellEditor detailItemCellEditor = new KDTDefaultCellEditor((IKDEditor)detailItemPromptBox);
        row.getCell("value").setEditor((com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor)detailItemCellEditor);
    }

    protected void deleteBtn_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void insertBtn_actionPerformed(ActionEvent e) throws Exception {
    }
}

