/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.fi.rpt.FormulaMoveTool;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class TableDragFiller {
    private static final Logger logger = Logger.getLogger(TableDragFiller.class);

    private static boolean checkIsLocked(KDTable currTable) {
        int activeRow = currTable.getSelectManager().getActiveRowIndex();
        int activeCol = currTable.getSelectManager().getActiveColumnIndex();
        Iterator iter = currTable.getSelectManager().getBlocks().iterator();
        KDTSelectBlock block = null;
        int left = -1;
        int right = -1;
        int top = -1;
        int bottom = -1;
        while (iter.hasNext()) {
            block = (KDTSelectBlock)iter.next();
            left = block.getLeft();
            right = block.getRight();
            top = block.getTop();
            bottom = block.getBottom();
            if (activeRow < top || activeRow > bottom || activeCol < left || activeCol > right) continue;
        }
        for (int i = left; i <= right; ++i) {
            for (int j = top; j <= bottom; ++j) {
                if (!currTable.getCell(j, i).getStyle().isLocked()) continue;
                MsgBox.showInfo((Component)currTable, (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"EXCEL_LOCKED"));
                return true;
            }
        }
        return false;
    }

    static void drag(KDTable currTable, boolean isFomulaState) {
        if (TableDragFiller.checkIsLocked(currTable)) {
            return;
        }
        try {
            int activeCol;
            if (!isFomulaState) {
                TableDragFiller.fillData(currTable);
                return;
            }
            int activeRow = currTable.getSelectManager().getActiveRowIndex();
            String formulaStr = currTable.getCell(activeRow, activeCol = currTable.getSelectManager().getActiveColumnIndex()).getExpressions();
            if (formulaStr == null || !formulaStr.trim().startsWith("=")) {
                TableDragFiller.fillData(currTable);
                return;
            }
            Iterator iter = currTable.getSelectManager().getBlocks().iterator();
            KDTSelectBlock block = null;
            int left = -1;
            int right = -1;
            int top = -1;
            int bottom = -1;
            while (iter.hasNext()) {
                block = (KDTSelectBlock)iter.next();
                left = block.getLeft();
                right = block.getRight();
                top = block.getTop();
                bottom = block.getBottom();
                if (activeRow < top || activeRow > bottom || activeCol < left || activeCol > right) continue;
            }
            if (activeCol == left && activeRow == top) {
                int currenctCol;
                FormulaMoveTool formulaMoveTool = new FormulaMoveTool(formulaStr);
                for (currenctCol = left + 1; currenctCol <= right; ++currenctCol) {
                    currTable.getCell(top, currenctCol).setExpressions("=" + formulaMoveTool.moveRight());
                }
                for (currenctCol = left; currenctCol <= right; ++currenctCol) {
                    String formula = currTable.getCell(top, currenctCol).getExpressions();
                    FormulaMoveTool formulaMoveTool2 = new FormulaMoveTool(formula);
                    for (int currenctRow = top + 1; currenctRow <= bottom; ++currenctRow) {
                        currTable.getCell(currenctRow, currenctCol).setExpressions("=" + formulaMoveTool2.moveDown());
                    }
                }
            } else if (activeCol == left && activeRow == bottom) {
                int currenctCol;
                FormulaMoveTool formulaMoveTool = new FormulaMoveTool(formulaStr);
                for (currenctCol = left + 1; currenctCol <= right; ++currenctCol) {
                    currTable.getCell(bottom, currenctCol).setExpressions("=" + formulaMoveTool.moveRight());
                }
                for (currenctCol = left; currenctCol <= right; ++currenctCol) {
                    String formula = currTable.getCell(bottom, currenctCol).getExpressions();
                    formulaMoveTool = new FormulaMoveTool(formula);
                    for (int currenctRow = bottom - 1; currenctRow >= top; --currenctRow) {
                        currTable.getCell(currenctRow, currenctCol).setExpressions("=" + formulaMoveTool.moveUp());
                    }
                }
            } else if (activeCol == right && activeRow == top) {
                int currenctCol;
                FormulaMoveTool formulaMoveTool = new FormulaMoveTool(formulaStr);
                for (currenctCol = right - 1; currenctCol >= left; --currenctCol) {
                    currTable.getCell(top, currenctCol).setExpressions("=" + formulaMoveTool.moveLeft());
                }
                for (currenctCol = left; currenctCol <= right; ++currenctCol) {
                    String formula = currTable.getCell(top, currenctCol).getExpressions();
                    formulaMoveTool = new FormulaMoveTool(formula);
                    for (int currenctRow = top + 1; currenctRow <= bottom; ++currenctRow) {
                        currTable.getCell(currenctRow, currenctCol).setExpressions("=" + formulaMoveTool.moveDown());
                    }
                }
            } else if (activeCol == right && activeRow == bottom) {
                int currenctCol;
                FormulaMoveTool formulaMoveTool = new FormulaMoveTool(formulaStr);
                for (currenctCol = right - 1; currenctCol >= left; --currenctCol) {
                    currTable.getCell(bottom, currenctCol).setExpressions("=" + formulaMoveTool.moveLeft());
                }
                for (currenctCol = left; currenctCol <= right; ++currenctCol) {
                    String formula = currTable.getCell(bottom, currenctCol).getExpressions();
                    formulaMoveTool = new FormulaMoveTool(formula);
                    for (int currenctRow = bottom - 1; currenctRow >= top; --currenctRow) {
                        currTable.getCell(currenctRow, currenctCol).setExpressions("=" + formulaMoveTool.moveUp());
                    }
                }
            }
        }
        catch (Exception ee) {
            logger.debug((Object)ee);
        }
    }

    private static void fillData(KDTable currTable) {
        block43: {
            int currenctCol;
            String tempStr;
            int afterDotBit;
            int iValue;
            BigDecimal dValue;
            BigDecimal dIncrement;
            boolean isInteger;
            int bottom;
            int top;
            int right;
            int left;
            int activeCol;
            int activeRow;
            block45: {
                int currenctCol2;
                block44: {
                    int currenctCol3;
                    block42: {
                        int currenctCol4;
                        activeRow = currTable.getSelectManager().getActiveRowIndex();
                        if (currTable.getCell(activeRow, activeCol = currTable.getSelectManager().getActiveColumnIndex()).getValue() == null) {
                            return;
                        }
                        String value = currTable.getCell(activeRow, activeCol).getValue().toString();
                        if (value == null || !TableDragFiller.isNumber(value)) {
                            return;
                        }
                        Iterator iter = currTable.getSelectManager().getBlocks().iterator();
                        KDTSelectBlock block = null;
                        left = -1;
                        right = -1;
                        top = -1;
                        bottom = -1;
                        while (iter.hasNext()) {
                            block = (KDTSelectBlock)iter.next();
                            left = block.getLeft();
                            right = block.getRight();
                            top = block.getTop();
                            bottom = block.getBottom();
                            if (activeRow < top || activeRow > bottom || activeCol < left || activeCol > right) continue;
                        }
                        isInteger = false;
                        dIncrement = new BigDecimal("1");
                        dValue = new BigDecimal("0");
                        iValue = 0;
                        BigDecimal zDotOne = new BigDecimal("0.1");
                        afterDotBit = 0;
                        if (value.indexOf(46) == -1) {
                            isInteger = true;
                            iValue = Integer.parseInt(value);
                        } else {
                            isInteger = false;
                            dValue = new BigDecimal(value);
                            afterDotBit = value.length() - value.indexOf(46) - 1;
                            for (int i = 0; i < afterDotBit; ++i) {
                                dIncrement = dIncrement.multiply(zDotOne);
                            }
                        }
                        tempStr = null;
                        if (activeCol != left || activeRow != top) break block42;
                        for (currenctCol4 = left + 1; currenctCol4 <= right; ++currenctCol4) {
                            if (isInteger) {
                                tempStr = Integer.toString(++iValue);
                            } else {
                                dValue = dValue.add(dIncrement);
                                dValue = dValue.setScale(afterDotBit);
                                tempStr = dValue.toString();
                            }
                            currTable.getCell(top, currenctCol4).setValue((Object)tempStr);
                        }
                        for (currenctCol4 = left; currenctCol4 <= right; ++currenctCol4) {
                            String value2 = currTable.getCell(top, currenctCol4).getValue().toString();
                            if (isInteger) {
                                iValue = Integer.parseInt(value2);
                            } else {
                                dValue = new BigDecimal(value2);
                            }
                            for (int currenctRow = top + 1; currenctRow <= bottom; ++currenctRow) {
                                if (isInteger) {
                                    tempStr = Integer.toString(++iValue);
                                } else {
                                    dValue = dValue.add(dIncrement);
                                    dValue = dValue.setScale(afterDotBit);
                                    tempStr = dValue.toString();
                                }
                                currTable.getCell(currenctRow, currenctCol4).setValue((Object)tempStr);
                            }
                        }
                        break block43;
                    }
                    if (activeCol != left || activeRow != bottom) break block44;
                    for (currenctCol3 = left + 1; currenctCol3 <= right; ++currenctCol3) {
                        if (isInteger) {
                            tempStr = Integer.toString(++iValue);
                        } else {
                            dValue = dValue.add(dIncrement);
                            dValue = dValue.setScale(afterDotBit);
                            tempStr = dValue.toString();
                        }
                        currTable.getCell(bottom, currenctCol3).setValue((Object)tempStr);
                    }
                    for (currenctCol3 = left; currenctCol3 <= right; ++currenctCol3) {
                        String value2 = currTable.getCell(bottom, currenctCol3).getValue().toString();
                        if (isInteger) {
                            iValue = Integer.parseInt(value2);
                        } else {
                            dValue = new BigDecimal(value2);
                        }
                        for (int currenctRow = bottom - 1; currenctRow >= top; --currenctRow) {
                            if (isInteger) {
                                tempStr = Integer.toString(--iValue);
                            } else {
                                dValue = dValue.subtract(dIncrement);
                                dValue = dValue.setScale(afterDotBit);
                                tempStr = dValue.toString();
                            }
                            currTable.getCell(currenctRow, currenctCol3).setValue((Object)tempStr);
                        }
                    }
                    break block43;
                }
                if (activeCol != right || activeRow != top) break block45;
                for (currenctCol2 = right - 1; currenctCol2 >= left; --currenctCol2) {
                    if (isInteger) {
                        tempStr = Integer.toString(--iValue);
                    } else {
                        dValue = dValue.subtract(dIncrement);
                        dValue = dValue.setScale(afterDotBit);
                        tempStr = dValue.toString();
                    }
                    currTable.getCell(top, currenctCol2).setValue((Object)tempStr);
                }
                for (currenctCol2 = left; currenctCol2 <= right; ++currenctCol2) {
                    String value2 = currTable.getCell(top, currenctCol2).getValue().toString();
                    if (isInteger) {
                        iValue = Integer.parseInt(value2);
                    } else {
                        dValue = new BigDecimal(value2);
                    }
                    for (int currenctRow = top + 1; currenctRow <= bottom; ++currenctRow) {
                        if (isInteger) {
                            tempStr = Integer.toString(++iValue);
                        } else {
                            dValue = dValue.add(dIncrement);
                            dValue = dValue.setScale(afterDotBit);
                            tempStr = dValue.toString();
                        }
                        currTable.getCell(currenctRow, currenctCol2).setValue((Object)tempStr);
                    }
                }
                break block43;
            }
            if (activeCol != right || activeRow != bottom) break block43;
            for (currenctCol = right - 1; currenctCol >= left; --currenctCol) {
                if (isInteger) {
                    tempStr = Integer.toString(--iValue);
                } else {
                    dValue = dValue.subtract(dIncrement);
                    dValue = dValue.setScale(afterDotBit);
                    tempStr = dValue.toString();
                }
                currTable.getCell(bottom, currenctCol).setValue((Object)tempStr);
            }
            for (currenctCol = left; currenctCol <= right; ++currenctCol) {
                String value2 = currTable.getCell(bottom, currenctCol).getValue().toString();
                if (isInteger) {
                    iValue = Integer.parseInt(value2);
                } else {
                    dValue = new BigDecimal(value2);
                }
                for (int currenctRow = bottom - 1; currenctRow >= top; --currenctRow) {
                    if (isInteger) {
                        tempStr = Integer.toString(--iValue);
                    } else {
                        dValue = dValue.subtract(dIncrement);
                        dValue = dValue.setScale(afterDotBit);
                        tempStr = dValue.toString();
                    }
                    currTable.getCell(currenctRow, currenctCol).setValue((Object)tempStr);
                }
            }
        }
    }

    private static boolean isNumber(String str) {
        try {
            Double.parseDouble(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

