/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluFactory;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluInfo;
import com.kingdee.eas.fi.newrpt.formulasolu.client.FormulaSolutionProcessUI;
import com.kingdee.eas.fi.rpt.ITemplate;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.client.AbstractTemplateListUI;
import com.kingdee.eas.fi.rpt.client.RptHelper;
import com.kingdee.eas.fi.rpt.client.TempReportProcessUI;
import com.kingdee.eas.fi.rpt.client.TemplateEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.SwingUtilities;

public class TemplateListUI
extends AbstractTemplateListUI {
    String selectTemplate = null;

    public TemplateListUI() throws Exception {
        this.setPreferredSize(new Dimension(600, 400));
        this.afterDataFill();
    }

    public String getUITitle() {
        String strTitle = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.History_Edition");
        return strTitle;
    }

    @Override
    public void initUIToolBarLayout() {
        this.toolBar.add((Component)this.btnView);
        this.toolBar.add((Component)this.btnPrint);
        this.toolBar.add((Component)this.btnPrintPreview);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        UIContext uiContext = new UIContext((Object)this);
        if (FormulaSoluFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(id))) {
            FormulaSoluInfo formulaSolu = FormulaSoluFactory.getRemoteInstance().getFormulaSoluInfo((IObjectPK)new ObjectUuidPK(id));
            String tmplId = formulaSolu.getTemplateId();
            uiContext.put((Object)"ID", (Object)tmplId);
            uiContext.put((Object)"openTemplate", (Object)Boolean.TRUE);
            uiContext.put((Object)"formulaSoluid", (Object)id);
            final IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(FormulaSolutionProcessUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    window.show();
                }
            });
        } else {
            uiContext.put((Object)"ID", (Object)id);
            this.prepareUIContext(uiContext, e);
            uiContext.put((Object)"actionHisTemplate", this.getUIContext().get("actionHisTemplate"));
            IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(TempReportProcessUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    protected String getEditUIName() {
        return TemplateEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TemplateFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "Template.id";
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        try {
            ITemplate iTemplate = TemplateFactory.getRemoteInstance();
            TemplateInfo tempalteInfo = iTemplate.getTemplateInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.selectTemplate)));
            if (tempalteInfo == null) {
                return;
            }
            if (tempalteInfo.getTemplateSource().getValue() == 0) {
                Set oldVersionGroupSet = this.getOldVersionGroupSet(tempalteInfo);
                if (oldVersionGroupSet.size() == 0) {
                    oldVersionGroupSet.add("111111111111111111111111111=");
                }
                if (this.mainQuery != null) {
                    FilterInfo filter = new FilterInfo();
                    FilterItemInfo filterItem = new FilterItemInfo("id", (Object)oldVersionGroupSet, CompareType.INCLUDE);
                    filter.getFilterItems().add(filterItem);
                    this.mainQuery.setFilter(filter);
                }
                this.mainQuery.getSorter().add(new SorterItemInfo("versionNumber"));
                super.tblMain_doRequestRowSet(e);
            } else {
                Map returnMap = FormulaSoluFactory.getRemoteInstance().getHisGradeTmpl(this.selectTemplate);
                if (returnMap != null && !returnMap.isEmpty()) {
                    IRowSet rowSet = (IRowSet)returnMap.get("rowSet");
                    e.setRowSet(rowSet);
                    this.onGetRowSet(rowSet);
                }
            }
        }
        catch (Exception ee) {
            this.handUIException(ee);
        }
    }

    private Set getOldVersionGroupSet(TemplateInfo template) throws BOSException {
        Set superCompanyIDs;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("group", (Object)template.getGroup());
        FilterItemInfo filterItem1 = new FilterItemInfo("versionNumber", (Object)template.getVersionNumber().trim(), CompareType.NOTEQUALS);
        filter.getFilterItems().add(filterItem);
        filter.getFilterItems().add(filterItem1);
        String companyID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID));
        if (template.getTemplateType() == RptTmpTypeEnum.GROUPREPORT || template.getTemplateType() == RptTmpTypeEnum.GROUPCOMMREPORT || template.getTemplateType() == RptTmpTypeEnum.DYNAMICNORMALREPORT || template.getTemplateType() == RptTmpTypeEnum.RPTDYNAMICREPORT || template.getTemplateType() == RptTmpTypeEnum.MULTIRPTDYNAMICREPORT || template.getTemplateType() == RptTmpTypeEnum.MULTIDYNAMICCSLREPORT) {
            filter.getFilterItems().add(new FilterItemInfo("templateType", (Object)new Integer(6)));
            filter.getFilterItems().add(new FilterItemInfo("templateType", (Object)new Integer(10)));
            filter.getFilterItems().add(new FilterItemInfo("templateType", (Object)new Integer(12)));
            filter.getFilterItems().add(new FilterItemInfo("templateType", (Object)new Integer(16)));
            filter.getFilterItems().add(new FilterItemInfo("templateType", (Object)new Integer(15)));
            filter.getFilterItems().add(new FilterItemInfo("versionStatus", (Object)new Integer(0), CompareType.GREATER));
            filter.setMaskString("#0 and #1 and (#2 or ((#3 or #4 or #5 or #6 or #7) and #8))");
        } else if (RptTmpTypeEnum.COMMONPUBLICTEMPLATE.equals((Object)template.getTemplateType())) {
            filter.getFilterItems().add(new FilterItemInfo("templateType", (Object)new Integer(14)));
            filter.getFilterItems().add(new FilterItemInfo("versionStatus", (Object)new Integer(0), CompareType.GREATER));
            superCompanyIDs = TemplateFactory.getRemoteInstance().getSuperCompanyIDs();
            superCompanyIDs.add(companyID);
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)superCompanyIDs, CompareType.INCLUDE));
            filter.setMaskString("#0 and #1 and (#2 or (#3 and #4 and #5))");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("templateType", (Object)new Integer(14)));
            superCompanyIDs = TemplateFactory.getRemoteInstance().getSuperCompanyIDs();
            superCompanyIDs.add(companyID);
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)superCompanyIDs, CompareType.INCLUDE));
            filter.setMaskString("#0 and #1 and ( #2 or ( #3 and #4 ) ) ");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().clear();
        view.getSelector().add("id");
        view.getSelector().add("versionNumber");
        view.setFilter(filter);
        TemplateCollection templates = TemplateFactory.getRemoteInstance().getTemplateCollection(view);
        HashSet<String> result = new HashSet<String>();
        Iterator iterator = templates.iterator();
        while (iterator.hasNext()) {
            String[] oldVersion;
            TemplateInfo oldTemplateInfo = (TemplateInfo)iterator.next();
            String[] newVersion = template.getVersionNumber().split("\\.");
            int count = newVersion.length < (oldVersion = oldTemplateInfo.getVersionNumber().split("\\.")).length ? newVersion.length : oldVersion.length;
            boolean isAddToSet = false;
            for (int i = 0; i < count; ++i) {
                int oldV;
                int newV = Integer.parseInt(newVersion[i]);
                if (newV > (oldV = Integer.parseInt(oldVersion[i]))) {
                    isAddToSet = true;
                    break;
                }
                if (newV == oldV) {
                    if (i != count - 1) continue;
                    if (newVersion.length > oldVersion.length) {
                        isAddToSet = true;
                        break;
                    }
                    isAddToSet = false;
                    break;
                }
                isAddToSet = false;
                break;
            }
            if (!isAddToSet) continue;
            result.add(oldTemplateInfo.getId().toString());
        }
        return result;
    }

    public void onLoad() throws Exception {
        Boolean isCommSerach;
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        super.onLoad();
        this.tblMain.checkParsed();
        this.getUIMenuBar().setVisible(false);
        this.tblMain.getColumn(0).getStyleAttributes().setHided(true);
        if (this.getUIContext().get("ID") != null) {
            this.selectTemplate = this.getUIContext().get("ID").toString();
        }
        if ((isCommSerach = (Boolean)this.getUIContext().get("isCommSerach")) != null && isCommSerach.booleanValue()) {
            CommonQueryDialog tempComm = new CommonQueryDialog();
            tempComm.setOwner((Component)((Object)this));
            tempComm.setParentUIClassName("com.kingdee.eas.fi.rpt.client.TemplateListUI");
            tempComm.setQueryObjectPK(this.mainQueryPK);
            tempComm.setShowFilter(true);
            tempComm.setShowSorter(true);
            tempComm.setShowToolbar(true);
            tempComm.show();
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        RptHelper.setEscAction((CoreUIObject)this, (Action)this.actionExitCurrent);
        this.tblMain.getActionMap().remove("CancelEdit");
    }

    private void afterDataFill() {
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int templateSource = 0;
                try {
                    templateSource = TemplateListUI.this.getTemplateSourceValue();
                }
                catch (Exception e1) {
                    TemplateListUI.this.handUIException(e1);
                }
                if (templateSource == 0) {
                    TemplateListUI.this.setGroupTmplAfterFill(e);
                } else {
                    TemplateListUI.this.setGradeTmplAfterFill(e);
                }
            }
        });
    }

    private void setGroupTmplAfterFill(KDTDataRequestEvent e) {
        int end = e.getLastRow();
        for (int start = e.getFirstRow(); start <= end; ++start) {
            ICell cell = this.tblMain.getRow(start).getCell("Template.templateType");
            if (cell == null) continue;
            Object value = cell.getValue();
            Object newValue = null;
            if (value instanceof Number) {
                Number v = (Number)cell.getValue();
                if (v.intValue() == 6) {
                    newValue = new Integer(2);
                } else if (v.intValue() == 10) {
                    newValue = new Integer(12);
                } else if (v.intValue() == 15) {
                    newValue = new Integer(16);
                }
            } else if (value instanceof RptTmpTypeEnum) {
                RptTmpTypeEnum templateType = (RptTmpTypeEnum)((Object)value);
                if (templateType == RptTmpTypeEnum.GROUPCOMMREPORT) {
                    newValue = RptTmpTypeEnum.GROUPREPORT;
                } else if (templateType == RptTmpTypeEnum.DYNAMICNORMALREPORT) {
                    newValue = RptTmpTypeEnum.RPTDYNAMICREPORT;
                } else if (templateType == RptTmpTypeEnum.MULTIDYNAMICCSLREPORT) {
                    newValue = RptTmpTypeEnum.MULTIRPTDYNAMICREPORT;
                }
            } else if (RptTmpTypeEnum.GROUPCOMMREPORT.getAlias(TemplateListUI.getDefaultLocale()).equals(value.toString())) {
                newValue = RptTmpTypeEnum.GROUPREPORT;
            } else if (RptTmpTypeEnum.DYNAMICNORMALREPORT.getAlias(TemplateListUI.getDefaultLocale()).equals(value.toString())) {
                newValue = RptTmpTypeEnum.RPTDYNAMICREPORT;
            } else if (RptTmpTypeEnum.MULTIDYNAMICCSLREPORT.getAlias(TemplateListUI.getDefaultLocale()).equals(value.toString())) {
                newValue = RptTmpTypeEnum.MULTIRPTDYNAMICREPORT;
            }
            cell.setValue(newValue == null ? value : newValue);
        }
    }

    private void setGradeTmplAfterFill(KDTDataRequestEvent e) {
        int end = e.getLastRow();
        for (int start = e.getFirstRow(); start <= end; ++start) {
            Number v;
            ICell cell = this.tblMain.getRow(start).getCell("Template.periodType");
            if (cell == null) continue;
            Object value = cell.getValue();
            if (value instanceof Number) {
                v = (Number)cell.getValue();
                int periodTypeInt = v.intValue();
                String periodType = RptPeriodTypeEnum.getEnum((int)periodTypeInt).getAlias();
                cell.setValue((Object)periodType);
            }
            if ((cell = this.tblMain.getRow(start).getCell("Template.templateType")) == null || !((value = cell.getValue()) instanceof Number)) continue;
            v = (Number)cell.getValue();
            String tmplType = null;
            tmplType = v.intValue() == 6 ? RptTmpTypeEnum.GROUPREPORT.getAlias() : (v.intValue() == 10 ? RptTmpTypeEnum.RPTDYNAMICREPORT.getAlias() : (v.intValue() == 15 ? RptTmpTypeEnum.MULTIRPTDYNAMICREPORT.getAlias() : RptTmpTypeEnum.getEnum(v.intValue()).getAlias()));
            cell.setValue((Object)tmplType);
        }
    }

    private int getTemplateSourceValue() throws Exception {
        ITemplate iTemplate = TemplateFactory.getRemoteInstance();
        TemplateInfo tempalteInfo = iTemplate.getTemplateInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.selectTemplate)));
        if (tempalteInfo != null) {
            return tempalteInfo.getTemplateSource().getValue();
        }
        return 0;
    }
}

