/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client.iref;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.fi.rpt.batch.iref.AsstItemTypeCache;
import com.kingdee.eas.fi.rpt.batch.iref.DateUtils;
import com.kingdee.eas.fi.rpt.client.FormulaWizardUI;
import com.kingdee.eas.fi.rpt.client.IItemObject;
import com.kingdee.eas.fi.rpt.client.IRptFormulaComboBoxInductorHint;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.List;

public class FormulaIRefComboBoxHint
implements IRptFormulaComboBoxInductorHint {
    public void setCustomConfig(KDComboBox cmb) {
        final FormulaWizardUI owner = (FormulaWizardUI)cmb.getUserObject();
        List<IItemObject> items = FormulaIRefComboBoxHint.loadAsstItemTypeDatas(owner, true);
        if (items != null) {
            cmb.addItems(items.toArray());
        }
        cmb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    owner.setParam("asstItem", null);
                }
            }
        });
    }

    protected static List<IItemObject> loadAsstItemTypeDatas(FormulaWizardUI owner, boolean firstLoad) {
        String companyNum = owner.getParam("orgnumber");
        if (StringUtils.isEmpty((String)companyNum)) {
            companyNum = owner.getRptCompanyNumber();
        }
        int periodType = 3;
        int year = -1;
        int period = -1;
        if (owner.getRptContext() != null && owner.getRptContext().getPropertyAdapter() != null) {
            try {
                periodType = (Integer)owner.getRptContext().getPropertyAdapter().getReportProperty("PeriodType");
                year = (Integer)owner.getRptContext().getPropertyAdapter().getReportProperty("Report.Year");
                period = (Integer)owner.getRptContext().getPropertyAdapter().getReportProperty("Report.Period");
            }
            catch (Exception e) {
                year = -1;
                period = -1;
                periodType = 3;
            }
        }
        String startDateStr = owner.getParam("startDate");
        String endDateStr = owner.getParam("endDate");
        Date startDate = DateUtils.getStartDate(periodType, year, period, startDateStr);
        Date endDate = DateUtils.getEndDate(periodType, year, period, endDateStr);
        OrgType orgType = owner.getRptOrgType();
        AsstItemTypeCache.CacheKey key = new AsstItemTypeCache.CacheKey(startDate, endDate, companyNum, orgType);
        if (!firstLoad && AsstItemTypeCache.getInstance().hasInCache(key)) {
            return null;
        }
        List<IItemObject> items = null;
        try {
            items = AsstItemTypeCache.getInstance().getAsstItemTypeList(key);
        }
        catch (Exception e) {
            MsgBox.showDetailAndOK((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"IRef_HappenErrorBecauseGetAsstType"), (String)e.getMessage(), (int)2);
            SysUtil.abort((Throwable)e);
        }
        return items;
    }
}

