/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client.report;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.IsSupportGroupReportEnum;
import com.kingdee.eas.fi.rpt.PublicStatusEnum;
import com.kingdee.eas.fi.rpt.PublishedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import java.math.BigDecimal;

public class ReportProvider
extends IBookProvider {
    public ReportProvider() {
    }

    public ReportProvider(ReportInfo rpt) {
        this.setEditValue((IObjectValue)rpt);
    }

    public Book loadBook() throws Exception {
        Book book = null;
        if (this.getReportInfo().getData() != null) {
            book = this.getReportInfo().getCatchBook();
        }
        if (book == null) {
            return null;
        }
        RptUtilForClient.prepareReportInfo4Display((IObjectValue)this.getReportInfo(), book);
        return book;
    }

    private ReportInfo createNewData() throws EASBizException, BOSException {
        ReportInfo reportInfo = this.getReportInfo();
        if (reportInfo == null) {
            reportInfo = new ReportInfo();
        }
        reportInfo.setPeriodType(RptPeriodTypeEnum.MONTHLY);
        reportInfo.setPublicStatus(PublicStatusEnum.PUBLIC);
        reportInfo.setSourceType(RptSrcTypeEnum.NORMAL);
        reportInfo.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
        reportInfo.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        reportInfo.setCommittedStatus(CommittedStatusEnum.UNCOMMITTED);
        reportInfo.setCompany(RptUtilForClient.getCurrentCompany());
        reportInfo.setExchangeRate(new BigDecimal("1"));
        reportInfo.setIsSupportGroup(IsSupportGroupReportEnum.NOTSUPPORT);
        if (reportInfo.getId() == null) {
            reportInfo.setId(BOSUuid.create((BOSObjectType)reportInfo.getBOSType()));
        }
        return reportInfo;
    }

    public boolean saveSpread(Book rpt) throws Exception {
        if (this.getReportInfo().getId() == null) {
            this.getReportInfo().setId(BOSUuid.create((BOSObjectType)this.getReportInfo().getBOSType()));
        }
        this.getReportInfo().setBook(rpt);
        ICoreBase bizInterface = this.getBizInterface();
        bizInterface.save((CoreBaseInfo)this.getReportInfo());
        this.setEditValue((IObjectValue)((IReport)bizInterface).getReportInfo((IObjectPK)new ObjectUuidPK(this.getReportInfo().getId()), this.getSelectors()));
        return true;
    }

    public void audit() throws Exception {
        ObjectStringPK pk = new ObjectStringPK();
        pk.setKeyValue(this.getReportInfo().getPKField(), (Object)this.getReportInfo().getId().toString());
        if (this.getReportInfo().getAuditedStatus() == AuditedStatusEnum.AUDITED) {
            ((IReport)this.getBizInterface()).unAudit((IObjectPK)pk);
        } else {
            ((IReport)this.getBizInterface()).audit((IObjectPK)pk);
        }
        IObjectValue vo = super.queryEditData((IObjectPK)pk);
        this.setEditValue(vo);
    }

    public void saveas(ReportInfo reportInfo) throws Exception {
        ReportInfo editData = reportInfo;
        editData.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        editData.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
        editData.setAuditor(null);
        editData.setAuditTime(null);
        editData.setId(null);
        editData.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        editData.setCommitTime(null);
        editData.setCreateTime(null);
        editData.setIsSupportGroup(IsSupportGroupReportEnum.NOTSUPPORT);
        editData.setCommittedStatus(CommittedStatusEnum.UNCOMMITTED);
        editData.setCslReport(null);
        IObjectPK pk = ((IReport)this.getBizInterface()).submit((CoreBaseInfo)editData);
        this.setEditValue((IObjectValue)((IReport)this.getBizInterface()).getReportInfo(pk, this.getSelectors()));
    }

    public ReportInfo getReportInfo() {
        return (ReportInfo)this.getEditValue();
    }

    public IObjectValue createNewReport() throws EASBizException, BOSException {
        return this.createNewData();
    }

    public ICoreBase getBizInterface() throws Exception {
        return ReportFactory.getRemoteInstance();
    }

    public void restoreBook(Book book) throws Exception {
        RptUtilForClient.prepareReportInfo4Save((IObjectValue)this.getReportInfo(), book);
        this.getReportInfo().setBook(book);
    }

    public IObjectValue queryEditData(IObjectPK pk) throws Exception {
        IObjectValue o = super.queryEditData(pk);
        ReportInfo r = (ReportInfo)o;
        if (RptSrcTypeEnum.COMMOMSUM.equals((Object)r.getSourceType())) {
            r.setSubReport(((IReport)this.getBizInterface()).getSubReport(BOSUuid.read((String)pk.toString())));
        }
        return o;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.longnumber"));
        sic.add(new SelectorItemInfo("company.accountPeriodType"));
        sic.add(new SelectorItemInfo("company.accountTable"));
        sic.add(new SelectorItemInfo("company.baseCurrency"));
        sic.add(new SelectorItemInfo("company.isBizUnit"));
        sic.add(new SelectorItemInfo("company.cu"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("sourceCurrency.id"));
        sic.add(new SelectorItemInfo("sourceCurrency.name"));
        sic.add(new SelectorItemInfo("sourceCurrency.number"));
        sic.add(new SelectorItemInfo("sourceCurrency.precision"));
        sic.add(new SelectorItemInfo("orgRela.id"));
        sic.add(new SelectorItemInfo("orgRela.orgType"));
        sic.add(new SelectorItemInfo("orgRela.relaType"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.sheet.sheetid"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("postils.LastUpdateUser.id"));
        sic.add(new SelectorItemInfo("postils.LastUpdateUser.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.number"));
        sic.add(new SelectorItemInfo("savePoint.rptType.company.id"));
        sic.add(new SelectorItemInfo("savePoint.relaType"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.number"));
        sic.add(new SelectorItemInfo("savePoint.rptType.rptTypeStd"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgType"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.precision"));
        sic.add(new SelectorItemInfo("sheetParam.postils.*"));
        sic.add(new SelectorItemInfo("sheetParam.postils.report.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.sheet.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.name"));
        sic.add(new SelectorItemInfo("sheetParam.postils.LastUpdateUser.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.LastUpdateUser.name"));
        sic.add(new SelectorItemInfo("template.id"));
        sic.add(new SelectorItemInfo("template.name"));
        sic.add(new SelectorItemInfo("template.number"));
        sic.add(new SelectorItemInfo("template.templateType"));
        sic.add(new SelectorItemInfo("template.DynaRpttype"));
        sic.add(new SelectorItemInfo("template.group"));
        sic.add(new SelectorItemInfo("template.currency.number"));
        sic.add(new SelectorItemInfo("template.currency.id"));
        sic.add(new SelectorItemInfo("template.versionNumber"));
        sic.add(new SelectorItemInfo("k3Template.group"));
        sic.add(new SelectorItemInfo("template.checkOpenPeriod"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("auditor.number"));
        sic.add(new SelectorItemInfo("cslReport.id"));
        sic.add(new SelectorItemInfo("LastUpdateUser.Name"));
        sic.add(new SelectorItemInfo("LastUpdateUser.Number"));
        sic.add(new SelectorItemInfo("savePoint.rptType.company.id"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("LastUpdateUser.Name"));
        sic.add(new SelectorItemInfo("LastUpdateUser.Number"));
        sic.add(new SelectorItemInfo("datacollect.id"));
        sic.add(new SelectorItemInfo("datacollect.number"));
        sic.add(new SelectorItemInfo("dataCollectNumber"));
        sic.add(new SelectorItemInfo("template.includeOtherDC"));
        sic.add(new SelectorItemInfo("cslReport.commitor.id"));
        return sic;
    }

    public String getBizFactoryName() {
        return TemplateFactory.class.getName();
    }
}

