/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.excelformula;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaParser;
import com.kingdee.eas.fi.rpt.excelformula.IBreakableExpressionHandler;
import com.kingdee.eas.fi.rpt.excelformula.IEditableExpressionHandler;
import com.kingdee.eas.fi.rpt.excelformula.IExpressionHandler;
import com.kingdee.eas.fi.rpt.excelformula.Parse2RPN;
import com.kingdee.eas.fi.rpt.excelformula.RptFormula;
import com.kingdee.eas.fi.rpt.excelformula.RptFormulaComp;
import com.kingdee.eas.fi.rpt.excelformula.expr.Area3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.AreaExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Ref3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.ReferenceExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ExcelFormulaPaserHelper {
    private static final Logger logger = Logger.getLogger(ExcelFormulaPaserHelper.class);
    public static Map<String, Object> easFormuls = new HashMap<String, Object>();
    private static String pattern = "\b*[\\+|\\-]?\b*(\\w+)\\(*.*?\\)*";
    private static Pattern p = Pattern.compile(pattern);
    private static Pattern formulaP = null;

    public static Expression parse(String line) throws Exception {
        if (line != null && line.trim().length() > 0 && line.charAt(0) == '=') {
            line = line.substring(1);
        }
        Parse2RPN p = new Parse2RPN(line);
        p.parse();
        ExcelFormulaParser fp = new ExcelFormulaParser(p.getTokens());
        return fp.parse();
    }

    public static FunctionExpr getOuterLastFunction(String line) throws Exception {
        if (line != null && line.trim().length() > 0 && line.charAt(0) == '=') {
            line = line.substring(1);
        }
        Expression ex = ExcelFormulaPaserHelper.parse(line);
        return ExcelFormulaPaserHelper.getOuterLastFunction(ex);
    }

    public static FunctionExpr getOuterLastFunction(Expression ex) throws Exception {
        return (FunctionExpr)ExcelFormulaPaserHelper.walkToLast(ex);
    }

    private static Expression walkToLast(Expression ex) {
        if (ex instanceof FunctionExpr) {
            return ex;
        }
        if (ex instanceof BinaryOperationExpr) {
            Expression expression = ((BinaryOperationExpr)ex).right;
            return ExcelFormulaPaserHelper.walkToLast(expression);
        }
        return null;
    }

    public static void walk(Expression exp, IExpressionHandler handler) {
        handler.handle(exp);
        if (exp instanceof BinaryOperationExpr) {
            ExcelFormulaPaserHelper.walk(((BinaryOperationExpr)exp).left, handler);
            ExcelFormulaPaserHelper.walk(((BinaryOperationExpr)exp).right, handler);
        } else if (exp instanceof UnaryOperationExpr) {
            ExcelFormulaPaserHelper.walk(((UnaryOperationExpr)exp).operand, handler);
        } else if (exp instanceof FunctionExpr) {
            List ps = ((FunctionExpr)exp).parameters;
            for (int i = 0; i < ps.size(); ++i) {
                ExcelFormulaPaserHelper.walk((Expression)ps.get(i), handler);
            }
        } else if (exp instanceof Area3DExpr) {
            ExcelFormulaPaserHelper.walk((Expression)((Area3DExpr)exp).area, handler);
        } else if (exp instanceof Ref3DExpr) {
            ExcelFormulaPaserHelper.walk((Expression)((Ref3DExpr)exp).ref, handler);
        }
    }

    public static void walk(Expression exp, IBreakableExpressionHandler handler) {
        boolean b = handler.handle(exp);
        if (!b) {
            return;
        }
        if (exp instanceof BinaryOperationExpr) {
            ExcelFormulaPaserHelper.walk(((BinaryOperationExpr)exp).left, handler);
            ExcelFormulaPaserHelper.walk(((BinaryOperationExpr)exp).right, handler);
        } else if (exp instanceof UnaryOperationExpr) {
            ExcelFormulaPaserHelper.walk(((UnaryOperationExpr)exp).operand, handler);
        } else if (exp instanceof FunctionExpr) {
            List ps = ((FunctionExpr)exp).parameters;
            for (int i = 0; i < ps.size(); ++i) {
                ExcelFormulaPaserHelper.walk((Expression)ps.get(i), handler);
            }
        } else if (exp instanceof Area3DExpr) {
            ExcelFormulaPaserHelper.walk((Expression)((Area3DExpr)exp).area, handler);
        } else if (exp instanceof Ref3DExpr) {
            ExcelFormulaPaserHelper.walk((Expression)((Ref3DExpr)exp).ref, handler);
        }
    }

    public static Expression walk(Expression exp, IEditableExpressionHandler handler) {
        Expression expression = handler.handle(exp);
        if (exp instanceof BinaryOperationExpr) {
            ((BinaryOperationExpr)exp).left = ExcelFormulaPaserHelper.walk(((BinaryOperationExpr)exp).left, handler);
            ((BinaryOperationExpr)exp).right = ExcelFormulaPaserHelper.walk(((BinaryOperationExpr)exp).right, handler);
        } else if (exp instanceof UnaryOperationExpr) {
            ((UnaryOperationExpr)exp).operand = ExcelFormulaPaserHelper.walk(((UnaryOperationExpr)exp).operand, handler);
        } else if (exp instanceof FunctionExpr) {
            List ps = ((FunctionExpr)exp).parameters;
            for (int i = 0; i < ps.size(); ++i) {
                Expression param = (Expression)ps.get(i);
                ps.set(i, ExcelFormulaPaserHelper.walk(param, handler));
            }
        } else if (exp instanceof Area3DExpr) {
            ((Area3DExpr)exp).area = (AreaExpr)ExcelFormulaPaserHelper.walk((Expression)((Area3DExpr)exp).area, handler);
        } else if (exp instanceof Ref3DExpr) {
            ((Ref3DExpr)exp).ref = (ReferenceExpr)ExcelFormulaPaserHelper.walk((Expression)((Ref3DExpr)exp).ref, handler);
        }
        return expression;
    }

    public static String toReducedBracketsString(Expression exp) {
        StringBuffer sb = new StringBuffer();
        ExcelFormulaPaserHelper.reducedBrackets(sb, exp, -1);
        return sb.toString();
    }

    private static void reducedBrackets(StringBuffer sb, Expression expr, int lastOperationType) {
        if (expr instanceof FunctionExpr) {
            FunctionExpr functionExpr = (FunctionExpr)expr;
            sb.append(functionExpr.funcionName);
            sb.append('(');
            for (int i = 0; i < functionExpr.parameters.size(); ++i) {
                Object obj = functionExpr.parameters.get(i);
                if (i > 0) {
                    sb.append(',').append(' ');
                }
                ExcelFormulaPaserHelper.reducedBrackets(sb, (Expression)obj, -1);
            }
            sb.append(')');
        } else if (expr instanceof BinaryOperationExpr) {
            ExcelFormulaPaserHelper.reducedBinaryBrackets(sb, (BinaryOperationExpr)expr, lastOperationType);
        } else if (expr instanceof UnaryOperationExpr) {
            ExcelFormulaPaserHelper.reducedUnaryBrackets(sb, (UnaryOperationExpr)expr, lastOperationType);
        } else {
            sb.append(expr.toString());
        }
    }

    private static void reducedUnaryBrackets(StringBuffer sb, UnaryOperationExpr expr, int lastOperationType) {
        boolean isPercent = false;
        if ("%".equals(expr.getOperation()) && expr.operand != null) {
            try {
                new BigDecimal(expr.operand.toString());
                isPercent = true;
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        if (!isPercent) {
            sb.append(expr.getOperation());
        }
        if (expr.operand instanceof BinaryOperationExpr) {
            BinaryOperationExpr binaryExpr = (BinaryOperationExpr)expr.operand;
            if ((binaryExpr.operationType == 5 || binaryExpr.operationType == 6) && expr.operationType != 3) {
                ExcelFormulaPaserHelper.reducedBrackets(sb, expr.operand, expr.operationType);
            } else {
                sb.append('(');
                ExcelFormulaPaserHelper.reducedBrackets(sb, expr.operand, expr.operationType);
                sb.append(')');
            }
        } else {
            sb.append('(');
            ExcelFormulaPaserHelper.reducedBrackets(sb, expr.operand, expr.operationType);
            if (isPercent) {
                sb.append(expr.getOperation());
            }
            sb.append(')');
        }
    }

    private static void reducedBinaryBrackets(StringBuffer sb, BinaryOperationExpr expr, int lastOperationType) {
        ExcelFormulaPaserHelper.reducedLeftBrackets(sb, expr.left, expr.operationType);
        sb.append(expr.getOperation());
        ExcelFormulaPaserHelper.reducedRightBrackets(sb, expr.right, expr.operationType);
    }

    private static void reducedLeftBrackets(StringBuffer sb, Expression left, int lastOperationType) {
        if (left instanceof BinaryOperationExpr) {
            BinaryOperationExpr expr = (BinaryOperationExpr)left;
            int operationType = expr.operationType;
            if (!(lastOperationType != 5 && lastOperationType != 6 || operationType != 7 && operationType != 8)) {
                sb.append('(');
                ExcelFormulaPaserHelper.reducedBinaryBrackets(sb, expr, operationType);
                sb.append(')');
            } else {
                ExcelFormulaPaserHelper.reducedBinaryBrackets(sb, expr, operationType);
            }
        } else {
            ExcelFormulaPaserHelper.reducedBrackets(sb, left, lastOperationType);
        }
    }

    private static void reducedRightBrackets(StringBuffer sb, Expression right, int lastOperationType) {
        if (right instanceof BinaryOperationExpr) {
            BinaryOperationExpr expr = (BinaryOperationExpr)right;
            int operationType = expr.operationType;
            if (6 == lastOperationType) {
                sb.append('(');
                ExcelFormulaPaserHelper.reducedBinaryBrackets(sb, expr, operationType);
                sb.append(')');
            } else if (!(lastOperationType != 5 && lastOperationType != 8 || operationType != 7 && operationType != 8)) {
                sb.append('(');
                ExcelFormulaPaserHelper.reducedBinaryBrackets(sb, expr, operationType);
                sb.append(')');
            } else {
                ExcelFormulaPaserHelper.reducedBinaryBrackets(sb, expr, operationType);
            }
        } else {
            ExcelFormulaPaserHelper.reducedBrackets(sb, right, lastOperationType);
        }
    }

    public static boolean isHavSpecialExpr(Expression exp) {
        if (ExcelFormulaPaserHelper.isReferenceExprORareaExpr(exp)) {
            return true;
        }
        if (exp instanceof BinaryOperationExpr) {
            if (ExcelFormulaPaserHelper.isHavSpecialExpr(((BinaryOperationExpr)exp).left)) {
                return true;
            }
            if (ExcelFormulaPaserHelper.isHavSpecialExpr(((BinaryOperationExpr)exp).right)) {
                return true;
            }
        } else if (exp instanceof UnaryOperationExpr) {
            if (ExcelFormulaPaserHelper.isHavSpecialExpr(((UnaryOperationExpr)exp).operand)) {
                return true;
            }
        } else if (exp instanceof FunctionExpr) {
            List ps = ((FunctionExpr)exp).parameters;
            for (int i = 0; i < ps.size(); ++i) {
                if (!ExcelFormulaPaserHelper.isHavSpecialExpr((Expression)ps.get(i))) continue;
                return true;
            }
        } else if (exp instanceof Area3DExpr ? ExcelFormulaPaserHelper.isHavSpecialExpr(((Area3DExpr)exp).area) : exp instanceof Ref3DExpr && ExcelFormulaPaserHelper.isHavSpecialExpr(((Ref3DExpr)exp).ref)) {
            return true;
        }
        return false;
    }

    public static boolean isHavCommonRptExpr(Expression exp) {
        if (ExcelFormulaPaserHelper.isCommonRptExpr(exp)) {
            return true;
        }
        if (exp instanceof BinaryOperationExpr) {
            if (ExcelFormulaPaserHelper.isHavCommonRptExpr(((BinaryOperationExpr)exp).left)) {
                return true;
            }
            if (ExcelFormulaPaserHelper.isHavCommonRptExpr(((BinaryOperationExpr)exp).right)) {
                return true;
            }
        } else if (exp instanceof UnaryOperationExpr) {
            if (ExcelFormulaPaserHelper.isHavCommonRptExpr(((UnaryOperationExpr)exp).operand)) {
                return true;
            }
        } else if (exp instanceof FunctionExpr) {
            List ps = ((FunctionExpr)exp).parameters;
            for (int i = 0; i < ps.size(); ++i) {
                if (!ExcelFormulaPaserHelper.isHavCommonRptExpr((Expression)ps.get(i))) continue;
                return true;
            }
        } else if (exp instanceof Area3DExpr ? ExcelFormulaPaserHelper.isHavCommonRptExpr(((Area3DExpr)exp).area) : exp instanceof Ref3DExpr && ExcelFormulaPaserHelper.isHavCommonRptExpr(((Ref3DExpr)exp).ref)) {
            return true;
        }
        return false;
    }

    private static boolean isReferenceExprORareaExpr(Expression expr) {
        return expr instanceof ReferenceExpr || expr instanceof AreaExpr;
    }

    private static boolean isCommonRptExpr(Expression expr) {
        if (expr instanceof FunctionExpr) {
            if (ExcelFormulaPaserHelper.isEasFormula(((FunctionExpr)expr).funcionName)) {
                return true;
            }
            List ps = ((FunctionExpr)expr).parameters;
            for (int i = 0; i < ps.size(); ++i) {
                if (!ExcelFormulaPaserHelper.isReferenceExprORareaExpr((Expression)ps.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isEasFormula(String formulaName) {
        if (!StringUtils.isEmpty((String)formulaName)) {
            if (easFormuls.isEmpty()) {
                RptFormulaComp comp = RptFormulaComp.getInstance();
                comp.setK3(false);
                if (!comp.isLoaded()) {
                    try {
                        comp.load();
                    }
                    catch (Exception e) {
                        logger.error((Object)"comp.load();", (Throwable)e);
                    }
                }
                Collection easFormulColl = RptFormulaComp.getInstance().getFormulasByCategory(null);
                for (Object formul : easFormulColl) {
                    easFormuls.put(((RptFormula)((Object)formul)).getName().toUpperCase(), null);
                }
            }
            if (easFormuls.containsKey(formulaName.toUpperCase())) {
                return true;
            }
        }
        return false;
    }

    public static void expandExpress(String expression, Sheet currSheet, List<FormulaHint> resultList, Set<String> formulaNames) {
        List formulaList = null;
        try {
            formulaList = TableToolkit.parseExcelFormula(expression, true);
        }
        catch (ParserException e) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("FormulaError"));
            SysUtil.abort();
        }
        if (formulaList == null || formulaList.size() == 0) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("PleaseChooseFormula2"));
            SysUtil.abort();
        }
        ExcelFormulaPaserHelper.expandDiscreteFormula(formulaList, currSheet, resultList, formulaNames);
    }

    public static void expandDiscreteFormula(List expressions, Sheet currTable, List<FormulaHint> reslutList, Set<String> formulaNames) {
        if (expressions == null) {
            return;
        }
        int size = expressions.size();
        for (int i = 0; i < size; ++i) {
            int[] paramType;
            FormulaHint hint = (FormulaHint)expressions.get(i);
            for (int x = 0; hint.params != null && x < hint.params.length && (paramType = hint.getParamType()) != null; ++x) {
                if (paramType.length < x) continue;
                if (paramType[x] == 33 || paramType[x] == 34) {
                    Variant v = currTable.calcFormula('=' + hint.params[x]);
                    hint.params[x] = v.getValue() == null ? "" : v.getValue().toString();
                    continue;
                }
                if (paramType[x] != 0) continue;
                ExcelFormulaPaserHelper.handBinaryOp(hint.params[x], currTable, reslutList, formulaNames);
            }
            if (ExcelFormulaPaserHelper.handleAccountAssts(hint, reslutList, currTable) || !formulaNames.contains(hint.name.toUpperCase())) continue;
            reslutList.add(hint);
        }
    }

    public static boolean handleAccountAssts(FormulaHint hint, List<FormulaHint> reslutList, Sheet currTable) {
        boolean isRacctOrAcctac = "racct".equalsIgnoreCase(hint.name) || "acctac".equalsIgnoreCase(hint.name);
        boolean isAcctCash = "acctcash".equalsIgnoreCase(hint.name);
        boolean isINcashflow = "INcashflow".equalsIgnoreCase(hint.name);
        boolean isAcct = "acct".equalsIgnoreCase(hint.name) || "acctext".equalsIgnoreCase(hint.name);
        boolean isAge = "age".equalsIgnoreCase(hint.name);
        if (isAcct || isRacctOrAcctac || isAcctCash || isINcashflow) {
            String accountAssts = null;
            if (isAcct) {
                accountAssts = hint.params[1].toString();
            } else if (isRacctOrAcctac) {
                accountAssts = hint.params[2].toString();
            } else if (isAcctCash) {
                accountAssts = hint.params[6].toString();
            } else if (isINcashflow) {
                accountAssts = hint.params[7].toString();
            } else if (isAge) {
                accountAssts = hint.params[1].toString();
            }
            try {
                boolean isFormula = ExcelFormulaPaserHelper.isFormula(accountAssts);
                if (isFormula) {
                    Variant variant = currTable.calcFormula(accountAssts);
                    if (variant == null) {
                        reslutList.add(hint);
                        return true;
                    }
                    accountAssts = variant.toString();
                }
                if (isAcctCash || isINcashflow) {
                    if (isFormula) {
                        hint.params[isAcctCash ? 6 : 7] = accountAssts;
                    }
                    reslutList.add(hint);
                    return true;
                }
                AcctountAsstItemParser.AccountAsstItem item = AcctountAsstItemParser.parse(accountAssts);
                AcctountAsstItemParser.Range[] accounts = item.accounts;
                if (accounts.length < 2) {
                    if (isFormula) {
                        hint.params[isRacctOrAcctac ? 2 : 1] = accountAssts;
                    }
                    reslutList.add(hint);
                    return true;
                }
                for (int y = 0; y < accounts.length; ++y) {
                    item.startNumber = accounts[y].startNumber;
                    item.endNumber = accounts[y].endNumber;
                    FormulaHint newHint = hint.copy();
                    if (isRacctOrAcctac) {
                        newHint.params[2] = item.toOldString();
                    } else {
                        newHint.params[1] = item.toOldString();
                    }
                    reslutList.add(newHint);
                }
            }
            catch (ParseException e) {
                logger.error((Object)"", (Throwable)e);
                return true;
            }
            return true;
        }
        return false;
    }

    public static boolean isFormula(String str) {
        if (!StringUtils.isEmpty((String)str)) {
            Matcher m;
            if (formulaP == null) {
                formulaP = Pattern.compile("[A-Za-z]+\\(.*\\)");
            }
            if ((m = formulaP.matcher(str)) != null && m.matches()) {
                return true;
            }
            return DynamicTemplateUtility.isExcelFormula((String)str);
        }
        return false;
    }

    public static void handBinaryOp(String expression, Sheet currTable, List<FormulaHint> reslutList, Set<String> formulaNames) {
        try {
            Expression exp;
            if (!StringUtils.isEmpty((String)expression) && (exp = ExcelFormulaPaserHelper.parse(expression)) != null) {
                if (exp instanceof BinaryOperationExpr) {
                    if (ExcelFormulaPaserHelper.isContainFormula(((BinaryOperationExpr)exp).right.toString(), formulaNames)) {
                        ExcelFormulaPaserHelper.expandExpress("=" + ((BinaryOperationExpr)exp).right.toString(), currTable, reslutList, formulaNames);
                    }
                    if (ExcelFormulaPaserHelper.isContainFormula(((BinaryOperationExpr)exp).left.toString(), formulaNames)) {
                        ExcelFormulaPaserHelper.expandExpress("=" + ((BinaryOperationExpr)exp).left.toString(), currTable, reslutList, formulaNames);
                    }
                } else if (ExcelFormulaPaserHelper.isContainFormula(exp.toString(), formulaNames)) {
                    ExcelFormulaPaserHelper.expandExpress("=" + exp.toString(), currTable, reslutList, formulaNames);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("expandDiscreteFormula error:" + expression), (Throwable)e);
        }
    }

    public static boolean isContainFormula(String formula, Set<String> formulaNames) {
        Matcher m = p.matcher(formula);
        String formulaName = null;
        while (m.find()) {
            formulaName = m.group(1);
            if (!formulaNames.contains(formulaName.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    public static boolean isSpecialInFormulas(String formula, Set<String> formulaNames, int startIndex) {
        int rightIndex;
        int leftIndex;
        int index;
        if (!StringUtils.isEmpty((String)formula) && (index = formula.indexOf("@", startIndex)) > 0 && (leftIndex = formula.lastIndexOf("(", index - 1)) > 0 && (rightIndex = formula.indexOf(")", leftIndex)) > index) {
            String formulaName = ExcelFormulaPaserHelper.getFormulaName(formula, leftIndex, rightIndex);
            if (!StringUtils.isEmpty((String)formulaName) && DynamicTemplateUtility.isExcelFormula((String)("=" + formulaName + formula.substring(leftIndex, rightIndex + 1))) ? (leftIndex = formula.lastIndexOf("(", leftIndex - 1)) > 0 && (rightIndex = formula.indexOf(")", rightIndex)) > 0 && !StringUtils.isEmpty((String)(formulaName = ExcelFormulaPaserHelper.getFormulaName(formula, leftIndex, rightIndex))) && !formulaNames.contains(formulaName.trim().toUpperCase()) : !StringUtils.isEmpty((String)formulaName) && !formulaNames.contains(formulaName.trim().toUpperCase())) {
                return false;
            }
            return ExcelFormulaPaserHelper.isSpecialInFormulas(formula, formulaNames, index + 1);
        }
        return true;
    }

    public static String getFormulaName(String formula, int leftIndex, int rightIndex) {
        int curRightIndex;
        int curLeftIndex;
        StringBuffer formulaName = new StringBuffer();
        for (int index = leftIndex - 1; index >= 0; --index) {
            char c = formula.charAt(index);
            if (c == '+' || c == '-' || c == '*' || c == '/' || c == '(' || c == ')' || c == '[' || c == ']' || c == '>' || c == '<' || c == '=' || c == ',') {
                if (formulaName.length() <= 0) break;
                formulaName.reverse();
                return formulaName.toString();
            }
            if (c == ' ') {
                if (formulaName.length() <= 0) continue;
                formulaName.reverse();
                return formulaName.toString();
            }
            formulaName.append(c);
        }
        if ((curLeftIndex = formula.lastIndexOf("(", leftIndex - 1)) > 0 && (curRightIndex = formula.indexOf(")", rightIndex + 1)) > 0) {
            return ExcelFormulaPaserHelper.getFormulaName(formula, curLeftIndex, curRightIndex);
        }
        return null;
    }
}

