/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.jdbc;

import com.kingdee.eas.fi.rpt.jdbc.SqlParameter;
import com.kingdee.eas.fi.rpt.jdbc.SqlTypeValue;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class StatementCreatorUtils {
    private static final Log logger = LogFactory.getLog(StatementCreatorUtils.class);
    private static boolean charSequenceAvailable;

    public static void setParameterValue(PreparedStatement ps, int paramIndex, SqlParameter declaredParam, Object inValue) throws SQLException {
        StatementCreatorUtils.setParameterValue(ps, paramIndex, declaredParam.getSqlType(), declaredParam.getTypeName(), inValue);
    }

    public static void setParameterValue(PreparedStatement ps, int paramIndex, int sqlType, String typeName, Object inValue) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting SQL statement parameter value: column index " + paramIndex + ", parameter value [" + inValue + "], value class [" + (inValue != null ? inValue.getClass().getName() : "null") + "], SQL type " + (sqlType == Integer.MIN_VALUE ? "unknown" : Integer.toString(sqlType))));
        }
        if (inValue == null) {
            if (sqlType == Integer.MIN_VALUE) {
                boolean useSetObject = false;
                try {
                    useSetObject = ps.getConnection().getMetaData().getDatabaseProductName().indexOf("Informix") != -1;
                }
                catch (Throwable ex) {
                    logger.debug((Object)"Could not check database product name", ex);
                }
                if (useSetObject) {
                    ps.setObject(paramIndex, null);
                } else {
                    ps.setNull(paramIndex, 0);
                }
            } else if (typeName != null) {
                ps.setNull(paramIndex, sqlType, typeName);
            } else {
                ps.setNull(paramIndex, sqlType);
            }
        } else if (inValue instanceof SqlTypeValue) {
            ((SqlTypeValue)inValue).setTypeValue(ps, paramIndex, sqlType, typeName);
        } else if (sqlType == 12) {
            ps.setString(paramIndex, inValue.toString());
        } else if (sqlType == 3 || sqlType == 2) {
            if (inValue instanceof BigDecimal) {
                ps.setBigDecimal(paramIndex, (BigDecimal)inValue);
            } else {
                ps.setObject(paramIndex, inValue, sqlType);
            }
        } else if (sqlType == 91) {
            if (inValue instanceof Date) {
                if (inValue instanceof java.sql.Date) {
                    ps.setDate(paramIndex, (java.sql.Date)inValue);
                } else {
                    ps.setDate(paramIndex, new java.sql.Date(((Date)inValue).getTime()));
                }
            } else if (inValue instanceof Calendar) {
                Calendar cal = (Calendar)inValue;
                ps.setDate(paramIndex, new java.sql.Date(cal.getTime().getTime()), cal);
            } else {
                ps.setObject(paramIndex, inValue, 91);
            }
        } else if (sqlType == 92) {
            if (inValue instanceof Date) {
                if (inValue instanceof Time) {
                    ps.setTime(paramIndex, (Time)inValue);
                } else {
                    ps.setTime(paramIndex, new Time(((Date)inValue).getTime()));
                }
            } else if (inValue instanceof Calendar) {
                Calendar cal = (Calendar)inValue;
                ps.setTime(paramIndex, new Time(cal.getTime().getTime()), cal);
            } else {
                ps.setObject(paramIndex, inValue, 92);
            }
        } else if (sqlType == 93) {
            if (inValue instanceof Date) {
                if (inValue instanceof Timestamp) {
                    ps.setTimestamp(paramIndex, (Timestamp)inValue);
                } else {
                    ps.setTimestamp(paramIndex, new Timestamp(((Date)inValue).getTime()));
                }
            } else if (inValue instanceof Calendar) {
                Calendar cal = (Calendar)inValue;
                ps.setTimestamp(paramIndex, new Timestamp(cal.getTime().getTime()), cal);
            } else {
                ps.setObject(paramIndex, inValue, 93);
            }
        } else if (sqlType == Integer.MIN_VALUE) {
            if (StatementCreatorUtils.isStringValue(inValue)) {
                ps.setString(paramIndex, inValue.toString());
            } else if (StatementCreatorUtils.isDateValue(inValue)) {
                ps.setTimestamp(paramIndex, new Timestamp(((Date)inValue).getTime()));
            } else if (inValue instanceof Calendar) {
                Calendar cal = (Calendar)inValue;
                ps.setTimestamp(paramIndex, new Timestamp(cal.getTime().getTime()));
            } else {
                ps.setObject(paramIndex, inValue);
            }
        } else {
            ps.setObject(paramIndex, inValue, sqlType);
        }
    }

    private static boolean isStringValue(Object inValue) {
        if (charSequenceAvailable) {
            return inValue instanceof CharSequence || inValue instanceof StringWriter;
        }
        return inValue instanceof String || inValue instanceof StringBuffer || inValue instanceof StringWriter;
    }

    private static boolean isDateValue(Object inValue) {
        return inValue instanceof Date && !(inValue instanceof java.sql.Date) && !(inValue instanceof Time) && !(inValue instanceof Timestamp);
    }

    static {
        try {
            Class.forName("java.lang.CharSequence");
            charSequenceAvailable = true;
        }
        catch (ClassNotFoundException ex) {
            charSequenceAvailable = false;
        }
    }
}

