/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.k3.calc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.AccountORMCollection;
import com.kingdee.eas.fi.rpt.AccountORMFactory;
import com.kingdee.eas.fi.rpt.AccountORMInfo;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.k3.calc.K3CalcFactory;
import com.kingdee.eas.fi.rpt.k3.calc.K3FormulaBase;
import com.kingdee.eas.fi.rpt.k3.webservice.K3WebServiceContext;
import com.kingdee.eas.fi.rpt.k3.webservice.impl.K3AccFunctionsSoapStub;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.rpc.Service;
import org.apache.log4j.Logger;

public abstract class K3CalcBase {
    private static final Logger logger = Logger.getLogger(K3CalcBase.class);
    protected Context srvCtx;
    private ICalculateContextProvider calcCtx;
    private BatchHelper batchHelper;
    private String currentCompanySdsn;
    private Map sdsnMap = new HashMap();
    private K3WebServiceContext k3Ctx;
    private boolean isK3Disable;

    public K3CalcBase(Context srvCtx, ICalculateContextProvider calcCtx) {
        this.srvCtx = srvCtx;
        this.calcCtx = calcCtx;
        this.batchHelper = new BatchHelper(calcCtx, srvCtx);
        this.initK3Config(srvCtx);
    }

    protected void initK3Config(Context ctx) {
        this.k3Ctx = new K3WebServiceContext();
        BOSUuid orgId = ContextUtil.getCurrentOrgUnit((Context)ctx).getId();
        try {
            AccountORMCollection collection = AccountORMFactory.getLocalInstance(ctx).getAccountORMCollection();
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                AccountORMInfo info = collection.get(i);
                this.sdsnMap.put(info.getLoginAccount(), info.getSdsn());
                if (!info.getCompany().getId().equals((Object)orgId)) continue;
                this.currentCompanySdsn = info.getSdsn();
                this.k3Ctx.setEndPointURL(info.getServerAddr());
                this.k3Ctx.setPassword(info.getUserPassword());
                this.k3Ctx.setUserName(info.getUserName());
                this.k3Ctx.setAISID(info.getAisID());
                this.isK3Disable = info.isIsForbidden();
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    protected void beforCalc(SortedParameterArray params) {
    }

    public void batchCalc(SortedParameterArray params) {
        this.beforCalc(params);
        int size = params.size();
        if (this.isK3Disable) {
            for (int i = 0; i < size; ++i) {
                params.getParameter(i).setValue((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"317accountORMNotStartUsed", (Locale)this.srvCtx.getOriginLocale()));
            }
            return;
        }
        K3AccFunctionsSoapStub stub = null;
        Method method = null;
        try {
            stub = new K3AccFunctionsSoapStub(this.k3Ctx.getK3FunctionEndPoint(), (Service)new org.apache.axis.client.Service());
            method = stub.getClass().getMethod(this.getK3MethodName(), String.class, String.class);
        }
        catch (Exception e) {
            logger.error((Object)e);
            for (int i = 0; i < size; ++i) {
                params.getParameter(i).setValue((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"318accountORMNotSetOrError", (Locale)this.srvCtx.getOriginLocale()));
            }
            return;
        }
        for (int i = 0; i < size; ++i) {
            Parameter p = params.getParameter(i);
            try {
                K3FormulaBase formula = this.initParam(p);
                if (formula.isHashException() && formula.getException() != null) {
                    p.setValue((Object)formula.getException().getMessage());
                    continue;
                }
                Object k3Value = method.invoke((Object)stub, (Object[])new String[]{formula.getFormulaSdsn(), this.getK3ParamText(formula)});
                p.setValue((Object)this.getK3Var(k3Value));
                continue;
            }
            catch (Exception e) {
                p.setValue((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"318accountORMNotSetOrError", (Locale)this.srvCtx.getOriginLocale()));
            }
        }
    }

    private Variant getK3Var(Object k3Value) {
        if (k3Value == null || "".equals(k3Value.toString()) || "#".equals(k3Value.toString())) {
            return new Variant((Object)new BigDecimal("0"));
        }
        try {
            return new Variant((Object)new BigDecimal(k3Value.toString()));
        }
        catch (NumberFormatException numberFormatException) {
            return new Variant(k3Value);
        }
    }

    protected abstract K3FormulaBase initParam(Parameter var1);

    protected abstract String getK3ParamText(K3FormulaBase var1);

    protected abstract String getK3MethodName();

    protected String getAccountSdsn(String sdsnAccount) {
        return (String)this.sdsnMap.get(sdsnAccount);
    }

    public Context getServerContext() {
        return this.srvCtx;
    }

    public ICalculateContextProvider getCalCulateContext() {
        return this.calcCtx;
    }

    public String getCurrentCompanySdsn() {
        return this.currentCompanySdsn;
    }

    public BatchHelper getBatchHelper() {
        return this.batchHelper;
    }

    public static K3CalcBase getInstance(Context srvCtx, ICalculateContextProvider calcCtx, String methodName) {
        return K3CalcFactory.getK3CalcInstance(srvCtx, calcCtx, methodName);
    }
}

