/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.styleinherit;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.Span;
import com.kingdee.bos.ctrl.excel.model.struct.validate.ValidationList;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.MessagedValidate;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import java.awt.Point;
import java.util.HashMap;
import java.util.Map;

public class RptSheetInheritSytleHelper {
    public void regionInheritStyleByDefaultPoint(Sheet sheet, Point standardPoint, int startRow, int startColumn, int endRow, int endColumn, boolean isVerticalInherit) {
        if (isVerticalInherit) {
            this.verticalRegionInheritStyleByDefaultPoint(sheet, standardPoint, startRow, startColumn, endRow, endColumn);
            this.inheritHeightByDefaultPoint(sheet, standardPoint, endRow);
        } else {
            this.horizontalRegionInheritStyleByDefaultPoint(sheet, standardPoint, startRow, startColumn, endRow, endColumn);
            this.inheritWidthByDefaultPoint(sheet, standardPoint, endColumn);
        }
        this.inheritValidationByBasePointNextLineOrColumn(sheet, standardPoint, startRow, startColumn, endRow, endColumn, isVerticalInherit);
    }

    public void inheritStyleByDefault(Sheet sheet) {
        int startRow = CslRptUtil.getBasePosition_Top((Sheet)sheet) + 2;
        this.verticalregionInheritStyleByDefault(sheet, startRow, sheet.getMaxRowIndex());
    }

    public void verticalregionInheritStyleByDefault(Sheet sheet, int startRow, int endRow) {
        int iPosLeft = CslRptUtil.getBasePosition_Left((Sheet)sheet);
        int iPosTop = CslRptUtil.getBasePosition_Top((Sheet)sheet);
        Point standardPoint = new Point(iPosLeft, iPosTop);
        this.verticalRowregionInheritStyleByDefaultPoint(sheet, standardPoint, startRow, endRow);
    }

    public void verticalRowregionInheritStyleByDefaultPoint(Sheet sheet, Point standardPoint, int startRow, int endRow) {
        int startColumn = standardPoint.x;
        int endColumn = sheet.getMaxColIndex();
        this.regionInheritStyleByDefaultPoint(sheet, standardPoint, startRow, startColumn, endRow, endColumn, true);
    }

    public void verticalRegionInheritStyleByDefaultPoint(Sheet sheet, Point standardPoint, int startRow, int startColumn, int endRow, int endColumn) {
        int iPosLeft = standardPoint.x;
        int iPosTop = standardPoint.y;
        if (iPosLeft < 0 || iPosTop < 0) {
            return;
        }
        if (startRow < 1) {
            startRow = iPosTop + 2;
        }
        for (int i = startColumn; i <= endColumn; ++i) {
            StyleAttributes saInnerBorder;
            StyleAttributes saOuterBorder = saInnerBorder = Styles.getEmptySA();
            sheet.getRange(iPosTop + 1, i).getStyle(saOuterBorder, saInnerBorder);
            saOuterBorder.setDirty(StyleAttributes.getAllBits());
            saInnerBorder.setDirty(StyleAttributes.getAllBits());
            sheet.getRange(startRow, i, endRow, i).setStyle(saOuterBorder, saInnerBorder);
        }
    }

    public void horizontalRegionInheritStyleByDefaultPoint(Sheet sheet, Point standardPoint, int startRow, int startColumn, int endRow, int endColumn) {
        int iPosLeft = standardPoint.x;
        int iPosTop = standardPoint.y;
        if (iPosLeft < 0 || iPosTop < 0) {
            return;
        }
        if (startColumn < 1) {
            startColumn = iPosLeft + 2;
        }
        for (int i = startRow; i < endRow; ++i) {
            StyleAttributes saInnerBorder;
            StyleAttributes saOuterBorder = saInnerBorder = Styles.getEmptySA();
            sheet.getRange(i, iPosLeft + 1).getStyle(saOuterBorder, saInnerBorder);
            saOuterBorder.setDirty(StyleAttributes.getAllBits());
            saInnerBorder.setDirty(StyleAttributes.getAllBits());
            sheet.getRange(i, startColumn, i, endColumn).setStyle(saOuterBorder, saInnerBorder);
        }
    }

    public void regionInheritStyleByDefault(Sheet sheet, int startRow, int startColumn, int endRow, int endColumn) {
        int iPosLeft = 1;
        CslRptUtil.getBasePosition_Left((Sheet)sheet);
        int iPosTop = 0;
        CslRptUtil.getBasePosition_Top((Sheet)sheet);
        if (iPosLeft < 0 || iPosTop < 0) {
            return;
        }
        if (startRow < 1) {
            startRow = iPosTop + 2;
        }
        for (int i = startColumn; i <= endColumn; ++i) {
            StyleAttributes saInnerBorder;
            StyleAttributes saOuterBorder = saInnerBorder = Styles.getEmptySA();
            sheet.getRange(iPosTop + 1, i).getStyle(saOuterBorder, saInnerBorder);
            saOuterBorder.setDirty(StyleAttributes.getAllBits());
            saInnerBorder.setDirty(StyleAttributes.getAllBits());
            sheet.getRange(startRow, i, endRow, i).setStyle(saOuterBorder, saInnerBorder);
        }
    }

    public void regionInheritStyleByRange(Sheet sheet, Range styleRange, int startRow, int startColumn, int endRow, int endColumn) {
        StyleAttributes saInnerBorder;
        StyleAttributes saOuterBorder = saInnerBorder = Styles.getEmptySA();
        styleRange.getStyle(saOuterBorder, saInnerBorder);
        saOuterBorder.setDirty(StyleAttributes.getAllBits());
        saInnerBorder.setDirty(StyleAttributes.getAllBits());
        sheet.getRange(startRow, startColumn, endRow, endColumn).setStyle(saOuterBorder, saInnerBorder);
    }

    public void cellInheritStyleByRange(Range styleRange, Cell cell) {
        StyleAttributes saInnerBorder;
        StyleAttributes saOuterBorder = saInnerBorder = Styles.getEmptySA();
        styleRange.getStyle(saOuterBorder, saInnerBorder);
        cell.setSSA(Styles.getSSA((StyleAttributes)saOuterBorder));
    }

    public void inheritHeightByDefaultPoint(Sheet sheet, Point standardPoint, int toMaxRow) {
        int iPosTop = standardPoint.y;
        int rowHeight = Sheet.getRowHeight((Sheet)sheet, (int)(iPosTop + 1));
        sheet.getRowSpans().setSpanAttribute(new Span(iPosTop + 2, toMaxRow), null, new Integer(rowHeight), null, null, null, null);
    }

    public void inheritWidthByDefaultPoint(Sheet sheet, Point standardPoint, int toMaxCol) {
        int iPosLeft = standardPoint.x;
        int colWidth = Sheet.getColWidth((Sheet)sheet, (int)(iPosLeft + 1));
        sheet.getColSpans().setSpanAttribute(new Span(iPosLeft + 2, toMaxCol), null, new Integer(colWidth), null, null, null, null);
    }

    public void inheritValidationByBasePointNextLineOrColumn(Sheet sheet, Point basePoint, int startRow, int startColumn, int endRow, int endColumn, boolean isVertical) {
        Map colValids = this.getCurBasePointNextLineValidation(sheet, basePoint, startRow, startColumn, endRow, endColumn, isVertical);
        ValidationList sheetValids = sheet.getValidations();
        MessagedValidate mv = null;
        String tmpIndxeValue2 = null;
        Range inheritRange = null;
        int colOrRowIndex = 0;
        for (String tmpIndxeValue2 : colValids.keySet()) {
            if (tmpIndxeValue2 == null) continue;
            colOrRowIndex = new Integer(tmpIndxeValue2);
            mv = (MessagedValidate)colValids.get(tmpIndxeValue2);
            if (isVertical) {
                inheritRange = sheet.getRange(startRow, colOrRowIndex, endRow, colOrRowIndex);
                sheetValids.insertValidation(mv, (SortedCellBlockArray)inheritRange);
                continue;
            }
            inheritRange = sheet.getRange(colOrRowIndex, startColumn, colOrRowIndex, endColumn);
            sheetValids.insertValidation(mv, (SortedCellBlockArray)inheritRange);
        }
    }

    public Map getCurBasePointNextLineValidation(Sheet sheet, Point basePoint, int startRow, int startColumn, int endRow, int endColumn, boolean isVertical) {
        HashMap<String, MessagedValidate> celValids = new HashMap<String, MessagedValidate>();
        int iPosLeft = basePoint.x;
        int iPosTop = basePoint.y;
        if (isVertical) {
            for (int curCol = startColumn; curCol < endColumn + 1; ++curCol) {
                MessagedValidate colValid = sheet.getValidations().getValidate(iPosTop + 1, curCol);
                if (colValid == null) continue;
                celValids.put(String.valueOf(curCol), colValid);
            }
        } else {
            for (int curRow = startRow; curRow < endRow + 1; ++curRow) {
                MessagedValidate colValid = sheet.getValidations().getValidate(curRow, iPosLeft + 1);
                if (colValid == null) continue;
                celValids.put(String.valueOf(curRow), colValid);
            }
        }
        return celValids;
    }

    public void inheritHeightByDefault(Sheet sheet, int rowStandand) {
        int startRow = rowStandand + 1;
        int endRow = sheet.getMaxRowIndex();
        this.regionInheritHeight(sheet, rowStandand, startRow, endRow);
    }

    public void regionInheritHeight(Sheet sheet, int rowStandand, int startRow, int endRow) {
        if (sheet.getRowRange(rowStandand, rowStandand) == null) {
            return;
        }
        int height = sheet.getRowRange(rowStandand, rowStandand).getRowHeight();
        for (int j = startRow; j <= endRow; ++j) {
            sheet.getRowRange(j, j).setRowHeight(height);
        }
    }
}

