/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.util;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.kdfsax.KDFSAX;
import com.kingdee.bos.olap.util.ByteArrayInputStream;
import com.kingdee.bos.olap.util.ByteArrayOutputStream;
import com.kingdee.eas.fi.rpt.Key;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.RptOperationSchemaComp;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.List;

public class BookProperties {
    private List calculateQueue = null;
    private RptOperationSchemaComp operationSchema = null;
    private ReportCalculateErrorProvider errorProvider = null;
    private ReportVariables variables = null;
    private Boolean includeGroupUnit = Boolean.FALSE;
    private Boolean isRemoveException = Boolean.FALSE;
    private Boolean isAutoFillDigit = Boolean.TRUE;
    private Integer dataElementRelating = new Integer("-1");

    public static BookProperties loadFromBook(Book book) {
        BookProperties m = new BookProperties();
        m.calculateQueue = (List)book.getUserObjectValue("multiCalculateQueue");
        m.errorProvider = (ReportCalculateErrorProvider)book.getUserObjectValue("ERRORHANDLER");
        m.variables = (ReportVariables)book.getUserObjectValue("VARIABLES");
        m.operationSchema = (RptOperationSchemaComp)book.getUserObjectValue("operationSchemas");
        m.includeGroupUnit = (Boolean)book.getUserObjectValue("INCLUDEGROUPUNIT");
        m.isRemoveException = (Boolean)book.getUserObjectValue("REMOVEEXCEPTION");
        m.isAutoFillDigit = (Boolean)book.getUserObjectValue("AUTOFILLDIGIT");
        m.dataElementRelating = (Integer)book.getUserObjectValue("DATAELEMENTRELATING");
        return m;
    }

    public byte[] toByteData() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream oot = new ObjectOutputStream((OutputStream)out);
        oot.writeObject(this.calculateQueue);
        oot.writeObject(this.errorProvider);
        oot.writeObject(this.variables);
        oot.writeObject(this.operationSchema);
        oot.writeObject(this.includeGroupUnit);
        oot.writeObject(this.isRemoveException);
        oot.writeObject(this.isAutoFillDigit);
        oot.writeObject(this.dataElementRelating);
        oot.flush();
        return out.getBuffer();
    }

    public BookProperties loadFromByteData(byte[] data) throws IOException, ClassNotFoundException {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        ObjectInputStream oin = new ObjectInputStream((InputStream)in);
        BookProperties m = new BookProperties();
        m.calculateQueue = (List)oin.readObject();
        m.errorProvider = (ReportCalculateErrorProvider)oin.readObject();
        m.variables = (ReportVariables)oin.readObject();
        m.operationSchema = (RptOperationSchemaComp)oin.readObject();
        if (m.operationSchema != null) {
            m.operationSchema.init();
        }
        m.includeGroupUnit = (Boolean)oin.readObject();
        m.isRemoveException = (Boolean)oin.readObject();
        m.isAutoFillDigit = (Boolean)oin.readObject();
        m.dataElementRelating = (Integer)oin.readObject();
        return m;
    }

    public void restoreToBook(Book book) {
        if (this.calculateQueue != null) {
            book.setUserObject("multiCalculateQueue", (Object)this.calculateQueue);
        }
        if (this.operationSchema != null) {
            book.setUserObject("operationSchemas", (Object)this.operationSchema);
        }
        if (this.errorProvider != null) {
            book.setUserObject("ERRORHANDLER", (Object)this.errorProvider);
        }
        if (this.variables != null) {
            book.setUserObject("VARIABLES", (Object)this.variables);
        }
        if (this.includeGroupUnit != null) {
            book.setUserObject("INCLUDEGROUPUNIT", (Object)this.includeGroupUnit);
        }
        if (this.isRemoveException != null) {
            book.setUserObject("REMOVEEXCEPTION", (Object)this.isRemoveException);
        }
        if (this.isAutoFillDigit != null) {
            book.setUserObject("AUTOFILLDIGIT", (Object)this.isAutoFillDigit);
        }
        if (this.dataElementRelating != null) {
            book.setUserObject("DATAELEMENTRELATING", (Object)this.dataElementRelating);
        }
    }

    public static BookProperties loadFromKDF(KDF kdf) {
        KDFUserObjects m = new KDFUserObjects();
        m.reportKeys = (List)kdf.getUserObject("reportKeys");
        m.operationSchema = (RptOperationSchemaComp)kdf.getUserObject("operationSchemas");
        if (m.operationSchema != null) {
            m.operationSchema.init();
        }
        m.errorProvider = RptUtil.getErrorhandlerFromKDF(kdf);
        BookProperties bp = new BookProperties();
        bp.calculateQueue = m.queue;
        bp.operationSchema = m.operationSchema;
        bp.errorProvider = m.errorProvider;
        bp.includeGroupUnit = Boolean.FALSE;
        bp.isRemoveException = Boolean.FALSE;
        bp.isAutoFillDigit = Boolean.TRUE;
        bp.dataElementRelating = new Integer("-1");
        return bp;
    }

    public static BookProperties loadFromKDF(KDFSAX kdf) {
        KDFUserObjects m = new KDFUserObjects();
        m.reportKeys = (List)kdf.getUserObject("reportKeys");
        m.operationSchema = (RptOperationSchemaComp)kdf.getUserObject("operationSchemas");
        if (m.operationSchema != null) {
            m.operationSchema.init();
        }
        m.errorProvider = RptUtil.getErrorhandlerFromKDF(kdf);
        BookProperties bp = new BookProperties();
        bp.calculateQueue = m.queue;
        bp.operationSchema = m.operationSchema;
        bp.errorProvider = m.errorProvider;
        bp.includeGroupUnit = Boolean.FALSE;
        bp.isRemoveException = Boolean.FALSE;
        bp.isAutoFillDigit = Boolean.TRUE;
        bp.dataElementRelating = new Integer("-1");
        return bp;
    }

    public static ReportVariables loadVariables(Book book) {
        return (ReportVariables)book.getUserObjectValue("VARIABLES");
    }

    public List getCalculateQueue() {
        return this.calculateQueue;
    }

    public void setCalculateQueue(List calculateQueue) {
        this.calculateQueue = calculateQueue;
    }

    public ReportCalculateErrorProvider getErrorProvider() {
        return this.errorProvider;
    }

    public void setErrorProvider(ReportCalculateErrorProvider errorProvider) {
        this.errorProvider = errorProvider;
    }

    public RptOperationSchemaComp getOperationSchema() {
        if (this.operationSchema == null) {
            this.operationSchema = new RptOperationSchemaComp();
        }
        return this.operationSchema;
    }

    public void setOperationSchema(RptOperationSchemaComp operationSchema) {
        this.operationSchema = operationSchema;
    }

    public ReportVariables getVariables() {
        if (this.variables == null) {
            this.variables = new ReportVariables();
        }
        return this.variables;
    }

    public void setVariables(ReportVariables variables) {
        this.variables = variables;
    }

    public boolean isIncludeGroupUnit() {
        return this.includeGroupUnit == null ? false : this.includeGroupUnit;
    }

    public void setIncludeGroupUnit(boolean b) {
        this.includeGroupUnit = b;
    }

    public boolean isRemoveException() {
        return this.isRemoveException == null ? false : this.isRemoveException;
    }

    public void setIsRemoveException(boolean b) {
        this.isRemoveException = b;
    }

    public boolean isAutoFillDigit() {
        return this.isAutoFillDigit == null ? true : this.isAutoFillDigit;
    }

    public void setIsAutoFillDigit(boolean b) {
        this.isAutoFillDigit = b;
    }

    public static boolean isShowSumRange(Book book) {
        Boolean bool = (Boolean)book.getUserObjectValue("SHOW_SUMRANGE");
        return bool != null && bool != false;
    }

    public static void setShowSumRange(Book book, boolean b) {
        book.setUserObject("SHOW_SUMRANGE", (Object)b);
    }

    public int getDataElementRelating() {
        return this.dataElementRelating == null ? -1 : this.dataElementRelating;
    }

    public void setDataElementRelating(int b) {
        this.dataElementRelating = new Integer(b);
    }

    public void notifyRenameSheet(String oldname, String newname) {
        if (this.operationSchema != null) {
            this.operationSchema.notifyRenameSheet(oldname, newname);
        }
        if (this.variables != null) {
            this.variables.onRenameSheet(oldname, newname);
        }
    }

    public void notifyDeleteSheet(String name) {
        if (this.operationSchema != null) {
            this.operationSchema.notifyDeleteSheet(name);
        }
        if (this.variables != null) {
            this.variables.onDeleteSheet(name);
        }
    }

    public void merge(BookProperties src) {
        if (this.variables != null) {
            this.variables.addAll(src.variables, false);
        }
        if (this.operationSchema != null) {
            this.operationSchema.mergeSchema(src.operationSchema);
        } else {
            this.operationSchema = new RptOperationSchemaComp();
            this.operationSchema.mergeSchema(src.operationSchema);
        }
    }

    public static boolean isShowErrorCell(Book book) {
        Boolean bool = (Boolean)book.getUserObjectValue("SHOW_ERROR_CELL");
        return bool != null && bool != false;
    }

    public static void setShowErrorCell(Book book, boolean b) {
        book.setUserObject("SHOW_ERROR_CELL", (Object)b);
    }

    private static class KDFUserObjects {
        private List reportKeys;
        private List queue;
        private RptOperationSchemaComp operationSchema;
        private String zeroReplacer;
        private ReportCalculateErrorProvider errorProvider = null;

        private KDFUserObjects() {
        }

        private void keysToVariables(ReportVariables v) {
            if (this.reportKeys != null) {
                for (int i = 0; i < this.reportKeys.size(); ++i) {
                    Key key = (Key)this.reportKeys.get(i);
                }
            }
        }
    }
}

