/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.util;

import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.dom.expr.BigDecimalExpr;
import com.kingdee.bos.kscript.dom.expr.BinaryOpExpr;
import com.kingdee.bos.kscript.dom.expr.CodeExpr;
import com.kingdee.bos.kscript.dom.expr.DoubleExpr;
import com.kingdee.bos.kscript.dom.expr.FloatExpr;
import com.kingdee.bos.kscript.dom.expr.IdentifierExpr;
import com.kingdee.bos.kscript.dom.expr.IntExpr;
import com.kingdee.bos.kscript.dom.expr.MethodInvokeExpr;
import com.kingdee.bos.kscript.dom.stmt.ExprStmt;
import com.kingdee.eas.fi.rpt.util.RptFormulaParser;
import com.kingdee.eas.fi.rpt.util.SheetRefExpr;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;

public class FormulaConvertUtil {
    private CodeExpr factor;
    private String line;
    private int operator = 9;
    private static BigDecimal ONE = new BigDecimal("1.00");
    public static Set formulaType = new HashSet(33);

    public static void main(String[] args) throws Exception {
        String[] s = new String[]{"=Acct(RptDate())/A1/1000 + acctExt() + sum(a1:a2)+" + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.HardCodingSettingResource", (String)"43_chinaFinancialReport") + "a4 + a5", "=(A1+A2)/1000 + acctExt()", "=(sum(a1:a2))/1000 + acctExt()", "=1000/B3 + acctExt()", "=(sum(a1:a2))/1000/B3 + acctExt()", "=1000/5/3/1/1 + 500/0.8", "=1000/5/3/A1 + 500/0.8", "=Acct()/Acct() + 500/0.8", "=(A1+A2)/Acct() + acctExt()", "=A1/sum(a1:a2) + acctExt()", "=Acct()/(A1+100) + acctExt()"};
        for (int i = 0; i < s.length; ++i) {
        }
    }

    public static String convert(String line, char operator, String factor) throws Exception {
        try {
            if (ONE.compareTo(new BigDecimal(factor)) == 0) {
                return line;
            }
        }
        catch (Exception e) {
            throw new Exception("Unsupported factor " + factor);
        }
        FormulaConvertUtil c = new FormulaConvertUtil();
        c.setOperator(operator);
        c.setFactor(factor);
        c.line = line;
        return c.convert();
    }

    private void setFactor(String factor) throws Exception {
        try {
            this.factor = new IntExpr(Integer.parseInt(factor));
            return;
        }
        catch (Exception exception) {
            try {
                this.factor = new FloatExpr(Float.parseFloat(factor));
                return;
            }
            catch (Exception exception2) {
                try {
                    this.factor = new DoubleExpr(factor);
                    return;
                }
                catch (Exception exception3) {
                    try {
                        this.factor = new BigDecimalExpr(new BigDecimal(factor));
                        return;
                    }
                    catch (Exception exception4) {
                        throw new Exception("Unsupported factor " + factor);
                    }
                }
            }
        }
    }

    private void setOperator(char c) throws Exception {
        if (c == '/') {
            this.operator = 9;
        } else if (c == '*') {
            this.operator = 22;
        } else {
            throw new Exception("Unsupported operator " + c);
        }
    }

    private String convert() throws ParserException {
        if (this.line == null || this.line.length() < 1) {
            return null;
        }
        if (this.line.charAt(0) != '=') {
            return null;
        }
        this.line = "value" + this.line;
        if (this.line.charAt(this.line.length() - 1) != ';') {
            this.line = this.line + ";";
        }
        ExprStmt stmt = RptFormulaParser.parse(this.line);
        BinaryOpExpr expr = (BinaryOpExpr)stmt.expr;
        CodeExpr codeExpr = expr.right;
        CodeExpr result = this.newWalk(codeExpr);
        return '=' + result.toString();
    }

    private CodeExpr walk(CodeExpr expr) throws ParserException {
        CodeExpr returnee = expr;
        if (expr instanceof BinaryOpExpr) {
            BinaryOpExpr bin = (BinaryOpExpr)expr;
            CodeExpr left = bin.left;
            if (!(left instanceof IdentifierExpr)) {
                ((BinaryOpExpr)expr).left = this.walk(left);
            }
            CodeExpr right = ((BinaryOpExpr)expr).right;
            if (!(right instanceof IdentifierExpr)) {
                ((BinaryOpExpr)expr).right = this.walk(right);
            }
        } else {
            if (expr instanceof MethodInvokeExpr) {
                MethodInvokeExpr e = (MethodInvokeExpr)expr;
                CodeExpr converted = this.convertOne(e);
                return converted;
            }
            if (!(expr instanceof IdentifierExpr) && (expr instanceof IntExpr || expr instanceof DoubleExpr || expr instanceof FloatExpr || expr instanceof BigDecimalExpr)) {
                BinaryOpExpr result = new BinaryOpExpr();
                result.operator = this.operator;
                result.left = expr;
                result.right = this.factor;
                return result;
            }
        }
        return returnee;
    }

    private CodeExpr convertOne(MethodInvokeExpr e) {
        if (formulaType.contains(e.methodName.toUpperCase())) {
            return this.convertWholeExpr((CodeExpr)e);
        }
        return e;
    }

    private CodeExpr newWalk(CodeExpr expr) throws ParserException {
        if (expr instanceof IdentifierExpr) {
            return expr;
        }
        CodeExpr returnee = expr;
        if (expr instanceof BinaryOpExpr) {
            BinaryOpExpr bin = (BinaryOpExpr)expr;
            CodeExpr left = bin.left;
            CodeExpr right = bin.right;
            if (bin.operator == 9 || bin.operator == 22) {
                if (this.isContainsCustomFormula(expr) || this.isAllConstantExpr(expr) || this.isAllSheetOrConstantExpr(expr)) {
                    return this.convertWholeExpr(expr);
                }
                return expr;
            }
            if (!(left instanceof IdentifierExpr)) {
                ((BinaryOpExpr)expr).left = this.newWalk(left);
            }
            if (!(right instanceof IdentifierExpr)) {
                ((BinaryOpExpr)expr).right = this.newWalk(right);
            }
        } else {
            if (expr instanceof MethodInvokeExpr) {
                MethodInvokeExpr e = (MethodInvokeExpr)expr;
                if ("IF".equals(e.methodName.toUpperCase())) {
                    if (e.paramList != null && e.paramList.size() > 0) {
                        for (int i = 1; i < e.paramList.size(); ++i) {
                            CodeExpr ee = (CodeExpr)e.paramList.get(i);
                            e.paramList.set(i, this.newWalk(ee));
                        }
                    }
                    return returnee;
                }
                return this.convertOne(e);
            }
            if (this.isConstantExpr(expr)) {
                return this.convertWholeExpr(expr);
            }
            if (expr instanceof SheetRefExpr) {
                return this.convertWholeExpr(expr);
            }
        }
        return returnee;
    }

    private boolean isAllConstantExpr(CodeExpr expr) {
        if (expr instanceof BinaryOpExpr) {
            BinaryOpExpr bin = (BinaryOpExpr)expr;
            CodeExpr left = bin.left;
            boolean b = true;
            b = left instanceof BinaryOpExpr ? this.isAllConstantExpr(left) : this.isConstantExpr(left);
            if (b) {
                CodeExpr right = bin.right;
                if (right instanceof BinaryOpExpr) {
                    return this.isAllConstantExpr(right);
                }
                return this.isConstantExpr(right);
            }
        }
        return false;
    }

    private boolean isAllSheetOrConstantExpr(CodeExpr expr) {
        if (expr instanceof BinaryOpExpr) {
            BinaryOpExpr bin = (BinaryOpExpr)expr;
            CodeExpr left = bin.left;
            boolean b = true;
            b = left instanceof BinaryOpExpr ? this.isAllSheetOrConstantExpr(left) : this.isSheetOrConstantRefExpr(left);
            if (b) {
                CodeExpr right = bin.right;
                if (right instanceof BinaryOpExpr) {
                    return this.isAllSheetOrConstantExpr(right);
                }
                b = this.isSheetOrConstantRefExpr(right);
                return b;
            }
        }
        return false;
    }

    private boolean isSheetOrConstantRefExpr(CodeExpr expr) {
        if (expr instanceof SheetRefExpr) {
            return true;
        }
        return this.isConstantExpr(expr);
    }

    private boolean isConstantExpr(CodeExpr expr) {
        return expr instanceof IntExpr || expr instanceof DoubleExpr || expr instanceof FloatExpr || expr instanceof BigDecimalExpr;
    }

    private CodeExpr convertWholeExpr(CodeExpr e) {
        BinaryOpExpr result = new BinaryOpExpr();
        result.operator = this.operator;
        result.left = e;
        result.right = this.factor;
        return result;
    }

    private boolean isContainsCustomFormula(CodeExpr expr) {
        if (expr instanceof BinaryOpExpr) {
            BinaryOpExpr bin = (BinaryOpExpr)expr;
            CodeExpr left = bin.left;
            if (left instanceof MethodInvokeExpr && this.isCustomFormula((MethodInvokeExpr)left)) {
                return true;
            }
            CodeExpr right = bin.right;
            if (right instanceof MethodInvokeExpr && this.isCustomFormula((MethodInvokeExpr)right)) {
                return true;
            }
            return this.isContainsCustomFormula(left) || this.isContainsCustomFormula(right);
        }
        return false;
    }

    private boolean isCustomFormula(MethodInvokeExpr e) {
        return formulaType.contains(e.methodName.toUpperCase());
    }

    static {
        formulaType.add("DHOLDING");
        formulaType.add("INCASHFLOW");
        formulaType.add("REFM");
        formulaType.add("REF");
        formulaType.add("ITEM");
        formulaType.add("DITEM");
        formulaType.add("ACCTITEM");
        formulaType.add("DYITEM");
        formulaType.add("ADJUSTDATA");
        formulaType.add("ELIMDATA");
        formulaType.add("ACCTAC");
        formulaType.add("CASH");
        formulaType.add("ACCTEXT");
        formulaType.add("ACCTCASH");
        formulaType.add("ACCT");
        formulaType.add("FOG_FA");
        formulaType.add("FPFIX");
        formulaType.add("FPFC");
        formulaType.add("FPAC");
        formulaType.add("FPACCT");
        formulaType.add("FPITEM");
        formulaType.add("INACCT");
        formulaType.add("BGFORMULA");
        formulaType.add("BGACTUAL");
        formulaType.add("BGACTUALFD");
        formulaType.add("BGREFBGFORM");
        formulaType.add("BGREFBGTEM");
        formulaType.add("BGBAL");
        formulaType.add("BGACT");
        formulaType.add("BGITEM");
        formulaType.add("FIX");
        formulaType.add("RPTINDEX");
        formulaType.add("REPT");
        formulaType.add("CSREF");
        formulaType.add("IF");
        formulaType.add("MBGAGGREGATE");
    }
}

