/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Comment;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.ContextUtils;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.RuleUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.designer.comment.CommentUtil;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.rpt.PostilCollection;
import com.kingdee.eas.fi.rpt.PostilInfo;
import com.kingdee.eas.fi.rpt.PostilTypeEnum;
import com.kingdee.eas.fi.rpt.ReportBaseCollection;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptCheckExpTank;
import com.kingdee.eas.fi.rpt.RptCheckExpression;
import com.kingdee.eas.fi.rpt.RptCommentTank;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.app.BaseFrameService;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.enums.IntEnum;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class RptUtilForServer {
    private static final Logger logger = Logger.getLogger(RptUtilForServer.class);

    public static CompanyOrgUnitInfo getCompanyOrgUnitInfoByNumber(Context ctx, String number) throws BOSException {
        CompanyOrgUnitInfo company = null;
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)number));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        ICompanyOrgUnit icompany = null;
        icompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitCollection companyCl = icompany.getCompanyOrgUnitCollection(view);
        if (companyCl.size() > 0 && (company = companyCl.get(0)) != null) {
            if (ctx.get((Object)"rptComapany") == null) {
                HashMap<String, CompanyOrgUnitInfo> rptComapany = new HashMap<String, CompanyOrgUnitInfo>();
                rptComapany.put(number, company);
                ctx.put((Object)"rptComapany", rptComapany);
            } else {
                ((HashMap)ctx.get((Object)"rptComapany")).put(number, company);
            }
        }
        return company;
    }

    public static FullOrgUnitInfo getFullOrgUnitInfoByNumber(Context ctx, String number) throws BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)number));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        FullOrgUnitCollection col = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection(view);
        return col == null || col.size() <= 0 ? null : col.get(0);
    }

    public static CompanyOrgUnitInfo getCurrentCompany(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = null;
        String companyid = ContextUtils.getCurrentCompany((Context)ctx);
        if (ctx.get((Object)"rptComapanyID") != null && (company = (CompanyOrgUnitInfo)((HashMap)ctx.get((Object)"rptComapanyID")).get(companyid)) != null) {
            return company;
        }
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("id", (Object)companyid));
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection src = view.getSelector();
        src.add(new SelectorItemInfo("*"));
        src.add(new SelectorItemInfo("baseCurrency.id"));
        src.add(new SelectorItemInfo("baseCurrency.number"));
        view.setFilter(filter);
        ICompanyOrgUnit icompany = null;
        icompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitCollection companyCl = icompany.getCompanyOrgUnitCollection(view);
        if (companyCl.size() > 0 && (company = companyCl.get(0)) != null) {
            if (ctx.get((Object)"rptComapanyID") == null) {
                HashMap<String, CompanyOrgUnitInfo> rptComapany = new HashMap<String, CompanyOrgUnitInfo>();
                rptComapany.put(companyid, company);
                ctx.put((Object)"rptComapanyID", rptComapany);
            } else {
                ((HashMap)ctx.get((Object)"rptComapanyID")).put(companyid, company);
            }
        }
        return company;
    }

    public static PeriodCollection getPeriodByDateAtServer(Context ctx, Date startDate, Date endDate, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        String keyString = "";
        PeriodCollection periodCL = null;
        keyString = startDate.toString() + endDate.toString() + companyInfo.toString();
        if (ctx.get((Object)"rptPeriodCache") != null && (periodCL = (PeriodCollection)((HashMap)ctx.get((Object)"rptPeriodCache")).get(keyString)) != null) {
            return periodCL;
        }
        periodCL = PeriodUtils.getPeriodCollection((Context)ctx, (Date)startDate, (Date)startDate, (CompanyOrgUnitInfo)companyInfo);
        if (periodCL != null) {
            if (ctx.get((Object)"rptPeriodCache") == null) {
                HashMap<String, PeriodCollection> rptPeriodCache = new HashMap<String, PeriodCollection>();
                rptPeriodCache.put(keyString, periodCL);
                ctx.put((Object)"rptPeriodCache", rptPeriodCache);
            } else {
                ((HashMap)ctx.get((Object)"rptPeriodCache")).put(keyString, periodCL);
            }
        }
        return periodCL;
    }

    public static PeriodInfo getStartPeriodByCompany(Context ctx, String companyID) throws BOSException, EASBizException {
        PeriodInfo period = null;
        if (ctx.get((Object)"rptStartPeriodCache") != null && (period = (PeriodInfo)((HashMap)ctx.get((Object)"rptStartPeriodCache")).get(companyID)) != null) {
            return period;
        }
        period = GlUtils.getStartPeriod((Context)ctx, (String)companyID);
        if (period != null) {
            if (ctx.get((Object)"rptStartPeriodCache") == null) {
                HashMap<String, PeriodInfo> rptStartPeriodCache = new HashMap<String, PeriodInfo>();
                rptStartPeriodCache.put(companyID, period);
                ctx.put((Object)"rptStartPeriodCache", rptStartPeriodCache);
            } else {
                ((HashMap)ctx.get((Object)"rptStartPeriodCache")).put(companyID, period);
            }
        }
        return period;
    }

    public static PeriodInfo getCurrentPeriodByCompany(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        PeriodInfo period = null;
        String companyID = "";
        if (company != null) {
            companyID = company.getId().toString();
        }
        if (ctx.get((Object)"rptCurrPeriodCache") != null && (period = (PeriodInfo)((HashMap)ctx.get((Object)"rptCurrPeriodCache")).get(companyID)) != null) {
            return period;
        }
        period = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
        if (period != null) {
            if (ctx.get((Object)"rptCurrPeriodCache") == null) {
                HashMap<String, PeriodInfo> rptCurrPeriodCache = new HashMap<String, PeriodInfo>();
                rptCurrPeriodCache.put(companyID, period);
                ctx.put((Object)"rptCurrPeriodCache", rptCurrPeriodCache);
            } else {
                ((HashMap)ctx.get((Object)"rptCurrPeriodCache")).put(companyID, period);
            }
        }
        return period;
    }

    public static int getScaleByCyNumAtServer(Context ctx, String strNumber) {
        if (ctx.get((Object)"rptCurrencyCache") != null && ((HashMap)ctx.get((Object)"rptCurrencyCache")).containsKey(strNumber)) {
            return (Integer)((HashMap)ctx.get((Object)"rptCurrencyCache")).get(strNumber);
        }
        int scale = 2;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)strNumber));
        SelectorItemCollection sic = view.getSelector();
        SelectorItemCollection sic_1 = new SelectorItemCollection();
        sic_1.add(new SelectorItemInfo("precision"));
        sic.addObjectCollection((IObjectCollection)sic_1);
        try {
            ICurrency cy = CurrencyFactory.getLocalInstance((Context)ctx);
            CurrencyCollection cyCol = cy.getCurrencyCollection(view);
            if (cyCol != null && cyCol.size() > 0) {
                CurrencyInfo cyInfo = cyCol.get(0);
                scale = cyInfo.getPrecision();
                scale = scale < 0 ? 0 : scale;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        if (ctx.get((Object)"rptCurrencyCache") == null) {
            HashMap<String, Integer> rptCurrencyCache = new HashMap<String, Integer>();
            rptCurrencyCache.put(strNumber, new Integer(scale));
            ctx.put((Object)"rptCurrencyCache", rptCurrencyCache);
        } else {
            ((HashMap)ctx.get((Object)"rptCurrencyCache")).put(strNumber, new Integer(scale));
        }
        return scale;
    }

    public static boolean checkExistsRequisition(Context context, ReportBaseInfo info) throws Exception {
        ReportBaseCollection c = new ReportBaseCollection();
        c.add(info);
        return RptUtilForServer.checkExistsRequisition(context, (IObjectCollection)c);
    }

    public static boolean checkExistsRequisition(Context context, IObjectCollection coll) throws Exception {
        List list = null;
        String p1 = ParamManager.getParamValue((Context)context, null, (String)"GR_CSL_CACHECK_001");
        if (!RptUtil.isTrue(p1)) {
            return false;
        }
        p1 = ParamManager.getParamValue((Context)context, (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getId()), (String)"GLG01");
        if (!RptUtil.isTrue(p1)) {
            return false;
        }
        IVoucher iV = VoucherFactory.getLocalInstance((Context)context);
        for (ReportBaseInfo info : coll) {
            List checked;
            int period = info.getPeriod();
            int year = info.getYear();
            if (RptPeriodTypeEnum.MONTHLY != info.getPeriodType()) {
                Date periodLastDate = RPTDateUtil.getPeriodLastDate((int)year, (int)period, (RptPeriodTypeEnum)info.getPeriodType());
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(periodLastDate);
                year = calendar.get(1);
                period = calendar.get(2) + 1;
            }
            list = checked = iV.requisitionCheckData(String.valueOf(year) + '.' + String.valueOf(period), 1, 2);
        }
        return list != null && list.size() > 0 && (Integer)list.get(0) != 0;
    }

    public static void checkTemplateDataPermission(Context context, String permItem, IObjectPK dataPK) throws BOSException, EASBizException {
        IPermission perm = PermissionFactory.getLocalInstance((Context)context);
        IObjectPK userPK = context.getCaller();
        ObjectUuidPK orgPK = new ObjectUuidPK(ContextUtil.getCurrentFIUnit((Context)context).getId());
        perm.checkDataPermission(userPK, (IObjectPK)orgPK, permItem, dataPK);
    }

    public static boolean editDataIsInWorkflow(Context context, ResponseContext response, String editDataID) throws Exception {
        IEnactmentService engine = EnactmentServiceFactory.createEnactService((Context)context);
        AssignmentInfo[] assignments = engine.checkAssignmentInfos(editDataID, context.getCaller().toString());
        Class[] typeClass = new Class[]{String.class, String.class};
        Object[] paramsValue = new Object[]{editDataID, context.getCaller().toString()};
        BaseFrameService.getMultiKey((ResponseContext)response, IEnactmentService.class, (String)"checkAssignmentInfos", (Class[])typeClass, (Object[])paramsValue, (Object)assignments);
        return assignments != null && assignments.length != 0;
    }

    public static CurrencyInfo getCurrenctCurrencyFromDatabase(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        if (company == null) {
            return null;
        }
        CurrencyInfo baseCurrency = company.getBaseCurrency();
        String currencyIdString = null;
        currencyIdString = baseCurrency == null || baseCurrency.getNumber() == null ? ((CompanyOrgUnitInfo)CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(company.getId()))).getBaseCurrency().getId().toString() : baseCurrency.getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)currencyIdString));
        view.setFilter(filter);
        CurrencyInfo currencyInfo = (CurrencyInfo)CurrencyFactory.getLocalInstance((Context)ctx).getCollection(view).get(0);
        return currencyInfo;
    }

    public static String getCurrencyIDByNumber(Context ctx, String currencyNumber) throws BOSException, EASBizException {
        String strCurrencyID = null;
        if (ctx.get((Object)"rptCurrency") != null && (strCurrencyID = (String)((HashMap)ctx.get((Object)"rptCurrency")).get(currencyNumber)) != null) {
            return strCurrencyID;
        }
        String strSql = "Select FID from T_Bd_Currency where FNumber = ?";
        Object[] params = new Object[]{currencyNumber};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSql, (Object[])params);
        try {
            while (rs.next()) {
                strCurrencyID = rs.getString("FID");
                if (ctx.get((Object)"rptCurrency") == null) {
                    HashMap<String, String> rptCurrency = new HashMap<String, String>();
                    rptCurrency.put(currencyNumber, strCurrencyID);
                    ctx.put((Object)"rptCurrency", rptCurrency);
                    continue;
                }
                ((HashMap)ctx.get((Object)"rptCurrency")).put(currencyNumber, strCurrencyID);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return strCurrencyID;
    }

    public static String getPeriodID(Context ctx, int iYear, int iPeriod, String strPeriodTypeID) throws BOSException, EASBizException {
        String strPeriodID = null;
        String strKey = strPeriodTypeID + "-" + iYear + "-" + iPeriod;
        if (ctx.get((Object)"rptPeriod") != null && (strPeriodID = (String)((HashMap)ctx.get((Object)"rptPeriod")).get(strKey)) != null) {
            return strPeriodID;
        }
        String strSql = "Select FID from T_Bd_Period where FPeriodYear = ? and FPeriodNumber = ? and FTypeID = ?";
        Object[] params = new Object[]{new Integer(iYear), new Integer(iPeriod), strPeriodTypeID};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSql, (Object[])params);
        try {
            if (rs.next()) {
                strPeriodID = rs.getString("FID");
                if (ctx.get((Object)"rptPeriod") == null) {
                    HashMap<String, String> rptPeriod = new HashMap<String, String>();
                    rptPeriod.put(strKey, strPeriodID);
                    ctx.put((Object)"rptPeriod", rptPeriod);
                } else {
                    ((HashMap)ctx.get((Object)"rptPeriod")).put(strKey, strPeriodID);
                }
                return strPeriodID;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        throw new ReportException(ReportException.ACCTEXT_NULL_PERIOD);
    }

    public static List getSuperCompanyIDs(Context ctx, String companyID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("Select distinct super.FID ID from T_ORG_Company super\t\t\n");
        sql.append("inner join T_ORG_Company sub on charindex(concat(super.flongnumber,'!'),sub.flongnumber) = 1\t\t\n");
        sql.append("where sub.fid = ?\t\t\t\t\t\n");
        sql.append("and super.fid <> ?\t\t\t\t\t\n");
        sql.append("and (Super.fid = Sub.fid or charindex(concat(Super.flongnumber,'!'),Sub.flongnumber) = 1 )\t\t\t\n");
        sql.append("and super.fiscompanyorgunit = 1 \t\n");
        sql.append("and super.FIssealup = 0 \t\t\t\n");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID, companyID});
        ArrayList<String> result = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                result.add(rowSet.getString("ID"));
            }
            return result;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public static String createInStringSql(Iterator iterator, Context ctx) throws SQLDataException {
        if (!iterator.hasNext()) {
            Locale locale = null;
            locale = ctx == null ? SysContext.getSysContext().getOriginLocale() : ctx.getOriginLocale();
            throw new SQLDataException(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"25_AcctAcCalculator", (Locale)locale));
        }
        boolean first = true;
        StringBuffer sql = new StringBuffer("\n(");
        while (iterator.hasNext()) {
            if (first) {
                sql.append(" '").append(iterator.next()).append("' ");
                first = false;
                continue;
            }
            sql.append(" ,'").append(iterator.next()).append("' ");
        }
        sql.append(")\n");
        return sql.toString();
    }

    public static String createInNumberSql(Iterator iterator, Context ctx) throws SQLDataException {
        if (!iterator.hasNext()) {
            throw new SQLDataException(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"25_AcctAcCalculator", (Locale)ctx.getOriginLocale()));
        }
        boolean first = true;
        StringBuffer sql = new StringBuffer("\n(");
        while (iterator.hasNext()) {
            Object object = iterator.next();
            Object value = null;
            value = object instanceof IntEnum ? new Integer(((IntEnum)object).getValue()) : object.toString();
            if (first) {
                sql.append(value);
                first = false;
                continue;
            }
            sql.append(" ,").append(value);
        }
        sql.append(")\n");
        return sql.toString();
    }

    public static String createInEnumSql(Iterator iterator, List params, Context ctx) throws SQLDataException {
        if (!iterator.hasNext()) {
            throw new SQLDataException(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"25_AcctAcCalculator", (Locale)ctx.getOriginLocale()));
        }
        boolean first = true;
        StringBuffer sql = new StringBuffer("\n(");
        while (iterator.hasNext()) {
            Object object = iterator.next();
            Object value = null;
            value = object instanceof IntEnum ? new Integer(((IntEnum)object).getValue()) : object.toString();
            if (first) {
                sql.append(" ? ");
                params.add(value);
                first = false;
                continue;
            }
            sql.append(" , ? ");
            params.add(value);
        }
        sql.append(")\n");
        return sql.toString();
    }

    public static String createInSql(Iterator iterator, List params) throws SQLDataException {
        if (!iterator.hasNext()) {
            throw new SQLDataException(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"25_AcctAcCalculator", (Locale)SysContext.getSysContext().getOriginLocale()));
        }
        boolean first = true;
        StringBuffer sql = new StringBuffer("\n(");
        while (iterator.hasNext()) {
            if (first) {
                sql.append(" ? ");
                params.add(iterator.next());
                first = false;
                continue;
            }
            sql.append(" , ?");
            params.add(iterator.next());
        }
        sql.append(")\n");
        return sql.toString();
    }

    public static String getCommonDataRule(Context context, IObjectPK userPK, IObjectPK orgPK, String permItemName) throws EASBizException, BOSException {
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache((Context)context).getPermItem(context, permItemName);
        String userID = userPK.toString();
        String orgID = orgPK.toString();
        String permItemID = permItemInfo.getId().toString();
        Object[] params = new Object[]{userID, orgID, permItemID, new Integer(10), userID, orgID, permItemID, new Integer(10)};
        StringBuffer sql = new StringBuffer(2000);
        sql.append(" SELECT UserOrgPerm.FRuleExpr FROM T_PM_UserOrgPerm UserOrgPerm \n").append(" WHERE UserOrgPerm.FOwner = ?                                      \n").append(" AND UserOrgPerm.FOrgID = ?                                        \n").append(" AND UserOrgPerm.FPermItemID = ?                                   \n").append(" AND UserOrgPerm.FPermType = ?                                     \n").append(" UNION ALL                                                         \n").append(" SELECT RolePerm.FRuleExpr FROM T_PM_RolePerm RolePerm             \n").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON UserRoleOrg.FRoleID = RolePerm.FRoleID \n").append(" WHERE UserRoleOrg.FUserID = ?                                     \n");
        if (OrgType.NONE.equals((Object)permItemInfo.getOrgRelation())) {
            sql.append(" AND ( 1= 1 OR UserRoleOrg.FOrgID = ? )                     \n");
        } else {
            sql.append(" AND UserRoleOrg.FOrgID = ?                                 \n");
        }
        sql.append(" AND RolePerm.FPermItemID = ?                                   \n").append(" AND RolePerm.FPermType = ?                                        \n");
        IRowSet rowSet = DbUtil.executeQuery((Context)context, (String)sql.toString(), (Object[])params);
        try {
            String rule = null;
            HashSet<String> retSet = new HashSet<String>();
            while (rowSet.next()) {
                retSet.add(rowSet.getString("FRuleExpr"));
            }
            for (String ruleExpr : retSet) {
                rule = RuleUtil.mergeOQL(rule, (String)ruleExpr, (String)"OR");
            }
            return rule;
        }
        catch (Exception e) {
            throw new PermissionException(PermissionException.GET_INFO_FAIL, (Throwable)e);
        }
    }

    public static Book LockBookExpTank(Book book) {
        return RptUtilForServer.isLockBookExpTank(book, true);
    }

    public static Book isLockBookExpTank(Book book, boolean isLock) {
        RptCheckExpTank tank;
        if (book == null) {
            return null;
        }
        BookProperties p = BookProperties.loadFromBook(book);
        if (p == null) {
            p = new BookProperties();
            p.restoreToBook(book);
        }
        if ((tank = p.getOperationSchema().getExpTank()) != null && tank.getExpressions() != null) {
            for (RptCheckExpression exp : tank.getExpressions()) {
                if (exp == null) continue;
                exp.setStatus(isLock ? 0 : 3);
            }
        }
        return book;
    }

    public static void prepareReportInfo4Save(IObjectValue model, Book book, Context ctx) {
        if (model instanceof ReportInfo || model instanceof TemplateInfo || model instanceof CslReportInfo) {
            VirtualSheetParamInfo virtualSheetParamInfo = (VirtualSheetParamInfo)model;
            if (book == null || virtualSheetParamInfo.getZipData() == null || virtualSheetParamInfo.getZipData().length <= 0) {
                return;
            }
            PostilCollection postils = null;
            ReportVariables variables = ReportVariables.loadFromBook((Book)book);
            virtualSheetParamInfo.getSheetParam().clear();
            postils = virtualSheetParamInfo instanceof ReportBaseInfo ? ((ReportBaseInfo)virtualSheetParamInfo).getPostils() : ((TemplateInfo)virtualSheetParamInfo).getPostils();
            postils.clear();
            Comment bookcomment = book.getComment();
            RptCommentTank ct = null;
            ct = !(bookcomment instanceof RptCommentTank) ? CommentUtil.convertComment((Comment)bookcomment, (UserInfo)ContextUtil.getCurrentUserInfo((Context)ctx)) : (RptCommentTank)bookcomment;
            if (ct != null) {
                int n = ct.getSize();
                for (int i = 0; i < n; ++i) {
                    PostilInfo source = ct.getEntry(i).getTrueSource();
                    source.setPostilType(PostilTypeEnum.REPORT);
                    postils.add(source);
                    if (virtualSheetParamInfo instanceof ReportBaseInfo) {
                        source.setReport((ReportBaseInfo)virtualSheetParamInfo);
                        continue;
                    }
                    source.setTemplate((TemplateInfo)virtualSheetParamInfo);
                }
            }
            for (int i = 0; i < book.getSheetCount(); ++i) {
                Sheet sheet = book.getSheet(i);
                String name = sheet.getSheetName();
                RptSheetParamInfo pinfo = VariablesHelper.variables2SheetParams((ReportVariables)variables, (String)name, (boolean)true, (Context)ctx);
                pinfo.setSheetID(sheet.getID());
                if (virtualSheetParamInfo instanceof CslReportInfo) {
                    pinfo.setRelaType(ReportTypeEnum.CSLREPORT);
                } else if (virtualSheetParamInfo instanceof ReportInfo) {
                    pinfo.setRelaType(ReportTypeEnum.REPORT);
                } else if (virtualSheetParamInfo instanceof TemplateInfo) {
                    pinfo.setRelaType(ReportTypeEnum.TEMPLATE);
                }
                virtualSheetParamInfo.getSheetParam().add(pinfo);
                RptUtilForServer.pickPostil(virtualSheetParamInfo, sheet, postils, pinfo, ctx);
            }
        }
    }

    private static void pickPostil(VirtualSheetParamInfo virtualSheetParamInfo, Sheet sheet, PostilCollection postils, RptSheetParamInfo p, Context ctx) {
        Comment bookcomment = sheet.getComment();
        RptCommentTank ct = null;
        ct = !(bookcomment instanceof RptCommentTank) ? CommentUtil.convertComment((Comment)bookcomment, (UserInfo)ContextUtil.getCurrentUserInfo((Context)ctx)) : (RptCommentTank)bookcomment;
        if (ct != null) {
            int n = ct.getSize();
            for (int i = 0; i < n; ++i) {
                PostilInfo source = (PostilInfo)ct.getEntry(i).getTrueSource().clone();
                source.setPostilType(PostilTypeEnum.SHEET);
                source.setSheet(p);
                if (virtualSheetParamInfo instanceof ReportBaseInfo) {
                    source.setReport((ReportBaseInfo)virtualSheetParamInfo);
                } else {
                    source.setTemplate((TemplateInfo)virtualSheetParamInfo);
                }
                postils.add(source);
            }
        }
        Sheet.ICellsIterator it = sheet.getCellsIterator(null, false, true);
        while (it.hasNext()) {
            Cell cell = it.next();
            ct = CommentUtil.getReportComment((Cell)cell);
            if (ct == null) continue;
            int n = ct.getSize();
            for (int i = 0; i < n; ++i) {
                PostilInfo source = (PostilInfo)ct.getEntry(i).getTrueSource().clone();
                source.setPostilType(PostilTypeEnum.CELL);
                source.setSheet(p);
                source.setCellName(cell.getName(false, false));
                if (virtualSheetParamInfo instanceof ReportBaseInfo) {
                    source.setReport((ReportBaseInfo)virtualSheetParamInfo);
                } else {
                    source.setTemplate((TemplateInfo)virtualSheetParamInfo);
                }
                postils.add(source);
                ItemFormula f = (ItemFormula)cell.getUserObjectValue("ITEM");
                if (f == null) continue;
                String num = f.getItemNumber();
                if (num == null || num.trim().length() < 1) {
                    num = f.getDItemNumber();
                }
                source.setItemNumber(num);
            }
        }
    }
}

