/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.eas.fi.rpt.CalculateErrorHandler;
import com.kingdee.eas.fi.rpt.util.IObjectIterator;
import com.kingdee.eas.fi.rpt.util.UserObjectTrans;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ReportCalculateErrorProvider
implements IErrorProvider,
Serializable {
    private static final long serialVersionUID = 3407096602685972803L;
    protected static final Logger logger = Logger.getLogger(ReportCalculateErrorProvider.class);
    public static final String _BAD_FUNCTION_ = "#BAD FUNCTION ";
    private String exceptionReplacer = null;
    private boolean dealException = false;
    private transient Variant replacer = null;
    private String zeroDivDisplayAs = null;
    private boolean dealDiv0Error = false;
    private static Map errormap = new ConcurrentHashMap(4);
    protected static ThreadLocal tl = new ThreadLocal();
    private boolean handleShowZero = false;
    private String zeroShowAs = null;

    public static void clear() {
        if (errormap != null) {
            errormap.clear();
        }
    }

    public static IErrorProvider getErrorProvider(Class c) {
        return ReportCalculateErrorProvider.getErrorProvider(c, ReportCalculateErrorProvider.isServierCal());
    }

    public static IErrorProvider getErrorProvider(Class c, boolean isServerCal) {
        IErrorProvider errorProvider;
        Map curErrorMap = null;
        if (isServerCal) {
            String errorSerial = (String)tl.get();
            if (errorSerial != null) {
                curErrorMap = (Map)errormap.get(errorSerial);
            } else {
                return null;
            }
        }
        if (curErrorMap == null) {
            curErrorMap = errormap;
        }
        if ((errorProvider = (IErrorProvider)curErrorMap.get(c)) == null) {
            for (Object k : curErrorMap.keySet()) {
                Class k1;
                if (!(k instanceof Class) || !(k1 = (Class)k).isAssignableFrom(c)) continue;
                errorProvider = (IErrorProvider)curErrorMap.get(k1);
                break;
            }
        }
        return errorProvider;
    }

    public static void addErrorProvider(Class c, IErrorProvider err) {
        ReportCalculateErrorProvider.addErrorProvider(c, err, ReportCalculateErrorProvider.isServierCal());
    }

    public static boolean isServierCal() {
        try {
            int i;
            Exception ex = new Exception();
            StackTraceElement[] elements = ex.getStackTrace();
            int elementLength = elements.length;
            String tmpElement = null;
            int n = i = elementLength > 2 ? 2 : 1;
            while (i < elementLength) {
                tmpElement = elements[i].toString();
                if (!StringUtils.isEmpty((String)tmpElement)) {
                    if (tmpElement.indexOf(".client.") > 0) {
                        return false;
                    }
                    if (tmpElement.indexOf(".app.") > 0) {
                        return true;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            logger.error((Object)"isClient error.", (Throwable)e);
        }
        return false;
    }

    public static void addErrorProvider(Class c, IErrorProvider err, boolean isServerCal) {
        if (err != null) {
            if (isServerCal && err != null && err instanceof ReportCalculateErrorProvider) {
                try {
                    String errorSerial = ((ReportCalculateErrorProvider)err).toSerialString();
                    tl.set(errorSerial);
                    HashMap<Class, IErrorProvider> curErrorMap = (HashMap<Class, IErrorProvider>)errormap.get(errorSerial);
                    if (curErrorMap == null) {
                        curErrorMap = new HashMap<Class, IErrorProvider>();
                        errormap.put(errorSerial, curErrorMap);
                    }
                    curErrorMap.put(c, err);
                }
                catch (Exception ex) {
                    logger.error((Object)"toSerialString error", (Throwable)ex);
                }
            } else {
                errormap.put(c, err);
            }
        }
    }

    public static void clearErrorProvider() {
        if (errormap == null) {
            return;
        }
        errormap.clear();
    }

    public Variant getProperValue(Exception e) {
        if (this.dealException) {
            if (this.replacer == null) {
                this.replacer = new Variant((Object)this.exceptionReplacer);
            }
            return this.replacer;
        }
        String m = null;
        m = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException().getMessage() : e.getMessage();
        return new Variant((Object)(_BAD_FUNCTION_ + m));
    }

    public ReportCalculateErrorProvider() {
    }

    public ReportCalculateErrorProvider(String v, boolean b) {
        this.setDealException(b);
        this.setExceptionReplacer(v);
    }

    public ReportCalculateErrorProvider(CalculateErrorHandler h) {
        this.setDealException(h.isDealException());
        this.setExceptionReplacer(h.getExceptionReplacer());
    }

    public boolean isDealException() {
        return this.dealException;
    }

    public void setDealException(boolean dealException) {
        this.dealException = dealException;
    }

    public Serializable getExceptionReplacer() {
        return this.exceptionReplacer;
    }

    public void setExceptionReplacer(String exceptionReplacer) {
        this.replacer = new Variant((Object)exceptionReplacer);
        this.exceptionReplacer = exceptionReplacer;
    }

    public String getZeroDivDisplayAs() {
        return this.zeroDivDisplayAs;
    }

    public void setZeroDivDisplayAs(String zeroDivDisplayAs) {
        this.zeroDivDisplayAs = zeroDivDisplayAs;
    }

    public void fromSerialString(String s) throws Exception {
        Boolean b;
        IObjectIterator oi = UserObjectTrans.createObjectIterator(s);
        if (oi.hasNext()) {
            this.exceptionReplacer = (String)oi.nextObject();
        }
        if (oi.hasNext()) {
            b = (Boolean)oi.nextObject();
            boolean bl = this.dealException = b == null ? false : b;
        }
        if (oi.hasNext()) {
            this.zeroDivDisplayAs = (String)oi.nextObject();
        }
        if (oi.hasNext()) {
            b = (Boolean)oi.nextObject();
            boolean bl = this.dealDiv0Error = b == null ? false : b;
        }
        if (oi.hasNext()) {
            this.zeroShowAs = (String)oi.nextObject();
        }
        if (oi.hasNext()) {
            b = (Boolean)oi.nextObject();
            this.handleShowZero = b == null ? false : b;
        }
    }

    public String toSerialString() throws Exception {
        StringBuffer sb = new StringBuffer();
        UserObjectTrans.toString(this.exceptionReplacer, sb);
        UserObjectTrans.toString(this.dealException, sb);
        UserObjectTrans.toString(this.zeroDivDisplayAs, sb);
        UserObjectTrans.toString(this.dealDiv0Error, sb);
        UserObjectTrans.toString(this.zeroShowAs, sb);
        UserObjectTrans.toString(this.handleShowZero, sb);
        return sb.toString();
    }

    public boolean isDealDiv0Error() {
        return this.dealDiv0Error;
    }

    public void setDealDiv0Error(boolean dealDiv0Error) {
        this.dealDiv0Error = dealDiv0Error;
    }

    public boolean isHandleShowZero() {
        return this.handleShowZero;
    }

    public void setHandleShowZero(boolean handleShowZero) {
        this.handleShowZero = handleShowZero;
    }

    public String getZeroShowAs() {
        return this.zeroShowAs;
    }

    public void setZeroShowAs(String zeroShowAs) {
        this.zeroShowAs = zeroShowAs;
    }
}

