/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.util;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.eas.fi.rpt.ISheetEditObserver;
import com.kingdee.eas.fi.rpt.util.IObjectIterator;
import com.kingdee.eas.fi.rpt.util.UserObjectTrans;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public class ReportVariables
implements ISheetEditObserver,
Serializable {
    private static final long serialVersionUID = 3078942887907268381L;
    private ArrayList variables = new ArrayList();

    public static ReportVariables loadFromBook(Book book) {
        return (ReportVariables)book.getUserObjectValue("VARIABLES");
    }

    public void add(VariableEntry[] e) {
        if (e != null && e.length > 0) {
            for (int i = 0; i < e.length; ++i) {
                this.variables.add(e[i]);
            }
        }
    }

    public VariableEntry[] getSheetVart(String sheet) {
        ArrayList<VariableEntry> list = new ArrayList<VariableEntry>();
        for (VariableEntry var : this.variables) {
            if (!sheet.equalsIgnoreCase(var.getSheetName())) continue;
            list.add(var);
        }
        return list.toArray(new VariableEntry[list.size()]);
    }

    public void storeToBook(Book book) {
        book.setUserObject("VARIABLES", (Object)this);
    }

    public void add(VariableEntry e) {
        this.variables.add(e);
    }

    public void addWithoutDup(VariableEntry e) {
        VariableEntry entry = this.get(e);
        if (entry == null) {
            this.variables.add(e);
        } else {
            entry.setQuery(e.getQuery());
        }
    }

    public void addOrReplace(VariableEntry e) {
        VariableEntry var = this.get(e);
        if (var == null) {
            this.variables.add(e);
        } else {
            var.copyFrom(e);
        }
    }

    public void addAll(ReportVariables variables, boolean allowDuplicate) {
        if (variables == null || variables.getAllVariables().size() < 1) {
            return;
        }
        ArrayList vs = variables.getAllVariables();
        for (int i = 0; i < vs.size(); ++i) {
            if (allowDuplicate) {
                this.add((VariableEntry)vs.get(i));
                continue;
            }
            this.addWithoutDup((VariableEntry)vs.get(i));
        }
    }

    public int indexOf(VariableEntry e) {
        return this.variables.indexOf(e);
    }

    public boolean contains(String name, String sheetName) {
        return this.variables.contains(new VariableEntry(name, sheetName));
    }

    public boolean contains(VariableEntry v) {
        return this.variables.contains(v);
    }

    public VariableEntry get(VariableEntry var) {
        int i = this.variables.indexOf(var);
        if (i < 0) {
            return null;
        }
        return (VariableEntry)this.variables.get(i);
    }

    public VariableEntry get(String name, String sheetName) {
        return this.get(new VariableEntry(name, sheetName));
    }

    public int getIntValue(String name, String sheetName, int defaultV) {
        VariableEntry entry = this.get(name, sheetName);
        if (entry == null) {
            return defaultV;
        }
        return entry.getIntValue(defaultV);
    }

    public String getStringValue(String name, String sheetName) {
        VariableEntry entry = this.get(name, sheetName);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public boolean getBoolValue(String name, String sheetName, boolean defaultValue) {
        VariableEntry entry = this.get(name, sheetName);
        if (entry == null) {
            return defaultValue;
        }
        return entry.getBoolValue(defaultValue);
    }

    public boolean remove(String name, String sheetName) {
        VariableEntry var = new VariableEntry(name, sheetName);
        return this.variables.remove(var);
    }

    public boolean remove(VariableEntry v) {
        return this.variables.remove(v);
    }

    public void clear() {
        this.variables.clear();
    }

    public ArrayList getAllVariables() {
        return this.variables;
    }

    public void fromSerialString(String s) throws Exception {
        IObjectIterator it = UserObjectTrans.createObjectIterator(s);
        if (it.hasNext()) {
            this.variables = (ArrayList)it.nextObject();
        }
        if (this.variables == null) {
            this.variables = new ArrayList();
        }
    }

    public String toSerialString() throws Exception {
        StringBuffer sb = new StringBuffer();
        UserObjectTrans.toString(this.variables, sb);
        return sb.toString();
    }

    @Override
    public void onDeleteSheet(String sheet) {
        Iterator it = this.variables.iterator();
        while (it.hasNext()) {
            VariableEntry var = (VariableEntry)it.next();
            if (!sheet.equalsIgnoreCase(var.getSheetName())) continue;
            it.remove();
        }
    }

    @Override
    public void onRenameSheet(String oldName, String newName) {
        for (int i = 0; i < this.variables.size(); ++i) {
            VariableEntry var = (VariableEntry)this.variables.get(i);
            if (var.getSheetName() == null || oldName == null || !var.getSheetName().equalsIgnoreCase(oldName)) continue;
            var.setSheetName(newName);
        }
    }

    @Override
    public void onAddNewSheet(String newSheet) {
    }

    public ReportVariables copy() {
        ReportVariables vars = new ReportVariables();
        if (this.variables == null) {
            return vars;
        }
        for (int i = 0; i < this.variables.size(); ++i) {
            VariableEntry var = (VariableEntry)this.variables.get(i);
            vars.add(var.copy());
        }
        return vars;
    }

    public void add(int ix, VariableEntry e) {
        this.variables.add(ix, e);
    }

    public int size() {
        if (this.variables == null) {
            return 0;
        }
        return this.variables.size();
    }

    public VariableEntry get(int i) {
        return (VariableEntry)this.variables.get(i);
    }
}

