/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.ElStateServiceFacadeFactory;
import com.kingdee.eas.fm.be.ElStatementBillCollection;
import com.kingdee.eas.fm.be.ElStatementBillFactory;
import com.kingdee.eas.fm.be.IElStateServiceFacade;
import com.kingdee.eas.fm.be.IElStatementBill;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ElStatementServiceHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.be.ElStatementServiceHelper");

    public static Map<String, byte[]> getFilesByElStateIdList(Context ctx, List<String> idList) throws BOSException, EASBizException {
        if (idList == null || idList.size() == 0) {
            return new HashMap<String, byte[]>();
        }
        IElStateServiceFacade ifacade = ElStatementServiceHelper.getIElStateServiceFacade(ctx);
        return ifacade.getFilesByElStateIds(idList);
    }

    public static Map<String, byte[]> getFilesByElStateIdList(Context ctx, List<String> idList, boolean isConvertToPDF) throws BOSException, EASBizException {
        if (idList == null || idList.size() == 0) {
            return new HashMap<String, byte[]>();
        }
        IElStateServiceFacade ifacade = ElStatementServiceHelper.getIElStateServiceFacade(ctx);
        return ifacade.getFilesByElStateIds(idList, isConvertToPDF);
    }

    public static List<byte[]> getSortedFilesByElStateIdList(Context ctx, List<String> idList, Map sortIems) throws BOSException, EASBizException {
        if (idList == null || idList.size() == 0) {
            return new ArrayList<byte[]>();
        }
        IElStateServiceFacade ifacade = ElStatementServiceHelper.getIElStateServiceFacade(ctx);
        return ifacade.getSortFilesByElStateIds(idList, sortIems);
    }

    public static List<byte[]> getSortedFilesByElStateIdList(Context ctx, List<String> idList, Map sortIems, boolean isConvertToPDF) throws BOSException, EASBizException {
        if (idList == null || idList.size() == 0) {
            return new ArrayList<byte[]>();
        }
        IElStateServiceFacade ifacade = ElStatementServiceHelper.getIElStateServiceFacade(ctx);
        return ifacade.getSortFilesByElStateIds(idList, sortIems, isConvertToPDF);
    }

    private static IElStateServiceFacade getIElStateServiceFacade(Context ctx) throws BOSException, EASBizException {
        if (ctx == null) {
            return ElStateServiceFacadeFactory.getRemoteInstance();
        }
        return ElStateServiceFacadeFactory.getLocalInstance(ctx);
    }

    public static ElStatementBillCollection getElStatementCollection(Context ctx, Date beginDate, Date endDate, Timestamp updateTime, String companyId) throws EASBizException, BOSException {
        EntityViewInfo elStatementView = new EntityViewInfo();
        SelectorItemCollection elStatementSic = new SelectorItemCollection();
        elStatementSic.add(new SelectorItemInfo("*"));
        elStatementView.setSelector(elStatementSic);
        FilterInfo elStatementFilter = new FilterInfo();
        elStatementFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        elStatementFilter.getFilterItems().add(new FilterItemInfo("transDate", (Object)beginDate, CompareType.GREATER_EQUALS));
        elStatementFilter.getFilterItems().add(new FilterItemInfo("transDate", (Object)endDate, CompareType.LESS_EQUALS));
        if (!EmptyUtil.isEmpty((Object)updateTime)) {
            elStatementFilter.getFilterItems().add(new FilterItemInfo("lastUpdateTime", (Object)updateTime, CompareType.GREATER_EQUALS));
        }
        elStatementView.setFilter(elStatementFilter);
        logger.error((Object)("elStatementView's SQL:" + elStatementView.toString()));
        ElStatementBillCollection coll = ElStatementServiceHelper.getIElStatementBillInstance(ctx).getElStatementBillCollection(elStatementView);
        return coll;
    }

    private static IElStatementBill getIElStatementBillInstance(Context ctx) throws BOSException, EASBizException {
        if (ctx == null) {
            return ElStatementBillFactory.getRemoteInstance();
        }
        return ElStatementBillFactory.getLocalInstance(ctx);
    }
}

