/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.TransDetailInfo;
import com.kingdee.eas.fm.be.TransDetailRecedEnum;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.common.H;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.util.client.EASResource;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

public class TransDetailVerify {
    private static Map<String, String> map = new HashMap<String, String>();

    public static boolean isCanConfirmTransUP(TransDetailInfo info) throws BOSException {
        TransDetailVerify.checkNullProperty(info, new String[]{"isTransUp", "creditAmount"});
        return !info.isIsTransUp() && info.getCreditAmount().compareTo(Constants.ZERO) != 0;
    }

    public static boolean isCanCancelConfirmTransUP(TransDetailInfo info) throws EASBizException {
        FMVerifyHelper.checkProperties((IObjectValue)info, (String[])new String[]{"isTransUp", "isCreatedTransUp"});
        return info.isIsTransUp() && !info.isIsCreatedTransUp();
    }

    public static boolean isCanConfirmTransDown(TransDetailInfo info) throws BOSException {
        TransDetailVerify.checkNullProperty(info, new String[]{"isTransDown", "debitAmount"});
        return !info.isIsTransDown() && info.getDebitAmount().compareTo(Constants.ZERO) != 0;
    }

    public static boolean isCanCancelConfirmTransDown(TransDetailInfo info) throws EASBizException {
        FMVerifyHelper.checkProperties((IObjectValue)info, (String[])new String[]{"isTransDown", "isCreatedtransDown"});
        return info.isIsTransDown() && !info.isIsCreatedtransDown();
    }

    public static boolean isCanConfirmBankWithHolding(TransDetailInfo info) throws BOSException {
        try {
            TransDetailVerify.checkNullProperty(info, new String[]{"isBankWithHolding", "debitAmount"});
        }
        catch (BOSException e) {
            return false;
        }
        return !info.isIsBankWithHolding() && info.getDebitAmount().compareTo(Constants.ZERO) != 0;
    }

    public static boolean isCanCancelConfirmBankWithHolding(TransDetailInfo info) throws EASBizException {
        FMVerifyHelper.checkProperties((IObjectValue)info, (String[])new String[]{"isBankWithHolding", "isReced"});
        return info.isIsBankWithHolding() && TransDetailRecedEnum.toBeReced == info.getIsReced();
    }

    public static void verifyBotpTransUpbill(CoreBillBaseCollection cols) throws EASBizException {
        if (cols.size() == 0) {
            return;
        }
        TransDetailInfo lastInfo = (TransDetailInfo)cols.get(0);
        int n = cols.size();
        for (int i = 1; i < n; ++i) {
            TransDetailInfo info = (TransDetailInfo)cols.get(i);
            if (!info.getBankAccount().equalsPK((IObjectValue)lastInfo.getBankAccount())) {
                throw new BEException(BEException.COMMON, new String[]{MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"91_TransDetailVerify"), TransDetailVerify.getTransDetailTitle(lastInfo), TransDetailVerify.getTransDetailTitle(info))});
            }
            if (!info.getCurrency().equalsPK((IObjectValue)lastInfo.getCurrency())) {
                throw new BEException(BEException.COMMON, new String[]{MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"92_TransDetailVerify"), TransDetailVerify.getTransDetailTitle(lastInfo), TransDetailVerify.getTransDetailTitle(info))});
            }
            lastInfo = info;
        }
    }

    public static String getTransDetailTitle(TransDetailInfo info) {
        if (info == null) {
            return "null";
        }
        return MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"93_TransDetailVerify"), info.getBankAccount().getName(), info.getBizTime(), info.getDebitAmount(), info.getCreditAmount());
    }

    public static boolean isCanRefundPay(TransDetailInfo info) {
        if (info.isHasRefundPay() || info.isIsTransDown() || info.isIsTransUp()) {
            return false;
        }
        return H.BDEC((Object)info.getCreditAmount()).compareTo(Constants.ZERO) == 1 || H.BDEC((Object)info.getDebitAmount()).compareTo(Constants.ZERO) == -1;
    }

    private static void checkNullProperty(TransDetailInfo info, String[] checkProperties) throws BOSException {
        for (int i = 0; i < checkProperties.length; ++i) {
            if (!EmptyUtil.isEmpty((Object)info.get(checkProperties[i]))) continue;
            throw new BOSException(map.get(checkProperties[i]));
        }
    }

    static {
        map.put("creditAmount", EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1269_TransDetailVerify"));
        map.put("debitAmount", EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1270_TransDetailVerify"));
    }
}

