/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.uiframe.client.ui.web20.statistics.StatisticsUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.fm.be.AccountBankBalanceFilterParam;
import com.kingdee.eas.fm.be.AccountBankBalanceInfo;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.BankInterface;
import com.kingdee.eas.fm.be.BeRpcCacheInfo;
import com.kingdee.eas.fm.be.BeServiceAddCollection;
import com.kingdee.eas.fm.be.BeServiceAddFactory;
import com.kingdee.eas.fm.be.BeServiceAddInfo;
import com.kingdee.eas.fm.be.IBankFacade;
import com.kingdee.eas.fm.be.client.AbstractAccountBankBalanceUI;
import com.kingdee.eas.fm.be.client.AccountBankBalanceFilterUI;
import com.kingdee.eas.fm.be.client.BankAcctBalServiceClient;
import com.kingdee.eas.fm.be.client.HttpUtil;
import com.kingdee.eas.fm.common.FMBatchProcessFacadeFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.FmRpcCacheInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AccountBankBalanceUI
extends AbstractAccountBankBalanceUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountBankBalanceUI.class);
    private Set<String> bankAccountNumber = new HashSet<String>();
    public BeRpcCacheInfo envirRpc = (BeRpcCacheInfo)FMBatchProcessFacadeFactory.getRemoteInstance().batchFetchData(this.getRpcCacheParam());
    public static String license = "";
    private AccountBankBalanceFilterUI filterUI;

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnQuery.setText(this.resHelper.getString("ActionQuery.SHORT_DESCRIPTION"));
        this.btnPrint.setText(this.resHelper.getString("ActionPrint.SHORT_DESCRIPTION"));
        this.btnRefresh.setText(this.resHelper.getString("ActionRefresh.NAME"));
        this.btnImport.setEnabled(true);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.getColumn("accountBank").getStyleAttributes().setNumberFormat("@");
        this.tblMain.getColumn("accountBankName").getStyleAttributes().setNumberFormat("@");
        this.tblMain.getColumn("lstBalance").setWidth(150);
        this.tblMain.getColumn("balance").setWidth(150);
        this.tblMain.getColumn("valiBalance").setWidth(150);
        this.menuItemView.setVisible(false);
        FMClientHelper.clearSeparatorOnToolBar((KDToolBar)this.toolBar);
        this.tblMain.setColumnMoveable(true);
        this.tblMain.getColumn("bizDate").getStyleAttributes().setNumberFormat(FMHelper.getDateTimeFormatString());
    }

    protected FmRpcCacheInfo getRpcCacheParam() {
        BeRpcCacheInfo paramInfo = new BeRpcCacheInfo();
        paramInfo.setBatchImplClassName(this.getRpcBatchImplClassName());
        paramInfo.setBillInfo((CoreBaseInfo)new AccountBankBalanceInfo());
        return paramInfo;
    }

    protected String getRpcBatchImplClassName() {
        return "com.kingdee.eas.fm.be.app.BeRpcBatchFetcher";
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public KDTable getMainTable() {
        return this.tblMain;
    }

    public void execQuery() {
        FilterInfo extFilter = this.getBillCanbeReceived();
        try {
            if (extFilter.getFilterItems().size() > 0) {
                this.mainQuery.getFilter().mergeFilter(extFilter, "AND");
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        super.execQuery();
    }

    private FilterInfo getBillCanbeReceived() {
        FilterInfo filter = new FilterInfo();
        if (this.bankAccountNumber.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("accountBank.bankAccountNumber", this.bankAccountNumber, CompareType.NOTINCLUDE));
        }
        return filter;
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"accountBankNumber", "lstBalance", "balance"};
        return locateNames;
    }

    public void executeQuery(FilterParam param) throws BOSException {
        AccountBankBalanceFilterParam filterParam = (AccountBankBalanceFilterParam)param;
        if (filterParam != null && !FMHelper.isEmpty((String)filterParam.getCurrencyId())) {
            String currencyId = filterParam.getCurrencyId();
            FMClientHelper.setNumberFormat((KDTable)this.tblMain, (String)"lstBalance", (String)currencyId);
            FMClientHelper.setNumberFormat((KDTable)this.tblMain, (String)"balance", (String)currencyId);
            FMClientHelper.setNumberFormat((KDTable)this.tblMain, (String)"valiBalance", (String)currencyId);
        }
        if (filterParam != null && filterParam.isOnLine()) {
            IBankFacade iBankFacade = BankFacadeFactory.getRemoteInstance();
            try {
                long startTime = System.currentTimeMillis();
                Map rst = null;
                if (EmptyUtil.isEmpty((String)filterParam.getBankInterface())) {
                    BankAcctBalServiceClient service = new BankAcctBalServiceClient();
                    rst = service.queryBalance(filterParam.getCurrencyId(), filterParam.getBankAccts(), filterParam.getBeginDate(), filterParam.getEndDate());
                } else {
                    AccountBankInfo[] ids = filterParam.getBankAccts();
                    String[] idSet = new String[ids.length];
                    for (int i = 0; i < ids.length; ++i) {
                        idSet[i] = ids[i].getId().toString();
                    }
                    rst = iBankFacade.getBalance(filterParam.getCurrencyId(), idSet, filterParam.getBeginDate(), filterParam.getEndDate());
                }
                long endTime = System.currentTimeMillis();
                logger.error((Object)(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1158_AccountBankBalanceUI") + (endTime - startTime) / 1000L + EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"108_BankInterfaceListUI")));
                if (rst != null && rst.size() > 0) {
                    String detailMsg = (String)rst.get("detailMsg");
                    String summaryMsg = (String)rst.get("summaryMsg");
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)summaryMsg, (String)detailMsg, (int)1);
                    if (!EmptyUtil.isEmpty((String)detailMsg)) {
                        this.bankAccountNumber = new HashSet<String>();
                    }
                }
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
            }
        }
        if (EmptyUtil.isEmpty((String)license)) {
            EntityViewInfo view = new EntityViewInfo();
            view.getSorter().add(new SorterItemInfo("createTime"));
            BeServiceAddCollection coll = BeServiceAddFactory.getRemoteInstance().getBeServiceAddCollection(view);
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)coll) && coll.size() > 0 && !EmptyUtil.isEmpty((String)coll.get(0).getSimpleName())) {
                license = coll.get(0).getSimpleName();
            } else if (!EmptyUtil.isEmpty((AbstractObjectCollection)coll) && coll.size() > 0) {
                license = StatisticsUtil.getEncodedSerialNum();
                SynThread synThread = new SynThread(license, coll);
                synThread.start();
            }
        }
        super.executeQuery(param);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new AccountBankBalanceFilterUI(this.envirRpc);
        }
        return this.filterUI;
    }

    public CommonQueryDialog getQueryDlg() throws Exception {
        CommonQueryDialog dlg = super.getQueryDlg();
        dlg.setShowFilter(true);
        dlg.setShowSorter(true);
        dlg.setWidth(586);
        return dlg;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        logger.info((Object)"dfdf");
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        boolean isPermission = PermissionFactory.getRemoteInstance().hasFunctionPermission(this.getUserPk(), this.getOrgPK(this.actionImport), "acctBankBalance_05import");
        if (!isPermission) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1159_AccountBankBalanceUI"));
            SysUtil.abort();
        }
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.setMainOrgContext(this.getMainOrgContext());
        if (this.getImportParam() != null) {
            task.invoke(this.getImportParam(), 0);
        }
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.fm.be.AcctBankBalance";
        param.alias = EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1160_AccountBankBalanceUI");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected String[] getPrecColName() {
        return new String[]{"lstBalance", "balance", "valiBalance"};
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected IRow appendFootRow() {
        IRow row = super.appendFootRow();
        for (int i = 0; i < this.getPrecColName().length; ++i) {
            row.getCell(this.getPrecColName()[i]).getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)2));
        }
        return row;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    class SynThread
    extends Thread {
        private BeServiceAddCollection coll;
        private String license;

        public SynThread(String license, BeServiceAddCollection coll) {
            this.coll = coll;
            this.license = license;
        }

        @Override
        public void run() {
            try {
                BeServiceAddInfo info = this.coll.get(0);
                info.setSimpleName(this.license);
                Object[] object = BankFacadeFactory.getRemoteInstance().getBankCert("");
                HttpUtil util = new HttpUtil();
                if (object != null) {
                    for (int i = 0; i < object.length; ++i) {
                        BankInterface bankInterfaceInfo = (BankInterface)object[i];
                        HttpUtil.sendGetRequest(this.license + bankInterfaceInfo.getNumber(), bankInterfaceInfo.getName());
                    }
                }
                BeServiceAddFactory.getRemoteInstance().save((CoreBaseInfo)info);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

