/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.fm.be.BEAreaData;
import com.kingdee.eas.fm.be.BEBankData;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.be.BECnapsData;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.client.AbstractBEBankImportUI;
import com.kingdee.eas.fm.be.client.BeAreaF7Selector;
import com.kingdee.eas.fm.be.client.BeBankF7Selector;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BEBankImportUI
extends AbstractBEBankImportUI {
    private static final Logger logger = CoreUIObject.getLogger(BEBankImportUI.class);
    private String resource = "com.kingdee.eas.fm.be.BEAutoGenerateResource";

    public void onLoad() throws Exception {
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int rows = BEBankImportUI.this.tblMain.getRowCount();
                for (int i = 0; i < rows; ++i) {
                    BEBankImportUI.this.tblMain.getRow(i).getCell("isSelected").setValue((Object)Boolean.FALSE);
                }
                BEBankImportUI.this.tblMain.repaint();
            }
        });
        super.onLoad();
        this.btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnRemoveAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.tblMain.checkParsed();
        this.tblMain.getColumn("isSelected").getStyleAttributes().setLocked(false);
        this.initBeBank();
        this.initBeProvince();
        this.kProBeCity.setEnabled(false);
    }

    private void initBeProvince() {
        this.kProBeProvince.setDisplayFormat("$areaName$");
        this.kProBeProvince.setEditFormat("$areaName$");
        HashMap<String, String> type = new HashMap<String, String>();
        type.put("areaCodeType", "province");
        BeAreaF7Selector bitF7Selector = new BeAreaF7Selector((IUIObject)this, this.kProBeProvince, null, type);
        this.kProBeProvince.setSelector((KDPromptSelector)bitF7Selector);
    }

    private void initBeBank() {
        this.kProBeBank.setDisplayFormat("$bankName$");
        this.kProBeBank.setEditFormat("$bankName$");
        BeBankF7Selector bitF7Selector = new BeBankF7Selector((IUIObject)this, this.kProBeBank, null);
        this.kProBeBank.setSelector((KDPromptSelector)bitF7Selector);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    @Override
    protected void kProBeCity_willShow(SelectorEvent e) throws Exception {
        if (EmptyUtil.isEmpty((Object)this.kProBeProvince.getValue())) {
            String msg = EASResource.getString((String)this.resource, (String)"UnselectProvince");
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
        this.kProBeCity.setDisplayFormat("$areaName$");
        this.kProBeCity.setEditFormat("$areaName$");
        HashMap<String, String> type = new HashMap<String, String>();
        type.put("areaCodeType", "city");
        type.put("provinceCode", ((BEAreaData)this.kProBeProvince.getValue()).getAreaCode());
        BeAreaF7Selector bitF7Selector = new BeAreaF7Selector((IUIObject)this, this.kProBeCity, null, type);
        this.kProBeCity.setSelector((KDPromptSelector)bitF7Selector);
    }

    @Override
    protected void kDBtnQuery_actionPerformed(ActionEvent e) throws Exception {
        String msg;
        if (EmptyUtil.isEmpty((Object)this.kProBeBank.getValue())) {
            msg = EASResource.getString((String)this.resource, (String)"UnselectBank");
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
        if (EmptyUtil.isEmpty((Object)this.kProBeCity.getValue())) {
            msg = EASResource.getString((String)this.resource, (String)"UnselectCity");
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
        this.tblMain.removeRows();
        String areaCode = ((BEAreaData)this.kProBeCity.getValue()).getAreaCode();
        logger.error((Object)areaCode);
        String bankCode = ((BEBankData)this.kProBeBank.getValue()).getBankCode();
        logger.error((Object)bankCode);
        Map map = BankFacadeFactory.getRemoteInstance().getBankCnapsByBankAndCity(bankCode, areaCode);
        logger.error((Object)map.size());
        Set keySet = map.keySet();
        logger.error((Object)(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1170_BEBankImportUI") + keySet.toString()));
        Iterator iter = keySet.iterator();
        int i = 0;
        int size = 0;
        while (iter.hasNext()) {
            Object tmp = iter.next();
            logger.error((Object)(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1171_BEBankImportUI") + ++i + EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1172_BEBankImportUI") + (!EmptyUtil.isEmpty(tmp) ? tmp.toString() : "\n")));
            if (EmptyUtil.isEmpty(tmp) || EmptyUtil.isEmpty(map.get(tmp.toString()))) continue;
            ++size;
            BECnapsData data = (BECnapsData)map.get(tmp.toString());
            logger.error((Object)(" -- " + (!EmptyUtil.isEmpty((String)data.getBankAddress()) ? data.getBankAddress() : "null") + " -- " + data.getBankName() + " -- " + data.getBankCnaps()));
            IRow row = this.tblMain.addRow();
            row.getCell("isSelected").setValue((Object)Boolean.FALSE);
            row.getCell("bankCnaps").setValue((Object)data.getBankCnaps());
            row.getCell("bankName").setValue((Object)data.getBankName());
            if (!EmptyUtil.isEmpty((String)data.getBankAddress())) {
                row.getCell("bankAddress").setValue((Object)data.getBankAddress());
                continue;
            }
            row.getCell("bankAddress").setValue((Object)"");
        }
        this.tblMain.setAutoscrolls(true);
        this.tblMain.setRowCount(size);
        this.tblMain.repaint();
        this.kDScrollPane1.setHorizontalScrollBarPolicy(32);
        this.kDScrollPane1.setVerticalScrollBarPolicy(22);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected String getKeyFieldName() {
        return "bankCnaps";
    }

    @Override
    public void actionRemoveAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveAll_actionPerformed(e);
        int rows = this.tblMain.getRowCount();
        for (int i = 0; i < rows; ++i) {
            this.tblMain.getRow(i).getCell("isSelected").setValue((Object)Boolean.FALSE);
        }
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        int rows = this.tblMain.getRowCount();
        for (int i = 0; i < rows; ++i) {
            this.tblMain.getRow(i).getCell("isSelected").setValue((Object)Boolean.TRUE);
        }
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        String msg;
        if (EmptyUtil.isEmpty((Object)this.kProBeBank.getValue())) {
            msg = EASResource.getString((String)this.resource, (String)"UnselectBank");
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
        if (EmptyUtil.isEmpty((Object)this.kProBeCity.getValue())) {
            msg = EASResource.getString((String)this.resource, (String)"UnselectCity");
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
        int rows = this.tblMain.getRowCount();
        HashSet<BEBankInfo> set = new HashSet<BEBankInfo>();
        for (int i = 0; i < rows; ++i) {
            boolean isSelected = (Boolean)this.tblMain.getRow(i).getCell("isSelected").getValue();
            if (!isSelected) continue;
            BEBankInfo info = new BEBankInfo();
            IRow row = this.tblMain.getRow(i);
            info.setNumber(row.getCell("bankCnaps").getValue().toString());
            info.setName(row.getCell("bankName").getValue().toString());
            info.setBeProvince(this.kProBeProvince.getValue().toString());
            info.setBeCity(this.kProBeCity.getValue().toString());
            if (row.getCell("bankAddress").getValue() != null) {
                info.setAdress(row.getCell("bankAddress").getValue().toString());
            }
            set.add(info);
        }
        Map result = BEBankFactory.getRemoteInstance().batchImport(set);
        this.buildResultMessage(result);
    }

    private void buildResultMessage(Map result) {
        Set unChangeData = (Set)result.get("unChangeData");
        Set updateData = (Set)result.get("updateData");
        Set addData = (Set)result.get("addData");
        String msg = EASResource.getString((String)this.resource, (String)"BeBankImportResult");
        String updateSuccess = EASResource.getString((String)this.resource, (String)"updateSuccess");
        String addSuccess = EASResource.getString((String)this.resource, (String)"updateAddSuccess");
        String success = MessageFormat.format(msg, new Integer(addData.size()), new Integer(updateData.size()));
        StringBuffer strBuff = new StringBuffer();
        for (BEBankInfo info : updateData) {
            strBuff.append(MessageFormat.format(EASResource.getString((String)this.resource, (String)"183_BANKCODE"), info.getNumber(), info.getName(), updateSuccess));
        }
        for (BEBankInfo info : addData) {
            strBuff.append(MessageFormat.format(EASResource.getString((String)this.resource, (String)"183_BANKCODE"), info.getNumber(), info.getName(), addSuccess));
        }
        if (strBuff.length() == 0) {
            MsgBox.showInfo((String)success);
        } else {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)success, (String)strBuff.toString(), (int)1);
        }
    }

    @Override
    protected void kProBeProvince_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getOldValue() == null && e.getNewValue() != null || e.getOldValue() != null && e.getNewValue() == null || e.getOldValue() != null && e.getNewValue() != null && !((BEAreaData)e.getOldValue()).getAreaCode().equals(((BEAreaData)e.getNewValue()).getAreaCode())) {
            this.kProBeCity.setValue(null);
        }
        if (e.getNewValue() == null) {
            this.kProBeCity.setEnabled(false);
        } else {
            this.kProBeCity.setEnabled(true);
        }
    }

    @Override
    protected void kProBeCity_dataChanged(DataChangeEvent e) throws Exception {
        this.tblMain.removeRows();
    }

    @Override
    protected void kProBeBank_dataChanged(DataChangeEvent e) throws Exception {
        this.kProBeCity.setValue(null);
        this.kProBeProvince.setValue(null);
        this.tblMain.removeRows();
    }
}

