/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.fm.BankInfo;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BankConfigFacdeFactory;
import com.kingdee.eas.fm.be.BankInterfaceTypeEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;

public final class BEClientHelper {
    private static final String RESOURCEPATH = "com.kingdee.eas.fm.be.beResourse";

    public static void initBankInterface(KDComboBox cmbxBankInterface) {
        cmbxBankInterface.removeAllItems();
        cmbxBankInterface.addItems(BankInterfaceTypeEnum.getEnumList().toArray());
    }

    public static boolean verifyDate(Component ui, KDDatePicker dtpBeginDate, KDDatePicker dtpEndDate) {
        if (dtpBeginDate.getSqlDate() == null) {
            dtpBeginDate.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)RESOURCEPATH, (String)"CheckBeginDate"));
            SysUtil.abort();
        }
        if (dtpEndDate.getSqlDate() == null) {
            dtpEndDate.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)RESOURCEPATH, (String)"CheckEndDate"));
            SysUtil.abort();
        }
        if (DateTimeUtils.truncateDate((Date)dtpEndDate.getSqlDate()).before(DateTimeUtils.truncateDate((Date)dtpBeginDate.getSqlDate()))) {
            dtpEndDate.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)RESOURCEPATH, (String)"ChecBeginAndEndkDate"));
            SysUtil.abort();
        }
        Date curDate = DateTimeUtils.truncateDate((Date)Calendar.getInstance().getTime());
        if (DateTimeUtils.truncateDate((Date)dtpBeginDate.getSqlDate()).after(curDate) || DateTimeUtils.truncateDate((Date)dtpEndDate.getSqlDate()).after(curDate)) {
            dtpEndDate.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)RESOURCEPATH, (String)"CanNotAfterCurDate"));
            SysUtil.abort();
        }
        return true;
    }

    public static void setVersion(BankInterfaceTypeEnum curBankInterfaceType, KDComboBox comversion) throws EASBizException, BOSException {
        comversion.removeAllItems();
        BankInfo[] bankInfo = BankConfigFacdeFactory.getRemoteInstance().getAvaliableBanks();
        for (int i = 0; i < bankInfo.length; ++i) {
            if (!bankInfo[i].getShortName().equalsIgnoreCase(curBankInterfaceType.getName())) continue;
            comversion.addItems((Object[])bankInfo[i].getVersions());
            break;
        }
    }

    public static boolean getIsMulCert() {
        IContextHelper contextHelper = ContextHelperFactory.getRemoteInstance();
        return contextHelper.getBooleanParam("BE005", (IObjectPK)new ObjectUuidPK(contextHelper.getCurrentCompany().getId()));
    }

    public static void initShowOpenArea(KDLabelContainer recPrince, KDLabelContainer recCity, KDLabelContainer recArea, String BE009) {
        if (EmptyUtil.isEmpty((String)BE009)) {
            IContextHelper contextHelper = ContextHelperFactory.getRemoteInstance();
            BE009 = contextHelper.getStringParam("BE009", (IObjectPK)new ObjectUuidPK(contextHelper.getCurrentCompany().getId()));
        }
        if (BE009 == null || "0".equals(BE009)) {
            recPrince.setVisible(true);
            recCity.setVisible(true);
            recArea.setVisible(false);
        } else {
            recPrince.setVisible(false);
            recCity.setVisible(false);
            recArea.setVisible(true);
        }
    }
}

