/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.client.f7.F7ContextInitializationHelper;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.be.BankInterface;
import com.kingdee.eas.fm.be.BeRpcCacheInfo;
import com.kingdee.eas.fm.be.client.AbstractBEpayInterfaceCostFilterUI;
import com.kingdee.eas.fm.be.client.BEClientHelper;
import com.kingdee.eas.fm.be.client.BEpayInterfaceCostFilterParam;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BEpayInterfaceCostFilterUI
extends AbstractBEpayInterfaceCostFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(BEpayInterfaceCostFilterUI.class);
    private static final String F7_ACCOUNT_BANK_QUERY = "com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery";
    private static final String RESOURCEPATH = "com.kingdee.eas.fm.be.beResourse";
    private BeRpcCacheInfo RpcCacheInfo;
    private Map bankInterMap = new HashMap();

    public BEpayInterfaceCostFilterUI() throws Exception {
    }

    public BEpayInterfaceCostFilterUI(BeRpcCacheInfo RpcCacheInfo) throws Exception {
        this.RpcCacheInfo = RpcCacheInfo;
    }

    protected void init() throws Exception {
        super.init();
        this.initBankInterface();
        this.dtpBegin.setValue((Object)DateTimeUtils.addDay((Date)DateUtil.getDayBegin(), (long)-30L));
        this.dtpEnd.setValue((Object)DateUtil.getDayBegin());
        this.dtpBegin.setSupportedEmpty(false);
        this.dtpEnd.setSupportedEmpty(false);
        NewCompanyF7 selector = F7ContextInitializationHelper.getSelectCompany((IUIObject)this, null, null, (boolean)false);
        selector.setUIActionPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fm.be.client", "BEpayInterfaceCostListUI"), (IMetaDataPK)new MetaDataPK("ActionOnLoad"));
        this.chkIA.setVisible(true);
        this.chkIA.setEnabled(true);
        this.btnCompanySelect.setEnabled(false);
        this.btnCompanySelect.setVisible(false);
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            selector.setMultiSelect(false);
        } else {
            this.btnCompanySelect.setEnabled(true);
            this.btnCompanySelect.setVisible(true);
            selector.setMultiSelect(true);
        }
        this.f7BankAccount.setDisplayFormat("$number$ $name$");
        this.f7BankAccount.setCommitFormat("$number$");
        this.f7BankAccount.setEditFormat("$number$");
        this.f7BankAccount.setEnabledMultiSelection(true);
        this.f7BankAccount.setQueryInfo(F7_ACCOUNT_BANK_QUERY);
    }

    private void initBankInterface() throws BOSException, EASBizException {
        this.cmbxBankInterface.removeAllItems();
        AccountBankCollection colls = this.RpcCacheInfo.getBankAcctCol();
        int k = 0;
        this.bankInterMap.clear();
        for (int i = 0; i < colls.size(); ++i) {
            AccountBankInfo info = colls.get(i);
            BankInterface bankAcct = new BankInterface();
            if (FMHelper.isEmpty((String)info.getBankInterFaceID())) continue;
            bankAcct.setNumber(info.getBankInterFaceID());
            bankAcct.setName(info.getBankInterFace());
            if (this.bankInterMap.containsKey(bankAcct.getNumber())) continue;
            this.cmbxBankInterface.addItem((Object)bankAcct);
            this.bankInterMap.put(bankAcct.getNumber(), new Integer(k));
            ++k;
        }
        if (!this.bankInterMap.containsKey(null)) {
            BankInterface bankAcct = new BankInterface();
            bankAcct.setNumber(null);
            bankAcct.setName(EASResource.getString((String)"com.kingdee.eas.fm.be.FmbeResource", (String)"Select_All"));
            this.cmbxBankInterface.addItem((Object)bankAcct);
            this.bankInterMap.put(null, new Integer(this.bankInterMap.size() + 1));
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
    }

    private void initAccountBankEvi() {
        BankInterface bankInterface;
        FilterInfo filterInfo = new FilterInfo();
        FilterInfo companyFilter = new FilterInfo();
        FilterInfo agencyCompanyFilter = new FilterInfo();
        Object[] companyId = this.getCompanyIds();
        if (!FMHelper.isEmpty((Object[])companyId)) {
            HashSet<Object> list = new HashSet<Object>(companyId.length);
            for (int i = 0; i < companyId.length; ++i) {
                list.add(companyId[i]);
            }
            companyFilter.getFilterItems().add(new FilterItemInfo("company.id", list, CompareType.INCLUDE));
            agencyCompanyFilter.getFilterItems().add(new FilterItemInfo("agencyCompany.id", list, CompareType.INCLUDE));
        }
        if (!this.chkIA.isSelected()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("shareType", (Object)2, CompareType.NOTEQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        if (this.cmbxBankInterface.getSelectedItem() instanceof BankInterface && !FMHelper.isEmpty((String)(bankInterface = (BankInterface)this.cmbxBankInterface.getSelectedItem()).getNumber())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bankInterFaceID", (Object)bankInterface.getNumber()));
        }
        try {
            companyFilter.mergeFilter(agencyCompanyFilter, "or");
            filterInfo.mergeFilter(companyFilter, "and");
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        this.f7BankAccount.setEntityViewInfo(evi);
        this.f7BankAccount.getQueryAgent().resetRuntimeEntityView();
    }

    protected NewCompanyF7 getNewCompanyF7() {
        if (FSClientHelper.isCHUser()) {
            try {
                return super.getAllCompanyOrg();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getNewCompanyF7();
    }

    protected void initCompanyState() {
        if (this.currentCompany == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"34_AccountBankBalanceFilterUI"));
            SysUtil.abort();
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            this.btnCompanySelect.setEnabled(true);
            this.btnCompanySelect.setVisible(true);
        } else {
            this.btnCompanySelect.setEnabled(false);
            this.btnCompanySelect.setVisible(false);
        }
    }

    protected void f7Company_dataChanged(DataChangeEvent e) throws Exception {
        this.reSetF7BankAccountQuery();
    }

    @Override
    protected void f7BankAccount_willCommit(CommitEvent e) throws Exception {
        this.initAccountBankEvi();
    }

    @Override
    protected void f7BankAccount_willShow(SelectorEvent e) throws Exception {
        this.initAccountBankEvi();
    }

    public Object getParam() {
        BEpayInterfaceCostFilterParam param = new BEpayInterfaceCostFilterParam();
        param.setBankAcctIds(AccessHelper.getF7Ids((KDBizPromptBox)this.f7BankAccount));
        param.setBeginDate(this.dtpBegin.getSqlDate());
        param.setEndDate(this.dtpEnd.getSqlDate());
        if (this.payingRadio.isSelected()) {
            param.setPayStatus(0);
        }
        if (this.payedRadio.isSelected()) {
            param.setPayStatus(1);
        }
        if (this.cmbxBankInterface.getSelectedItem() instanceof BankInterface) {
            BankInterface bankInterface = (BankInterface)this.cmbxBankInterface.getSelectedItem();
            param.setBEInterfaceId(bankInterface.getNumber());
        } else {
            param.setBEInterfaceId(null);
        }
        param.setMainOrgCollIDSet(this.getCompanyIdSet());
        param.setChkIA(this.chkIA.getSelected());
        return param;
    }

    public void setParam(Object param) {
        BEpayInterfaceCostFilterParam params = (BEpayInterfaceCostFilterParam)param;
        if (params == null) {
            return;
        }
        this.setCompanyIdSet(params.getMainOrgCollIDSet());
        this.dtpBegin.setValue((Object)params.getBeginDate());
        this.dtpEnd.setValue((Object)params.getEndDate());
        if (params.getPayStatus() != null) {
            if (params.getPayStatus().equals(0)) {
                this.payingRadio.setSelected(true);
            }
            if (params.getPayStatus().equals(1)) {
                this.payedRadio.setSelected(true);
            }
        }
        this.chkIA.setSelected(params.getChkIA());
        if (FMHelper.isEmpty((String)params.getBEInterfaceId())) {
            this.cmbxBankInterface.setSelectedItem(this.cmbxBankInterface.getItemAt(this.cmbxBankInterface.getItemCount() - 1));
        } else {
            int index = (Integer)this.bankInterMap.get(params.getBEInterfaceId());
            FMClientHelper.setSelectObject((KDComboBox)this.cmbxBankInterface, (Object)this.cmbxBankInterface.getItemAt(index));
        }
        try {
            if (params.getBankAcctIds() != null) {
                Set set = FMHelper.asSet((String[])params.getBankAcctIds());
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
                ev.setFilter(filter);
                AccountBankCollection coll = null;
                IAccountBank bankAcct = AccountBankFactory.getRemoteInstance();
                coll = bankAcct.getAccountBankCollection(ev);
                this.f7BankAccount.setData((Object)coll.toArray());
            }
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
    }

    public boolean verify() {
        Boolean passVerify = BEClientHelper.verifyDate((Component)((Object)this), this.dtpBegin, this.dtpEnd);
        long dayDiff = DateTimeUtils.dateDiff((String)"d", (Date)DateTimeUtils.truncateDate((Date)this.dtpBegin.getSqlDate()), (Date)DateTimeUtils.truncateDate((Date)this.dtpEnd.getSqlDate()));
        if (dayDiff > 30L) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCEPATH, (String)"beginEndDayDiffLimmit"));
            SysUtil.abort();
        }
        return passVerify;
    }

    protected void companyValueChange(Object object) throws Exception {
        Object[] array = (Object[])object;
        Object[] result = FMClientHelper.removeVirtualCompany((Object[])array);
        super.companyValueChange((Object)array);
        this.reSetF7BankAccountQuery();
    }

    public void clear() {
        super.clear();
        try {
            this.init();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    protected void cmbxBankInterface_actionPerformed(ActionEvent e) throws Exception {
        this.reSetF7BankAccountQuery();
    }

    private void reSetF7BankAccountQuery() {
        this.f7BankAccount.setData(null);
    }

    protected void chkIA_actionPerformed(ActionEvent e) throws Exception {
        this.f7BankAccount.setData(null);
    }

    protected Class getParamClass() {
        return BEpayInterfaceCostFilterParam.class;
    }
}

