/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.be.client.AbstractBKLogFilterUI;
import com.kingdee.eas.fm.be.client.BKLogFilterParam;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.util.Date;
import org.apache.log4j.Logger;

public class BKLogFilterUI
extends AbstractBKLogFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(BKLogFilterUI.class);
    private static final int ALL_STATUS = 100;

    protected void init() throws Exception {
        super.init();
        FMClientHelper.initCurrency((KDComboBox)this.comboCurrency);
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(company));
    }

    public boolean verify() {
        Date dateFrom = DateTimeUtils.truncateDate((Date)((Date)this.pkFrom.getValue()));
        Date dateTo = DateTimeUtils.truncateDate((Date)((Date)this.pkTo.getValue()));
        FMClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)this, (Date)dateFrom, (Date)dateTo);
        return super.verify();
    }

    public Object getParam() {
        BKLogFilterParam para = new BKLogFilterParam();
        para.setCurrencyId(AccessHelper.getCboId((KDComboBox)this.comboCurrency));
        String[] companyIds = this.getCompanyIds();
        para.setCompanyIds(companyIds);
        para.setBeginDate(this.pkFrom.getSqlDate());
        para.setEndDate(this.pkTo.getSqlDate());
        if (this.rdBtnFailure.isSelected()) {
            para.setStatus(0);
        } else if (this.rdBtnSuceess.isSelected()) {
            para.setStatus(1);
        } else {
            para.setStatus(100);
        }
        return para;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof BKLogFilterParam)) {
            return;
        }
        BKLogFilterParam para = (BKLogFilterParam)param;
        String currencyId = para.getCurrencyId();
        CurrencyInfo currencyInfo = null;
        try {
            if (currencyId != null) {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)currencyInfo);
            }
        }
        catch (Exception e1) {
            SysUtil.abort((Throwable)e1);
        }
        String[] companyIds = para.getCompanyIds();
        try {
            this.setCompanyIds(companyIds);
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
        this.pkFrom.setValue((Object)para.getBeginDate());
        this.pkTo.setValue((Object)para.getEndDate());
        if (para.getStatus() == 0) {
            this.rdBtnFailure.setSelected(true);
        } else if (para.getStatus() == 1) {
            this.rdBtnSuceess.setSelected(true);
        } else {
            this.btnAll.setSelected(true);
        }
    }

    protected void companyValueChange(Object object) throws Exception {
        Object[] array = (Object[])object;
        Object[] result = FMClientHelper.removeVirtualCompany((Object[])array);
        super.companyValueChange((Object)result);
    }

    protected void initCompanyState() {
        if (this.currentCompany == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"34_AccountBankBalanceFilterUI"));
            SysUtil.abort();
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            this.btnCompanySelect.setEnabled(true);
            this.btnCompanySelect.setVisible(true);
        } else {
            this.btnCompanySelect.setEnabled(false);
            this.btnCompanySelect.setVisible(false);
        }
    }

    protected NewCompanyF7 getNewCompanyF7() {
        if (FSClientHelper.isCHUser()) {
            try {
                return super.getAllCompanyOrg();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getNewCompanyF7();
    }

    protected Class getParamClass() {
        return BKLogFilterParam.class;
    }
}

