/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.be.BankAcntRelationEntryInfo;
import com.kingdee.eas.fm.be.BankAcntRelationFactory;
import com.kingdee.eas.fm.be.BankAcntRelationInfo;
import com.kingdee.eas.fm.be.BankInterface;
import com.kingdee.eas.fm.be.BankOverAccountTypeEnum;
import com.kingdee.eas.fm.be.IBankAcntRelation;
import com.kingdee.eas.fm.be.client.AbstractBankAcntRelationEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BankAcntRelationEditUI
extends AbstractBankAcntRelationEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BankAcntRelationEditUI.class);
    private IBankAcntRelation bankAcntRelation = BankAcntRelationFactory.getRemoteInstance();
    private static final String F7_ACCOUNT_BANK_QUERY = "com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery";
    private Map bankInterMap = new HashMap();
    private static String resourcePath = "com.kingdee.eas.fm.be.BankAcntRelationResource";
    private boolean isOnload = true;
    private KDBizPromptBox kdtEntrys_bankAcnt_PromptBox = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        BankAcntRelationInfo info = new BankAcntRelationInfo();
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        info.setCompany(company);
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        info.setHandler(user);
        info.setBankOverAccountType(BankOverAccountTypeEnum.handInput);
        info.setOverPer(Constants.ONE_HUNDRED);
        this.initBankOverAccount();
        return info;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        BankAcntRelationEntryInfo entryInfo = new BankAcntRelationEntryInfo();
        return entryInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BankAcntRelationFactory.getRemoteInstance();
    }

    protected void initTable() {
        this.kdtSecondAcnt.checkParsed();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    public void onLoad() throws Exception {
        this.isOnload = true;
        this.initTable();
        super.onLoad();
        this.initControl();
        this.initF7Control();
        this.initTableControl();
        this.isOnload = false;
    }

    private void initF7Control() {
        FilterInfo filterInfo = new FilterInfo();
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        if (!EmptyUtil.isEmpty((CoreBaseInfo)company)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filterInfo.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        if (this.comboBankInterfaceType.getSelectedItem() != null) {
            String bankInterface = ((BankInterface)this.comboBankInterfaceType.getSelectedItem()).getName();
            if (bankInterface != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("bankInterFace", (Object)new String(bankInterface)));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("bankInterFace", (Object)new String("")));
            }
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isVirtualAcct", (Object)new Integer(1)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        this.prmtFirstAcnt.setDisplayFormat("$number$ $name$");
        this.prmtFirstAcnt.setCommitFormat("$number$");
        this.prmtFirstAcnt.setEditFormat("$number$");
        this.prmtFirstAcnt.setQueryInfo(F7_ACCOUNT_BANK_QUERY);
        this.prmtFirstAcnt.setEntityViewInfo(evi);
        this.prmtSecondOverAcnt.setDisplayFormat("$number$ $name$");
        this.prmtSecondOverAcnt.setCommitFormat("$number$");
        this.prmtSecondOverAcnt.setEditFormat("$number$");
        this.prmtSecondOverAcnt.setQueryInfo(F7_ACCOUNT_BANK_QUERY);
        this.prmtSecondOverAcnt.setEntityViewInfo(evi);
        this.btnAttachment.setVisible(false);
        this.btnAuditResult.setVisible(false);
    }

    private void initControl() throws BOSException {
        this.initBankInterface();
        if (this.getOprtState() == OprtState.ADDNEW) {
            this.kdtSecondAcnt.addRow();
            this.txtBankOverAccount.setVisible(true);
            this.txtBankOverAccount.setEditable(true);
        }
        this.txtOverPer.setHorizontalAlignment(4);
        this.txtOverPer.setDataType(1);
        this.txtOverPer.setMinimumValue((Comparable)Constants.ZERO);
        this.txtOverPer.setMaximumValue((Comparable)new BigDecimal("100.00"));
        this.txtOverPer.setPrecision(2);
        this.txtBankOverAccount.setHorizontalAlignment(4);
        this.txtBankOverAccount.setDataType(1);
        this.txtBankOverAccount.setMinimumValue((Comparable)Constants.ZERO);
        this.txtBankOverAccount.setMaximumValue((Comparable)new BigDecimal("100000000000000.00"));
        this.txtBankOverAccount.setValue((Object)this.editData.getBankOverAccount());
        if (!EmptyUtil.isEmpty((Object)this.editData.getBankOverAccount())) {
            this.txtBankOverAccount.setValue((Object)this.editData.getBankOverAccount());
        } else {
            this.txtBankOverAccount.setValue((Object)Constants.ZERO);
        }
        this.txtBankOverAccount.setPrecision(2);
    }

    private void initBankInterface() throws BOSException {
        this.comboBankInterfaceType.removeAllItems();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        view.setFilter(filter);
        AccountBankCollection colls = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
        int k = 0;
        this.bankInterMap.clear();
        for (int i = 0; i < colls.size(); ++i) {
            AccountBankInfo info = colls.get(i);
            BankInterface bankAcct = new BankInterface();
            if (EmptyUtil.isEmpty((String)info.getBankInterFaceID())) continue;
            bankAcct.setNumber(info.getBankInterFaceID());
            bankAcct.setName(info.getBankInterFace());
            if (this.bankInterMap.containsKey(bankAcct.getNumber())) continue;
            this.comboBankInterfaceType.addItem((Object)bankAcct);
            this.bankInterMap.put(bankAcct.getNumber(), new Integer(k));
            if (!EmptyUtil.isEmpty((String)this.editData.getBankInterFace()) && !EmptyUtil.isEmpty((String)bankAcct.getName()) && this.editData.getBankInterFace().equals(bankAcct.getName())) {
                this.comboBankInterfaceType.setSelectedIndex(k);
            }
            ++k;
        }
    }

    protected void initTableControl() throws Exception {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filterInfo.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        if (this.comboBankInterfaceType.getSelectedItem() != null) {
            String bankInterface = ((BankInterface)this.comboBankInterfaceType.getSelectedItem()).getName();
            if (bankInterface != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("bankInterFace", (Object)new String(bankInterface)));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("bankInterFace", (Object)new String("")));
            }
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isVirtualAcct", (Object)new Integer(1)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        this.kdtEntrys_bankAcnt_PromptBox = new KDBizPromptBox();
        this.kdtEntrys_bankAcnt_PromptBox.setQueryInfo(F7_ACCOUNT_BANK_QUERY);
        this.kdtEntrys_bankAcnt_PromptBox.setVisible(true);
        this.kdtEntrys_bankAcnt_PromptBox.setEditable(true);
        this.kdtEntrys_bankAcnt_PromptBox.setDisplayFormat("$number$ $name$");
        this.kdtEntrys_bankAcnt_PromptBox.setEditFormat("$number$");
        this.kdtEntrys_bankAcnt_PromptBox.setCommitFormat("$number$");
        this.kdtEntrys_bankAcnt_PromptBox.setEntityViewInfo(evi);
        this.kdtEntrys_bankAcnt_PromptBox.setEnabledMultiSelection(true);
        this.kdtEntrys_bankAcnt_PromptBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    BankAcntRelationEditUI.this.entryBankAcnt_willShow(e);
                }
                catch (Exception exc) {
                    BankAcntRelationEditUI.this.handUIException(exc);
                }
            }
        });
        KDTDefaultCellEditor kdtEntrys_bankAcnt_CellEditor = new KDTDefaultCellEditor((IKDEditor)this.kdtEntrys_bankAcnt_PromptBox);
        this.kdtSecondAcnt.getColumn("bankAcntID").setEditor((ICellEditor)kdtEntrys_bankAcnt_CellEditor);
        ObjectValueRender kdtEntrys_material_OVR = new ObjectValueRender();
        kdtEntrys_material_OVR.setFormat((IDataFormat)new BizDataFormat("$number$ $name$"));
        this.kdtSecondAcnt.getColumn("bankAcntID").setRenderer((IBasicRender)kdtEntrys_material_OVR);
    }

    private void entryBankAcnt_willShow(SelectorEvent e) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filterInfo.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        if (this.comboBankInterfaceType.getSelectedItem() != null) {
            String bankInterface = ((BankInterface)this.comboBankInterfaceType.getSelectedItem()).getName();
            if (bankInterface != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("bankInterFace", (Object)new String(bankInterface)));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("bankInterFace", (Object)new String("")));
            }
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isVirtualAcct", (Object)new Integer(1)));
        Set set = this.getUsedBankAcctSet();
        if (set.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.NOTINCLUDE));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        this.kdtEntrys_bankAcnt_PromptBox.setEntityViewInfo(evi);
        this.kdtEntrys_bankAcnt_PromptBox.getQueryAgent().resetRuntimeEntityView();
    }

    private Set getUsedBankAcctSet() {
        HashSet<String> set = new HashSet<String>();
        if (!EmptyUtil.isEmpty((Object)this.prmtFirstAcnt.getValue())) {
            set.add(((AccountBankInfo)this.prmtFirstAcnt.getValue()).getId().toString());
        }
        if (!EmptyUtil.isEmpty((Object)this.prmtSecondOverAcnt.getValue())) {
            set.add(((AccountBankInfo)this.prmtSecondOverAcnt.getValue()).getId().toString());
        }
        for (int i = 0; i < this.kdtSecondAcnt.getRowCount(); ++i) {
            IRow row = this.kdtSecondAcnt.getRow(i);
            if (EmptyUtil.isEmpty((Object)row.getCell("bankAcntID").getValue())) continue;
            set.add(((AccountBankInfo)row.getCell("bankAcntID").getValue()).getId().toString());
        }
        return set;
    }

    @Override
    protected void kdtSecondAcnt_editStopped(KDTEditEvent e) throws Exception {
        String fieldName = this.kdtSecondAcnt.getColumn(e.getColIndex()).getFieldName();
        if ("bankAcntID".equals(fieldName)) {
            if (e.getValue() == null || e.getOldValue() != null && e.getOldValue().equals(e.getValue())) {
                return;
            }
            IRow row = this.kdtSecondAcnt.getRow(e.getRowIndex());
            AccountBankInfo accountBank = null;
            Object[] accountBankInfoArray = (Object[])e.getValue();
            int rowIndex = e.getRowIndex();
            for (int i = accountBankInfoArray.length - 1; i >= 0; --i) {
                accountBank = (AccountBankInfo)accountBankInfoArray[i];
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(accountBank.getCompany().getId()));
                row.getCell(fieldName).setValue((Object)accountBank);
                row.getCell("bankAcntName").setValue((Object)accountBank.getName());
                row.getCell("bankAcntNum").setValue((Object)accountBank.getBankAccountNumber());
                row.getCell("acntName").setValue((Object)company.getName());
                if (i <= 0) break;
                row = this.kdtSecondAcnt.addRow(rowIndex);
            }
        }
    }

    protected KDTable getDetailTable() {
        return this.kdtSecondAcnt;
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
    }

    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsertLine_actionPerformed(e);
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
    }

    private void showWarning(String resName) {
        MsgBox.showWarning((String)resName);
        SysUtil.abort();
    }

    @Override
    protected void comboBankOverAccountType_itemStateChanged(ItemEvent e) throws Exception {
        super.comboBankOverAccountType_itemStateChanged(e);
        this.initBankOverAccount();
    }

    private void initBankOverAccount() {
        if (this.comboBankOverAccountType.getSelectedIndex() == 1) {
            this.txtBankOverAccount.setText("0.0");
            this.txtBankOverAccount.setEnabled(false);
        } else {
            this.txtBankOverAccount.setEnabled(true);
        }
    }

    @Override
    protected void comboBankInterfaceType_itemStateChanged(ItemEvent e) throws Exception {
        if (this.isOnload) {
            return;
        }
        if (this.comboBankInterfaceType.getSelectedItem() != null) {
            this.txtBankInterfaceTypeName.setText(this.comboBankInterfaceType.getSelectedItem().toString());
        }
        this.initF7Control();
        this.initTableControl();
        this.prmtFirstAcnt.setValue(null);
        this.prmtSecondOverAcnt.setValue(null);
        int count = this.kdtSecondAcnt.getRowCount();
        for (int i = count - 1; i >= 0; --i) {
            this.kdtSecondAcnt.removeRow(i);
        }
        this.kdtSecondAcnt.addRow();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyData();
        this.editData.setHasEffected(true);
        super.actionSubmit_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.verifyData();
        this.editData.setHasEffected(true);
        super.actionSave_actionPerformed(e);
    }

    public void verifyData() throws Exception {
        BankOverAccountTypeEnum bankOverAccountTypeEnum;
        BankInterface bankInterface = (BankInterface)this.comboBankInterfaceType.getSelectedItem();
        if (bankInterface == null || EmptyUtil.isEmpty((String)bankInterface.getName())) {
            this.showWarning(EASResource.getString((String)resourcePath, (String)"BankInterfaceType"));
        }
        if (this.prmtFirstAcnt.getData() == null && this.prmtSecondOverAcnt.getData() == null) {
            this.showWarning(EASResource.getString((String)resourcePath, (String)"bothNull"));
        }
        if (this.prmtFirstAcnt.getData() != null && this.prmtSecondOverAcnt.getData() != null) {
            AccountBankInfo tmpFitst = (AccountBankInfo)this.prmtFirstAcnt.getData();
            AccountBankInfo tmpSecond = (AccountBankInfo)this.prmtSecondOverAcnt.getData();
            if (tmpFitst.getId().toString().equals(tmpSecond.getId().toString())) {
                this.showWarning(EASResource.getString((String)resourcePath, (String)"SameAccount"));
            }
        }
        if ((bankOverAccountTypeEnum = (BankOverAccountTypeEnum)((Object)this.comboBankOverAccountType.getSelectedItem())) == null || StringUtils.isEmpty((String)bankOverAccountTypeEnum.getValue())) {
            this.showWarning(EASResource.getString((String)resourcePath, (String)"bankOverAccountType"));
        }
        if (this.txtOverPer.getText().length() == 0) {
            this.showWarning(EASResource.getString((String)resourcePath, (String)"overType"));
        }
        if (this.kdtSecondAcnt.getRowCount() == 0) {
            this.showWarning(EASResource.getString((String)resourcePath, (String)"secondAcntNum"));
        } else {
            for (int i = 0; i < this.kdtSecondAcnt.getRowCount(); ++i) {
                if (this.kdtSecondAcnt.getRow(i).getCell("bankAcntID").getValue() == null) {
                    this.showWarning(EASResource.getString((String)resourcePath, (String)"SecondAcnt"));
                }
                if (this.prmtFirstAcnt.getData() != null) {
                    AccountBankInfo tmpFitst = (AccountBankInfo)this.prmtFirstAcnt.getData();
                    AccountBankInfo tmpSecond = (AccountBankInfo)this.kdtSecondAcnt.getRow(i).getCell("bankAcntID").getValue();
                    if (tmpFitst.getId().toString().equals(tmpSecond.getId().toString())) {
                        this.showWarning(EASResource.getString((String)resourcePath, (String)"SameAccount"));
                    }
                }
                if (this.prmtSecondOverAcnt.getData() != null) {
                    AccountBankInfo tmpSecondOver = (AccountBankInfo)this.prmtSecondOverAcnt.getData();
                    AccountBankInfo tmpSecondNormal = (AccountBankInfo)this.kdtSecondAcnt.getRow(i).getCell("bankAcntID").getValue();
                    if (tmpSecondOver.getId().toString().equals(tmpSecondNormal.getId().toString())) {
                        this.showWarning(EASResource.getString((String)resourcePath, (String)"SameAccount"));
                    }
                }
                for (int j = i + 1; j < this.kdtSecondAcnt.getRowCount(); ++j) {
                    AccountBankInfo tmp1 = (AccountBankInfo)this.kdtSecondAcnt.getRow(i).getCell("bankAcntID").getValue();
                    AccountBankInfo tmp2 = (AccountBankInfo)this.kdtSecondAcnt.getRow(j).getCell("bankAcntID").getValue();
                    if (tmp1 == null || tmp2 == null || !tmp1.getId().toString().equals(tmp2.getId().toString())) continue;
                    this.showWarning(EASResource.getString((String)resourcePath, (String)"SameAccount"));
                }
            }
        }
        if (this.txtBankOverAccount.getText().length() == 0) {
            this.showWarning(EASResource.getString((String)resourcePath, (String)"bankOverAccount"));
        }
        super.verifyData();
    }
}

