/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.service.helper.PermissionParameterFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.be.BankAgentPayBillFactory;
import com.kingdee.eas.fm.be.BankAgentPayBillInfo;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.BankPayResult;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.IBankAgentPayBill;
import com.kingdee.eas.fm.be.IBankFacade;
import com.kingdee.eas.fm.be.client.AbstractBankAgentPayBillListUI;
import com.kingdee.eas.fm.be.client.BankAgentPayBillFilterUI;
import com.kingdee.eas.fm.be.client.BankLogListUI;
import com.kingdee.eas.fm.be.client.BankPayingBillUpdateStateUI;
import com.kingdee.eas.fm.common.CheckUtils;
import com.kingdee.eas.fm.common.H;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BankAgentPayBillListUI
extends AbstractBankAgentPayBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(BankAgentPayBillListUI.class);
    private static final String resourcePath = "com.kingdee.eas.fm.be.beResourse";
    private IContextHelper contextHelper = ContextHelperFactory.getRemoteInstance();
    private static final String SHREntryAmount = "XXXXXX";
    private BankAgentPayBillFilterUI filterUI;

    public void onload() throws Exception {
        super.onLoad();
        this.tblMain.getColumn("entrys.seq").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("Amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("Count").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("ConfigureCount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("ConfigurAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("expectTransTime").getStyleAttributes().setNumberFormat(this.timeFormat);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionBitBack.setEnabled(true);
        this.actionEditState.setEnabled(true);
        this.actionDetailView.setEnabled(true);
        this.actionSyncState.setEnabled(true);
        if ("true".equalsIgnoreCase(PermissionParameterFactory.getRemoteInstance().getPermissionParameter("EnableAutoSign"))) {
            this.btnViewSignature.setVisible(true);
            this.btnViewSignature.setEnabled(true);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionSyncState.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_synchronization"));
        this.actionDetailView.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.actionEditState.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_modifyattribute"));
        this.actionBitBack.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fclose"));
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
    }

    @Override
    public void actionDetailView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int i = this.tblMain.getSelectManager().getActiveRowIndex();
        if (i >= 0) {
            Object isBitBack = this.tblMain.getRow(i).getCell("isBitBack").getValue();
            if (((Boolean)isBitBack).booleanValue()) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"37_BankAgentPayBillListUI"));
                return;
            }
            String billId = (String)this.tblMain.getRow(i).getCell("id").getValue();
            BankAgentPayBillInfo info = BankAgentPayBillFactory.getRemoteInstance().getBankAgentPayBillInfo((IObjectPK)new ObjectUuidPK(billId));
            String sourceBillId = info.getSourceBillId();
            if (billId != null) {
                CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
                FMClientHelper.viewDetailBill((CoreUIObject)this, (String)sourceBillId, (CompanyOrgUnitInfo)company);
            }
        } else {
            this.setMessageText(EASResource.getString((String)resourcePath, (String)"SelectOneRow"));
            this.showMessage();
        }
    }

    @Override
    public void actionSyncState_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        IBankFacade bankFacade = BankFacadeFactory.getRemoteInstance();
        try {
            Map ret = bankFacade.syncBankAgentPayStateByBill(idList);
            if (ret != null) {
                int success = H.INT(ret.get("success"));
                int error = H.INT(ret.get("error"));
                String errMsg = (String)ret.get("errMsg");
                if (error > 0) {
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"416_BankAgentPayWebFacadeControllerBean") + success + EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"417_BankAgentPayWebFacadeControllerBean") + error + EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1162_BankAgentPayBillListUI")), (String)errMsg, (int)0);
                    return;
                }
            }
        }
        catch (Exception e1) {
            this.setMessageText(EASResource.getString((String)resourcePath, (String)"SyncFailure"));
            this.showMessage();
            SysUtil.abort();
        }
        this.actionRefresh_actionPerformed(e);
        this.setMessageText(EASResource.getString((String)resourcePath, (String)"SyncSucess"));
        this.showMessage();
    }

    @Override
    public void actionViewLog_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() > 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"189_GETSINGLE"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"bankPaymentBillId", idList.get(0));
        String uiName = BankLogListUI.class.getName();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionBitBack_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        IBankAgentPayBill pay = BankAgentPayBillFactory.getRemoteInstance();
        for (int i = 0; i < ids.size(); ++i) {
            String id = (String)ids.get(i);
            BankAgentPayBillInfo info = pay.getBankAgentPayBillInfo((IObjectPK)new ObjectUuidPK(id));
            for (int j = 0; j < info.getEntrys().size(); ++j) {
                if (info.getEntrys().get(j).getState() == BankPayingBillStateEnum.TF || info.getEntrys().get(j).getState() == BankPayingBillStateEnum.OP) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"38_BankAgentPayBillListUI"));
                return;
            }
            if (!info.isIsBitBack()) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"39_BankAgentPayBillListUI"));
            return;
        }
        pay.bitBack(ids);
        FMClientHelper.showSuccessInfo((CoreUI)this, (ItemAction)this.actionBitBack);
        this.refreshList();
    }

    @Override
    public void actionEditState_actionPerformed(ActionEvent e) throws Exception {
        int result;
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        ArrayList<String> idList = new ArrayList<String>();
        int nc = 0;
        for (int i = 0; i < selectRows.length; ++i) {
            int state = ((BizEnumValueInfo)this.tblMain.getRow(selectRows[i]).getCell("entrys.state").getValue()).getInt();
            if (state != 4) continue;
            idList.add((String)this.tblMain.getRow(selectRows[i]).getCell("entrys.id").getValue());
            ++nc;
        }
        String msg = null;
        if (nc < selectRows.length) {
            msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"315_BankAgentPay_EditState"), new Integer(nc), new Integer(selectRows.length - nc));
            if (MsgBox.showConfirm2((Component)((Object)this), (String)msg) == 2 || nc <= 0) {
                SysUtil.abort();
            }
            msg = null;
        }
        UIContext uiContext = new UIContext((Object)this);
        String uiName = BankPayingBillUpdateStateUI.class.getName();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, OprtState.VIEW);
        ((BankPayingBillUpdateStateUI)uiWindow.getUIObject()).setUITitle(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"40_BankAgentPayBillListUI"));
        uiWindow.show();
        BankPayingBillStateEnum updateState = ((BankPayingBillUpdateStateUI)uiWindow.getUIObject()).getResult();
        if (updateState == null) {
            return;
        }
        if (updateState == BankPayingBillStateEnum.TF && (result = MsgBox.showConfirm2((Component)((Object)this), (String)(msg = EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"41_BankAgentPayBillListUI")))) == 2) {
            SysUtil.abort();
        }
        IObjectPK[] pks = new IObjectPK[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            pks[i] = new ObjectUuidPK(((String)idList.get(i)).toString());
        }
        IBankAgentPayBill iBankAgentPayBill = BankAgentPayBillFactory.getRemoteInstance();
        Map rets = iBankAgentPayBill.updateState(pks, updateState);
        List resultList = (List)rets.get("resultList");
        if (!EmptyUtil.isEmpty((Collection)resultList)) {
            this.showActionResult(resultList, EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1163_BankAgentPayBillListUI"), "");
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"415_BankAgentPayWebFacadeControllerBean"));
        }
    }

    private void showActionResult(List<BankPayResult> resultList, String title, String spentTimeHint) throws Exception {
        int size = resultList.size();
        if (resultList == null || size == 0) {
            return;
        }
        if (size == 1 && resultList.get(0).getId().equals("error")) {
            BankPayResult bankPayResult = resultList.get(0);
            MsgBox.showInfo((Component)((Object)this), (String)bankPayResult.getErrorDetail());
            return;
        }
        StringBuilder hintBuilder = new StringBuilder();
        StringBuffer errorDetail = new StringBuffer();
        int fail = 0;
        String LINE_SEPARATOR = System.getProperty("line.separator");
        String numberTitle = EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"411_BankAgentPayWebFacadeControllerBean");
        String successTitle = EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1164_BankAgentPayBillListUI");
        String failureTitle = EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1165_BankAgentPayBillListUI");
        String recordTile = EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"100_BankFacadeControllerBean");
        for (int j = 0; j < size; ++j) {
            BankPayResult resultInfo = resultList.get(j);
            if (!CheckUtils.exist((Object)resultInfo.getErrorDetail())) continue;
            errorDetail.append(numberTitle).append(resultInfo.getNumber()).append("\uff1a");
            errorDetail.append("\u3010" + resultInfo.getErrorDetail() + "\u3011").append(LINE_SEPARATOR);
            ++fail;
        }
        if (fail == 0) {
            hintBuilder.append(title + successTitle).append(" ").append(size).append(" ").append(recordTile);
            if (!EmptyUtil.isEmpty((String)spentTimeHint)) {
                hintBuilder.append(" , ").append(spentTimeHint);
            }
            MsgBox.showInfo((Component)((Object)this), (String)hintBuilder.toString());
            this.refreshList();
        } else {
            hintBuilder.append(title + successTitle).append(" ").append(size - fail).append(" ").append(recordTile).append(" , ");
            hintBuilder.append(failureTitle).append(fail).append(recordTile);
            if (!EmptyUtil.isEmpty((String)spentTimeHint)) {
                hintBuilder.append(" , ").append(spentTimeHint);
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)hintBuilder.toString(), (String)errorDetail.toString(), (int)0);
            if (size != fail) {
                this.refreshList();
            }
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return BankAgentPayBillFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        BankAgentPayBillInfo objectValue = new BankAgentPayBillInfo();
        return objectValue;
    }

    protected void execQuery() {
        super.execQuery();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("entrys.*"));
        return sic;
    }

    @Override
    public String[] getMergeColumnKeys() {
        this.tblMain.checkParsed();
        int size = this.tblMain.getColumn("entrys.id").getColumnIndex();
        String[] keys = new String[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = this.tblMain.getColumn(i).getKey();
        }
        return keys;
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new BankAgentPayBillFilterUI();
        }
        return this.filterUI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onGetRowSet(IRowSet rowSet) {
        super.onGetRowSet(rowSet);
        if (!this.menuItemSwitchView.isSelected()) {
            try {
                while (rowSet.next()) {
                    if (!rowSet.getString("SourceType").equals("SHR")) continue;
                    String companyID = rowSet.getString("company.id");
                    boolean encryption = ContextHelperFactory.getRemoteInstance().getBooleanParam("CS112", (IObjectPK)new ObjectUuidPK(companyID));
                    if (!encryption) continue;
                    IRowSetMetaData rsmd = rowSet.getRowSetMetaData();
                    rsmd.setColumnType(rsmd.getColumnIndex("entrys.Amount0"), 1);
                    rowSet.updateString("entrys.Amount0", SHREntryAmount);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    rowSet.beforeFirst();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

