/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.fm.BankInfo;
import com.kingdee.eas.base.core.fm.BankVersionInfo;
import com.kingdee.eas.base.core.fm.CertUser;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.be.BankConfigFacdeFactory;
import com.kingdee.eas.fm.be.BankInterfaceTypeEnum;
import com.kingdee.eas.fm.be.client.AbstractBankCertListUI;
import com.kingdee.eas.fm.be.client.BankCertEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class BankCertListUI
extends AbstractBankCertListUI {
    private static final Logger logger = CoreUIObject.getLogger(BankCertListUI.class);
    private boolean isMnlBankCert = false;
    private Map map = new HashMap();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getSelectManager().setSelectMode(2);
        KDTableHelper.releaseEnterAndTab((JComponent)this.tblMain);
        this.fillTable();
        this.tblMain.getColumn("id").getStyleAttributes().setHided(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAddNew.setVisible(this.isMnlBankCert);
        this.actionQuery.setVisible(false);
    }

    private void fillTable() throws EASBizException, BOSException {
        int j;
        int i;
        IRow row = null;
        this.tblMain.removeRows();
        BankInfo[] allBanks = BankConfigFacdeFactory.getRemoteInstance().getAvaliableBanks();
        BankVersionInfo[] allVertions = BankConfigFacdeFactory.getRemoteInstance().getAvaliableVersions();
        HashMap<String, BankInfo> shortName2Bank = new HashMap<String, BankInfo>();
        HashMap<String, BankVersionInfo> shortName2Version = new HashMap<String, BankVersionInfo>();
        for (i = 0; i < allBanks.length; ++i) {
            BankInfo bank = allBanks[i];
            BankVersionInfo[] versions = bank.getVersions();
            for (j = 0; j < versions.length; ++j) {
                shortName2Bank.put(versions[j].getShortName(), bank);
            }
        }
        for (i = 0; i < allVertions.length; ++i) {
            shortName2Version.put(allVertions[i].getShortName(), allVertions[i]);
        }
        for (i = 0; i < allVertions.length; ++i) {
            String versionShortName = allVertions[i].getShortName();
            CertUser[] certs = BankConfigFacdeFactory.getRemoteInstance().getCertUsersByVersion(versionShortName);
            for (j = 0; j < certs.length; ++j) {
                CertUser cert = certs[j];
                BankInfo bankInfo = (BankInfo)shortName2Bank.get(cert.getBankVersion());
                BankVersionInfo versionInfo = (BankVersionInfo)shortName2Version.get(cert.getBankVersion());
                row = this.tblMain.addRow();
                row.getCell("id").setValue((Object)(bankInfo.getShortName() + "," + cert.toString4Equals()));
                row.getCell("certUserID").setValue((Object)cert.getCertUserID());
                row.getCell("certUserName").setValue((Object)cert.getCertUserName());
                row.getCell("bankinterface").setValue((Object)bankInfo.getName());
                row.getCell("bankVersion").setValue((Object)cert.getBankVersion());
            }
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        IUIWindow uiWindow = null;
        UIContext uiContext = new UIContext((Object)this);
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BankCertEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.fillTable();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.fillTable();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex;
        IRow row;
        this.checkSelected();
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null && (row = this.tblMain.getRow(rowIndex = selectBlock.getTop())) != null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"certUserID", row.getCell("certUserID").getValue());
            uiContext.put((Object)"certUserName", row.getCell("certUserName").getValue());
            uiContext.put((Object)"bankinterface", row.getCell("bankinterface").getValue());
            uiContext.put((Object)"bankVersion", row.getCell("bankVersion").getValue());
            IUIWindow uiWindow = null;
            uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(BankCertEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex;
        IRow row;
        this.checkSelected();
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null && (row = this.tblMain.getRow(rowIndex = selectBlock.getTop())) != null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"certUserID", row.getCell("certUserID").getValue());
            uiContext.put((Object)"certUserName", row.getCell("certUserName").getValue());
            uiContext.put((Object)"bankinterface", row.getCell("bankinterface").getValue());
            uiContext.put((Object)"bankVersion", row.getCell("bankVersion").getValue());
            IUIWindow uiWindow = null;
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BankCertEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
            this.fillTable();
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (!MsgBox.isCancel((int)MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"42_BankCertListUI")))) {
            ArrayList arrayList = this.tblMain.getSelectManager().getBlocks();
            for (int i = 0; i < arrayList.size(); ++i) {
                IBlock selectBlock = KDTSelectBlock.change((KDTable)this.tblMain, (IBlock)this.tblMain.getSelectManager().get(i));
                for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                    IRow row = this.tblMain.getRow(j);
                    CertUser certUser = new CertUser();
                    certUser.setCertUserID(row.getCell("certUserID").getValue().toString());
                    certUser.setCertUserName(row.getCell("certUserName").getValue().toString());
                    certUser.setBankVersion(row.getCell("bankVersion").getValue().toString());
                    BankConfigFacdeFactory.getRemoteInstance().delCertUser(certUser);
                    this.fillTable();
                }
            }
        }
    }

    protected String getEditUIName() {
        return BankCertEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getKeyFieldName() {
        return "id";
    }

    private BankInterfaceTypeEnum getSelectedCertUser() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            BankInterfaceTypeEnum keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell("certUserID");
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((keyValue = (BankInterfaceTypeEnum)cell.getValue()) != null) {
                return keyValue;
            }
        }
        return null;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }
}

