/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fm.be.BankConfigReaderFacadeFactory;
import com.kingdee.eas.fm.be.IBankConfigReaderFacade;
import com.kingdee.eas.fm.be.client.AbstractBankConfigEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class BankConfigEditUI
extends AbstractBankConfigEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BankConfigEditUI.class);

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void setBankName(String bankname) throws BOSException {
        this.getValueFromServer(bankname);
        this.btnSave.setEnabled(true);
        this.btnRefresh.setEnabled(true);
    }

    private void getValueFromServer(String bankname) throws BOSException {
        IBankConfigReaderFacade facade = BankConfigReaderFacadeFactory.getRemoteInstance();
        String[] config = facade.getBankConfig(bankname);
        this.bankName.setText(bankname);
        this.serverIP.setText(config[0]);
        this.clientID.setText(config[1]);
        this.signedPort.setText(config[2]);
        this.encryptedPort.setText(config[3]);
        this.localPort.setText(config[4]);
        this.userID.setText(config[5]);
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.getValueFromServer(this.bankName.getText());
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        IBankConfigReaderFacade facade = BankConfigReaderFacadeFactory.getRemoteInstance();
        String[] config = new String[]{this.serverIP.getText(), this.clientID.getText(), this.signedPort.getText(), this.encryptedPort.getText(), this.localPort.getText(), this.userID.getText()};
        boolean result = facade.setBankConfig(this.bankName.getText(), config);
        if (result) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"43_BankConfigEditUI"));
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"44_BankConfigEditUI"));
        }
    }
}

