/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.be.BankDynamicNoticeFilterParam;
import com.kingdee.eas.fm.be.SharedAcctFacadeFactory;
import com.kingdee.eas.fm.be.client.AbstractBankDynamicNoticeFilterUI;
import com.kingdee.eas.fm.be.client.BEClientHelper;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BankDynamicNoticeFilterUI
extends AbstractBankDynamicNoticeFilterUI {
    public static final int ALL_TYPE = 3;
    public static final int REC_TYPE = 2;
    public static final int PAY_TYPE = 1;
    private static final Logger logger = CoreUIObject.getLogger(BankDynamicNoticeFilterUI.class);
    private static final String F7_COMPANY_QUERY = "com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery";
    private static final String F7_ACCOUNT_BANK_QUERY = "com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery";

    protected void init() throws Exception {
        super.init();
        this.f7BankAccount.setDisplayFormat("$number$ $name$");
        this.f7BankAccount.setCommitFormat("$number$");
        this.f7BankAccount.setEditFormat("$number$");
        this.f7BankAccount.setEnabledMultiSelection(true);
        this.f7BankAccount.setQueryInfo(F7_ACCOUNT_BANK_QUERY);
        this.chkClose.setSelected(false);
        this.chkQueryBalanceOnly.setSelected(false);
        CashHelper.initCombCurrency((KDComboBox)this.cmbxCurrency, (boolean)false);
        this.cmbxCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        FMClientHelper.setSelectObject((KDComboBox)this.cmbxCurrency, (Object)ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(company));
        this.reSetF7BankAccountQuery();
    }

    private void reSetF7BankAccountQuery() {
        this.f7BankAccount.setData(null);
    }

    protected void initCompanyState() {
        if (this.currentCompany == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"34_AccountBankBalanceFilterUI"));
            SysUtil.abort();
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            this.btnCompanySelect.setEnabled(true);
            this.btnCompanySelect.setVisible(true);
        } else {
            this.btnCompanySelect.setEnabled(false);
            this.btnCompanySelect.setVisible(false);
        }
    }

    private void initF7BankAccount() {
        FilterInfo filterInfo = new FilterInfo();
        CompanyOrgUnitInfo curCompany = SysContext.getSysContext().getCurrentFIUnit();
        try {
            CompanyOrgUnitInfo clearingHouse = FSClientHelper.getClearingHouseCompany();
            if (clearingHouse != null && !clearingHouse.getId().equals((Object)curCompany.getId())) {
                filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)curCompany.getId()));
            }
        }
        catch (Exception e1) {
            SysUtil.abort();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        this.f7BankAccount.setDisplayFormat("$name$");
        this.f7BankAccount.setEnabledMultiSelection(true);
        this.f7BankAccount.setQueryInfo(F7_ACCOUNT_BANK_QUERY);
        this.f7BankAccount.setEntityViewInfo(evi);
    }

    private void initF7Comapny(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company)) {
            this.f7Company.setEnabled(true);
            this.f7Company.setDisplayFormat("$name$");
            this.f7Company.setHasCUDefaultFilter(false);
            this.f7Company.setEnabledMultiSelection(false);
            this.f7Company.setQueryInfo(F7_COMPANY_QUERY);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isOnlyUnion", (Object)new Integer(0)));
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(company.getLongNumber() + "!%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)("%!" + company.getLongNumber() + "!%"), CompareType.LIKE));
            filter.setMaskString("#0 and #1 and (#2 or #3)");
            view.setFilter(filter);
            this.f7Company.setEntityViewInfo(view);
        } else {
            BankInfo clearingHouse = FSClientHelper.getClearingHouse();
            if (clearingHouse != null && clearingHouse.isUsed()) {
                if (company.getId().equals((Object)clearingHouse.getRelatedCompany().getId())) {
                    this.f7Company.setEnabled(true);
                    this.f7Company.setDisplayFormat("$name$");
                    this.f7Company.setHasCUDefaultFilter(false);
                    this.f7Company.setEnabledMultiSelection(false);
                    this.f7Company.setQueryInfo(F7_COMPANY_QUERY);
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("isOnlyUnion", (Object)new Integer(0)));
                    filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
                    view.setFilter(filter);
                    this.f7Company.setEntityViewInfo(view);
                }
            } else {
                this.f7Company.setData((Object)company);
                this.f7Company.setEnabled(false);
            }
        }
    }

    protected NewCompanyF7 getNewCompanyF7() {
        if (FSClientHelper.isCHUser()) {
            try {
                return super.getAllCompanyOrg();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getNewCompanyF7();
    }

    public void clear() {
        super.clear();
        try {
            this.init();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    protected void f7Company_dataChanged(DataChangeEvent e) throws Exception {
        this.reSetF7BankAccountQuery();
    }

    @Override
    protected void chkIsQueryBalanceOnly_actionPerformed(ActionEvent e) throws Exception {
        if (this.chkQueryBalanceOnly.isSelected()) {
            this.dtpBeginDate.setEnabled(false);
        } else {
            this.dtpBeginDate.setEnabled(true);
        }
    }

    protected void companyValueChange(Object object) throws Exception {
        Object[] array = (Object[])object;
        Object[] result = FMClientHelper.removeVirtualCompany((Object[])array);
        super.companyValueChange((Object)array);
        this.reSetF7BankAccountQuery();
    }

    @Override
    protected void f7BankAccount_willCommit(CommitEvent e) throws Exception {
        this.initAccountBankEvi();
    }

    @Override
    protected void f7BankAccount_willShow(SelectorEvent e) throws Exception {
        this.initAccountBankEvi();
    }

    private void initAccountBankEvi() {
        CurrencyInfo selectedCurrency;
        FilterInfo filterInfo = new FilterInfo();
        FilterInfo companyFilter = new FilterInfo();
        FilterInfo agencyCompanyFilter = new FilterInfo();
        Object[] companyId = this.getCompanyIds();
        if (!FMHelper.isEmpty((Object[])companyId)) {
            HashSet<Object> list = new HashSet<Object>(companyId.length);
            for (int i = 0; i < companyId.length; ++i) {
                list.add(companyId[i]);
            }
            companyFilter.getFilterItems().add(new FilterItemInfo("company.id", list, CompareType.INCLUDE));
            agencyCompanyFilter.getFilterItems().add(new FilterItemInfo("agencyCompany.id", list, CompareType.INCLUDE));
        }
        if (!this.chkClose.isSelected()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("shareType", (Object)2, CompareType.NOTEQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isDynamicNotice", (Object)new Integer(1)));
        this.chkQueryBalanceOnly.isSelected();
        FilterInfo currencyFilter = new FilterInfo();
        if (this.cmbxCurrency.getSelectedItem() != null && !this.cmbxCurrency.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS) && (selectedCurrency = (CurrencyInfo)this.cmbxCurrency.getSelectedItem()) != null) {
            currencyFilter.getFilterItems().add(new FilterItemInfo("isByCurrency", (Object)new Boolean(true)));
            currencyFilter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)selectedCurrency.getId()));
            currencyFilter.getFilterItems().add(new FilterItemInfo("isByCurrency", (Object)new Boolean(false)));
            currencyFilter.setMaskString("( #0 and #1 ) or #2 ");
        }
        try {
            companyFilter.mergeFilter(agencyCompanyFilter, "or");
            filterInfo.mergeFilter(companyFilter, "and");
            filterInfo.mergeFilter(currencyFilter, "and");
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        this.f7BankAccount.setEntityViewInfo(evi);
        this.f7BankAccount.getQueryAgent().resetRuntimeEntityView();
    }

    public Object getParam() {
        BankDynamicNoticeFilterParam para = new BankDynamicNoticeFilterParam();
        HashSet<String> idSet = new HashSet<String>();
        Object[] acctBank = (Object[])this.f7BankAccount.getData();
        if (!EmptyUtil.isEmpty((Object[])acctBank)) {
            for (int i = 0; i < acctBank.length; ++i) {
                idSet.add(((AccountBankInfo)acctBank[i]).getBankAccountNumber());
            }
            Map result = null;
            try {
                result = SharedAcctFacadeFactory.getRemoteInstance().getSharedAcctAndCompany(idSet);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            para.setBankAccts((AccountBankInfo[])result.get("acctBank"));
            String[] companyIds = (String[])result.get("companys");
            para.setCompanyId(companyIds);
        } else {
            EntityViewInfo viewInfo = this.f7BankAccount.getEntityViewInfo();
            try {
                AccountBankCollection accountBankCollection = AccountBankFactory.getRemoteInstance().getAccountBankCollection(viewInfo);
                if (!accountBankCollection.isEmpty()) {
                    for (int i = 0; i < accountBankCollection.size(); ++i) {
                        idSet.add(accountBankCollection.get(i).getBankAccountNumber());
                    }
                    Map result = SharedAcctFacadeFactory.getRemoteInstance().getSharedAcctAndCompany(idSet);
                    para.setBankAccts((AccountBankInfo[])result.get("acctBank"));
                    String[] stringArray = (String[])result.get("companys");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.cmbxCurrency.getSelectedItem() == null || !this.cmbxCurrency.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS)) {
            para.setCurrencyId(AccessHelper.getCboId((KDComboBox)this.cmbxCurrency));
        }
        para.setBeginDate(this.dtpBeginDate.getSqlDate());
        para.setEndDate(this.dtpEndDate.getSqlDate());
        para.setClose(this.chkClose.isSelected());
        para.setQueryBalanceOnly(this.chkQueryBalanceOnly.isSelected());
        if (this.rdbPay.isSelected()) {
            para.setTransType(1);
        } else if (this.rdbReceive.isSelected()) {
            para.setTransType(2);
        } else {
            para.setTransType(3);
        }
        return para;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof BankDynamicNoticeFilterParam)) {
            return;
        }
        BankDynamicNoticeFilterParam para = (BankDynamicNoticeFilterParam)param;
        String currencyId = para.getCurrencyId();
        CurrencyInfo currencyInfo = null;
        try {
            if (currencyId != null) {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                FMClientHelper.setSelectObject((KDComboBox)this.cmbxCurrency, (Object)currencyInfo);
            } else {
                this.cmbxCurrency.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
            }
        }
        catch (Exception e1) {
            SysUtil.abort((Throwable)e1);
        }
        String[] companyIds = para.getCompanyId();
        try {
            this.setCompanyIds(companyIds);
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
        this.dtpBeginDate.setValue((Object)para.getBeginDate());
        this.dtpEndDate.setValue((Object)para.getEndDate());
        this.chkClose.setSelected(para.isClose());
        this.chkQueryBalanceOnly.setSelected(para.isQueryBalanceOnly());
        if (para.getTransType() == 1) {
            this.rdbPay.setSelected(true);
        } else if (para.getTransType() == 2) {
            this.rdbReceive.setSelected(true);
        } else {
            this.rdbRecPay.setSelected(true);
        }
        if (para.getBankAccts() != null) {
            AccountBankCollection coll = new AccountBankCollection();
            for (int index = 0; index < para.getBankAccts().length; ++index) {
                coll.add(para.getBankAccts()[index]);
            }
            this.f7BankAccount.setData((Object)coll.toArray());
        } else if (para.getBankAcctIds() != null) {
            try {
                if (para.getBankAcctIds() != null) {
                    Set set = FMHelper.asSet((String[])para.getBankAcctIds());
                    EntityViewInfo ev = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
                    ev.setFilter(filter);
                    AccountBankCollection coll = null;
                    IAccountBank bankAcct = AccountBankFactory.getRemoteInstance();
                    coll = bankAcct.getAccountBankCollection(ev);
                    this.f7BankAccount.setData((Object)coll.toArray());
                }
            }
            catch (BOSException e) {
                SysUtil.abort();
            }
        }
    }

    public boolean verify() {
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany) && this.f7BankAccount.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1166_BankDynamicNoticeFilterUI"));
            SysUtil.abort();
        }
        return BEClientHelper.verifyDate((Component)((Object)this), this.dtpBeginDate, this.dtpEndDate);
    }

    protected Class getParamClass() {
        return BankDynamicNoticeFilterParam.class;
    }
}

