/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.be.BankDynamicNoticeFactory;
import com.kingdee.eas.fm.be.BankDynamicNoticeFilterParam;
import com.kingdee.eas.fm.be.BankDynamicNoticeInfo;
import com.kingdee.eas.fm.be.client.AbstractBankDynamicNoticeListUI;
import com.kingdee.eas.fm.be.client.BankDynamicNoticeFilterUI;
import com.kingdee.eas.fm.be.client.BeDetailCheckForBankDynNoticeUI;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BankDynamicNoticeListUI
extends AbstractBankDynamicNoticeListUI {
    private static final Logger logger = CoreUIObject.getLogger(BankDynamicNoticeListUI.class);
    private BankDynamicNoticeFilterUI filterUI;
    private BankDynamicNoticeFilterParam para;

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionDetailCheck.setEnabled(true);
        this.actionCreateTo.setEnabled(false);
        this.actionCreateTo.setVisible(false);
        this.actionCopyTo.setVisible(false);
        this.actionExport.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_output"));
        this.actionImportData.setEnabled(true);
        this.menuItemImportData.setVisible(true);
        this.menuItemImportData.setEnabled(true);
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BankDynamicNoticeFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        this.btnView.setEnabled(false);
        this.btnView.setVisible(false);
        this.menuItemAddNew.setEnabled(false);
        this.menuItemAddNew.setVisible(false);
        this.menuItemEdit.setEnabled(false);
        this.menuItemEdit.setVisible(false);
        this.menuItemView.setEnabled(false);
        this.menuItemView.setVisible(false);
        super.onLoad();
        this.tblMain.setColumnMoveable(true);
        if (this.para.isQueryBalanceOnly()) {
            this.tblMain.getColumn("tranPackageID").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("description").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("usege").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("debitAmount").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("creditAmount").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("oppUnit").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("oppBankNumber").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("oppBank").getStyleAttributes().setHided(true);
        } else {
            this.tblMain.getColumn("tranPackageID").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("description").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("usege").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("debitAmount").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("creditAmount").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("oppUnit").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("oppBankNumber").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("oppBank").getStyleAttributes().setHided(false);
        }
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new BankDynamicNoticeFilterUI();
        }
        return this.filterUI;
    }

    protected IObjectValue createNewData() {
        BankDynamicNoticeInfo objectValue = new BankDynamicNoticeInfo();
        return objectValue;
    }

    @Override
    public void actionDetailCheck_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BeDetailCheckForBankDynNoticeUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        for (int i = 0; i < ids.size(); ++i) {
        }
        super.actionRemove_actionPerformed(e);
    }

    protected void execQuery() {
        this.tblMain.removeRows();
        this.para = (BankDynamicNoticeFilterParam)this.getFilterParam();
        this.setCurrencyFormat(this.tblMain, this.para);
        if (this.para.isQueryBalanceOnly()) {
            this.tblMain.getColumn("tranPackageID").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("description").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("usege").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("debitAmount").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("creditAmount").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("oppUnit").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("oppBankNumber").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("oppBank").getStyleAttributes().setHided(true);
            try {
                this.fillData(this.tblMain);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            this.tblMain.getColumn("tranPackageID").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("description").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("usege").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("debitAmount").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("creditAmount").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("oppUnit").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("oppBankNumber").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("oppBank").getStyleAttributes().setHided(false);
        }
    }

    public void setCurrencyFormat(KDTable tblMain, BankDynamicNoticeFilterParam param) {
        String numberFtm = param.getCurrencyId() == null ? "%r-[ ]{###,###,##0.00}15.2n" : FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)param.getCurrencyId()));
        tblMain.getColumn("debitAmount").getStyleAttributes().setNumberFormat(numberFtm);
        tblMain.getColumn("creditAmount").getStyleAttributes().setNumberFormat(numberFtm);
        tblMain.getColumn("transBalance").getStyleAttributes().setNumberFormat(numberFtm);
        tblMain.getColumn("debitAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.getColumn("creditAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.getColumn("transBalance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public void fillData(KDTable tblMain) throws EASBizException, BOSException, SQLException {
        if (this.mainQuery == null) {
            return;
        }
        tblMain.removeRows();
        List rows = tblMain.getBody().getRows();
        for (int i = rows.size() - 1; i >= 0; --i) {
            tblMain.removeRow(i);
        }
        EntityViewInfo ev = (EntityViewInfo)this.mainQuery.clone();
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.mainQueryPK);
        exec.setObjectView(ev);
        IRowSet rs = exec.executeQuery();
        HashMap<String, BankDynamicNoticeInfo> map = new HashMap<String, BankDynamicNoticeInfo>();
        while (rs.next()) {
            if (map.containsKey(rs.getString("currency.id") + rs.getString("bankAccount.id"))) {
                BankDynamicNoticeInfo oldRs = (BankDynamicNoticeInfo)map.get(rs.getString("currency.id") + rs.getString("bankAccount.id"));
                if (!rs.getTimestamp("bizTime").after(oldRs.getBizTime())) continue;
                BankDynamicNoticeInfo info = this.transInfo(rs);
                map.put(rs.getString("currency.id") + rs.getString("bankAccount.id"), info);
                continue;
            }
            BankDynamicNoticeInfo info = this.transInfo(rs);
            map.put(rs.getString("currency.id") + rs.getString("bankAccount.id"), info);
        }
        for (Object object : map.keySet()) {
            String string = object.toString();
            BankDynamicNoticeInfo info = (BankDynamicNoticeInfo)map.get(string);
            IRow row = tblMain.addRow();
            row.getCell("description").setValue((Object)info.getDescription());
            row.getCell("debitAmount").setValue((Object)info.getDebitAmount());
            row.getCell("creditAmount").setValue((Object)info.getCreditAmount());
            row.getCell("bizTime").setValue((Object)info.getBizTime());
            row.getCell("transBalance").setValue((Object)info.getTransBalance());
            row.getCell("bizDate").setValue((Object)info.getBizDate());
            row.getCell("currency.name").setValue((Object)info.getCurrency().getName());
            row.getCell("bankAccount.name").setValue((Object)info.getBankAccount().getName());
            row.getCell("bankAccount.number").setValue((Object)info.getBankAccount().getNumber());
            row.getCell("bankAccount.bankAccountNumber").setValue((Object)info.getBankAccount().getBankAccountNumber());
            row.getCell("company.name").setValue((Object)info.getCompany().getName());
        }
    }

    private BankDynamicNoticeInfo transInfo(IRowSet rs) throws SQLException, EASBizException, BOSException {
        BankDynamicNoticeInfo info = new BankDynamicNoticeInfo();
        info.setBizDate(rs.getDate("bizDate"));
        info.setDescription(rs.getString("description"));
        info.setDebitAmount(rs.getBigDecimal("debitAmount"));
        info.setCreditAmount(rs.getBigDecimal("creditAmount"));
        info.setBizTime(rs.getTimestamp("bizTime"));
        info.setOppBank(rs.getString("oppBank"));
        info.setOppBankNumber(rs.getString("oppBankNumber"));
        info.setOppUnit(rs.getString("oppUnit"));
        info.setTranPackageID(rs.getString("tranpackageID"));
        info.setTransBalance(rs.getBigDecimal("transBalance"));
        info.setBankAccount(AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(rs.getString("bankAccount.id"))));
        info.setCompany(CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(rs.getString("company.id"))));
        info.setCurrency(CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(rs.getString("currency.id"))));
        return info;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"90_TransDetailListUI"));
    }

    public CommonQueryDialog getQueryDlg() throws Exception {
        CommonQueryDialog dlg = super.getQueryDlg();
        dlg.setWidth(586);
        return dlg;
    }
}

