/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.fm.be.BankInterface;
import com.kingdee.eas.fm.be.client.AbstractBankInterfaceTypeF7UI;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class BankInterfaceTypeF7UI
extends AbstractBankInterfaceTypeF7UI {
    private static final Logger logger = CoreUIObject.getLogger(BankInterfaceTypeF7UI.class);
    private Object listData;
    protected boolean isCanceled = true;
    public static final String IS_ENABLED_MULTI_SELECTION = "isEnabledMultiSelection";
    public static final String FILTER = "filter";
    protected static final String COL_VALUE = "value";
    protected static final String COL_NAME = "name";
    protected static final String NAME = EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"53_BankInterfaceTypeF7UI");
    protected static final String NUMBER = EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"54_BankInterfaceTypeF7UI");
    private Map bankInterMap = new HashMap();

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.buildData();
            this.isCanceled = false;
            this.getUIWindow().close();
        }
    }

    @Override
    protected void btnFastQuery_actionPerformed(ActionEvent e) throws Exception {
        this.launchQuickFilter();
    }

    @Override
    protected void kdOk_actionPerformed(ActionEvent e) throws Exception {
        this.buildData();
        this.isCanceled = false;
        this.getUIWindow().close();
    }

    @Override
    protected void kdCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    public Object getRstData() {
        return this.listData;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void onLoad() throws Exception {
        this.toolBar.setVisible(false);
        this.cboKey.addItem((Object)NAME);
        this.cboKey.addItem((Object)NUMBER);
        this.initTable();
        FilterInfo filter = (FilterInfo)this.getUIContext().get(FILTER);
        this.fillTable(filter);
        boolean isMul = (Boolean)this.getUIContext().get(IS_ENABLED_MULTI_SELECTION);
        if (isMul) {
            this.tblMain.getSelectManager().setSelectMode(10);
        } else {
            this.tblMain.getSelectManager().setSelectMode(2);
        }
        KDTableHelper.releaseEnterAndTab((JComponent)this.tblMain);
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.tblMain, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        this.tblMain.requestFocusInWindow();
        this.tblMain.getInputMap().remove(KeyStroke.getKeyStroke(10, 0));
    }

    private void initTable() {
        this.tblMain.checkParsed();
    }

    private void fillTable(FilterInfo filter) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo(COL_NAME));
        view.getSelector().add(new SelectorItemInfo("bankInterFaceID"));
        view.getSelector().add(new SelectorItemInfo("bankInterFace"));
        fi.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        fi.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        view.setFilter(fi);
        AccountBankCollection colls = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
        this.tblMain.removeRows(false);
        if (filter == null) {
            int k = 0;
            for (int i = 0; i < colls.size(); ++i) {
                AccountBankInfo info = colls.get(i);
                if (FMHelper.isEmpty((String)info.getBankInterFaceID()) || this.bankInterMap.containsKey(info.getBankInterFaceID())) continue;
                IRow row = this.tblMain.addRow();
                row.getCell(COL_VALUE).setValue((Object)info.getBankInterFaceID());
                row.getCell(COL_NAME).setValue((Object)info.getBankInterFace());
                this.bankInterMap.put(info.getBankInterFaceID(), new Integer(k));
                ++k;
            }
        } else {
            FilterItemInfo filterItemInfo = filter.getFilterItems().get(0);
            String keyValue = (String)filterItemInfo.getCompareValue();
            for (int i = 0; i < colls.size(); ++i) {
                Matcher m;
                AccountBankInfo info = colls.get(i);
                boolean canAdd = false;
                String regEx = keyValue;
                Pattern p = Pattern.compile(regEx);
                if (filterItemInfo.getPropertyName().equals(NAME)) {
                    if (filterItemInfo.getCompareType().equals((Object)CompareType.EQUALS) && info.getName().equals(keyValue)) {
                        canAdd = true;
                    }
                    if (filterItemInfo.getCompareType().equals((Object)CompareType.LIKE) && (m = p.matcher(info.getName())).find()) {
                        canAdd = true;
                    }
                }
                if (filterItemInfo.getPropertyName().equals(NUMBER)) {
                    if (filterItemInfo.getCompareType().equals((Object)CompareType.EQUALS) && info.getNumber().equals(keyValue)) {
                        canAdd = true;
                    }
                    if (filterItemInfo.getCompareType().equals((Object)CompareType.LIKE) && (m = p.matcher(info.getNumber())).find()) {
                        canAdd = true;
                    }
                }
                if (!canAdd) continue;
                IRow row = this.tblMain.addRow();
                row.getCell(COL_VALUE).setValue((Object)info.getNumber());
                row.getCell(COL_NAME).setValue((Object)info.getName());
            }
        }
    }

    private void buildData() {
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (rows.length < 1) {
            this.abort();
        }
        if (this.tblMain.getRow(rows[0]) == null) {
            this.abort();
        }
        ArrayList<BankInterface> buildList = new ArrayList<BankInterface>();
        for (int i = 0; i < rows.length; ++i) {
            String value = (String)this.tblMain.getRow(rows[i]).getCell(0).getValue();
            String name = (String)this.tblMain.getRow(rows[i]).getCell(1).getValue();
            BankInterface bankAcct = new BankInterface();
            bankAcct.setName(name);
            name = name.trim();
            bankAcct.setNumber(value);
            buildList.add(bankAcct);
        }
        this.listData = buildList;
    }

    private void launchQuickFilter() throws BOSException {
        this.fillTable(this.getFilter(this.cboKey.getSelectedItem().toString()));
    }

    private FilterInfo getFilter(String key) {
        String keyValue = this.txtValue.getText().trim();
        FilterInfo filter = new FilterInfo();
        if (this.chkLike.isSelected()) {
            filter.getFilterItems().add(new FilterItemInfo(key, (Object)keyValue, CompareType.LIKE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo(key, (Object)keyValue, CompareType.EQUALS));
        }
        return filter;
    }
}

