/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.core.fm.BankInfo;
import com.kingdee.eas.base.core.fm.BankVersionInfo;
import com.kingdee.eas.base.core.fm.CertUser;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fm.be.BankConfigFacdeFactory;
import com.kingdee.eas.fm.be.BankInterfaceTypeEnum;
import com.kingdee.eas.fm.be.client.AbstractBankInterfaceUI;
import com.kingdee.eas.fm.be.client.BEClientHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class BankInterfaceUI
extends AbstractBankInterfaceUI {
    private BankInterfaceTypeEnum curBankInterfaceType;
    public static final String resourcePath = "com.kingdee.eas.fm.be.FmbeResource";
    private Map map = new HashMap();
    private Map keyMap;
    String oldVersion = null;
    private boolean isInitFirst = true;
    private boolean isMnlBankCert = false;
    private BankInfo[] allBanks;
    private BankVersionInfo[] allVertions;
    private BankInfo bankInfo;
    private BankVersionInfo versionInfo;
    private CertUser certUser;
    private Map shortName2Version = new HashMap();

    @Override
    public void loadFields() {
        if (this.curBankInterfaceType != null && this.map != null) {
            Iterator it = this.map.keySet().iterator();
            String key = null;
            JTextField txtControl = null;
            while (it.hasNext()) {
                key = (String)it.next();
                txtControl = (JTextField)this.map.get(key);
                txtControl.setEnabled(false);
            }
            try {
                if (!this.isMnlBankCert) {
                    this.keyMap = BankConfigFacdeFactory.getRemoteInstance().getBankServiceConfig(this.curBankInterfaceType.getName(), null, "");
                    this.versionInfo = (BankVersionInfo)this.shortName2Version.get((String)this.keyMap.get("version"));
                    FMClientHelper.setSelectObject((KDComboBox)this.comboVersion, (Object)this.versionInfo);
                }
                if (this.keyMap != null && this.keyMap.size() > 0) {
                    String version;
                    this.oldVersion = version = (String)this.keyMap.get("version");
                    Iterator keyIt = this.keyMap.keySet().iterator();
                    String value = null;
                    while (keyIt.hasNext()) {
                        key = (String)keyIt.next();
                        if (key == null || (txtControl = (JTextField)this.map.get(key)) == null) continue;
                        txtControl.setEnabled(true);
                        value = (String)this.keyMap.get(key);
                        txtControl.setText(value);
                    }
                }
            }
            catch (Exception e1) {
                SysUtil.abort();
            }
        }
    }

    public void onLoad() throws Exception {
        this.isInitFirst = true;
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            this.comboType.setEnabled(false);
            if (this.isMnlBankCert) {
                this.comboVersion.setEnabled(false);
                this.comboCert.setEnabled(false);
            } else {
                this.comboVersion.setEnabled(true);
            }
            this.getCurrentBankInfo();
        } else if (!this.isMnlBankCert) {
            // empty if block
        }
        this.txtEncryptedPort.setGroupingUsed(false);
        this.txtSignedPort.setGroupingUsed(false);
        this.txtEncryptedPort.setSupportedEmpty(true);
        this.txtSignedPort.setSupportedEmpty(true);
        this.txtTimeOut.setSupportedEmpty(true);
        super.onLoad();
        this.putControlToMap();
        this.loadFields();
        this.initControlStatus();
        this.txtPwd.setBackground(UIManager.getColor("TextField.requiredBackground"));
        this.txtUsbKey.setBackground(UIManager.getColor("TextField.requiredBackground"));
    }

    private void initControlStatus() {
        if (this.getOprtState().equals(OprtState.EDIT)) {
            this.comboType.setEnabled(false);
        }
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.comboType.setEnabled(false);
            this.comboVersion.setEnabled(false);
            this.comboCert.setEnabled(false);
            this.btnSubmit.setEnabled(false);
            Iterator it = this.map.keySet().iterator();
            String key = null;
            JTextField txtControl = null;
            while (it.hasNext()) {
                key = (String)it.next();
                txtControl = (JTextField)this.map.get(key);
                txtControl.setEnabled(false);
            }
        }
        this.lbconCert.setVisible(this.isMnlBankCert);
    }

    private void getCurrentBankInfo() throws EASBizException, BOSException {
        int i;
        this.allBanks = BankConfigFacdeFactory.getRemoteInstance().getAvaliableBanks();
        this.allVertions = BankConfigFacdeFactory.getRemoteInstance().getAvaliableVersions();
        for (i = 0; i < this.allVertions.length; ++i) {
            this.shortName2Version.put(this.allVertions[i].getShortName(), this.allVertions[i]);
        }
        block1: for (i = 0; i < this.allBanks.length; ++i) {
            if (!this.allBanks[i].getName().equalsIgnoreCase((String)this.getUIContext().get("bankinterface"))) continue;
            this.bankInfo = this.allBanks[i];
            this.curBankInterfaceType = BankInterfaceTypeEnum.getEnum((String)this.bankInfo.getShortName());
            FMClientHelper.setSelectObject((KDComboBox)this.comboType, (Object)this.curBankInterfaceType);
            Object[] versions = this.bankInfo.getVersions();
            this.comboVersion.addItems(versions);
            for (int j = 0; j < versions.length; ++j) {
                if (!versions[j].getName().equalsIgnoreCase((String)this.getUIContext().get("bankVersion"))) continue;
                this.versionInfo = versions[j];
                if (!this.isMnlBankCert) {
                    this.isInitFirst = false;
                }
                FMClientHelper.setSelectObject((KDComboBox)this.comboVersion, (Object)this.versionInfo);
                if (!this.isMnlBankCert) break block1;
                Object[] certs = BankConfigFacdeFactory.getRemoteInstance().getCertUsersByVersion(this.versionInfo.getShortName());
                this.isInitFirst = false;
                this.comboCert.addItems(certs);
                for (int k = 0; k < certs.length; ++k) {
                    if (!certs[k].getCertUserName().equalsIgnoreCase((String)this.getUIContext().get("certUser"))) continue;
                    this.certUser = certs[k];
                    FMClientHelper.setSelectObject((KDComboBox)this.comboCert, (Object)this.certUser);
                }
                break block1;
            }
            break;
        }
    }

    private void putControlToMap() {
        this.map.put("OpNo", this.txtOpNo);
        this.map.put("CorpNo", this.txtCorpNo);
        this.map.put("AuthNo", this.txtAuthNo);
        this.map.put("TimeOut", this.txtTimeOut);
        this.map.put("sequenceSeed", this.txtSequenceSeed);
        this.map.put("UserID", this.txtUserId);
        this.map.put("UserHostId", this.txtClientId);
        this.map.put("EncryptedPort", this.txtEncryptedPort);
        this.map.put("SignedPort", this.txtSignedPort);
        this.map.put("ServerAddr", this.txtServerAddr);
        this.map.put("pwd", this.txtPwd);
        this.map.put("usbkey", this.txtUsbKey);
        this.map.put("bankServerAddr", this.txtBankServerAddr);
        this.map.put("bankServerPort", this.txtBankServerPort);
        this.map.put("UnsignedPort", this.txtUnsignedPort);
        this.map.put("email", this.txtEmail);
        this.map.put("grpidt", this.txtGrpidt);
        this.map.put("downloadDir", this.txtDownloadDir);
    }

    @Override
    public void storeFields() {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        if (this.curBankInterfaceType != null && this.map != null && this.keyMap != null) {
            Iterator keyIt = this.keyMap.keySet().iterator();
            String key = null;
            JTextField txtControl = null;
            while (keyIt.hasNext()) {
                String value;
                key = (String)keyIt.next();
                if (key == null || (txtControl = (JTextField)this.map.get(key)) == null) continue;
                if (key.equals("EncryptedPort") || key.equals("SignedPort") || key.equals("TimeOut") || key.equals("LocalPort")) {
                    value = ((KDFormattedTextField)this.map.get(key)).getText();
                    valueMap.put(key, value);
                    continue;
                }
                if (key.equals("version")) {
                    value = ((KDComboBox)this.map.get(key)).getSelectedItem().toString();
                    valueMap.put(key, value);
                    continue;
                }
                valueMap.put(key, txtControl.getText());
            }
            try {
                String version = this.getProperVersion();
                String certUser = "";
                if (this.isMnlBankCert) {
                    certUser = ((CertUser)this.comboCert.getSelectedItem()).getCertUserID();
                }
                BankConfigFacdeFactory.getRemoteInstance().setBankServiceConfig(this.curBankInterfaceType.getName(), valueMap, version, certUser);
            }
            catch (Exception e) {
                this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"55_BankInterfaceUI"));
                this.showMessage();
                Logger.error((Throwable)e);
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        this.storeFields();
        String version = this.getProperVersion();
        String certUser = "";
        if (this.isMnlBankCert) {
            certUser = ((CertUser)this.comboCert.getSelectedItem()).getCertUserID();
        }
        this.keyMap = BankConfigFacdeFactory.getRemoteInstance().getBankServiceConfig(this.curBankInterfaceType.getName(), version, certUser);
        String res = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK_New");
        Object[] objs = new Object[]{this.resHelper.getString("this.title")};
        String msg = MessageFormat.format(res, objs);
        MsgBox.showInfo((String)msg);
    }

    private void verify() {
        if (this.keyMap == null || this.map == null) {
            return;
        }
        if (this.comboVersion.getSelectedItem() == null || StringUtils.isEmpty((String)this.comboVersion.getSelectedItem().toString())) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"mustHaveVersion"));
            SysUtil.abort();
        }
        Iterator keyIt = this.keyMap.keySet().iterator();
        String key = null;
        JTextField txtControl = null;
        KDLabelContainer cont = null;
        String controlName = null;
        while (keyIt.hasNext()) {
            key = (String)keyIt.next();
            txtControl = (JTextField)this.map.get(key);
            if (txtControl == null) continue;
            cont = (KDLabelContainer)txtControl.getParent();
            if (cont != null) {
                controlName = cont.getBoundLabelText();
            }
            if (!StringUtils.isEmpty((String)txtControl.getText())) continue;
            MsgBox.showError((Component)((Object)this), (String)(controlName + EASResource.getString((String)resourcePath, (String)"mustWrite")));
            SysUtil.abort();
        }
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected boolean checkBeforeWindowClosing() {
        boolean b = super.checkBeforeWindowClosing();
        if (!b) {
            return b;
        }
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
            if (result == 0) {
                this.verify();
                this.storeFields();
                return true;
            }
            return result == 1;
        }
        return true;
    }

    private boolean isModify() {
        if (this.getOprtState().equals("VIEW")) {
            return false;
        }
        if (this.curBankInterfaceType != null && this.keyMap != null && this.map != null) {
            Iterator keyIt = this.keyMap.keySet().iterator();
            String key = null;
            JTextField txtControl = null;
            String txtValue = null;
            String keyValue = null;
            while (keyIt.hasNext()) {
                String newVersion;
                key = (String)keyIt.next();
                if (key != null && key.equals("version") && (newVersion = this.getProperVersion()) != null && !newVersion.equals("") && !newVersion.equals(this.oldVersion)) {
                    return true;
                }
                if (key == null || key.equals("version")) continue;
                txtControl = (JTextField)this.map.get(key);
                if (txtControl != null) {
                    if (key.equals("EncryptedPort") || key.equals("SignedPort") || key.equals("TimeOut") || key.equals("LocalPort")) {
                        if (((KDFormattedTextField)this.map.get(key)).getBigIntegerValue() != null) {
                            txtValue = ((KDFormattedTextField)this.map.get(key)).getBigIntegerValue().toString();
                        }
                    } else {
                        txtValue = txtControl.getText();
                    }
                } else {
                    txtValue = "";
                }
                keyValue = (String)this.keyMap.get(key);
                if (txtValue != null && keyValue != null && !txtValue.equals(keyValue)) {
                    return true;
                }
                if ((!FMHelper.isEmpty((String)txtValue) || FMHelper.isEmpty((String)keyValue)) && (FMHelper.isEmpty((String)txtValue) || !FMHelper.isEmpty((String)keyValue))) continue;
                return true;
            }
        }
        return false;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    private void setCertUser(String version) throws EASBizException, BOSException {
        CertUser[] certUser = BankConfigFacdeFactory.getRemoteInstance().getCertUsersByVersion(version);
        if (certUser == null) {
            return;
        }
        this.comboCert.removeAllItems();
        for (int i = 0; i < certUser.length; ++i) {
            this.comboCert.addItem((Object)certUser[i]);
        }
    }

    private void setUserCert(BankInterfaceTypeEnum curBankInterfaceType, BankVersionInfo version) throws EASBizException, BOSException {
        this.comboCert.removeAllItems();
    }

    private void loadFieldsByBankAndVersion(String version, String certUser) {
        if (this.curBankInterfaceType != null && this.map != null) {
            Iterator it = this.map.keySet().iterator();
            String key = null;
            JTextField txtControl = null;
            while (it.hasNext()) {
                key = (String)it.next();
                txtControl = (JTextField)this.map.get(key);
                txtControl.setEnabled(false);
                txtControl.setText(null);
            }
            try {
                this.keyMap = BankConfigFacdeFactory.getRemoteInstance().getBankServiceConfig(this.curBankInterfaceType.getName(), version, certUser);
                Iterator keyIt = this.keyMap.keySet().iterator();
                String value = null;
                while (keyIt.hasNext()) {
                    key = (String)keyIt.next();
                    if (key == null || (txtControl = (JTextField)this.map.get(key)) == null) continue;
                    txtControl.setEnabled(true);
                    value = (String)this.keyMap.get(key);
                    txtControl.setText(value);
                }
            }
            catch (Exception e1) {
                SysUtil.abort();
            }
        }
    }

    @Override
    protected void comboCert_itemStateChanged(ItemEvent e) throws Exception {
        if (this.comboCert.getSelectedItem() != null && !this.isInitFirst) {
            String version = this.getProperVersion();
            String certUser = ((CertUser)this.comboCert.getSelectedItem()).getCertUserID();
            this.loadFieldsByBankAndVersion(version, certUser);
        }
    }

    @Override
    protected void comboType_itemStateChanged(ItemEvent e) throws Exception {
        this.curBankInterfaceType = (BankInterfaceTypeEnum)this.comboType.getShowSelectedItem();
        if (this.curBankInterfaceType != null && !this.isInitFirst) {
            BEClientHelper.setVersion(this.curBankInterfaceType, this.comboVersion);
        }
    }

    @Override
    protected void comboVersion_itemStateChanged(ItemEvent e) throws Exception {
        if (this.comboVersion.getSelectedItem() != null && !this.isInitFirst) {
            this.setCertUser(((BankVersionInfo)this.comboVersion.getSelectedItem()).getShortName());
        }
        if (!this.isMnlBankCert && this.versionInfo != null) {
            this.loadFieldsByBankAndVersion(((BankVersionInfo)this.comboVersion.getSelectedItem()).getShortName(), "");
        }
    }

    private String getProperVersion() {
        String version = "";
        if (this.comboVersion.getSelectedItem() != null && this.comboVersion.getSelectedItem() instanceof BankVersionInfo) {
            version = ((BankVersionInfo)this.comboVersion.getSelectedItem()).getShortName();
        } else if (this.comboVersion.getSelectedItem() != null) {
            version = this.comboVersion.getSelectedItem().toString();
        }
        return version;
    }
}

