/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASAppException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BankLogFactory;
import com.kingdee.eas.fm.be.BankLogInfo;
import com.kingdee.eas.fm.be.client.AbstractBankLogEditUI;
import com.kingdee.eas.framework.ICoreBase;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;

public class BankLogEditUI
extends AbstractBankLogEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BankLogEditUI.class);

    public void onLoad() throws Exception {
        this.init();
        super.onLoad();
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnSubmit.setVisible(false);
    }

    private void init() {
        this.initLogType();
        this.kDScrollPane1.setHorizontalScrollBarPolicy(30);
        this.kDScrollPane2.setHorizontalScrollBarPolicy(30);
        this.kDScrollPane3.setHorizontalScrollBarPolicy(30);
        this.kDScrollPane4.setHorizontalScrollBarPolicy(30);
    }

    private void initLogType() {
    }

    protected IObjectValue createNewData() {
        BankLogInfo info = new BankLogInfo();
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BankLogFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "ID";
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.decode(this.kDTextAreaSend, this.kDTextAreaReceive, this.kDTextAreaSendException, this.kDTextAreaReceiveException, this.editData);
        }
        catch (EASAppException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (IOException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
    }

    public void decode(KDTextArea kDTextAreaSend, KDTextArea kDTextAreaReceive, KDTextArea kDTextAreaSendException, KDTextArea kDTextAreaReceiveException, BankLogInfo info) throws EASAppException, BOSException, IOException, EASBizException {
        Map map = BankLogFactory.getRemoteInstance().unSerialMessages(info.getId().toString());
        kDTextAreaSend.setText((String)map.get("send"));
        kDTextAreaReceive.setText((String)map.get("receive"));
        kDTextAreaSendException.setText((String)map.get("sendException"));
        kDTextAreaReceiveException.setText((String)map.get("receiveException"));
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("SendInfo"));
        sic.add(new SelectorItemInfo("receiveInfo"));
        sic.add(new SelectorItemInfo("sendExceptionInfo"));
        sic.add(new SelectorItemInfo("receiveExceptionInfo"));
        return sic;
    }

    public boolean useScrollPane() {
        return true;
    }

    public int getVerticalScrollPolicy() {
        return 20;
    }

    public int getHorizontalScrollPolicy() {
        return 30;
    }
}

