/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.be.BankInterfaceTypeEnum;
import com.kingdee.eas.fm.be.client.AbstractBankPayingBillSyncFilterUI;
import com.kingdee.eas.fm.be.client.BEClientHelper;
import com.kingdee.eas.fm.be.client.BankPayingBillSyncFilterParam;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.util.SysUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class BankPayingBillSyncFilterUI
extends AbstractBankPayingBillSyncFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(BankPayingBillSyncFilterUI.class);
    private static final int ALL_STATUS = 100;
    private static final int OTHER_STATUS = 99;
    private static final String F7_COMPANY_QUERY = "com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery";

    protected void init() throws Exception {
        super.init();
        this.initBankInterface();
        FMClientHelper.initCurrency((KDComboBox)this.cboCurrency);
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(company));
    }

    private void initF7Comapny() {
        this.f7Company.setDisplayFormat("$name$");
        this.f7Company.setEnabledMultiSelection(true);
        this.f7Company.setQueryInfo(F7_COMPANY_QUERY);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isOnlyUnion", (Object)new Integer(0)));
        view.setFilter(filter);
        this.f7Company.setEntityViewInfo(view);
    }

    protected void initCompanyState() {
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany) || FSClientHelper.isCHUser()) {
            this.btnCompanySelect.setEnabled(true);
            this.btnCompanySelect.setVisible(true);
        } else {
            this.btnCompanySelect.setEnabled(false);
            this.btnCompanySelect.setVisible(false);
        }
    }

    protected void companyValueChange(Object object) throws Exception {
        Object[] array = (Object[])object;
        Object[] result = FMClientHelper.removeVirtualCompany((Object[])array);
        super.companyValueChange((Object)result);
    }

    protected NewCompanyF7 getNewCompanyF7() {
        if (FSClientHelper.isCHUser()) {
            try {
                return super.getAllCompanyOrg();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getNewCompanyF7();
    }

    private void initBankInterface() {
        this.cmbxBankInterface.removeAllItems();
        this.cmbxBankInterface.addItems(BankInterfaceTypeEnum.getEnumList().toArray());
    }

    protected void chkIA_actionPerformed(ActionEvent e) throws Exception {
        super.chkIA_actionPerformed(e);
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
    }

    @Override
    protected void rdbAll_actionPerformed(ActionEvent e) throws Exception {
        super.rdbAll_actionPerformed(e);
    }

    public Object getParam() {
        BankPayingBillSyncFilterParam para = new BankPayingBillSyncFilterParam();
        para.setCurrencyId(AccessHelper.getCboId((KDComboBox)this.cboCurrency));
        String[] companyIds = this.getCompanyIds();
        para.setCompanyId(companyIds);
        para.setBeginDate(this.dtpBegin.getSqlDate());
        para.setEndDate(this.dtpEndo.getSqlDate());
        BankInterfaceTypeEnum bankInterface = (BankInterfaceTypeEnum)this.cmbxBankInterface.getSelectedItem();
        if (bankInterface != null) {
            para.setBankInterface(bankInterface.getValue());
        }
        return para;
    }

    public void setParam(Object param) {
        if (!(param instanceof BankPayingBillSyncFilterParam)) {
            return;
        }
        BankPayingBillSyncFilterParam para = (BankPayingBillSyncFilterParam)param;
        String currencyId = para.getCurrencyId();
        CurrencyInfo currencyInfo = null;
        try {
            if (currencyId != null) {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)currencyInfo);
            }
        }
        catch (Exception e1) {
            SysUtil.abort((Throwable)e1);
        }
        this.dtpBegin.setValue((Object)para.getBeginDate());
        this.dtpEndo.setValue((Object)para.getEndDate());
        String[] companyIds = para.getCompanyId();
        try {
            this.setCompanyIds(companyIds);
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
        BankInterfaceTypeEnum bankInterface = BankInterfaceTypeEnum.getEnum((int)para.getBankInterface());
        FMClientHelper.setSelectObject((KDComboBox)this.cmbxBankInterface, (Object)bankInterface);
    }

    public boolean verify() {
        return BEClientHelper.verifyDate((Component)((Object)this), this.dtpBegin, this.dtpEndo);
    }
}

