/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.be.BankPayingBillCollection;
import com.kingdee.eas.fm.be.BankPayingBillFactory;
import com.kingdee.eas.fm.be.client.AbstractBankPayingBillUI;
import com.kingdee.eas.fm.be.client.BEClientHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.SettlementBillFeeTypEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Map;
import org.apache.log4j.Logger;

public class BankPayingBillUI
extends AbstractBankPayingBillUI {
    private static final Logger logger = CoreUIObject.getLogger(BankPayingBillUI.class);
    private static final String resourcePath = "com.kingdee.eas.fm.be.beResourse";

    @Override
    protected IObjectValue createNewData() {
        return null;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return BankPayingBillFactory.getRemoteInstance();
    }

    public static void showDialogWindows(CoreUIObject ui, String srcBillId) throws UIException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)srcBillId));
        view.setFilter(filter);
        try {
            BankPayingBillCollection coll = BankPayingBillFactory.getRemoteInstance().getBankPayingBillCollection(view);
            if (coll == null || coll.size() == 0) {
                MsgBox.showInfo((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"CanNotFindPayingBill"));
                SysUtil.abort();
            }
            String id = coll.get(0).getId().toString();
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"ID", (Object)id);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BankPayingBillUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnCopy.setEnabled(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionPrint.setEnabled(false);
        this.actionPrintPreview.setEnabled(false);
        this.pkExpectTransTime.setDatePattern("yyyy-MM-dd HH:mm:ss");
    }

    @Override
    public void loadFields() {
        BOSUuid currencyId = this.editData.getCurrency().getId();
        int prec = FMClientHelper.getPrecOfCurrency((BOSUuid)currencyId);
        this.txtPayAmount.setPrecision(prec);
        this.txtPayAmount.setRemoveingZeroInDispaly(false);
        String feeMode = this.editData.getSettleFeeMode();
        if (feeMode != null && SettlementBillFeeTypEnum.BEN.toString().equals(feeMode)) {
            this.ComboFeeMode.setSelectedItem((Object)SettlementBillFeeTypEnum.BEN);
        } else if (feeMode != null && SettlementBillFeeTypEnum.OUR.toString().equals(feeMode)) {
            this.ComboFeeMode.setSelectedItem((Object)SettlementBillFeeTypEnum.OUR);
        } else if (feeMode != null && SettlementBillFeeTypEnum.SHA.toString().equals(feeMode)) {
            this.ComboFeeMode.setSelectedItem((Object)SettlementBillFeeTypEnum.SHA);
        }
        BEClientHelper.initShowOpenArea(this.contrecProvinceStr, this.contrecCityStr, this.contPayeeArea, null);
        super.loadFields();
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.chkIsDiffPlace.setEnabled(false);
        this.chkIsEmergency.setEnabled(false);
        this.txtLastUpdateUser.setEnabled(false);
        this.actionRemove.setVisible(false);
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.actionAddNew.setVisible(false);
            this.actionCopy.setVisible(false);
        }
    }
}

