/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import java.util.HashSet;

public class BankTransDownBillFilterParam
implements FilterParam {
    private static final long serialVersionUID = 3936782090532824966L;
    private static final int OTHER_STATUS = 99;
    private String currencyId;
    private String[] companyIds;
    private String[] bankAcctIds;
    private Date beginDate;
    private Date endDate;
    private int status;

    public String[] getCompanyIds() {
        return this.companyIds;
    }

    public void setCompanyIds(String[] companyIds) {
        this.companyIds = companyIds;
    }

    public String[] getBankAcctId() {
        return this.bankAcctIds;
    }

    public void setBankAcctId(String[] bankAcctIds) {
        this.bankAcctIds = bankAcctIds;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public FilterInfo getFilter() {
        FilterInfo fi = new FilterInfo();
        String[] company = this.getCompanyIds();
        if (company != null && company.length > 0) {
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)FMHelper.asSet((String[])company), CompareType.INCLUDE));
        } else {
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString()));
        }
        if (!FMHelper.isEmpty((Object[])this.bankAcctIds)) {
            HashSet<String> list = new HashSet<String>(this.bankAcctIds.length);
            for (int i = 0; i < this.bankAcctIds.length; ++i) {
                list.add(this.bankAcctIds[i]);
            }
            fi.getFilterItems().add(new FilterItemInfo("motherAcctBank.id", list, CompareType.INCLUDE));
        }
        if (this.currencyId != null) {
            fi.getFilterItems().add(new FilterItemInfo("currency.id", (Object)this.currencyId));
        }
        if (this.beginDate != null) {
            fi.getFilterItems().add(new FilterItemInfo("submitTime", (Object)DateTimeUtils.truncateDate((Date)this.beginDate), CompareType.GREATER_EQUALS));
        }
        if (this.endDate != null) {
            fi.getFilterItems().add(new FilterItemInfo("submitTime", (Object)DateTimeUtils.truncateDate((Date)DateUtil.getNextDay((Date)this.endDate)), CompareType.LESS));
        }
        if (this.status == 5 || this.status == 6) {
            fi.getFilterItems().add(new FilterItemInfo("entrys.state", (Object)new Integer(this.status)));
        } else if (this.status == 99) {
            fi.getFilterItems().add(new FilterItemInfo("entrys.state", (Object)new Integer(5), CompareType.NOTEQUALS));
            fi.getFilterItems().add(new FilterItemInfo("entrys.state", (Object)new Integer(6), CompareType.NOTEQUALS));
        }
        return fi;
    }

    public SorterItemCollection getSorterItems() {
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        sorter.add(new SorterItemInfo("entrys.seq"));
        return sorter;
    }
}

