/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.be.BEAreaData;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.client.BeAreaF7UI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BeAreaF7Selector
implements KDPromptSelector {
    KDBizPromptBox prmt;
    IUIObject ui;
    IUIWindow uiWindow;
    FilterInfo filter;
    Map type = new HashMap();
    private String resource = "com.kingdee.eas.fm.be.BEAutoGenerateResource";

    public BeAreaF7Selector(IUIObject ui, KDBizPromptBox prmt, FilterInfo otherFilter, Map type) {
        this.type = type;
        this.init(ui, prmt, otherFilter);
    }

    private void init(IUIObject ui, KDBizPromptBox prmt, FilterInfo otherFilter) {
        this.ui = ui;
        this.prmt = prmt;
        prmt.addCommitListener((CommitListener)new BeProvinceF7CommitListener());
        prmt.setCommitParser((IParser)new BeProvinceF7Parser());
        this.filter = otherFilter;
    }

    public void show() {
        UIContext map = new UIContext((Object)this.ui);
        map.put("isEnabledMultiSelection", this.prmt.isEnabledMultiSelection());
        map.put("filter", this.filter);
        map.put("areaCodeType", this.type.get("areaCodeType"));
        if (this.type.containsKey("provinceCode")) {
            map.put("provinceCode", this.type.get("provinceCode").toString());
        } else {
            map.put("provinceCode", null);
        }
        try {
            this.uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BeAreaF7UI.class.getName(), (Map)map, null, OprtState.VIEW);
            if (this.type.containsKey("areaCodeType")) {
                if (this.type.get("areaCodeType").equals("province")) {
                    ((BeAreaF7UI)this.uiWindow.getUIObject()).setUITitle(EASResource.getString((String)this.resource, (String)"184_BE_PROVINCE"));
                } else if (this.type.get("areaCodeType").equals("city")) {
                    ((BeAreaF7UI)this.uiWindow.getUIObject()).setUITitle(EASResource.getString((String)this.resource, (String)"185_BE_CITY"));
                }
            }
            this.uiWindow.show();
        }
        catch (UIException e) {
            e.printStackTrace();
        }
    }

    public boolean isCanceled() {
        if (this.uiWindow != null) {
            return ((BeAreaF7UI)this.uiWindow.getUIObject()).isCanceled;
        }
        return true;
    }

    public Object getData() {
        return ((BeAreaF7UI)this.uiWindow.getUIObject()).getRstData();
    }

    public boolean isEmpty(KDBizPromptBox prmt) {
        if (prmt.isEnabledMultiSelection()) {
            Object value = prmt.getData();
            if (value instanceof Object[] && EmptyUtil.isEmpty((Object[])((Object[])value))) {
                return true;
            }
            if (value instanceof List && ((List)value).size() <= 0) {
                return true;
            }
            if (prmt.getData() == null) {
                return true;
            }
        } else if (prmt.getData() == null) {
            return true;
        }
        return false;
    }

    class BeProvinceF7Parser
    implements IParser {
        BeProvinceF7Parser() {
        }

        public Object stringToValue(String str) {
            if (EmptyUtil.isEmpty((String)str)) {
                return null;
            }
            str = str.trim();
            return null;
        }

        private BEAreaData filterBankInter(String str) throws BOSException, EASBizException {
            Map resultMap = BankFacadeFactory.getRemoteInstance().getProvince();
            Set bankCodeSet = resultMap.keySet();
            Iterator iter = bankCodeSet.iterator();
            while (iter.hasNext()) {
                String provinceCode = iter.next().toString();
                String provinceName = resultMap.get(provinceCode).toString();
                if (!str.equals(provinceName)) continue;
                BEAreaData info = new BEAreaData();
                info.setAreaCode(provinceCode);
                info.setAreaName(provinceName);
                return info;
            }
            return null;
        }

        public void applyPattern(String pattern) {
        }

        public IRowSet getRowSetForPopupF8(String text) {
            return null;
        }

        public void setQuickQureyEntityViewInfo(EntityViewInfo quickQueryEvi) {
        }
    }

    class BeProvinceF7CommitListener
    implements CommitListener {
        BeProvinceF7CommitListener() {
        }

        public void willCommit(CommitEvent e) {
            if (e == null) {
                return;
            }
        }
    }
}

