/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.be.TransDetailFactory;
import com.kingdee.eas.fm.be.client.AbstractBeDetailCheckUI;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class BeDetailCheckUI
extends AbstractBeDetailCheckUI {
    private static final Logger logger = CoreUIObject.getLogger(BeDetailCheckUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.uiWindow.close();
    }

    @Override
    protected void btnLast_actionPerformed(ActionEvent e) throws Exception {
        this.setDisplay(false);
    }

    @Override
    protected void btnStart_actionPerformed(ActionEvent e) throws Exception {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtAccountBank);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDComboBox)this.comboCurrency);
        if (this.dtpBeginDate.getValue() != null && this.dtpEndDate.getValue() != null) {
            FMClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)this, (KDDatePicker)this.dtpBeginDate, (KDDatePicker)this.dtpEndDate);
        }
        AccountBankInfo acct = (AccountBankInfo)this.prmtAccountBank.getData();
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        Map resultMap = TransDetailFactory.getRemoteInstance().detailCheck(acct.getId().toString(), currency.getId().toString(), this.dtpBeginDate.getSqlDate(), this.dtpEndDate.getSqlDate());
        StringBuffer allInfo = new StringBuffer();
        Set set = resultMap.entrySet();
        for (Map.Entry entry : set) {
            allInfo.append(entry.getValue()).append("\n");
        }
        allInfo.append(EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"74_BeDetailCheckUI"));
        this.txtResult.setText(allInfo.toString());
        this.setDisplay(true);
    }

    private void setDisplay(boolean flag) {
        this.btnCancel.setVisible(!flag);
        this.btnStart.setVisible(!flag);
        this.pnlData.setVisible(!flag);
        this.btnLast.setVisible(flag);
        this.btnFinish.setVisible(flag);
        this.pdlResult.setVisible(flag);
    }

    @Override
    protected void btnFinish_actionPerformed(ActionEvent e) throws Exception {
        this.uiWindow.close();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
    }

    private void initUI() throws Exception {
        this.setImage();
        FMClientHelper.initCurrency((KDComboBox)this.comboCurrency);
        this.setF7BankAccountQuery();
    }

    private void setImage() {
        Icon guide = EASResource.getIcon((String)"imgGuide_pic260");
        KDLabel backlabel = new KDLabel(guide);
        backlabel.setBounds(0, 0, guide.getIconWidth(), guide.getIconHeight());
        this.pnlPicture.add((Component)backlabel, (Object)"Center");
        this.pnlPicture.setSize(guide.getIconWidth(), guide.getIconHeight());
        this.pnlPicture.setBackground(Color.blue);
    }

    private void setF7BankAccountQuery() {
        FilterInfo filterInfo = new FilterInfo();
        CompanyOrgUnitInfo curCompany = SysContext.getSysContext().getCurrentFIUnit();
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)curCompany.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filterInfo.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        this.prmtAccountBank.setDisplayFormat("$number$ $name$");
        this.prmtAccountBank.setCommitFormat("$number$");
        this.prmtAccountBank.setEditFormat("$number$");
        this.prmtAccountBank.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        this.prmtAccountBank.setEntityViewInfo(evi);
    }
}

