/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.be.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.be.DetailIntegralityCondition;
import com.kingdee.eas.fm.be.DetailIntegralityFactory;
import com.kingdee.eas.fm.be.DetailIntegralityFilterParam;
import com.kingdee.eas.fm.be.DetailIntegralityInfo;
import com.kingdee.eas.fm.be.TransDetailFactory;
import com.kingdee.eas.fm.be.client.AbstractDetailIntegralityListUI;
import com.kingdee.eas.fm.be.client.DetailIntegralityFilterUI;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class DetailIntegralityListUI
extends AbstractDetailIntegralityListUI {
    private DetailIntegralityFilterUI filterUI;
    private static final Logger logger = CoreUIObject.getLogger(DetailIntegralityListUI.class);
    private DetailIntegralityFilterParam paramCash = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TransDetailFactory.getRemoteInstance();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new DetailIntegralityFilterUI();
        }
        return this.filterUI;
    }

    public CommonQueryDialog getQueryDlg() throws Exception {
        CommonQueryDialog dlg = super.getQueryDlg();
        dlg.setShowFilter(true);
        dlg.setShowSorter(true);
        dlg.setWidth(586);
        return dlg;
    }

    public void executeQuery(FilterParam param) throws BOSException {
        this.genDetailIntregralityResult((DetailIntegralityFilterParam)param);
        this.paramCash = (DetailIntegralityFilterParam)param;
        super.executeQuery(param);
    }

    private void genDetailIntregralityResult(DetailIntegralityFilterParam param) {
        try {
            Set condition = this.genConditions(param);
            DetailIntegralityFactory.getRemoteInstance().genDetailIntegralityResult(condition);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    protected Set genConditions(DetailIntegralityFilterParam param) throws EASBizException, BOSException {
        HashSet<DetailIntegralityCondition> conSet = new HashSet<DetailIntegralityCondition>();
        if (param.getBankAccts() == null || param.getBankAccts().length <= 0) {
            String[] companyId = param.getCompanyId();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(1)));
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)FMHelper.asSet((String[])companyId), CompareType.INCLUDE));
            AccountBankCollection bankAccts = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
            param.setBankAccts((AccountBankInfo[])bankAccts.toArray());
        }
        Date beginDate = param.getBeginDate();
        Date endDate = param.getEndDate();
        Calendar cal = Calendar.getInstance();
        cal.setTime(beginDate);
        long time1 = cal.getTimeInMillis();
        cal.setTime(endDate);
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        int days = Integer.parseInt(String.valueOf(between_days));
        if (param.getBankAccts().length > 0) {
            AccountBankInfo[] bankAccts = param.getBankAccts();
            for (int index = 0; index < bankAccts.length; ++index) {
                Date bizDate;
                GregorianCalendar calNew;
                AccountBankInfo info = bankAccts[index];
                if (param.getCurrencyId() != null) {
                    if (days == 0) {
                        DetailIntegralityCondition condition = new DetailIntegralityCondition();
                        condition.setCompanyInfo(info.getCompany());
                        condition.setBankId(info.getId().toString());
                        condition.setCurrencyId(param.getCurrencyId());
                        condition.setCurrency(CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(param.getCurrencyId())));
                        condition.setBankAccount(info);
                        condition.setBizDate(beginDate);
                        conSet.add(condition);
                        continue;
                    }
                    for (int i = 0; i <= days; ++i) {
                        DetailIntegralityCondition condition = new DetailIntegralityCondition();
                        condition.setCompanyInfo(info.getCompany());
                        condition.setBankId(info.getId().toString());
                        condition.setCurrencyId(param.getCurrencyId());
                        condition.setCurrency(CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(param.getCurrencyId())));
                        condition.setBankAccount(info);
                        GregorianCalendar calNew2 = new GregorianCalendar();
                        calNew2.setTime(beginDate);
                        ((Calendar)calNew2).add(5, i);
                        Date bizDate2 = calNew2.getTime();
                        condition.setBizDate(bizDate2);
                        conSet.add(condition);
                    }
                    continue;
                }
                Set curSet = this.getAccountCurrency(info.getId().toString());
                for (String currencyId : curSet) {
                    if (days == 0) {
                        DetailIntegralityCondition condition = new DetailIntegralityCondition();
                        condition.setCompanyInfo(info.getCompany());
                        condition.setBankId(info.getId().toString());
                        condition.setCurrencyId(currencyId);
                        condition.setCurrency(CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId)));
                        condition.setBankAccount(info);
                        condition.setBizDate(beginDate);
                        conSet.add(condition);
                        continue;
                    }
                    for (int i = 0; i <= days; ++i) {
                        DetailIntegralityCondition condition = new DetailIntegralityCondition();
                        condition.setCompanyInfo(info.getCompany());
                        condition.setBankId(info.getId().toString());
                        condition.setCurrencyId(currencyId);
                        condition.setCurrency(CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId)));
                        condition.setBankAccount(info);
                        calNew = new GregorianCalendar();
                        calNew.setTime(beginDate);
                        ((Calendar)calNew).add(5, i);
                        bizDate = calNew.getTime();
                        condition.setBizDate(bizDate);
                        conSet.add(condition);
                    }
                }
                if (curSet != null && curSet.size() != 0) continue;
                if (days == 0) {
                    DetailIntegralityCondition condition = new DetailIntegralityCondition();
                    condition.setCompanyInfo(info.getCompany());
                    condition.setBankId(info.getId().toString());
                    CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
                    condition.setCurrencyId(company.getBaseCurrency().getId().toString());
                    condition.setCurrency(company.getBaseCurrency());
                    condition.setBizDate(beginDate);
                    conSet.add(condition);
                    continue;
                }
                for (int i = 0; i < days; ++i) {
                    DetailIntegralityCondition condition = new DetailIntegralityCondition();
                    condition.setCompanyInfo(info.getCompany());
                    condition.setBankId(info.getId().toString());
                    CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
                    condition.setCurrencyId(company.getBaseCurrency().getId().toString());
                    condition.setCurrency(company.getBaseCurrency());
                    calNew = new GregorianCalendar();
                    calNew.setTime(beginDate);
                    ((Calendar)calNew).add(5, 1 + i);
                    bizDate = calNew.getTime();
                    condition.setBizDate(bizDate);
                    conSet.add(condition);
                }
            }
        }
        return conSet;
    }

    private Set getAccountCurrency(String bankAcctId) {
        HashSet<String> idSet = new HashSet<String>();
        try {
            String sSQL = "Select FCurrencyId From T_Be_TransDetail Where FBANKACCOUNTID = '" + bankAcctId + "' ";
            ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sSQL);
            IRowSet rs = exec.executeSQL();
            while (rs.next()) {
                idSet.add(rs.getString("FCurrencyId"));
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        return idSet;
    }

    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"1176_DetailIntegralityListUI");
    }

    protected IObjectValue createNewData() {
        DetailIntegralityInfo objectValue = new DetailIntegralityInfo();
        return objectValue;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)"90_TransDetailListUI"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAuditResult.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.tblMain.getColumn("totalPayAmount").getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
        this.tblMain.getColumn("totalRecAmount").getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
        this.tblMain.getColumn("balance").getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
        this.tblMain.getColumn("calculateBalance").getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
        this.tblMain.getColumn("balanceDif").getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
        this.tblMain.getColumn("lstBalance").getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
        this.menuWorkFlow.setVisible(false);
    }

    protected void refresh(ActionEvent e) throws Exception {
        this.executeQuery(this.paramCash);
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }
}

